/**
 * @Description: 最大号表本文件
 * @Author: ChenXin
 * @Date: 2018/3/7.
 */

/**
 * 最大号表初始化
 */
layui.use(['jquery','layer','Hussar','HussarAjax','form','table', 'upload'], function(){
	
var Hussar = layui.Hussar;
var $ = layui.jquery;
var layer=layui.layer;
var $ax=layui.HussarAjax;
var form=layui.form;
var table = layui.table;
var upload = layui.upload;
var layerView;

var IdtableManage = {
	seItem : null,
	setSys : null,
	layIndex : null
};

/**
 * 页面初始化
 */
IdtableManage.initPage = function () {
	this.initTable();
	this.initButton();
};

/**
 * 加载列表
 */
IdtableManage.initTable = function() {
    var serIdDesc = $('#serIdDesc').val();
    var serFieldName = $('#serFieldName').val();
    var serTableName = $('#serTableName').val();
		table.render({
			elem : '#idtableTable',
			url : Hussar.ctxPath+'/idtable/list',
			cols : [ [
			          {type: 'checkbox'} ,
			          {title : '序号', type : 'numbers', align : 'center',width:40},
			          {title : '业务中文名称', field: 'idDesc', align : 'center'},
			          {title : '业务名称', field: 'fieldName', align : 'center', event: 'detailEvent', style:'cursor: pointer;color:#00a4ff'},
			          {title : '业务表名', field: 'tableName', align : 'center'},
			          {title : '当前编号', field: 'idValue', align : 'center'},
			          {title : '递增值', field: 'cacheSize', align : 'center'},
			          {title : '编号长度', field: 'idLength', align : 'center'},
			          {title : '是否系统编码', field: 'isSys', align : 'center',templet:function(d){
			              if(d.isSys=='0'){
			            	  return "否"
			              }else if (d.isSys=='1'){
			            	  return "是"
			              }else{
			            	  return "-";
			              }
			          }}
			          ] ],
			page : true,
			even: true,
			id : 'tableReload',
            height:$("body").height() - $(".layui-form").outerHeight(true)-30,
            where : {
                serIdDesc : serIdDesc,
                serFieldName:serFieldName,
                serTableName:serTableName
            }
		});
};

/**
 * 选中一条结果
 */
IdtableManage.check = function() {
	var checkStatus = table.checkStatus('tableReload'), data = checkStatus.data;
	if (data.length == 0 || data.length > 1) {
        Hussar.info(PLEASE_CHOOSE_ONE);
		return false;
	} else {
		IdtableManage.seItem = data[0];
		return true;
	}
};

/**
 * 选中多条结果
 */
IdtableManage.checks = function() {
	var checkStatus = table.checkStatus('tableReload'), data = checkStatus.data;
	var ids = [];
	var isys = [];
	if (data.length == 0) {
		Hussar.info(PLEASE_SELECT_AT_LEAST_ONE);
		return false;
	} else {
		for (var i = 0, l = data.length; i < l; i++) {
			var r = data[i];
			ids.push(r.idId);
			isys.push(r.isSys);
		}
		var eId = ids.join(',');
		var sys = isys.join(',');
		IdtableManage.seItem = eId;
		IdtableManage.setSys = sys;
		return true;
	}
};

/**
 * 按钮操作
 */
IdtableManage.initButton = function () {
	
	/**
	 * 查询
	 */
	$('#search').on('click', function() {
		var serIdDesc = $('#serIdDesc').val();
		var serFieldName = $('#serFieldName').val();
		var serTableName = $('#serTableName').val();
		// 执行重载
		table.reload('tableReload', {
			page : {
				curr : 1
			// 重新从第 1 页开始
			},
			where : {
				serIdDesc : serIdDesc,
				serFieldName:serFieldName,
				serTableName:serTableName
			}
		});
	});
	
	/**
	 * 新增
	 */
	$("#add").click(function(){
		$("#status").val("add");
		$("#idValue").val("");
		$("#idId").val("");
		layerView=layer.open({
			type : 1,
			title: '最大号表新增',
			area : [ '850px', '400px' ],
			//shift : 6,
			shadeClose : false,
			maxmin : false,
			content : $("#viewEvent"),
			success : function() {
				$('#addForm')[0].reset();
				$("input[name='isPrefix']").removeAttr("disabled");
				$("input[name='isSuffix']").removeAttr("disabled");
				$("input[name='isLevel']").removeAttr("disabled");
				$("#fieldName").removeAttr("disabled");
				$("#tableName").removeAttr("disabled");
				$("#idSuffix").attr("disabled","disabled");
				$("#idPrefix").attr("disabled","disabled");
				$("#idSuffix").removeAttr("lay-verify");
				$("#idPrefix").removeAttr("lay-verify");
				form.render();
			}
		});
	});
	
	/**
	 * 修改
	 */
	$("#edit").click(function(){
		if (IdtableManage.check()) {
			$("#status").val("edit");
			$("#idValue").val(IdtableManage.seItem.idValue);
			$("#idId").val(IdtableManage.seItem.idId);
			layerView=layer.open({
				type : 1,
				title: '最大号表修改',
				area : [ '850px', '400px' ],
				//shift : 6,
				shadeClose: false,
				maxmin : false,
				content : $("#viewEvent"),
				success : function() {
					$("input[name='isLevel']").attr("disabled","disabled");
					$("input[name='isLevel']")[0].checked=true;
					$("input[name='isPrefix']").removeAttr("disabled");
					$("input[name='isSuffix']").removeAttr("disabled");
					$("#idPrefix").removeAttr("disabled");
					$("#idSuffix").removeAttr("disabled");
					$("#fieldName").attr("disabled","disabled");
					$("#tableName").attr("disabled","disabled");
					$("#fieldName").val(IdtableManage.seItem.fieldName);
					$("#tableName").val(IdtableManage.seItem.tableName.toUpperCase());
					$("input[name='idDesc']").val(IdtableManage.seItem.idDesc);
					$("input[name='cacheSize']").val(IdtableManage.seItem.cacheSize);
					$("input[name='idLength']").val(IdtableManage.seItem.idLength);
					$("input[name='idPrefix']").val(IdtableManage.seItem.idPrefix);
					$("input[name='idSuffix']").val(IdtableManage.seItem.idSuffix);
					var isPrefix = $("input[name='isPrefix']");
        			for(var i=0; i<isPrefix.length; i++){
        				if(isPrefix[i].value == IdtableManage.seItem.isPrefix){
        					isPrefix[i].checked = true;
        				}
        				$("input[name='isPrefix']").removeAttr("disabled");
        			}
        			if(IdtableManage.seItem.isPrefix=="0"){
        				$("#idPrefix").attr("disabled","disabled");
        				$("#idPrefix").removeAttr("lay-verify");
        			}else{
        				$("#idPrefix").removeAttr("disabled");
        				$("#idPrefix").attr("lay-verify","required");
        			}
        			var isSuffix = $("input[name='isSuffix']");
        			for(var i=0; i<isSuffix.length; i++){
        				if(isSuffix[i].value == IdtableManage.seItem.isSuffix){
        					isSuffix[i].checked = true;
        				}
        				$("input[name='isSuffix']").removeAttr("disabled");
        			}
        			if(IdtableManage.seItem.isSuffix=="0"){
        				$("#idSuffix").attr("disabled","disabled");
        				$("#idSuffix").removeAttr("lay-verify");
        			}else{
        				$("#idSuffix").removeAttr("disabled");
        				$("#idSuffix").attr("lay-verify","required");
        			}
        			var isSys = $("input[name='isSys']");
        			for(var i=0; i<isSys.length; i++){
        				if(isSys[i].value == IdtableManage.seItem.isSys){
                            isSys[i].checked = true;
						}
					}
        			var isLevel = $("input[name='isLevel']");
        			for(var i=0; i<isLevel.length; i++){
        				if(isLevel[i].value == IdtableManage.seItem.isLevel){
        					isLevel[i].checked = true;
        					if(IdtableManage.seItem.isLevel=="1"){
        						$("input[name='isPrefix']").attr("disabled","disabled");
            					$("input[name='isSuffix']").attr("disabled","disabled");
            					$("input[name='isPrefix']")[0].checked=true;
            					$("input[name='isSuffix']")[0].checked=true;
            					$("#idPrefix").attr("disabled","disabled");
            					$("#idSuffix").attr("disabled","disabled");
        					}
        					
        				}
        			}
					form.render();
				}
			});
		}
	});
	// 监听单元格事件
	table.on('tool(tableList)', function(obj) {
		var data = obj.data;
		if (obj.event == 'detailEvent') {
			layer.open({
				type : 1,
				title: '最大号表明细',
				area : [ '450px', '500px' ],				
				shadeClose: false,
				maxmin : false,
				content : $("#viewEventDetail"),
				success : function() {
					$('#viewForm')[0].reset();										
					$('#fieldNameDetail').html(data.fieldName);
					$('#tableNameDetail').html(data.tableName);
					$('#idValueDetail').html(data.idValue);
					$('#idDescDetail').html(data.idDesc);
					$('#cacheSizeDetail').html(data.cacheSize);
					$('#idLengthDetail').html(data.idLength);
					$('#idPrefixDetail').html(data.idPrefix);
					$('#idSuffixDetail').html(data.idSuffix);
					if(data.isPrefix==0){
						$('#isPrefixDetail').html("否");
						$("#prefixDivDetail").attr("style","display:none;");
						
					}else{
						$('#isPrefixDetail').html("是");
						$("#prefixDivDetail").removeAttr("style");
						
					}
					if(data.isSuffix==0){
						$('#isSuffixDetail').html("否");
						$("#suffixDivDetail").attr("style","display:none;");
					}else{
						$('#isSuffixDetail').html("是");
						$("#suffixDivDetail").removeAttr("style");
					}
					if(data.isLevel==0){
						$('#isLevelDetail').html("否");
					}else{
						$('#isLevelDetail').html("是");
					}
					if(data.isSys == '0'){
						$('#isSysDetail').html("否");
					}else if(data.isSys == '1'){
						$('#isSysDetail').html("是");
					}else {
						$('#isSysDetail').html("-");
					}
				}
			});
		}
	});
	/**
	 * 删除
	 */
	$("#del").click(function() {
		if (IdtableManage.checks()) {
			if(IdtableManage.setSys.indexOf("1")!=-1){
				Hussar.info("系统编码不可以删除!");
			}else{
				var operation =function(){
					var ajax = new $ax(Hussar.ctxPath + "/idtable/delByIds",
						function(data) {
							if (data.code == 200){
								// 执行重载
								table.reload('tableReload', {
									page : {
										curr : 1
										// 重新从第 1 页开始
									}
								});
								Hussar.success(data.message);
							}else if (data.code == 500){
								Hussar.error(data.message);
							}
						}, function(data) {
								Hussar.error(DELETE_FAIL);
						});
					ajax.set("id", IdtableManage.seItem);
					ajax.start();
				};
				Hussar.confirm(DELETE_SURE, operation);
				//layer.confirm("确定要删除吗 ?", {title:'提示'}, operation);//{icon: 3, title:'提示'}
				}
			}
		});
	
	/**
	 * 保存
	 */
	$("#btnSave").click(function(){
		form.on('submit(verify)', function(data){
			var data = data.field;
			var idValue = $("#idValue").val();
			var idLength =$("#idLength").val();
			var cacheSize = $("#cacheSize").val();
			if(idLength>6||idLength<1){
				Hussar.valid("编号长度必须介于1-6之间！");
				return false;
			}
			if(cacheSize>9||cacheSize<1){
				Hussar.valid("递增值必须介于1-9之间！");
				return false;
			}
		    // 提交信息
			var type=$("#status").val();
			var url;
			if(type=="add"){
				url="/idtable/addSave";
			}else{
				url="/idtable/editSave";
				//判断当前编号长度是否大于等于设置长度
				if(idLength<idValue.length){
					Hussar.valid("编号长度不可以小于当前编号长度！");
					return false;
				}
			}
		    var ajax = new $ax(Hussar.ctxPath + url, function(data) {
		    	if(data.code==100){
		    		Hussar.valid(data.message);
		    		return false;
		    	}else if(data.code == 500){
					Hussar.error(data.message)
				}else if(data.code == 200){
					Hussar.success(data.message);
					layer.close(layerView);
					$('#searchForm')[0].reset();
					$('#addForm')[0].reset();
					// 执行重载
					table.reload('tableReload', {
						page : {
							curr : 1
							// 重新从第 1 页开始
						}
					});
				}
		    }, function(data) {
		        Hussar.error(SAVE_FAIL);
		    });
		    ajax.setData(data);
		    ajax.start();
		});
	});
	
	/**
	 * 关闭
	 */
	$("#btnClose").click(function(){
		layer.close(layerView);
	});

    /**
     * 导出
     */
    $("#export").click(function(){
        if (IdtableManage.checks()) {
            var operation =function(){
                var url = Hussar.ctxPath + "/idtable/exportData";
                var form = $("<form></form>").attr("action", url).attr("method", "post");
                form.append($("<input></input>").attr("type", "hidden").attr("name", "ids").attr("value", IdtableManage.seItem));
                form.appendTo('body').submit().remove();
            };
            Hussar.confirm(EXPORT_DATA_SURE, operation);
        }
    });

    /**
	 * 导入
     */
    var dataImport = upload.render({
        elem: '#import'
        ,url: Hussar.ctxPath+'/idtable/importData'
		,accept: 'file'
		,exts: 'hussar'
		,before: function (obj) {
            IdtableManage.layIndex = layer.load(2);
        }
        ,done: function(res, index, upload){
            layer.close(IdtableManage.layIndex);	//关闭loading
            if(res.code == 200){
                Hussar.success(res.message);
                table.reload('tableReload', {page : {curr : 1} });
            }else{
                Hussar.error(res.message);
            }
        }
        ,error: function(){
            layer.close(IdtableManage.layIndex);	//关闭loading
			Hussar.error(IMPORT_FAIL);
        }

	});

	
	/**
	 * 是否有层级码点击事件
	 */
	form.on('radio(isSys)', function(data){
		if(data.value=="0"){
		}else{
			// layer.tips('温馨提示：为系统编码时不可以删除最大号表', data.othis)
			Hussar.info("温馨提示：为系统编码时不可以删除最大号表");
		}
	});
	
	/**
	 * 是否层级码按钮点击事件
	 */
	form.on('radio(isLevel)', function(data){
		if(data.value=="1"){
			$("input[name='isPrefix']").attr("disabled","disabled");
			$("input[name='isSuffix']").attr("disabled","disabled");
			$("#idPrefix").removeAttr("lay-verify");
			$("#idSuffix").removeAttr("lay-verify");
			$("#idPrefix").val("");
			$("#idSuffix").val("");
			$("input[name='isPrefix']")[0].checked=true;
			$("input[name='isSuffix']")[0].checked=true;
			$("#idPrefix").attr("disabled","disabled");
			$("#idSuffix").attr("disabled","disabled");
		}else{
			$("input[name='isPrefix']").removeAttr("disabled");
			$("input[name='isSuffix']").removeAttr("disabled");
			$("#idPrefix").val("");
			$("#idSuffix").val("");
		}
		form.render();
	});
	
	/**
	 * 是否有前缀按钮点击事件
	 */
	form.on('radio(isPrefix)', function(data){
		if(data.value=="0"){
			$("#idPrefix").attr("disabled","disabled");
			$("#idPrefix").removeAttr("lay-verify");
			$("#idPrefix").val("");
		}else{
			$("#idPrefix").removeAttr("disabled");
			$("#idPrefix").attr("lay-verify","required");
			$("#idPrefix").val("");
		}
	});
	
	/**
	 * 是否有后缀按钮点击事件
	 */
	form.on('radio(isSuffix)', function(data){
		if(data.value=="0"){
			$("#idSuffix").attr("disabled","disabled");
			$("#idSuffix").removeAttr("lay-verify");
			$("#idSuffix").val("");
		}else{
			$("#idSuffix").removeAttr("disabled");
			$("#idSuffix").attr("lay-verify","required");
			$("#idSuffix").val("");
		}
	}); 


};


/**
 * 初始化
 */
$(function() {
	IdtableManage.initPage();
});
});