var DictInfoDlg = {};

layui.use(['layer','form', 'HussarAjax', 'Hussar'], function() {

    var layer = layui.layer
        , form = layui.form
        , $ = layui.jquery
        , $ax = layui.HussarAjax
        , Hussar = layui.Hussar;

    /**
     * 初始化字典详情对话框
     */
    DictInfoDlg = {
        count: $("#itemSize").val(),
        dictName: '',			//字典类别的名称
        dictTypeCode:'',        //字典类别描述
        mutiString: [],		//拼接字符串内容(拼接字典条目)
        itemTemplate: $("#itemTemplate").html(),
        delIdString: []      //要删除的id拼成字符串，以","隔开
    };

    /**
     * item获取新的id
     */
    DictInfoDlg.newId = function () {
        if (this.count == undefined) {
            this.count = 0;
        }
        this.count = this.count + 1;
        return "dictItem" + this.count;
    };

    /**
     * 关闭此对话框
     */
    DictInfoDlg.close = function () {
        parent.layer.close(window.parent.Dict.layerIndex);
    };

    /**
     * 添加条目
     */
    DictInfoDlg.addItem = function () {
        $("#itemsArea").append(this.itemTemplate);
        $("#dictItem").attr("id", this.newId());
    };

    /**
     * 删除item
     */
    DictInfoDlg.deleteItem = function (event) {
        event = event ? event : window.event;
        var obj = event.srcElement ? event.srcElement : event.target;
        obj = $(obj);
        obj = obj.is('button') ? obj : obj.parent();
        obj.parent().parent().remove();
        // 删除的如果是已有字段的item，则将其id加入删除数组
        var objNew = obj.parent().children('input:first-child');
        if (objNew.length > 0){
            DictInfoDlg.delIdString.push(objNew.attr("value"));
        }
    };

    /**
     * 检查字典条目是否有空值
     */
    DictInfoDlg.checkNullDom = function () {
        var flag = true;
        $("[name='dictItem']").each(function () {
            var num = $(this).find("[name='itemNum']");
            var name = $(this).find("[name='itemName']");
            [name, num].every(function(v){
                if (!v.val().trim()){
                    flag = false;
                    v.focus();
                    return false;
                }
                return true;
            });
            if(!flag){
                return false;
            }
        });
        return flag;
    };

    /**
     * 收集添加字典的数据，进行非空验证，并提交
     * isAdd是否为新增的提交，否则为修改的提交
     */
    DictInfoDlg.collectDataSubmit = function (isAdd) {

        this.mutiString = [];
        var dictNameDom = $("#dictName");
        var dictTypeCodeDom = $("#dictTypeCode");

        var checkTypeNull = function(){
            var flag = true;
            [dictTypeCodeDom, dictNameDom].every(function(v){
                if (!v.val().trim()){
                    flag = false;
                    v.focus();
                    return false;
                }
                return true;
            });
            return flag;
        };

        if(!checkTypeNull() || !DictInfoDlg.checkNullDom()){
            layer.msg("必填项不能为空！",{
                icon:5, shift:6
            });
            return false;
        }

        this.dictName = dictNameDom.val().trim();
        this.dictTypeCode = dictTypeCodeDom.val().trim();

        var checkerNum = [], checkerName = [], checker = true;
        var mutiString = [];
        //获取数据并检查重复项
        $("[name='dictItem']").each(function () {
            var id = typeof($(this).find("[name='itemId']").val()) == 'undefined'? "" : $(this).find("[name='itemId']").val();
            var num = $(this).find("[name='itemNum']").val().trim();
            var name = $(this).find("[name='itemName']").val().trim();
            if(checkerName.indexOf(name) > -1 || checkerNum.indexOf(num) > -1){
                checker = false;
                return false;
            }else{
                checkerNum.push(num);
                checkerName.push(name);
                mutiString.push({"id":id,"num":num,"name":name});
            }
        });
        if(!checker){
            layer.msg("存在值或名称重复的字典条目，请检查！",{
                icon:5, shift:6
            });
            return false;
        }
        DictInfoDlg.mutiString = mutiString;
        var str = $("#checkFlag").val();
        if(isAdd) {
            DictInfoDlg.addSubmit();
        }else{
            DictInfoDlg.editSubmit(str);
        }
    };


    /**
     * 提交添加字典
     */
    DictInfoDlg.addSubmit = function () {
        //提交信息
        var ajax = new $ax(Hussar.ctxPath+"/sys/dic/add", function (data) {
            data = data || {};
            if(data.code == 200){
                parent.layui.Hussar.success("添加成功！");
                window.parent.Dict.refreshTreeAndTable();
                DictInfoDlg.close();
            }else{
                Hussar.error("添加失败！（" + (data.message || '未知错误') + "）");
            }
        }, function (data) {
            Hussar.error("添加失败！（" + (data.message || '未知错误') + "）");
        });
        ajax.set('dictName', this.dictName);
        ajax.set('dictTypeCode', this.dictTypeCode);
        ajax.set('dictValues', JSON.stringify(this.mutiString));
        ajax.set('parentId', $("#parentId").val());
        ajax.start();
    };

    /**
     * 提交修改
     */
    DictInfoDlg.editSubmit = function (flag) {
        // 类别信息
        var info = {"dictId":$("#dictId").val(),"dictTypeCode":this.dictTypeCode,"dictName":this.dictName,"flag":flag};
        var ajax = new $ax(Hussar.ctxPath+"/sys/dic/update", function (data) {
            data = data || {};
            if(data.code == 200){
                parent.layui.Hussar.success("修改成功！");
                window.parent.Dict.refreshTreeAndTable();
                DictInfoDlg.close();
            }else{
                Hussar.error("修改失败！（" + (data.message || '未知错误') + "）");
            }

        }, function (data) {
            Hussar.error("修改失败！（" + (data.message || '未知错误') + "）");
        });
        ajax.set('info', JSON.stringify(info));
        ajax.set('dictValues', JSON.stringify(this.mutiString));
        ajax.set('delIdString',JSON.stringify(this.delIdString));
        ajax.set('flag',flag);
        ajax.set('dictTypeId',JSON.stringify(this.dictTypeId));
        ajax.set('dictName',JSON.stringify(this.dictName));
        ajax.set('dictTypeCode',JSON.stringify(this.dictTypeCode));
        ajax.start();
    };
});
