var SysStaffAuditDlg = {
    SysStaffAuditData: {}
};
layui.use(['jquery', 'layer', 'Hussar', 'HussarAjax', "form", "table", "laydate"], function () {

    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var layer = layui.layer;
    var $ax = layui.HussarAjax;
    var form = layui.form;
    var table = layui.table;
    var table1;
    var layerView;

    var SysStaffAudit = {
        seItem: null,
        type: null
    };

    /**
     * 初始化按钮事件
     */
    SysStaffAudit.initButtonEvent = function () {
        $("#btnClose").click(function () {
            SysStaffAudit.closeIndex();
            layer.closeAll();
        });
        //重置
        $("#reset").click(function () {
            SysStaffAudit.reset();
        });
        //查询
        $("#search").click(function () {
            SysStaffAudit.search();
        });
    };
    /**
     * 查询
     */
    SysStaffAudit.search = function () {
        var userName = $('#userName').val();
        var type = $('#type').val();
        SysStaffAudit.initTable()
    }
    /**
     * 重置
     */
    SysStaffAudit.reset = function () {
        $('#userName').val("");
        $('#type').val("");
        // 执行重载
        //  SysStaffAudit.search();
    }

    /**
     * 查看
     */
    SysStaffAudit.view = function (struId, type, realStruId, state) {
        var width;
        //如果是新增 删除
        if ("1" == type || "3" == type) {
            width = "550px"
        } else {
            width = "700px"
        }
        layer.open({
            type: 2,
            area: [width, '550px'],
            title: "查看详情",
            shadeClose: true,
            maxmin: false,
            content: Hussar.ctxPath + '/sysStaffAudit/detail?struId=' + struId + '&type=' + type + '&realStruId=' + realStruId + '&state=' + state,
            skin: 'confirm-class'
        });
    }

    /**
     * 审核
     */
    SysStaffAudit.verify = function (struId, type, inUse, realStruId) {
        var ac = "通过"
        if ("2" == type) {
            ac = "驳回"
        }
        var operation = function () {
            var ajax = new $ax(Hussar.ctxPath + "/sysStruAudit/verify",
                function (data) {
                    if (data.code == 200) {
                        $(".layui-laypage-btn").click();
                        Hussar.success(ac + data.message);
                        table1.reload();
                    } else {
                        Hussar.error(ac + data.message)
                    }
                }, function (data) {
                    Hussar.error(ac + FAIL);
                });
            ajax.set("struId", struId);
            ajax.set("type", type);
            ajax.set("inUse", inUse);
            ajax.set("realStruId", realStruId);
            ajax.start();
        };
        Hussar.confirm("确定要" + ac + "吗 ?", operation);
    }

    /**
     * 获取状态option
     */
    SysStaffAudit.queryOption = function () {
        var ajax = new $ax(Hussar.ctxPath + "/userRoleReview/statusOption",
            function (json) {
                $("#type").html("");
                for (var i = 0; i < json.length; i++) {
                    $("#type").append("<option value='" + json[i].value + "'>" + json[i].label + "</option>");
                }
                form.render();
            }, function (data) {
                Hussar.error(GET_AUDIT_TYPE_FAIL);
            });
        ajax.start();
    };
    /**
     * 初始化列表
     */
    SysStaffAudit.initTable = function () {
        layui.use('table', function () {
            var type = $("#type option:selected").val();
            var userName = $('#userName').val();
            var table = layui.table;
            var str = [{type: 'checkbox', width: 40},
                {title: '序号', type: 'numbers', align: 'center'},
                {field: 'organName', title: '人员名称', align: 'center', sort: false},
                {field: 'typeName', title: '类型', width: 100, align: 'center', sort: false},
                {field: 'parentName', title: '上级组织机构名称', align: 'center', sort: false},
                {
                    field: 'inUse', title: '操作类型', sort: false, width: 100, align: 'center',
                    templet: function (value) {
                        if (value.inUse == '1') {
                            return "新增"
                        } else if (value.inUse == '2') {
                            return "修改"
                        } else if (value.inUse == '3') {
                            return "删除"
                        } else if (value.inUse == '4') {
                            return "转移"
                        } else {
                            return ""
                        }
                    }
                },
                {
                    field: 'STATE', title: '审核类型', sort: false, width: 100, align: 'center',
                    templet: function (value) {
                        if (value.state == '0') {
                            return "未审核"
                        } else if (value.state == '1') {
                            return "已通过"
                        } else if (value.state == '2') {
                            return "已驳回"
                        } else {
                            return ""
                        }
                    }
                },]
            if (type == "0") {
                str.push({field: 'operate', width: 300, title: '操作', sort: false, align: 'center', toolbar: "#operate"})
            }
            table.render({
                elem: '#SysStaffAudit',
                height: $("body").height() - $(".layui-form").outerHeight(true) - 26,
                url: Hussar.ctxPath + '/sysStaffAudit/list',
                cols: [str],
                page: true,
                id: 'SysStaffAudit',
                even: true,
                limit: 10,
                where: {
                	userName:userName,
                    type: type
                }
            });
            table1 = table;
        });
    };
    //监听工具条
    table.on('tool(SysStaffAudit)', function (obj) {
        var data = obj.data;
        if (obj.event === 'view') {
            SysStaffAudit.view(data.struId, data.inUse, data.realStruId, data.state)
        } else if (obj.event === 'pass') {
            SysStaffAudit.verify(data.struId, "1", data.inUse, data.realStruId)
        } else {
            SysStaffAudit.verify(data.struId, "2", data.inUse, data.realStruId)
        }
    })
    /**
     * 初始化
     */
    $(function () {
        SysStaffAudit.queryOption();
        SysStaffAudit.initTable();
        SysStaffAudit.initButtonEvent();
    });

    SysStaffAudit.closeIndex = function () {
        layer.close(layerView);
        SysStaffAudit.search()
    }

    /**
     * 关闭此对话框
     */
    SysStaffAuditDlg.close = function () {
        SysStaffAudit.closeIndex();
    };
});
