/**
 * @Description: 角色管理脚本文件
 * @Author: chenxin
 * @Date: 2018/2/27.
 */

/**
 * 角色信息查看初始化
 */
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','form','element'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer=layui.layer;
	var $ax=layui.HussarAjax;
	var jstree=layui.jstree;
    var RoleManage = {};
    var element=layui.element;
    var form=layui.form;

    /*初始化页面*/
    RoleManage.initPage = function() {
        this.initTable();
        this.initResTree();
        this.initUserTree();
        this.initFrameHeight()
    }

    /**
     *  加载当前角色的关联用户树
     */
    RoleManage.initUserTree = function () {
        var nodeId=$("#nodeId").val();
        var $userTree = $("#userTree");//用户树
        $userTree.jstree({
            core: {
                check_callback: true,
                // // 2019.12.09 修改为懒加载
                data: {
                    "url": Hussar.ctxPath + "/roleManager/lazyRoleUserTreeView",
                    "data": function (node) {
                        return {"nodeId": node.id,roleId:nodeId};
                    }
                }
            },
            plugins: ['types','search'],
            types:{
                "1":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/com.png"},
                "2":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/dept.png"},
                "3":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/station.png"},
                "9":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/empl.png"},
                "USER":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/user.png"},
                "isRoot":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/root.png"}
            },
            search: RoleManage.searchUser()
        });

    };

    /**
     *  角色关联用户树查询
     */
    RoleManage.searchUser = function () {
        var to = false;
        $("#searchUser").keyup(function () {
            if (to) { clearTimeout(to); }
            to = setTimeout(function () {
                var v = $("#searchUser").val();
                var temp = $("#userTree").is(":hidden");
                if (temp == true) {
                    $("#userTree").show();
                }
                $("#userTree").jstree(true).search(v);
                //添加索引
                if(v!=''){
                    //定位到符合查询结果的树节点上
                    var searchResult = $("#userTree").jstree('search', v);
                    $(searchResult).find('.jstree-search').focus();
                }else {
                    $(".search-results1").html("");
                }
            }, 250);
        });
    }

    /**
     * 加载资源树
     */
    RoleManage.initResTree = function (roles) {
        var $retree = $("#resourceTree");//资源树
        $retree.jstree({
            core: {
                check_callback: true,
                data: function (obj, callback) {
                    var data;
                    var resource = [];
                    for(var i=0; i<roles.length; i++){
                        resource.push(roles[i].resourceId);
                    }
                    var ajax = new $ax(Hussar.ctxPath + "/resource/selfResourceTree",function(result) {
                        data = result;
                    }, function(data) {
                        Hussar.error(LOAD_RESOURCES_TREE_FAIL);
                    });
                    ajax.set("rsourceIds",resource.join(','));
                    ajax.start();
                    callback.call(this, data);
                }
            },
            plugins: ['search','types','sort'],
            types:{
                "isRoot":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/root.png"} ,
                "isModule":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/module.png"} ,
                "isFun":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/function.png"} ,
                "1":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/resource_menu.png"}, //菜单资源
                "2":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/resource_btn.png"},  //按钮资源
            },
            sort:function(a,b){
                return this.get_node(a).original.seq > this.get_node(b).original.seq ? 1 : -1;
            },
            search : RoleManage.searchResource()
        });

    };

    /**
     * 资源树查询
     */
    RoleManage.searchResource = function () {
        var to = false;
        $("#searchResource").keyup(function () {
            if (to) { clearTimeout(to); }
            to = setTimeout(function () {
                var v = $("#searchResource").val();
                var temp = $("#resourceTree").is(":hidden");
                if (temp == true) {
                    $("#resourceTree").show();
                }
                $("#resourceTree").jstree(true).search(v);
                //添加索引
                if(v!=''){
                    //定位到符合查询结果的树节点上
                    var searchResult = $("#resourceTree").jstree('search', v);
                    $(searchResult).find('.jstree-search').focus();
                }else {
                    $(".search-results1").html("");
                }
            }, 250);
        });
    };

    RoleManage.initTable = function(){
        var nodeId=$("#nodeId").val();
        var ajax = new $ax(Hussar.ctxPath + "/roleManager/roleView",function(result) {
            $('#resourceTree').jstree("destroy");
            RoleManage.initResTree(result[1]);
        },function(data) {
            Hussar.error(LOAD_ROLE_INFO_FAIL);
        });
        ajax.set("id",nodeId);
        ajax.start();
    }

    RoleManage.initFrameHeight=function(){
        var h3 = $(window).height()-161;
        $("#contentInfo").css("height", h3 + "px");
        $("#userInfo").css("height", h3 + "px");
    };

    /**
     * 初始化
     */
    $(function() {
        RoleManage.initPage();
        $(window).resize(function() {
            RoleManage.initFrameHeight();
        });
    });

});