/**
 * @Description: 组织机构修改
 * @Author: sunZengXin
 * @Date: 2018/2/6.
 */
var EmployeeEdit = {};
layui.use(['jquery','layer','Hussar','form', 'laydate', 'HussarAjax'], function(){
	var form=layui.form,
		laydate = layui.laydate,
		$ = layui.jquery,
		Hussar = layui.Hussar,
        $ax = layui.HussarAjax;

    /**
	 * 初始化时间控件
     */
    EmployeeEdit.initLaydate = function () {
        laydate.render({
            elem: '#beginDate'
        });
        laydate.render({
            elem: '#endDate'
        });
        laydate.render({
            elem: '#birthday'
        });
        laydate.render({
            elem: '#workDate'
        });
        laydate.render({
            elem: '#graduateDate'
        });
    };

    /**
	 * 监听表单提交
     */
    EmployeeEdit.formSubmit = function () {
        form.on('submit(orgInfoEdit)', function(data){
            var formData = data.field;
            if(formData.beginDate>formData.endDate){
                Hussar.info(ENDDATE_CANNOT_EARLIER_STARTDATE);
                return false;
            }
            var ajax = new $ax(Hussar.ctxPath+"/employee/emplInfoEditSave",
                function (data) {
                    if(data.code == 200) {
                        // 提示信息
                        window.parent.layui.Hussar.success(data.message);
                        // 刷新父页面的树
                        window.parent.EmplMaintenance.refreshTree();
                        // 清空iframe
                        window.parent.EmplMaintenance.blank();
                    }else {
                        Hussar.error(data.message);
                    }
                },
                function () {
                    Hussar.error(SAVE_FAIL);
                });
            ajax.setAsync(false);
            ajax.setData(formData);
            ajax.start();
            return false;
        });
    };

    /**
	 * 表单元素渲染
     */
    EmployeeEdit.renderForm = function () {
		//性别
        var sex = $("input[name='sex']");
        for(var i=0; i<sex.length; i++){
            if(sex[i].value == staff_sex){
                sex[i].checked = true;
            }
        }

        form.render();	//设置完成后渲染表单
    };



    /**
	 * 页面加载完成后
     */
    $(function(){
        EmployeeEdit.renderForm();
        EmployeeEdit.initLaydate();
        EmployeeEdit.formSubmit();
    });
	  
});