/**
 * @Description: 通用前端加密组件
 * @Author: 组件
 * @Date: 2018/7/11.
 */

layui.define([],function(exports) {
	var HussarSecurity = function(){
		this.securityType = securityType;
		this.pk = pk;
	};
	
	HussarSecurity.prototype = {
		encode:function(cipher) {
			cipher = decodeURIComponent(cipher,true); 
			var that = this;
			if ("RSACryptoProvider" == that.securityType) {
					var encrypt = new JSEncrypt();
					encrypt.setPublicKey(that.pk);
					var data = encrypt.encrypt(cipher);
					return data;
			}
			if("AESCryptoProvider" == that.securityType){
				var key = CryptoJS.enc.Utf8.parse(that.pk);
			    var srcs = CryptoJS.enc.Utf8.parse(cipher);
			    var encrypted = CryptoJS.AES.encrypt(srcs, key, {mode:CryptoJS.mode.ECB,padding: CryptoJS.pad.Pkcs7});
			    return encrypted.toString();
			}
			if("Base64CryptoProvider" == that.securityType){
			    var encrypted = encode64(cipher);
			    return encrypted.toString();
			}
		}
	};
	exports('HussarSecurity', HussarSecurity);
});