/**
 * 表格的初始化
 */
var RedisThawPwd = {
    id: "RedisThawPwdTable",	//表格id
    seItem: null,		//选中的条目 array
    table: null,
    layerIndex: -1
};



layui.use(['jquery', 'layer', 'table', 'HussarAjax', 'Hussar'], function() {

    var  table = layui.table
        , $ = layui.jquery
        , $ax = layui.HussarAjax
        , Hussar = layui.Hussar;


    /**
     * 检查是否选中
     */
    RedisThawPwd.check = function () {
        var flag = false;
        var selected = table.checkStatus('RedisThawPwdTable').data;
        if (selected && selected.length > 0) {
            RedisThawPwd.seItem = selected;
            flag = true;
        } else {
            Hussar.info(PLEASE_SELECT_AT_LEAST_ONE);
        }
        return flag;
    };

    /**
     * 删除字段
     */
    RedisThawPwd.delete = function () {
        if (RedisThawPwd.check()) {
            var idArr = [];
            RedisThawPwd.seItem.forEach(function (v) {
                idArr.push(v.key);
            });
            var operation = function () {
                var ajax = new $ax(Hussar.ctxPath+"/thawPwd/deleteNoSQLKeys", function (data) {
                    if(data.status == 'success'){
                        Hussar.success(DELETE_SUCCESS);
                        RedisThawPwd.search();
                    }else{
                        Hussar.error(DELETE_FAIL + "（" + data.message + "）")
                    }
                }, function (data) {
                    Hussar.error(DELETE_FAIL + "（" + data.message + "）");
                });
                ajax.set("keys", JSON.stringify(idArr));
                ajax.start();
            };

            Hussar.confirm(DELETE_SURE, operation);
        }
    };

    /**
     * 查询字段列表
     */
    RedisThawPwd.search = function () {
        table.reload('RedisThawPwdTable');
    };

    $(function () {
        var bodyH = $("body").height();
        $(".tree-box").css("height", bodyH + "px");

        table.render({
            elem: '#RedisThawPwdTable'
            ,url: Hussar.ctxPath+'/thawPwd/showRedisValue' //数据接口
            ,page: false //开启分页
            ,cols: [[ //表头
                {type:'checkbox', width: 40},
                {title: '序号', type: 'numbers',width:50},
                {title: '键名', field: 'key'},
                {title: '值', field: 'value'}
            ]]
            ,even: true
            ,height: bodyH - $(".layui-form").outerHeight(true)-26
        });
    });
});
