/**
 * @Description: 定义组织机构规则脚本文件
 * @Author: liangdong
 * @Date: 2018/2/27.
 */
layui.use(['jquery','layer','Hussar','HussarAjax','form','table'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer = layui.layer;
	var $ax = layui.HussarAjax;
	var form = layui.form;
	var table = layui.table;

	/**
	 * 组织机构规则的单例
	 */
	var SysOrgRule = {
	    id: "ruleTable",	//表格id
	    seItem: null,		//选中的条目
	    table: null,
	    layerIndex: -1
	};

	/**
	 * 搜索组织机构规则
	 */
	SysOrgRule.search = function () {
		var parentType = $('#parentType').val();
	    var lowerType = $('#lowerType').val();
        var queryData = {};
        queryData['parentType'] = parentType;
        queryData['lowerType'] = lowerType;
        table.reload('ruleTable', {where: queryData});
	}

    /**
     * 检查是否选中一条记录
     */
    SysOrgRule.check = function () {
        var flag = false;
        var selected = table.checkStatus('ruleTable').data;
        if (selected && selected.length == 1) {
            SysOrgRule.seItem = selected;
            flag = true;
        } else {
            Hussar.info(PLEASE_CHOOSE_ONE);
        }
        return flag;
    }

    /**
     * 检查是否选中多条记录
     */
    SysOrgRule.checkIds = function() {
        var selected = table.checkStatus('ruleTable').data;
        var ids = [];
        if (selected.length == 0) {
            Hussar.info(PLEASE_SELECT_AT_LEAST_ONE);
            return false;
        } else {
            for (var i = 0, l = selected.length; i < l; i++) {
                var r = selected[i];
                ids.push(r.ruleId);
            }
            var eId = ids.join(',');
            SysOrgRule.seItem = eId;
            return true;
        }
    };

	/**
	 * 新增组织机构规则
	 */
	SysOrgRule.add = function () {
	    $("#status").val("add");
	    SysOrgRule.layerIndex = layer.open({
	        type: 1,
	        title: '组织规则新增',
	        area: ['685px', '300px'], //宽高
	        fix: false, //不固定
	        maxmin: false,
	        shadeClose: false,
	        content: $('#addEvent'),
	        success:function(){
	            //重置form
	        	$('#ruleForm')[0].reset();
	            $("#parentOrgType").attr("disabled",false);
	            $("#sonOrgType").attr("disabled",false);
	        }
	    });
	}

    /**
     * 修改组织机构规则
     */
    SysOrgRule.edit = function () {
        if(this.check()){
            $("#status").val("edit");
            SysOrgRule.layerIndex = layer.open({
                type: 1,
                title: '组织规则修改',
                area: ['685px', '300px'], //宽高
                fix: false, //不固定s
                maxmin: false,
                shadeClose: false,
                content: $('#addEvent'),
                success:function(){
                    $('#ruleForm')[0].reset();
                    $("#ruleIdUpdate").val(SysOrgRule.seItem[0].ruleId);//id
                    $("#parentOrgType").val(SysOrgRule.seItem[0].sysOrganType);//上级组织类型
                    $("#sonOrgType").val(SysOrgRule.seItem[0].organType);//下级组织类型
                    $("#ruleNoteUpdate").val(SysOrgRule.seItem[0].ruleNote);//描述
                    $("#parentOrgType").attr("disabled", true);
                    $("#sonOrgType").attr("disabled", true);
                }
            });
        }
    }

	/**
	 * 删除组织机构规则
	 */
	SysOrgRule.del = function () {
		if(this.checkIds()){
			var operation = function() {
				var ajax = new $ax(Hussar.ctxPath + "/orgRule/delete",
						function(data) {
							if (data.code == "200") {
								//Hussar.success("删除成功!");
								Hussar.success(data.message)
								SysOrgRule.search();
							} else if (data.code == "500") {
								Hussar.error(data.message);
							}
						},
						function(data) {
							Hussar.error(DELETE_FAIL);
						});
				ajax.set("eId", SysOrgRule.seItem);
				ajax.start();
			};
			Hussar.confirm(DELETE_SURE_CHOOSE, operation);
		}
	}

    /**
     * 保存组织机构规则
     */
    SysOrgRule.save = function () {
        var status = $("#status").val();
        var ruleId = $("#ruleIdUpdate").val();//id
        var parentOrg = $("#parentOrgType").val();//上级组织类型
        var sonOrg = $("#sonOrgType").val();//下级组织类型
        var ruleNote = $("#ruleNoteUpdate").val();//描述
        if(status == "add"){
            var ajax = new $ax(Hussar.ctxPath + "/orgRule/add",
                function (data) {
                    if (data.code == "200") {
                        //Hussar.success("保存成功");
                        Hussar.success(data.message)
                        SysOrgRule.closeWin();//关闭弹窗
                        SysOrgRule.search();//查询列表
                    } else if (data.code = "500") {
                        Hussar.valid(data.message);
                    } else {
                        //Hussar.valid("保存失败!");
                        Hussar.valid(data.message);
                    }
                },
                function (data) {
                    Hussar.valid(SAVE_FAIL);
                });
            ajax.setData({
                parentOrg: parentOrg,
                sonOrg: sonOrg,
                ruleNote: ruleNote
            });
            ajax.start();
        } else if (status == "edit") {
            var ajax = new $ax(Hussar.ctxPath + "/orgRule/edit",
                function (data) {
                    if (data.code == "200") {
                        //Hussar.success("保存成功!");
                        Hussar.success(data.message);
                    } else if (data.code = "500") {
                        Hussar.valid(data.message);
                    } else {
                        //Hussar.valid("保存失败!");
                        Hussar.valid(data.message);
                    }
                    SysOrgRule.closeWin();
                    SysOrgRule.search();
                },
                function (data) {
                    Hussar.valid(SAVE_FAIL);
                });
            ajax.setData({
                ruleId: ruleId,
                parentOrg: parentOrg,
                sonOrg: sonOrg,
                ruleNote: ruleNote
            });
            ajax.start();
        }
    }

	/**
	 * 关闭弹出窗
	 */
	SysOrgRule.closeWin = function () {
	    layer.close(SysOrgRule.layerIndex);
	}

	/**
	 * 初始化按钮事件
	 */
	SysOrgRule.initButtonEvent = function () {
		$("#btnSearch").click(function(){
			SysOrgRule.search();
	    });
		$("#btnAdd").click(function(){
			SysOrgRule.add();
	    });
		$("#btnEdit").click(function(){
			SysOrgRule.edit();
		});
		$("#btnDel").click(function(){
			SysOrgRule.del();
		});

		$("#btnSave").click(function(){
			form.on('submit(go)', function(data){
				SysOrgRule.save();
			});
		});
		$("#btnClose").click(function(){
			SysOrgRule.closeWin();
		});
	}

	/**
	 * 初始化下拉框
	 */
	SysOrgRule.initSelectTags = function () {
		//获取组织结构类型名称option
		var ajax = new $ax(Hussar.ctxPath + "/orgType/orgTypeOption",
			function (json) {
				$("#parentType").append("<option value=''>上级类型</option>");
				$("#lowerType").append("<option value=''>下级类型</option>");
				$("select[name^='orgType']").append("<option value=''></option>");
				for (var i = 0; i < json.length; i++) {
					$("select[name^='orgType']").append("<option value='" + json[i].organType + "'>" + json[i].typeName + "</option>");
				}
				form.render();
			}, function (data) {
				$.showInforDlg(GET_ORGANIZATION_TYPE_NAME_FAIL);
			});
		ajax.start();
	}

	/**
	 * 初始化表格
	 */
	SysOrgRule.initTableView = function () {
        var parentType = $('#parentType').val();
        var lowerType = $('#lowerType').val();
        table.render({
            elem: '#ruleTable',
            url: Hussar.ctxPath+'/orgRule/list',
            page: true,
            id: 'ruleTable',
            even: true,
            height:$("body").height() - $(".layui-form").outerHeight(true)-26,
            request: {
                pageName: 'curr', //页码的参数名称，默认：page
                limitName: 'nums' //每页数据量的参数名，默认：limit
            },
            cols: [[{type: 'checkbox',width:40},
                {type: 'numbers', title: '序号', align: 'center',width:50},
                {field: 'sysOrganTypeName', title: '上级类型', align:'center',width:130},
                {field: 'organTypeName', title: '下级类型', align:'center',width:200},
                {field: 'ruleNote', title: '规则描述', align:'left'}
            ]],
            where: {
                parentType : parentType,
                lowerType: lowerType
            }
        });
    }

	$(function () {
		SysOrgRule.initSelectTags(); //初始化下拉框
		SysOrgRule.initTableView(); //初始化表格
	    SysOrgRule.initButtonEvent(); //初始化按钮事件
	});

});




