/**
 * @Description: 组织机构新增
 * @Author: sunZengXin
 * @Date: 2018/2/6.
 */
var EmployeeAdd={ id:"employeeAdd"};
layui.use(['jquery','layer','Hussar','form', 'laydate', 'HussarAjax'], function(){
	var form=layui.form,
		laydate = layui.laydate,
		$ = layui.jquery,
		Hussar = layui.Hussar,
		$ax = layui.HussarAjax;


	EmployeeAdd.initButtonEvent=function(){
		  //监听提交
		  form.on('submit(employeeAdd)', function(data){
              var loadIndex = layer.load(1,{shade:true});
			  var formData = data.field;
			  var isEmployee = "1";
			  //是否为人员
			  formData.isEmployee=isEmployee;
			  if(formData.beginDate>formData.endDate){
                  layer.close(loadIndex);
				  Hussar.info(ENDDATE_CANNOT_EARLIER_STARTDATE);
				  return false;
			  }
			  var ajax = new $ax(Hussar.ctxPath+"/employee/emplInfoSave",
				  function (data) {
                      if (data.code == 200){
                          // 提示信息
                          window.parent.layui.Hussar.success(data.message);
                          // 刷新父页面的树
                          window.parent.EmplMaintenance.refreshTree();
                          // 清空iframe
                          window.parent.EmplMaintenance.blank();
                      } else {
                          layer.close(loadIndex);
                          Hussar.error(data.message);
                      }
                  },
				  function () {
                      layer.close(loadIndex);
                      Hussar.error(SAVE_FAIL);
                  });
			  ajax.setData(formData);
			  ajax.setAsync(false);
			  ajax.start();
		    return false;
		  });
	};

    /**
	 * 初始化日期控件
     */
    EmployeeAdd.initLaydate = function () {
        laydate.render({
            elem: '#beginDate'
        });
        laydate.render({
            elem: '#endDate'
        });
        laydate.render({
            elem: '#birthday'
        });
        laydate.render({
            elem: '#workDate'
        });
        laydate.render({
            elem: '#graduateDate'
        });
		
    };


    /**
	 * 页面加载完成后
     */
	$(function(){
		EmployeeAdd.initLaydate();
        EmployeeAdd.initButtonEvent();
	});
});