/**
 * @Description: 定义用户个人信息脚本文件
 * @Author: liangdong
 * @Date: 2018/3/15.
 */
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','HussarSecurity','element','form','table'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer = layui.layer;
	var $ax = layui.HussarAjax;
	var element = layui.element;
	var form = layui.form;
	var table = layui.table;
	var Security = new layui.HussarSecurity();	
	var UserInfo = {	
			roleTree: $("#roleTree"),//角色树
			proxyTree: $("#proxyTree"),//代理用户树
			byProxyTree: $("#byProxyTree"),//被代理用户树
		    layerIndex: -1
		};
	
	/**
	 * 树的模糊查询
	 */
	UserInfo.search = function () {
		var to = false;   
		//角色树查询
		$("#roleTreeSearch").keyup(function () {   
		    if (to) { clearTimeout(to); }   
		    to = setTimeout(function () {   
		        var v = $("#roleTreeSearch").val();   
		        var temp = $roleTree.is(":hidden");   
		        if (temp == true) {   
		        	$roleTree.show();   
		        }   
		        $roleTree.jstree(true).search(v); 
		        //添加索引
				if(v!=''){
                    var n = $(".jstree-search").length,con_html;
                    if(n>0){
                        con_html = "<em>"+ n +"</em>个匹配项";
                    }else{
                        con_html = "无匹配项";
                    }
                    $(".search-results").html(con_html);
				}else {
                    $(".search-results").html("");
				}
		    }, 250);   
		}); 
		//代理用户树查询
		$("#proxyTreeSearch").keyup(function () {   
		    if (to) { clearTimeout(to); }   
		    to = setTimeout(function () {   
		        var v = $("#proxyTreeSearch").val();   
		        var temp = $proxyTree.is(":hidden");   
		        if (temp == true) {   
		        	$proxyTree.show();   
		        }   
		        $proxyTree.jstree(true).search(v);   
		    }, 250);   
		}); 
		//被代理用户树查询
		$("#byProxyTreeSearch").keyup(function () {   
		    if (to) { clearTimeout(to); }   
		    to = setTimeout(function () {   
		        var v = $("#byProxyTreeSearch").val();   
		        var temp = $byProxyTree.is(":hidden");   
		        if (temp == true) {   
		        	$byProxyTree.show();   
		        }   
		        $byProxyTree.jstree(true).search(v);   
		    }, 250);   
		}); 
	}
	
	UserInfo.showUserInfo = function () {
		var ajax = new $ax(Hussar.ctxPath + "/user/currentUserInfo",
    		function(result) {	 				
	        	$('#userForm')[0].reset();	//	重置form
				/*基本信息开始*/
    			var user = result[0];
                $('#userId').val(user.userId);
    			$('#corporationId').val(user.corporationId);
    			$('#userAccount').val(user.userAccount);
    			$('#userName').val(user.userName);
    			$('#maxSessions').val(user.maxSessions);
    			$('#eMail').val(user.eMail);
    			$('#mobile').val(user.mobile);
    			$('#weChat').val(user.weChat);
    			$('#telephone').val(user.telephone);
    			var isSys = $("input[name='isSys']");
    			for(var i=0; i<isSys.length; i++){
    				if(isSys[i].value == user.isSys){
    					isSys[i].checked = true;    				
    				}
    			}    			
    			var state = $("input[name='accountStatus']");
    			for(var i=0; i<state.length; i++){
    				if(state[i].value == user.accountStatus){
    					state[i].checked = true;
    				}
    			}    
    			form.render();
    			/*基本信息结束*/
    			
    			/*角色信息开始*/
//    			var grantRole = result[1];
//    			var roles = [];
//    			for(var i=0; i<grantRole.length; i++){
//    				roles.push(grantRole[i].grantedRole);
//    			}     
//    			UserInfo.initroleTree(roles);
//    			/*角色信息结束*/    			    			
			}, 
			function(data) {
				Hussar.error("加载用户信息失败!");
			});		
		ajax.start();
	};
	
	/**
	 * 加载角色树
	 */
//	UserInfo.initroleTree = function (roles) {	
//		$roleTree = UserInfo.roleTree;//角色树
//	    $roleTree.jstree({
//	        core: {        	
//	            check_callback: true,
//	            data: function (obj, callback) {
//	                var data;
//	                var ajax = new $ax(Hussar.ctxPath + "/roleManager/selfRoleTree",function(result) {                	
//                    	data = result;
//    					}, function(data) {
//    						Hussar.error("加载角色树失败!");
//    					});
//	                ajax.set("roleIds",roles.join(','));	            
//	    			ajax.start();
//	                callback.call(this, data);
//	            }
//	        },
//	        plugins: ['search','types'],
//	        types:{
//	        	"GROUP":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/roleGroup.png"} ,
//	        	"ROLE":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/role.png"} ,
//	        	"isRoot":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/root.png"}
//	        },	       
//	        search: UserInfo.search()
//	    });        
//	};

    /**
	 * 初始化按钮点击事件
     */
    UserInfo.initButtonEvent = function () {
        $("#btnSave").click(function(){
            UserInfo.layerIndex = layer.load(2);
            UserInfo.saveChangeInfo();
        });
    };

    /**
	 * 保存用户可修改的个人信息
     */
    UserInfo.saveChangeInfo = function () {
    	var userId = $('#userId').val();
        var eMail = $('#eMail').val();
        var weChat = $('#weChat').val();
        var mobile = $('#mobile').val();
        var telephone = $('#telephone').val();
        var ajax = new $ax(Hussar.ctxPath + "/user/saveSelfInfo",function(result) {
        	layer.close(UserInfo.layerIndex);
        	Hussar.success("修改成功！");
            UserInfo.showUserInfo();
        }, function(data) {
            layer.close(UserInfo.layerIndex);
            Hussar.error("修改失败!");
        });
        ajax.set("userId",Security.encode(userId));
        ajax.set("eMail", Security.encode(eMail));
        ajax.set("weChat", Security.encode(weChat));
        ajax.set("mobile", Security.encode(mobile));
        ajax.set("telephone", Security.encode(telephone));
        ajax.start();

		
    };

	

	$(function () { 
		UserInfo.showUserInfo();
        UserInfo.initButtonEvent();
	});
	
});




