layui.use(['jquery', 'layer', 'Hussar', 'jstree', 'HussarAjax', 'element','form','table'], function () {
    var Hussar = layui.Hussar,
        table = layui.table;
    var $ = layui.jquery;
    var layer = layui.layer;
    var jstree = layui.jstree;
    var $ax = layui.HussarAjax;
    var form = layui.form;
    var layerView;
    var OrgTreeDemo = {};
    var userTreeArry = [];
    var UserMgr = {};
    var RoleManager = {};
    var RoleInfo = {};
    var flag;
    var data;
    var dataForTable;

    $("#userName").click(function () {
        if (flag || flag === false){
            var title;
            if (flag){
                title = "人员树"
            } else{
                title = "角色树"
            }
            layerView = layer.open({
                type: 1,
                area: ['350px', '400px'],
                fix: false, //不固定
                maxmin: true,
                shadeClose: false,
                shade: 0.4,
                title: title,
                content: $("#userTreeDiv"),
                success: function () {
                    if (flag){
                        var data;
                        var ajax = new $ax(Hussar.ctxPath + "/user/userTree", function (result) {
                            data = result;
                        }, function (data) {
                            Hussar.error(GET_USER_TREE_FAIL);
                        });
                        ajax.set("treeType", 3);
                        ajax.start();
                        OrgTreeDemo.initUserTree(data);
                    } else {
                        RoleManager.initJsTree();
                    }
                },
                end:function () {
                    $("#userTreeSearch").val("");
                    $("#userTreeSearchResult").html("");
                    $('#showUserTree').jstree("destroy");
                }
            });
        }
    });
    OrgTreeDemo.initUserTree = function (data) {
        var $tree = $("#showUserTree");
        $tree.jstree({
            core: {
                data:{
                    "url": Hussar.ctxPath + "/user/userTree",
                    "data": function (node) {
                        return {
                        	  "parentId": node.id,
                              "level" : node.parents.length
                        };
                    }
                
                },
                "multiple": true
            },
            plugins: ['types', 'checkbox','search'],
            checkbox: {
                keep_selected_style: false,
                three_state: true,
                tie_selection: false
            },
            types: {
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/com.png"},
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/dept.png"},
                "3": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/station.png"},
                "9": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/empl.png"},
                "USER": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/user.png"}
            },
            search: UserMgr.search(),
            sort:function(a,b){
                return this.get_node(a).original.struOrder > this.get_node(b).original.struOrder ? 1 : -1;
            }
        })
        $tree.bind('activate_node.jstree', function (obj, e) {
            var ref = $tree.jstree(true);
            if (e.node.type == "USER") {
                var nodes = ref.get_checked(); //使用get_checked方法
                OrgTreeDemo.getUserCheckedId($tree);
            } else {
                ref.uncheck_node(e.node.id);
                return;
            }
        })
        $tree.on('ready.jstree open_node.jstree', function (obj, e) {
            //这两句话是在loaded所有的树节点后，然后做的选中操作，这点是需要注意的，loaded.jstree 这个函数
            //取消选中，然后选中某一个节点
            $("#showUserTree").jstree("deselect_all",true);
            //是选中的节点id，然后后面的一个参数 true表示的是不触发默认select_node.change的事件
            var userId = $("#userId").val();
            var ids =  userId.split(",");
            $('#showUserTree').jstree('check_node',ids,true);
            OrgTreeDemo.getUserCheckedId($tree);
        })
    }
    OrgTreeDemo.getUserCheckedId = function (tree) {
        var ref = tree.jstree(true);
        var nodes = ref.get_checked(true);  //使用get_checked方法
        var nds = [];
        var names = '';
        $.each(nodes, function (i, nd) {
            var type = nd.original.type;
            if (type == "USER") {
                nds.push(nd.id);
                names += "," + nd.text
            }
        });
        userTreeArry = [];
        userTreeArry.push(nds);
        userTreeArry.push(names.substring(1));
        return userTreeArry;
    }
    $("#userTreeSave").click(function () {
        if (flag){
            var nodes = $("#showUserTree").jstree(true).get_checked();//使用get_checked方法
            if (nodes.length == 0) {
                layer.msg("请选择用户！");
            } else {
                $("#userId").val(userTreeArry[0]);
                $("#userName").val(userTreeArry[1]);
                $("#userTreeSearch").val("");
                $("#userTreeSearchResult").html("");
                $('#showUserTree').jstree("destroy");
                layer.close(layerView);
            }
        } else {
            var nodes = $("#showUserTree").jstree(true).get_checked();//使用get_checked方法
            if (nodes.length == 0) {
                layer.msg("请选择角色！");
            } else {
                $("#userId").val(RoleInfo.ids);
                $("#userName").val(RoleInfo.names);
                $("#userTreeSearch").val("");
                $("#userTreeSearchResult").html("");
                $('#showUserTree').jstree("destroy");
                layer.close(layerView);
            }
        }

    })
    $("#userTreeRest").click(function () {
        $("#userTreeSearch").val("");
        $("#userTreeSearchResult").html("");
        var $tree = $("#showUserTree");
        var ref = $tree.jstree(true);
        if (!flag){
            ref.uncheck_node( RoleInfo.ids);
            RoleInfo.ids = [];
        } else{
            ref.uncheck_node(userTreeArry[0]);
            userTreeArry = [];
        }
    })
    /**
     * 所有树的模糊查询
     */
    UserMgr.search = function () {
        var to = false;
        //用户树查询
        $("#userTreeSearch").keyup(function () {
            if (to) { clearTimeout(to); }
            to = setTimeout(function () {
                var v = $("#userTreeSearch").val();
                var temp =$("#showUserTree").is(":hidden");
                if (temp == true) {
                    $("#showUserTree").show();
                }
                $("#showUserTree").jstree(true).search(v);
                //添加索引
                if(v!=''){
                    var n = $(".jstree-search").length,con_html;
                    if(n>0){
                        con_html = "<em>"+ n +"</em>个匹配项";
                    }else{
                        con_html = "无匹配项";
                    }
                    $("#userTreeSearchResult").html(con_html);
                    //定位到符合查询结果的树节点上
                    var searchResult = $("#showUserTree").jstree('search', v);
                    $(searchResult).find('.jstree-search').focus();
                }else {
                    $("#userTreeSearchResult").html("");
                }
            }, 250);
        });
    };

    form.on('select(select)', function(data){
        if (data.value === '1') {
            flag = false;
        }else if (data.value === '2') {
            flag = true;
        }else {
            flag = null;
        }
        $("#userName").val("")
    });

    /*角色树*/

    /**
     * 初始化角色树
     */
    RoleManager.initJsTree = function(){
        var $tree = $("#showUserTree");
        $tree.jstree({
            core: {
                data:{
                    "url": Hussar.ctxPath + "/roleManager/roleTree",
                    "data": function (node) {
                        return {
                        	"nodeId": node.id,
                        	"functionType":"edit"
                        };
                    }
                },
                "multiple": true
            },
            plugins: ['types', 'checkbox','search'],
            checkbox: {
                keep_selected_style: false,
                three_state: true,
                tie_selection: false
            },
            types: {
                "GROUP":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/roleGroup.png"},
                "ROLE":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/role.png"},
                "ORGANROLE":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/role.png"},
                "isRoot":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/root.png"}
            },
            search:RoleManager.search(),
            sort:function(a,b){
                return this.get_node(a).original.struOrder > this.get_node(b).original.struOrder ? 1 : -1;
            }
        });
        $tree.bind('activate_node.jstree', function (obj, e) {
            var ref = $tree.jstree(true);
            if (e.node.type == "ROLE" || e.node.type == "ORGANROLE" || e.node.type == "GROUP") {
                var nodes = ref.get_checked(); //使用get_checked方法
                RoleManager.getRoleCheckedId($tree);
            } else {
                ref.uncheck_node(e.node.id);
            }
        });
        $tree.on('ready.jstree open_node.jstree', function (obj, e) {
            //这两句话是在loaded所有的树节点后，然后做的选中操作，这点是需要注意的，loaded.jstree 这个函数
            //取消选中，然后选中某一个节点
            $("#showUserTree").jstree("deselect_all",true);
            //是选中的节点id，然后后面的一个参数 true表示的是不触发默认select_node.change的事件
            var userId = $("#userId").val();
            var ids =  userId.split(",");
            $('#showUserTree').jstree('check_node',ids,true);
            RoleManager.getRoleCheckedId($tree);
        })
    };

    /**
     * 获得选中的角色id以及text值
     * @param tree 角色树
     */
    RoleManager.getRoleCheckedId = function (tree) {
        var ref = tree.jstree(true);
        var nodes = ref.get_checked(true);  //使用get_checked方法
        var nds = [];
        var names = '';
        $.each(nodes, function (i, nd) {
            var type = nd.original.type;
            if (type == "ROLE" ||type=="ORGANROLE") {
                nds.push(nd.id);
                names += "," + nd.text
            }
        });
        RoleInfo = {};
        RoleInfo.ids = nds;
        RoleInfo.names = names.substring(1);
    };

    /**
     * 角色树查询事件
     */
    RoleManager.search = function(){
        var to = false;
        //用户树查询
        $("#userTreeSearch").keyup(function () {
            if (to) { clearTimeout(to); }
            to = setTimeout(function () {
                var v = $("#userTreeSearch").val();
                var temp = $("#showUserTree").is(":hidden");
                if (temp == true) {
                    $("#showUserTree").show();
                }
                $("#showUserTree").jstree(true).search(v);
                //添加索引
                if(v!=''){
                    var n = $(".jstree-search").length,con_html;
                    if(n>0){
                        con_html = "<em>"+ n +"</em>个匹配项";
                    }else{
                        con_html = "无匹配项";
                    }
                    $("#userTreeSearchResult").html(con_html);
                    //定位到符合查询结果的树节点上
                    var searchResult = $("#showUserTree").jstree('search', v);
                    $(searchResult).find('.jstree-search').focus();
                }else {
                    $("#userTreeSearchResult").html("");
                }
            }, 250);
        });
    };

    /**
     * 收集数据
     */
    function collectData(){
        var type;
        if (flag){
            type = 2;
        } else {
            type = 1;
        }
        data = {
            userId : $("#userId").val(),
            userName : $("#userName").val(),
            welcomeUrl : $("#welcomeUrl").val(),
            types : type
        }
    }

    /**
     * 保存
     */
    $("#btnSave").click(function () {
        collectData();
        var url;
        if (flag){
            url = "/sysWelcome/add";
        } else {
            url = "/sysWelcome/addRole";
        }
        var type=$("#status").val();
        form.on("submit(save)",function () {
            if(type=="add"){
                //提交信息
                var ajax = new $ax(Hussar.ctxPath + url, function(data){
                    if (data.code == 200) {
                        Hussar.success(SAVE_SUCCESS);
                        SysWelcomeInfoDlg.close();
                    }else {
                        Hussar.error(data.message);
                    }
                },function(data){
                    Hussar.error(ADD_FAIL + data.message + "!");
                });
                ajax.set(data);
                ajax.start();
            }else{
                //提交信息
                var ajax = new $ax(Hussar.ctxPath + "/sysWelcome/update", function(data){
                    if (data.code == 200) {
                        layer.closeAll('page');
                        Hussar.success(UPDATE_SUCCESS);
                        table.reload('SysWelcomeTable')
                    }else {
                        Hussar.error(data.message);
                    }
                },function(data){
                    Hussar.error(UPDATE_FAIL + data.message + "!");
                });
                ajax.set(data);
                ajax.set("oldUrl",$("#oldUrl").val());
                ajax.start();
            }
        });
    });

    /**
     * 选中一条结果
     */
    function check() {
        var checkStatus = table.checkStatus('SysWelcomeTable'),
            data = checkStatus.data;
        if (data.length == 0 || data.length > 1) {
            Hussar.info(PLEASE_CHOOSE_ONE);
            return false;
        } else {
            dataForTable = data[0];
            return true;
        }
    }

    /**
     * 点击修改用户欢迎页配置
     */
    $("#edit").click(function(){
        $("#select").attr("lay-verify","");
        $("#val").hide();
        if (check()) {
            $("#status").val("edit");
            if (dataForTable.types === '1'){
                flag = false;
            } else {
                flag = true;
            }
            layerView = layer.open({
                type : 1,
                area : [ '400px', '300px' ],
                shadeClose : false,
                maxmin : false,
                title : '修改',
                content : $("#viewEvent"),
                success : function() {
                    var ajax = new $ax(Hussar.ctxPath + "/sysWelcome/sysWelcome_update", function(data) {
                        $("#userName").val(data.userName);
                        $("#userId").val(data.userId);
                        $("#welcomeUrl").val(data.welcomeUrl);
                        $("#oldUrl").val(data.welcomeUrl);
                        form.render();
                    }, function(data) {
                        Hussar.error(SELECT_INFO_FAIL);
                    });
                    ajax.set("sysWelcomeUrl",dataForTable.welcomeUrl);
                    ajax.set("types",dataForTable.types);
                    ajax.start();
                },end : function() {
                    $("#userName").val("");
                    $("#userId").val("");
                    $("#welcomeUrl").val("");
                    $("#oldUrl").val("");
                    form.render();
                }
            });
        }
    });
 });