/**
 * 管理初始化
 */
var SysUsersAudit = {
    id: "SysUsersAuditTable",	//表格id
    seItem: null,		//选中的条目
    table: null,
    layerIndex: -1,
    pageSize: 20,
    pageNumber: 1
};
layui.use(['layer', 'bootstrap_table_edit', 'Hussar', 'HussarAjax', 'table'], function () {
    var layer = layui.layer
        , table = layui.table
        , Hussar = layui.Hussar
        , $ = layui.jquery
        , $ax = layui.HussarAjax;

    /**
     * 初始化表格的列
     */
    SysUsersAudit.initColumn = function () {
        var tableHead = [
            {
                type: 'checkbox',
                width: 40
            },
            {
                type: 'numbers',
                title: '序号',
                align: 'center',
                width: 50},
            {
                field: 'userName',
                title: '用户名称',
                align: 'center'},
            {
                field: 'userAccount',
                title: '登录账号',
                align: 'center'},
            {
                field: 'currentStatus',
                title: '操作类型',
                align: 'center',
                templet: function (row) {
                    if (row.currentStatus == '0') {
                        return "新增"
                    } else if (row.currentStatus == '1') {
                        return "修改"
                    } else if (row.currentStatus == '2') {
                        return "删除"
                    } else if (row.currentStatus == '3'){
                        return "转移"
                    } else if (row.currentStatus == '4'){
                        return "注销"
                    } else {
                        return ""
                    }
                }
            },
            {
                field: 'isAudit',
                title: '审核状态',
                align: 'center',
                templet: function (row) {
                    if (row.isAudit == '0') {
                        return "未审核"
                    } else if (row.isAudit == '1') {
                        return "已通过"
                    } else if (row.isAudit == '2') {
                        return "已驳回"
                    } else {
                        return ""
                    }
                }
            }
        ];
        if ($("#status").val() == 0) {
            tableHead.push({
                field: 'operate',
                width: 300,
                title: '操作',
                sort: false,
                align: 'center',
                toolbar: "#operate"
            })
        }
        return [tableHead]
    };

    //监听工具条
    table.on('tool(sysUsersAudit)', function (obj) {
        var row = obj.data;
        var ev = obj.event
        if (ev == "view") { // 详情
            if (row.currentStatus == "1") { // 修改情况下
                if (row.isAudit == "1") { // 已通过
                    SysUsersAudit.viewEditPass(row);
                } else { // 未审核或者驳回
                    SysUsersAudit.viewEdit(row);
                }
            } else if (row.currentStatus == "3") { // 转移
                SysUsersAudit.viewTrans(row);
            } else {
                SysUsersAudit.view(row);
            }
        } else if (ev == "pass") {
            if (row.currentStatus == "0") { // 通过
                SysUsersAudit.passAdd(row);
            } else if (row.currentStatus == "1") {
                SysUsersAudit.passEdit(row);
            } else if (row.currentStatus == "2") {
                SysUsersAudit.passDel(row);
            } else if (row.currentStatus == "3") {
                SysUsersAudit.passTrans(row)
            } else if (row.currentStatus == "4") {
                SysUsersAudit.passCalcel(row)
            }
        } else if (ev == "reject") { // 驳回
            SysUsersAudit.reject(row);
        } else {

        }
    });

    /**
     * 查看详情
     */
    SysUsersAudit.view = function (row) {
        SysUsersAudit.layerIndex = layer.open({
            type: 2,
            area: ['400px', '500px'],
            title: "查看详情",
            shadeClose: true,
            maxmin: false,
            content: Hussar.ctxPath + '/user/detail?id=' + row.id ,
            skin: 'confirm-class'
        });
    };

    /**
     * 查看转移详情
     */
    SysUsersAudit.viewTrans = function (row) {
        SysUsersAudit.layerIndex = layer.open({
            type: 2,
            area: ['600px', '200px'],
            title: "查看详情",
            shadeClose: true,
            maxmin: false,
            content: Hussar.ctxPath + '/user/transDetail?id=' + row.id ,
            skin: 'confirm-class'
        });
    };

    /**
     * 修改(未审核以及驳回)查看详情
     */
    SysUsersAudit.viewEdit = function (row) {
        SysUsersAudit.layerIndex = layer.open({
            type: 2,
            area: ['600px', '500px'],
            title: "查看详情",
            shadeClose: true,
            maxmin: false,
            content: Hussar.ctxPath + '/user/editDetail?id=' + row.id ,
            skin: 'confirm-class'
        });
    };

    /**
     * 修改（已通过）查看详情
     */
    SysUsersAudit.viewEditPass = function (row) {
        SysUsersAudit.layerIndex = layer.open({
            type: 2,
            area: ['400px', '500px'],
            title: "查看详情",
            shadeClose: true,
            maxmin: false,
            content: Hussar.ctxPath + '/user/editPassDetail?id=' + row.id ,
            skin: 'confirm-class'
        });
    };

    /**
     * 新增通过
     */
    SysUsersAudit.passAdd = function (row) {
        var operation = function () {
            var ajax = new $ax(Hussar.ctxPath + "/user/passAdd",
                function (data) {
                    if (data.code == 200) {
                        Hussar.success(THROUGH_SUCCESS);
                        SysUsersAudit.search();
                    } else {
                        Hussar.error(THROUGH_FAIL)
                    }
                }, function () {
                    Hussar.error(THROUGH_FAIL);
                });
            ajax.set("id", row.id);
            ajax.start();
        };
        Hussar.confirm(THROUGH_SURE, operation);
    };

    /**
     * 修改通过
     */
    SysUsersAudit.passEdit = function (row) {
        var operation = function () {
            var ajax = new $ax(Hussar.ctxPath + "/user/passEdit",
                function (data) {
                    if (data.code == 200) {
                        Hussar.success(THROUGH_SUCCESS);
                        SysUsersAudit.search();
                    } else {
                        Hussar.error(THROUGH_FAIL)
                    }
                }, function () {
                    Hussar.error(THROUGH_FAIL);
                });
            ajax.set("id", row.id);
            ajax.start();
        };
        Hussar.confirm(THROUGH_SURE, operation);
    };

    /**
     * 删除通过
     */
    SysUsersAudit.passDel = function (row) {
        var operation = function () {
            var ajax = new $ax(Hussar.ctxPath + "/user/passDel",
                function (data) {
                    if (data.code == 200) {
                        Hussar.success(THROUGH_SUCCESS);
                        SysUsersAudit.search();
                    } else {
                        Hussar.error(THROUGH_FAIL)
                    }
                }, function () {
                    Hussar.error(THROUGH_FAIL);
                });
            ajax.set("id", row.id);
            ajax.start();
        };
        Hussar.confirm(THROUGH_SURE, operation);
    };
    /**
     * 注销通过
     */
    SysUsersAudit.passCalcel = function (row) {
        var operation = function () {
            var ajax = new $ax(Hussar.ctxPath + "/user/passCalcel",
                function (data) {
                    if (data.code == 200) {
                        Hussar.success(THROUGH_SUCCESS);
                        SysUsersAudit.search();
                    } else {
                        Hussar.error(THROUGH_FAIL)
                    }
                }, function () {
                    Hussar.error(THROUGH_FAIL);
                });
            ajax.set("id", row.id);
            ajax.start();
        };
        Hussar.confirm(THROUGH_SURE, operation);
    };

    /**
     * 转移通过
     */
    SysUsersAudit.passTrans = function (row) {
        var operation = function () {
            var ajax = new $ax(Hussar.ctxPath + "/user/passTrans",
                function (data) {
                    if (data.code == 200) {
                        Hussar.success(THROUGH_SUCCESS);
                        SysUsersAudit.search();
                    } else {
                        Hussar.error(THROUGH_FAIL)
                    }
                }, function () {
                    Hussar.error(THROUGH_FAIL);
                });
            ajax.set("id", row.id);
            ajax.start();
        };
        Hussar.confirm(THROUGH_SURE, operation);
    };


    /**
     * 驳回
     */
    SysUsersAudit.reject = function (row) {
        var operation = function () {
            var ajax = new $ax(Hussar.ctxPath + "/user/reject",
                function (data) {
                    if (data.code == 200) {
                        Hussar.success(REJECT_SUCCESS);
                        SysUsersAudit.search();
                    } else {
                        Hussar.error(REJECT_FAIL)
                    }
                }, function () {
                    Hussar.error(REJECT_FAIL);
                });
            ajax.set("id", row.id);
            ajax.start();
        };
        Hussar.confirm(REJECT_SURE, operation);
    };

    /**
     * 查询列表
     */
    SysUsersAudit.search = function () {
        SysUsersAudit.initTable();
    };

    /**
     * 初始化表格
     */
    SysUsersAudit.initTable = function () {
        table.render({
            elem: '#SysUsersAuditTable',
            url: Hussar.ctxPath + '/user/listAudit',
            page: true,
            id: 'SysUsersAuditTable',
            limit: 10,
            where: { //设定异步数据接口的额外参数，任意设
                type: $("#type").val(),
                account: $("#condition").val(),
                status: $("#status").val()
            },
            even: true,
            height: $("body").height() - $(".layui-form").outerHeight(true) - 26,
            cols: SysUsersAudit.initColumn()
        });
    }

    $(function () {
        SysUsersAudit.initTable();
    })

});