var SysBaseConfigDlg = {
    SysBaseConfigData: {}
};
layui.use(['jquery', 'layer', 'Hussar', 'HussarAjax', "form", "table", "laydate"], function () {

    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var laydate = layui.laydate;
    var layer = layui.layer;
    var $ax = layui.HussarAjax;
    var form = layui.form;
    var table = layui.table;
    var table1;
    var layerView;

    var SysBaseConfig = {
        seItem: null,
        type: null,
        inputTemplate: $("#config1").html(),
        radioTemplate: $("#config2").html(),
        timeTemplate: $("#config3").html(),
    };

    /**
     * 初始化按钮事件
     */
    SysBaseConfig.initButtonEvent = function () {
        $("#btnClose").click(function () {
            SysBaseConfig.closeIndex();
            layer.closeAll();
        });
        $("#btnSave").click(function () {
            SysBaseConfig.save();
        });
    };
    /**
     * 初始化表单验证
     */
    SysBaseConfig.initValidate = function () {
        form.verify({
            required: function (value, item) {
                if (value.trim() === "") {
                    return '必填项不能为空！';
                }
            },
        });
    };
    /**
     * 保存
     */
    SysBaseConfig.save = function () {
        form.on('submit(save)', function (d) {
            var saveData = $("#addForm").serialize();
            var configKey = $('#configKey').val()
            /*if (configKey == "access_time") {
                var date1 = $('#date1').val()
                var date2 = $('#date2').val()
                if (date1 > date2) {
                    Hussar.info("开始不能早于结束日期！");
                    return false;
                }
                saveData = saveData + "&configValue=" + date1 + "-" + date2
            }*/
            if (!(configKey == "user_account_status") ) {
                var configValue = $('#configValue').val()
                if (!/^[0-9]*$/.test(configValue)) {
                    Hussar.error("请输入正整数!");
                    return
                }
            }
           /* if (configKey == "access_ip") {
                var configValue = $('#configValue').val()
                if (configValue.indexOf("，") != -1) {
                    Hussar.error("请使用英文逗号隔开!");
                    return
                }
            }*/
            var ajax = new $ax(Hussar.ctxPath + "/sysBaseConfig/update", function (data) {
                if (data.code == 200) {
                    //保存成功
                    Hussar.success(data.message);
                    SysBaseConfigDlg.close();
                } else {
                    Hussar.error(data.message);
                }
            }, function (data) {
                Hussar.error(SAVE_FAIL);
            });
            ajax.setData(saveData);
            ajax.start();
        });

    }

    /**
     * 编辑
     */
    SysBaseConfig.edit = function (id) {
        layerView = layer.open({
            type: 1,
            area: ['475px', '430px'],
            shadeClose: false,
            maxmin: false,
            title: '修改',
            content: $("#viewEvent"),
            success: function () {
                var ajax = new $ax(Hussar.ctxPath + "/sysBaseConfig/detail", function (data) {
                    $("#id").val(data.id);
                    $("#name").val(data.name);
                    $("#example").val(data.example);
                    $("#configKey").val(data.configKey);
                    $("#example").css("background","#f5f5f5");
                    if ("user_account_status" == data.configKey) {
                        document.getElementById("config").innerHTML = "";
                        $("#config").append(SysBaseConfig.radioTemplate)
                        form.render();
                        var status = $("input[name='configValue']");
                        for (var i = 0; i < status.length; i++) {
                            if (status[i].value == data.configValue) {
                                status[i].checked = true;
                            }
                        }
                    } /*else if ("access_time" == data.configKey) {
                        document.getElementById("config").innerHTML = "";
                        $("#config").append(SysBaseConfig.timeTemplate)
                        var date = data.configValue
                        laydate.render({
                            elem: '#date1'
                            , type: 'time'
                            ,value:date.split("-")[0]
                        });
                        laydate.render({
                            elem: '#date2'
                            , type: 'time'
                            ,value:date.split("-")[1]
                        });
                    }*/ else {
                        document.getElementById("config").innerHTML = "";
                        $("#config").append(SysBaseConfig.inputTemplate);
                        form.render();
                        $("#configValue").val(data.configValue);
                    }
                    form.render();
                }, function (data) {
                    Hussar.error(SELECT_INFO_FAIL);
                });
                ajax.set("sysBaseConfigId", id);
                ajax.start();
            }
        });
    };

    SysBaseConfig.initTable = function () {
        layui.use('table', function () {
            var table = layui.table;
            table.render({
                elem: '#SysBaseConfig',
                height: $("body").height() - $(".layui-form").outerHeight(true) - 26,
                url: Hussar.ctxPath + '/sysBaseConfig/list',
                cols: [
                    [{
                        type: 'checkbox',
                        width: 40
                    }, {
                        title: '序号',
                        type: 'numbers',
                        align: 'center'
                    }, {
                        field: 'name',
                        title: '配置项',
                        sort: false,
                        align: 'center'
                    }, {
                        field: 'configKey',
                        title: '配置键',
                        align: 'center',
                        sort: false,
                    }, {
                        field: 'configValue',
                        title: '配置值',
                        sort: false,
                        align: 'center',
                        templet: function (value) {
                            if (value.configKey == 'user_account_status') {
                                if ("0" == value.configValue) {
                                    return "锁定"
                                } else {
                                    return "休眠"
                                }
                            } else {
                                return value.configValue
                            }
                        }
                    }, {
                        field: 'example',
                        title: '说明',
                        sort: false,
                        align: 'center',
                    }, {
                        field: 'operate',
                        title: '操作',
                        sort: false,
                        align: 'center',
                        toolbar: "#operate"
                    }
                    ]],
                page: true,
                id: 'SysBaseConfig',
                even: true,
                limit: 10
            });
            table1 = table;
        });
    };
    //监听工具条
    table.on('tool(SysBaseConfig)', function (obj) {
        var data = obj.data;
        if (obj.event === 'edit') {
            SysBaseConfig.edit(data.id)
        }
    })

    /**
     * 初始化
     */
    $(function () {
        SysBaseConfig.initTable();
        SysBaseConfig.initButtonEvent();
        SysBaseConfig.initValidate();
    });
    SysBaseConfig.closeIndex = function () {
        layer.close(layerView);
        // 执行重载
        table1.reload('SysBaseConfig', {
            page: {
                curr: 1
            }
        });
    }

    /**
     * 关闭此对话框
     */
    SysBaseConfigDlg.close = function () {
        SysBaseConfig.closeIndex();
    };
});
