/**
 * @Description: 角色管理脚本文件
 * @Author: chenxin
 * @Date: 2018/2/27.
 */
var RoleManage = {
    layIndex: null,
    exportTree: null
};
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','form','upload', 'element'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer=layui.layer;
	var $ax=layui.HussarAjax;
	var jstree=layui.jstree;
    var element=layui.element;
    var upload = layui.upload;


    RoleManage.initTree = function () {
        var $tree = $("#roleTree");// 角色树
        $tree.jstree({
            core: {
                check_callback: true,
                // 2019/12/09修改为懒加载
                data: {
                    "url": Hussar.ctxPath + "/roleManager/lazyRoleTree",
                    "data": function (node) {
                        return {"nodeId": node.id};
                    }
                }
            },
            contextmenu:{
                select_node:true,
                show_at_node:true,
                'items' : RoleManage.contextmenu
            },
            plugins: ['contextmenu','types','search'],
            types: {
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/com.png"},
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/dept.png"},
                "3": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/station.png"},
                "GROUP":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/roleGroup.png"},
                "ROLE":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/role.png"},
                "ORGANROLE":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/role.png"},
                "isRoot":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/root.png"}
            },
            search : RoleManage.search()
        });
        $tree.bind('activate_node.jstree', function (obj,e){
        	if(e.node.state.isOrganRoleNode){
        		 $("#roleIframe").attr("src",Hussar.ctxPath + "/roleManager/roleViewPage?id=" + e.node.id);
        	}else if(e.node.original.code == 'ROLE'){
                if(e.node.id=="1400a6ac866c40a2a44baf1394060306"){
                    e.node.id+=",public_role";
                }
                $("#roleIframe").attr("src",Hussar.ctxPath + "/roleManager/roleViewPage?id=" + e.node.id)
            }else if(e.node.original.code == 'GROUP'&&e.node.original.parent != '#'){
                $("#roleIframe").attr("src",Hussar.ctxPath + "/roleManager/roleGroupViewPage?id=" + e.node.id)
            }else{
                $("#roleIframe").attr("src","")
            }
        })
    };

    /**
	 * 树查询
	 */
    RoleManage.search = function () {
        var to = false;
        $("#txtIndustryArea").keyup(function () {
            if (to) { clearTimeout(to); }
            to = setTimeout(function () {
                var v = $("#txtIndustryArea").val();
                var temp = $("#roleTree").is(":hidden");
                if (temp == true) {
                    $("#roleTree").show();
                }
                $("#roleTree").jstree(true).search(v);
                // 添加索引
                if(v!=''){
                    var n = $(".jstree-search").length,con_html;
                    if(n>0){
                        con_html = "<em>"+ n +"</em>个匹配项";
                    }else{
                        con_html = "无匹配项";
                    }
                    $(".search-results").html(con_html);
                    // 定位到符合查询结果的树节点上
                    var searchResult = $("#roleTree").jstree('search', v);
                    $(searchResult).find('.jstree-search').focus();
                }else {
                    $(".search-results").html("");
                }
            }, 250);
        });
    };

    /**
	 * 右键菜单
	 */
    RoleManage.contextmenu = function (node) {
        if(node!=undefined){
        	var state = node.state;
        	if(state.isOrganRoleTree){
        		// 组织角色树右键菜单
        		var items = {
                		'organRoleAdd' : {
                			'label' : '新增组织角色',
                            'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5011.png",
                            'action' : function(){
                            	$("#roleIframe").attr("src",Hussar.ctxPath + "/roleManager/roleAddPage?type=organRoleAdd&id="+node.id);
                            }
                		},
                		'organRoleEdit' : {
                			'label' : '修改组织角色',
                			'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/53.png",
                            'action' : function () {
                                $("#roleIframe").attr("src",Hussar.ctxPath + "/roleManager/roleEditPage?type=organRoleEdit&id="+node.id);
                            }
                		}, 
                		'reclaimPerm' : {
                            'label' : '回收角色权限',
                            'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5411.png",
                            'action' : function () {
                                var operation = function() {
                                    var ajax = new $ax(Hussar.ctxPath + "/roleManager/reclaimPerm",
                                        function() {
                                            Hussar.success(RECOVERY_PERMISSION_SUCCESS);
                                            $("#roleIframe").attr("src",Hussar.ctxPath + "/roleManager/roleViewPage?id=" + node.id)
                                        },
                                        function(data) {
                                            Hussar.error(RECOVERY_PERMISSION_FAIL);
                                        });
                                    ajax.set("id", node.id);
                                    ajax.start();
                                };
                                Hussar.confirm(RECOVERY_PERMISSION_SURE, operation);
                            }
                        },
                		'organRoleDel' : {
                			'label' : '删除组织角色',
            			    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/57.png",
                            'action' : function () {
                                 var operation = function() {
                                     var ajax = new $ax(Hussar.ctxPath + "/roleManager/delRole",
                                         function(data) {
                                             if(data.code=="200"){
                                                 Hussar.success(data.message);
                                                 RoleManage.refreshPage();
                                             }
                                             else if (data.code == "409") {
                                            	 Hussar.error("删除失败！("+data.message+")");
        		                              }else {
        		                                  Hussar.error(data.message);
        		                              }
        		                              },
        		                              function(data) {
        		                                  Hussar.error(DELETE_FAIL);
        		                              });
        		                          ajax.set("id", node.id);
        		                          ajax.start();
                                 	};
                                Hussar.confirm(DELETE_SURE, operation);
                            }
                		},
                		'organRoleOrder' :{
                			'label' : '下级角色排序',
                			'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5111.png",
                            'action' : function () {
                                RoleManage.roleOrder(node);
                            }
                		},
                        export: {
                            label: "资源导出",
                            'icon': Hussar.ctxPath + "/static/assets/img/treeContext/export.png",
                            action: function (obj) {
                            	RoleManage.dataExport();
                            }
                        },
                        import: {
                            label: "资源导入",
                            'icon': Hussar.ctxPath + "/static/assets/img/treeContext/import.png",
                            action: function (obj) {
                            	RoleManage.dataImport();
                            }
                        }
                	}
        		  // 角色排序
                var shiroAdd=$("#shiroAdd").val();
        		var shiroEdit=$("#shiroEdit").val();
                var shiroDel=$("#shiroDel").val();
                var shiroRec=$("#shiroRec").val();
        		if(state.gradeDisabled){
        		    delete items.organRoleAdd;
        		    delete items.organRoleDel;
        		    delete items.organRoleEdit;
        		    delete items.reclaimPerm;
        		    delete items.organRoleOrder;
                }
        		
        		if(shiroAdd!="add"){
        		    delete items.organRoleAdd;
	            }
        		if(shiroEdit!="edit"){
        			delete items.organRoleEdit;
        		}
                if(shiroRec!="rec"){
        		    delete items.reclaimPerm;
                }
                if(shiroDel!="del"){
        		    delete items.organRoleDel;
                }
        		
        		// 是角色节点的，删除新增角色、角色排序的菜单
        		if(state.isOrganRoleNode){
        		    delete items.organRoleAdd;
        			delete items.organRoleOrder;
        		}else{
        			// 是组织机构节点的，删除其它菜单，只保留新增角色、角色排序的菜单
        			delete items.organRoleEdit;
        			delete items.organRoleDel;
        			delete items.reclaimPerm;
        		}
        		// 导出导入右键菜单只有根节点存在
	            if (node.parent != '#') {
	                delete items.export;
	                delete items.import;
	            }else{
	                var importData = $("#importData").val();
	                var exportData = $("#exportData").val();
	                
	                if(importData!="true"){
	                    delete items.import;
	                }
	                if(exportData!="true"){
	                	delete items.export;
	                }
	            }
        		return items;
        	}else {
        		// 不同节点菜单不一样
                var items = {
                    'roleAddGroup' : {
                            'label' : '新增角色分组',
                            'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5011.png",
                            'action' : function () {
                                $("#roleIframe").attr("src",Hussar.ctxPath + "/roleManager/roleAddGroupPage?type=add&id="+node.id);
                            }
                        },
                    'roleAdd' : {
                        'label' : '新增角色',
                        'action' : function () { /* 写点击处理函数 */
                            $("#roleIframe").attr("src",Hussar.ctxPath + "/roleManager/roleAddPage?id="+node.id);
                        },
                        'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5011.png"
                    },
                    'roleEdit' : {
                        'label' : '修改',
                        'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/53.png",
                        'action' : function () {
                            $("#roleIframe").attr("src",Hussar.ctxPath + "/roleManager/roleEditPage?id="+node.id);
                        }
                    },
                    'reclaimPerm' : {
                        'label' : '回收权限',
                        'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5411.png",
                        'action' : function () {
                            var operation = function() {
                                var ajax = new $ax(Hussar.ctxPath + "/roleManager/reclaimPerm",
                                    function() {
                                        Hussar.success(RECOVERY_PERMISSION_SUCCESS);
                                        $("#roleIframe").attr("src",Hussar.ctxPath + "/roleManager/roleViewPage?id=" + node.id)
                                    },
                                    function(data) {
                                        Hussar.error(RECOVERY_PERMISSION_FAIL);
                                    });
                                ajax.set("id", node.id);
                                ajax.start();
                            };
                            Hussar.confirm(RECOVERY_PERMISSION_SURE, operation);
                        }
                    },
                    'roleDel' : {
                        'label' : '删除',
                        'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/57.png",
                        'action' : function () {
                                var operation = function() {
                                    var ajax = new $ax(Hussar.ctxPath + "/roleManager/delRole",
                                        function(data) {
                                        if(data.code=="200"){
                                            Hussar.success(data.message);
                                            RoleManage.refreshPage();
                                        }
                                        else if (data.code == "409") {
                                            Hussar.error("删除失败！("+data.message+")");
                                        }else {
                                            Hussar.error(data.message);
                                        }
                                        },
                                        function(data) {
                                            Hussar.error(DELETE_FAIL);
                                        });
                                    ajax.set("id", node.id);
                                    ajax.start();
                                };
                                Hussar.confirm(DELETE_SURE, operation);

                        }
                    },
                    'roleGroupEdit' : {
                        'label' : '修改角色分组',
                        'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/53.png",
                        'action' : function () {
                            $("#roleIframe").attr("src",Hussar.ctxPath + "/roleManager/roleAddGroupPage?type=edit&id="+node.id);
                        }
                    },
                    'roleGroupDel' : {
                        'label' : '删除角色分组',
                        'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/57.png",
                        'action' : function () {
                                var operation = function() {
                                    var ajax = new $ax(Hussar.ctxPath + "/roleManager/searchRoleToGroup",
                                            function(data) {
                                        if(data.length!=0){
                                            Hussar.info("请先删除角色！");
                                        }else{
                                            var ajax = new $ax(Hussar.ctxPath + "/roleManager/delGroup",
                                                    function(data) {
                                                if(data.code=="200"){
                                                    Hussar.success(data.message);
                                                    RoleManage.refreshPage();
                                                }else{
                                                    Hussar.error(data.message);
                                                }
                                                    },
                                                    function(data) {
                                                        Hussar.error(DELETE_FAIL);
                                                    });
                                                ajax.set("id", node.id);
                                                ajax.start();
                                        }
                                            },
                                            function(data) {
                                                Hussar.error("查询角色分组下是否存在角色失败！");
                                            });
                                        ajax.set("id", node.id);
                                        ajax.start();
                                };
                                Hussar.confirm(DELETE_SURE, operation);

                        }
                    },
                    'roleGroupOrder' : {
                        'label' : '分组排序',
                        'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5111.png",
                        'action' : function () {
                            RoleManage.groupOrder(node);

                        }
                    },
                    'roleOrder' : {
                        'label' : '角色排序',
                        'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5111.png",
                        'action' : function () {
                            RoleManage.roleOrder(node);
                        }
                    },
                    export: {
                        label: "角色导出",
                        'icon': Hussar.ctxPath + "/static/assets/img/treeContext/export.png",
                        action: function (obj) {
                        	RoleManage.dataExport();
                        }
                    },
                    import: {
                        label: "角色导入",
                        'icon': Hussar.ctxPath + "/static/assets/img/treeContext/import.png",
                        action: function (obj) {
                        	RoleManage.dataImport();
                        }
                    }
                };
	            if(node.original.code == 'ROLE'){
	                var ajax = new $ax(Hussar.ctxPath + "/roleManager/queryPerm",function(json) {// 角色是否有权限
	                    if(json.length==0){// 角色下无权限删除回收权限菜单
	                        delete items.reclaimPerm;
	                    }
	                }, function(data) {
	                    Hussar.error(GET_ROLE_PERMISSION_FAIL);
	                });
	                ajax.set("id", node.id);
	                ajax.start();
	            }
	            // 系统角色不能被修改、删除和回收权限
	            if(node.original.parent == "sys_role_group" ){
	            	if(node.original.id =="public_role"){
		                delete items.roleDel;
	            	}else{
		                delete items.roleEdit;
		                delete items.reclaimPerm;
		                delete items.roleDel;
	            	}
	            }
	         // 系统角色不能被修改、删除和回收权限
	            if(node.original.id == "sys_role_group"){
	            	delete items.roleAdd;
	                delete items.roleGroupEdit;
	                delete items.roleGroupDel;
	                delete items.roleGroupOrder;
	            }
	            // 系统管理员和审计管理员不能被删除和回收权限
	            if (node.original.id == "systemadmin_role" || node.original.id == "auditadmin_role") {
	                delete items.reclaimPerm;
	                delete items.roleDel;
	            }
	
	            if (node.original.code == 'GROUP'&&node.original.parent != '#') {
	                // 角色分组拥有的右键菜单
	                var shiroAdd=$("#shiroAdd").val();
	                var editGroup=$("#editGroup").val();
	                var delGroup=$("#delGroup").val();
	                if(shiroAdd!="add"){
	                    delete items.roleAdd;
	                }
	                if(editGroup!="editGroup"){
	                    delete items.roleGroupEdit;
	                }
	                if(delGroup!="delGroup"){
	                    delete items.roleGroupDel;
	                }
	                delete items.roleAddGroup;
	                delete items.roleEdit;
	                delete items.reclaimPerm;
	                delete items.roleDel;
	                delete items.roleGroupOrder;
	            } else if(node.original.parent == '#'){
	                // 根节点右键菜单
	                var saveGroup=$("#saveGroup").val();
	                if(saveGroup!="saveGroup"){
	                    delete items.roleAddGroup;
	                }
	                delete items.roleAdd;
	                delete items.roleOrder;
	                delete items.roleEdit;
	                delete items.reclaimPerm;
	                delete items.roleDel;
	                delete items.roleGroupEdit;
	                delete items.roleGroupDel;
	            }else {
	                // 角色排序
	                var shiroEdit=$("#shiroEdit").val();
	                var shiroDel=$("#shiroDel").val();
	                var shiroRec=$("#shiroRec").val();
	                if(shiroEdit!="edit"){
	                    delete items.roleEdit;
	                }
	                if(shiroRec!="rec"){
	                    delete items.reclaimPerm;
	                }
	                if(shiroDel!="del"){
	                    delete items.roleDel;
	                }
	                delete items.roleAddGroup;  // 删除节点 items
	                delete items.roleAdd;
	                delete items.roleGroupEdit;
	                delete items.roleGroupDel;
	                delete items.roleGroupOrder;
	                delete items.roleOrder;
	            }
	            // 导出导入右键菜单只有根节点存在
	            if (node.parent != '#') {
	                delete items.export;
	                delete items.import;
	            }else{
	                var importData = $("#importData").val();
	                var exportData = $("#exportData").val();
	                
	                if(importData!="true"){
	                    delete items.import;
	                }
	                if(exportData!="true"){
	                	delete items.export;
	                }
	            }
	            return items;
        	}
        }
    };

    
    
    /**
	 * 角色数据导入
	 */
    RoleManage.dataImport = function(){
    	var ensureImport = function(){
    		$("#import").click();
    	}
    	Hussar.confirm(IMPORT_DATA_SURE, ensureImport);
    }
    
    /**
	 * 数据导出
	 */
    RoleManage.dataExport = function(){
    	  $('#dataExportTree').jstree("destroy");
    	  RoleManage.initExportTree();
    	  layer.open({
              type: 1,
              btn: ['取消', '导出'],
              skin: 'confirm-class',
              area: ['350px', '500px'],
              shadeClose: false,
              zIndex: 9999,
              title: "角色数据导出",
              content: $('#dataExport'),
              success: function () {
                  $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                  $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe017</i>");
              },
              btn2: function (index) {
                  var nodes = RoleManage.exportTree.jstree(true).get_checked();
                  if (nodes.length == 0) {
                      Hussar.info(CHOOSE_EXPORT_ROLE);
                  } else {
                      var exportFunction = function () {
                          var ids = nodes.join(",");
                          var url = Hussar.ctxPath + "/roleManager/exportData";
                          var form = $("<form></form>").attr("action", url).attr("method", "post");
                          form.append($("<input></input>").attr("type", "hidden").attr("name", "ids").attr("value", ids));
                          form.appendTo('body').submit().remove();
                          layer.close(index);
                      };
                      Hussar.confirm(EXPORT_ROLE_SURE, exportFunction);
                  }
                  return false;
              }
          });
    };
    
    /**
	 * 数据上传导入
	 */
    var dataImport = upload.render({
        elem: '#import'
        , url: Hussar.ctxPath + '/roleManager/importData'
        , accept: 'file'
        , exts: 'hussar'
        , before: function (obj) {
        	RoleManage.layIndex = layer.load(2);
        }
        , done: function (res, index, upload) {
            layer.close(RoleManage.layIndex);	// 关闭loading
            if (res.code == 200) {
                Hussar.success(res.message);
                RoleManage.refreshRoleTree();
            } else {
                Hussar.error(res.message);
            }
        }
        , error: function () {
            layer.close(RoleManage.layIndex);	// 关闭loading
            Hussar.error(IMPORT_FAIL);
        }
    });
  
    /**
	 * 初始化数据导出树
	 */
    RoleManage.initExportTree = function () {
    	RoleManage.exportTree = $('#dataExportTree');
    	RoleManage.exportTree.jstree({
            core: {
                check_callback: true,
                data: {
                    "url": Hussar.ctxPath + "/roleManager/lazyRoleTree",
                    "data": function (node) {
                        return {
                        	"nodeId": node.id,
                        	"isExport":true
                        };
                    }
                }
            },
            plugins: ['checkbox', 'types'],
            checkbox: {
                keep_selected_style: false,// 是否默认选中
                three_state: true,// 是否父子级别关联
                tie_selection: false
            },
            types: {
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/com.png"},
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/dept.png"},
                "3": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/station.png"},
                "GROUP":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/roleGroup.png"},
                "ROLE":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/role.png"},
                "ORGANROLE":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/role.png"},
                "isRoot":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/root.png"}
            }
        });
    	RoleManage.exportTree.on('check_node.jstree', function (event, obj) {
            var currentNode = obj.node;
            var ref = RoleManage.exportTree.jstree(true);
            // 根节点不能勾选
            if (currentNode.parent == '#') {
                ref.uncheck_node(currentNode.id);
                return;
            }
        });
    };
    
    
    RoleManage.initFrameHeight=function(){
        var h = $(window).height()-60;
        var h2 = $(window).height()-10;
        $("#roleIframe").css("height", h2 + "px");
        $("#roleInfo").css("height", h + "px");
    };

    /**
	 * 刷新页面，供子页面调用
	 * 
	 * @author LiangDong
	 */
    RoleManage.refreshPage = function () {
        $("#roleTree").jstree(true).refresh();
        $("#roleIframe").attr("src","");
    };

    // 刷新树
    RoleManage.refreshRoleTree = function () {
        $("#roleTree").jstree(true).refresh();
    };


    /**
	 * 初始化排序树
	 */
    RoleManage.initOrderTree = function () {
        var $orderTree = $("#orderTree"); // 排序树
        $orderTree.jstree({
            core: {
                check_callback: function (operation, node, node_parent, node_position, more) {
                    if(operation=='move_node'){
                        if(node.parent==node_parent.parent||node_parent.parent==null){
                            return false;
                        }else{
                            return true;
                        }
                    }else{
                        return true;
                    }
                },
                data: null
            },
            plugins: ['types', "dnd"],
            types: {
                "GROUP":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/roleGroup.png"},
                "ROLE":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/role.png"},
                "isRoot":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/root.png"}
            },
            sort:function(a,b){
                return this.get_node(a).original.seq > this.get_node(b).original.seq ? 1 : -1;
            }
        });

        // 移动树事件
        var resultDom = $("#output");   // 隐藏结果集dom
        $orderTree.bind('move_node.jstree', function (e, data) {
            // 移动的组织ID
            var id = data.node.id;
            // 移动之前的位置
            var oldPosition = data.old_position;
            // 移动后的位置
            var position = data.position;
            // 原地未动
            if(oldPosition==position){
                return;
            }
            var oldResult = JSON.parse(resultDom.val());
            // 向上移动
            if(position-oldPosition<0){
                for(var i=0;i<oldResult.length;i++){
                    if(i<position){
                        oldResult[i].seq=i+1;
                    }else{
                        if(oldResult[i].id==id){
                            oldResult[i].seq=position+1;
                        }else{
                            if(i<=oldPosition){
                                oldResult[i].seq=i+2;
                            }else{
                                oldResult[i].seq=i+1;
                            }
                        }
                    }
                }
            }else{// 向下移动
                for(var i=0;i<oldResult.length;i++){
                    if(i<oldPosition){
                        oldResult[i].seq=i+1;
                    }else{
                        if(oldResult[i].id==id){
                            oldResult[i].seq=position+1;
                        }else{
                            if(i<=position){
                                oldResult[i].seq=i;
                            }else{
                                oldResult[i].seq=i+1;
                            }
                        }
                    }
                }
            }
            oldResult.sort(RoleManage.up);
            resultDom.val(window.JSON.stringify(oldResult));
        });
        
    };

    /**
	 * 角色排序
	 */
    RoleManage.up = function (x,y) {
        return x.seq-y.seq;
    };

    /**
	 * 分组排序
	 * 
	 * @param node
	 */
    RoleManage.groupOrder = function (node) {
        RoleManage.layIndex = layer.open({
            type: 1,
            btn: ['取消', '保存'],
            skin: 'confirm-class',
            area: ['350px','500px'],
            fix: false, // 不固定
            maxmin: false,
            shadeClose: false,
            shade: 0.4,
            title: "分组排序",
            content: $('#roleOrder'),
            btn2: function(index, layero){
                // 保存角色分组排序
                var operation = function () {
                    var info = $("#output").val();
                    var ajax = new $ax(Hussar.ctxPath + "/roleManager/saveGroupOrder",function(data) {
                        if (data.code == "200") {
                            Hussar.success(SAVE_SUCCESS);
                            layer.close(RoleManage.layIndex);
                            $("#roleTree").jstree(true).refresh();
                        } else if (data.code) {
                            Hussar.error(data.message);
                        } else {
                            Hussar.error(SAVE_FAIL);
                        }
                    }, function(data) {
                        Hussar.error(SAVE_ROLE_GROUP_SORT_FAIL);
                    });
                    ajax.set("info",info);
                    ajax.start();
                };
                Hussar.confirm(SAVE_SORT_SURE, operation);
                return false;
            },
            success:function(){
                // 添加按钮图标
                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
                // 加载排序树数据
                var ajax = new $ax(Hussar.ctxPath + "/roleManager/groupOrderTree",function(result) {
                    // 排序树数据
                    $("#orderTree").jstree(true).settings.core.data = result;
                    $("#orderTree").jstree(true).refresh();
                    // 除根节点数据保存到隐藏域里
                    var newResult=[];
                    for(var i=0;i<result.length;i++){
                        if(result[i].parent!="#"){
                            newResult.push(result[i]);
                        }
                    }
                    $("#output").val(window.JSON.stringify(newResult));
                }, function(data) {
                    Hussar.error(LOAD_ROLE_GROUP_TREE_FAIL);
                });
                ajax.start();
            }
        });
    };

    /**
	 * 角色排序
	 * 
	 * @param node
	 */
    RoleManage.roleOrder = function (node) {
        RoleManage.layIndex = layer.open({
            type: 1,
            btn: ['取消', '保存'],
            skin: 'confirm-class',
            area: ['350px','500px'],
            fix: false, // 不固定
            maxmin: false,
            shadeClose: false,
            shade: 0.4,
            title: "角色排序",
            content: $('#roleOrder'),
            btn2: function(index, layero){
                var operation = function () {
                    // 保存角色分组排序
                    var info = $("#output").val();
                    var ajax = new $ax(Hussar.ctxPath + "/roleManager/saveRoleOrder",function(data) {
                        if (data.code == "200") {
                            Hussar.success(SAVE_SUCCESS);
                            layer.close(RoleManage.layIndex);
                            $("#roleTree").jstree(true).refresh();
                        } else if (data.code) {
                            Hussar.error(data.message);
                        } else {
                            Hussar.error(SAVE_FAIL);
                        }
                    }, function(data) {
                        Hussar.error(SAVE_ROLE_GROUP_SORT_FAIL);
                    });
                    ajax.set("info",info);
                    ajax.start();
                };
                Hussar.confirm(SAVE_SORT_SURE, operation);
                return false;
            },
            success:function(){
                // 添加按钮图标
                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
                // 加载排序树数据
                var ajax = new $ax(Hussar.ctxPath + "/roleManager/roleOrderTree",function(result) {
                    // 排序树数据
                    $("#orderTree").jstree(true).settings.core.data = result;
                    $("#orderTree").jstree(true).refresh();
                    // 除根节点数据保存到隐藏域里
                    var newResult=[];
                    for(var i=0;i<result.length;i++){
                        if(result[i].parent!="#"){
                            newResult.push(result[i]);
                        }
                    }
                    $("#output").val(window.JSON.stringify(newResult));
                }, function(data) {
                    Hussar.error(LOAD_ROLE_GROUP_TREE_FAIL);
                });
                var parent = node.id;
                ajax.set("parent", parent);
                ajax.start();
            }
        });
        
    };


/**
 * 初始化
 */
$(function() {
    RoleManage.initTree();
    RoleManage.initOrderTree();
    RoleManage.contextmenu();
    RoleManage.initFrameHeight();
    $(window).resize(function() {
    	RoleManage.initFrameHeight();
	});
});



});


