/**
 * @Description: 资源修改脚本文件
 * @Author: sunZengXin
 * @Date: 2018/3/9.
 */
layui.use(['jquery','layer','Hussar','form', 'HussarAjax', 'element', 'jstree'], function(){
	var form=layui.form,
        element=layui.element,
        jstree=layui.jstree,
		$ = layui.jquery,
		$ax=layui.HussarAjax,
		Hussar = layui.Hussar;

    var ResourceEdit = {
        themeColor: ''
	};


    /**
	 *  自定义校验
     */
    ResourceEdit.initValidate = function () {
        form.verify({
            url : function(value, item){
                var oldUrlNames=$("#oldUrlNames").val().trim();
                if(oldUrlNames!=value){
                    var msg="";
                    var ajax = new $ax(Hussar.ctxPath + "/resource/sameUrl", function(data) {
                        if(data.length!=0){
                            msg= 'URL名称已存在！';
                        }
                    }, function(data) {
                        Hussar.error("查询URL名称是否存在失败！");
                    });
                    ajax.set("url",value);
                    ajax.start();
                    return msg;
                }
            },
            permission : function (value, item) {
                if(!/^[a-zA-Z0-9]+\:{1}[a-zA-z0-9\*\,]+(\:{1}[a-zA-z0-9\*\,]+){0,1}$/.test(value)){
                    return '格式为 资源:操作 或 资源:操作:实例'
                }
            }
        });
    };

    /**
	 * 按钮及监听事件
     */
    ResourceEdit.initButtonEvent = function () {
        //权限标识提示
        $('#permissions').on('focus', function () {
            layer.tips('权限标识的命名规则为  业务:操作，例user:add', '#permissions', {
                tips: [3, ResourceEdit.themeColor]
            });
        });

        //渲染开关
        var isDefault =$("#isDefault").val();
        var isAudit =$("#isAudit").val();
        var isRepeatAuthenticate =$("#isRepeatAuthenticate").val();
        var resTypeId =$("#resTypeId").val();
        if(resTypeId==1){
            $('#resType').hide();
            $("#urlShow").css("display","block");
            $("#urlNames").attr("lay-verify","required|url");
        }else{
            $('#resType').show();
            $("#urlShow").css("display","none");
            $("#urlNames").removeAttr("lay-verify");
        }
        if(isDefault==1){
            $("#isDefault").attr("checked","checked")
        }
        if(isAudit==1){
            $("#isAudit").attr("checked","checked")
        }
        if(isRepeatAuthenticate==1){
            $("#isRepeatAuthenticate").attr("checked","checked")
        }
        form.render('checkbox');

		//资源基本信息保存
        form.on('submit(resourceEdit)', function(data){
            var formData = data.field;
            if(formData.isDefault){
                formData.isDefault = 1;
            }else{
                formData.isDefault = 0;
            }
            if(formData.isAudit){
                formData.isAudit = 1;
            }else{
                formData.isAudit = 0;
            }
            if(formData.isRepeatAuthenticate){
                formData.isRepeatAuthenticate = 1;
            }else{
                formData.isRepeatAuthenticate = 0;
            }
            var ajax = new $ax(Hussar.ctxPath + "/resource/resourceEditSave", function(data) {
                Hussar.success(BASIC_INFO_SAVE_SUCCESS);
                //切换到关联角色Tab页
                $("#roleMsg").click();
            }, function(data) {
                Hussar.error(SAVE_FAIL);
            });
            ajax.setData(formData);
            ajax.start();
            return false;
        });

        /**
         * 保存资源关联角色
         */
        $("#saveRole").click(function(){
            //当前修改的资源id
            var resourceId = $("#resourceId").val();
            //获取所选择的关联用户id
            var nodes = $("#roleTree").jstree(true).get_checked(true);
            var roleIds =[];
            $.each(nodes, function(i, nd) {
                if(nd.type == 'ROLE'){
                    roleIds.push(nd.original.id);
                }
            });
            var ajax = new $ax(Hussar.ctxPath + "/resource/resourceEditSaveRole", function(data) {
                if(data.code=="200"){
                    window.parent.layui.Hussar.success("资源关联角色保存成功！");
                    //刷新父页面
                    window.parent.ResourceManage.refreshPage();
                }else{
                    Hussar.error(SAVE_FAIL);
                }

            }, function(data) {
                Hussar.error(SAVE_FAIL);
            });
            ajax.set("resourceId", resourceId);
            ajax.set("roleIds",roleIds.join(','));
            ajax.start();
        });
		
    };

    /**
	 * 加载资源关联的角色树
     */
    ResourceEdit.initRoleTree = function () {
    	//当前修改的资源id
    	var resourceId = $("#resourceId").val();
        //角色树
        var $roleTree = $("#roleTree");
        $roleTree.jstree({
            core: {
                check_callback: true,
                data: function (obj, callback) {
                    var data;
                    var ajax = new $ax(Hussar.ctxPath + "/resource/roleTreeEdit",
                        function(result) {
                            data = result;
                        },
                        function(data) {
                            Hussar.error("加载资源关联角色树失败！");
                        });
                    ajax.set("resourceId",resourceId);
                    ajax.start();
                    callback.call(this, data);
                }
            },
            plugins: ['types','search','checkbox'],
            types:{
                "GROUP":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/roleGroup.png"},
                "ROLE":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/role.png"},
                "isRoot":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/root.png"}
            },
            checkbox: {
                keep_selected_style : false,//是否默认选中
                three_state : true,//是否父子级别关联
                tie_selection : false
            },
            search: ResourceEdit.searchRole()
        });
		
    };

    /**
	 *  资源关联角色树查询
     */
    ResourceEdit.searchRole = function () {
        var to = false;
        $("#searchRole").keyup(function () {
            if (to) { clearTimeout(to); }
            to = setTimeout(function () {
                var v = $("#searchRole").val();
                var temp = $("#roleTree").is(":hidden");
                if (temp == true) {
                    $("#roleTree").show();
                }
                $("#roleTree").jstree(true).search(v);
                //添加索引
                if(v!=''){
                    //定位到符合查询结果的树节点上
                    var searchResult = $("#roleTree").jstree('search', v);
                    $(searchResult).find('.jstree-search').focus();
                }else {
                }
            }, 250);
        });
    };

    /**
     * 获取主题颜色
     */
    ResourceEdit.getThemeColor = function () {
        ResourceEdit.themeColor = $("#btnSave").css("background-color");
    };

    /**
     *  页面初始化
     */
    $(function() {
        ResourceEdit.getThemeColor();
        ResourceEdit.initValidate();
        ResourceEdit.initButtonEvent();
        ResourceEdit.initRoleTree();
    });


});

