/**
 * @Description: 组织机构维护脚本文件
 * @Author: sunZengXin
 * @Date: 2018/2/6.
 */
var OrgMaintenance = {
    treeId: "orgTree",
    infoWin: null, // 弹出窗口
    selectId: null,
    isRootChange: '0',
    changeLevel: null,
    exportTree: null,
    layIndex: null
}
layui.use(['jquery', 'layer', 'Hussar', 'jstree', 'form', 'upload', 'HussarAjax'], function () {
    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var layer = layui.layer;
    var form = layui.form;
    var $ax = layui.HussarAjax;
    var upload = layui.upload;

    /* 初始化页面 */
    OrgMaintenance.initPage = function () {
        this.initTreeView();// 初始化组织树
        this.initOrderTreeView();// 初始化排序树
        this.initChangeTreeView();// 初始化转移树
        this.initButtonEvent();
        OrgMaintenance.initFrameHeight();
    }
    /* 组织机构树右键菜单 */
    OrgMaintenance.menuList = function (node) {
        var items = {
            create: null,
            remove: null,
            ccp: null,
            add: {
                label: "新增下级",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5011.png",
                action: function (obj) {
                    // 获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    // alert(info.id+"+"+info.text);
                    // 选中组织ID
                    var orgId = clickedNode.id;
                    // 选中组织编码
                    var orgCode = clickedNode.original.code;
                    // 选中组织上级不同类型组织编码(用于构建下级组织机构编码)
                    var parentTypeCode = clickedNode.original.parentTypeCode;
                    // 选中组织名称
                    var orgName = clickedNode.text;
                    // 选中组织类型
                    var orgType = clickedNode.original.struType;
                    // 选中组织机构层级
                    var struLevel = clickedNode.original.struLevel;
                    // 获取子节点数量
                    var childNum = clickedNode.children.length;
                    var isRoot = '';
                    if (struLevel == 0) {
                        isRoot = '1';
                    }
                    var ajax = new $ax(Hussar.ctxPath + "/orgMain/getOrgRoleByCode",
                        function (data) {
                            $("#orgType").html('');
                            var isEmpl = false;
                            for (var i = 0; i < data.length; i++) {
                                if (data[i].organType != "9") {
                                    $("#orgType").append("<input type='radio' lay-filter='orgType' name='orgType' value='" + data[i].organType + "' title='" + data[i].organTypeName + "' >");
                                } else {
                                    isEmpl = true;
                                }
                            }
                            form.render('select');
                            if (data.length == 0 || (data.length == 1 && isEmpl == true)) {
                                Hussar.info("根据组织机构规则，该组织机构无下级！");
                                return false;
                            }
                            layer.open({
                                type: 1,
                                btn: ['取消', '保存'],
                                area: ['500px', '200px'],
                                skin: 'confirm-class',
                                fix: false, // 不固定
                                maxmin: false,
                                shadeClose: false,
                                shade: 0.4,
                                title: "下级类型选择",
                                content: $('#selectOrgType'),
                                btn2: function (index, layero) {
                                    // 确认按钮回调
                                    var isClose = OrgMaintenance.addOrgInfo();
                                    if (isClose == true) {
                                        layer.close(index);
                                    } else {
                                        return false;
                                    }
                                },
                                success: function () {
                                    $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                                    $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
                                    document.getElementById("orgTypeSelect").reset();
                                    // 将选中组织信息放到页面中
                                    $("#orgParentId").val(orgId);
                                    $("#orgParentCode").val(orgCode);
                                    $("#orgParentName").val(orgName);

                                    $("#struLevel").val(struLevel);
                                    $("#childNum").val(childNum);
                                    $("#parentType").val(orgType);
                                    $("#parentTypeCode").val(parentTypeCode);
                                }
                            });
                        }, function (data) {
                            Hussar.error("失败!");
                        });
                    ajax.set("orgType", orgType)
                    ajax.set("isRoot", isRoot)
                    ajax.start();
                }
            },
            edit: {
                label: "修改",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/53.png",
                action: function (obj) {
                    // 获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    // 选中组织ID
                    var orgId = clickedNode.id;
                    $("#orgInfo").attr("src", Hussar.ctxPath + "/orgMain/orgInfoEdit?orgId=" + orgId);
                }
            },
            change: {
                label: "转移",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5411.png",
                action: function (obj) {
                    // 获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    // 选中组织ID
                    var orgId = clickedNode.id;
                    // 选中组织类型
                    var orgType = clickedNode.original.struType;
                    layer.open({
                        type: 1,
                        btn: ['取消', '保存'],
                        skin: 'confirm-class',
                        area: ['350px', '500px'],
                        fix: false, // 不固定
                        maxmin: false,
                        shadeClose: false,
                        shade: 0.4,
                        title: "上级组织机构选择",
                        content: $('#treeEditChange'),
                        btn2: function (index, layero) {
                            // 获取选中节点
                            var nodes = $("#orgTreeChange").jstree(true).get_checked();// 使用get_checked方法
                            if (nodes.length == 0) {
                                Hussar.info(CHOOSE_SUPERIOR_ORGANIZATION);
                            } else {
                                // 确认按钮回调
                                var saveTree = function () {
                                    var ajax = new $ax(Hussar.ctxPath + "/orgMain/orgTreeChange",
                                        function (data) {
                                            if (data.success) {
                                                Hussar.success(data.msg);
                                            } else {
                                                Hussar.error(data.msg);
                                            }
                                            OrgMaintenance.refreshTree();
                                            layer.close(index);
                                        },
                                        function () {
                                            Hussar.error(MOVE_FAIL);
                                        });
                                    ajax.setAsync(false);
                                    ajax.set("orgId", orgId);
                                    ajax.set("orgType", orgType);
                                    ajax.set("parentId", nodes[0]);
                                    ajax.set("isRoot", OrgMaintenance.isRootChange);
                                    ajax.set("changeLevel", OrgMaintenance.changeLevel);
                                    ajax.start();
                                }
                                Hussar.confirm(MOVE_SURE, saveTree);
                                layer.close(index);
                            }
                        },
                        success: function () {
                            $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                            $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
                            var ajax = new $ax(Hussar.ctxPath + "/orgMain/orgChangeById",
                                function (result) {
                                    OrgMaintenance.selectId = orgId;
                                    $("#orgTreeChange").jstree(true).settings.core.data = result;
                                    $("#orgTreeChange").jstree(true).refresh();
                                },
                                function () {

                                });
                            ajax.setAsync(false);
                            ajax.set("orgId", orgId);
                            ajax.start();
                        }
                    });
                }
            },
            up: {
                label: "上移",
                icon: Hussar.ctxPath + "/static/assets/img/treeContext/511101.png",
                action: function (obj) {
                    // 获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    // 选中组织ID
                    var orgId = clickedNode.id;
                    OrgMaintenance.singleMove(orgId, 'up');
                }
            },
            down: {
                label: "下移",
                icon: Hussar.ctxPath + "/static/assets/img/treeContext/511102.png",
                action: function (obj) {
                    // 获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    // 选中组织ID
                    var orgId = clickedNode.id;
                    OrgMaintenance.singleMove(orgId, 'down');
                }
            },
            sort: {
                label: "下级排序",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5111.png",
                action: function (obj) {
                    // 获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    if (clickedNode.children == undefined || clickedNode.children.length <2) {
                        Hussar.error("下级节点数量小于2，无需排序!");
                        return
                    }
                    // 选中组织ID
                    var orgId = clickedNode.id;
                    var length = clickedNode.parents.length;
                    var isRoot;
                    if (length > 1) {
                        isRoot = false;
                    } else {
                        isRoot = true;
                    }
                    layer.open({
                        type: 1,
                        btn: ['取消', '保存'],
                        skin: 'confirm-class',
                        area: ['350px', '500px'],
                        fix: false, // 不固定
                        maxmin: false,
                        shadeClose: false,
                        shade: 0.4,
                        title: "下级排序",
                        content: $('#treeEditOrder'),
                        btn2: function (index, layero) {
                            // 确认按钮回调
                            var saveTree = function () {
                                var ajax = new $ax(Hussar.ctxPath + "/orgMain/orgTreeOrder",
                                    function (data) {
                                        OrgMaintenance.refreshTree();
                                        Hussar.success(SAVE_SUCCESS);
                                        OrgMaintenance.closeWindow();
                                    },
                                    function () {
                                        Hussar.error(SAVE_FAIL);
                                    });
                                ajax.setAsync(false);
                                ajax.set("treeInfo", $("#output").val());
                                ajax.start();
                            }
                            Hussar.confirm(SAVE_SORT_SURE, saveTree);
                            layer.close(index);
                        },
                        success: function () {
                            $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                            $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
                            var ajax = new $ax(Hussar.ctxPath + "/orgMain/orgTreeById",
                                function (result) {
                                    $("#orgTreeOrder").jstree(true).settings.core.data = result;
                                    $("#orgTreeOrder").jstree(true).refresh();
                                    // 返回值在页面显示
                                    var newResult = [];
                                    for (var i = 0; i < result.length; i++) {
                                        if (result[i].parent != "#") {
                                            newResult.push(result[i]);
                                        }
                                    }
                                    $("#output").val(window.JSON.stringify(newResult));
                                },
                                function () {

                                });
                            ajax.setAsync(false);
                            ajax.set("orgId", orgId);
                            ajax.set("isRoot", isRoot);
                            ajax.start();
                        }
                    });
                }
            },
            delete: {
                label: "删除",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/57.png",
                action: function (obj) {
                    // 获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    // 选中组织ID
                    var orgId = clickedNode.id;
                    var delOrg = function () {
                        var ajax = new $ax(Hussar.ctxPath + "/orgMain/delOrgById",
                            function (data) {
                                if (data.success == true) {
                                    OrgMaintenance.refreshTree();
                                    OrgMaintenance.blank();
                                    Hussar.success(data.msg);
                                } else {
                                    Hussar.error(data.msg);
                                }
                            }, function () {
                                Hussar.error(DELETE_FAIL);
                            });
                        ajax.setAsync(false);
                        ajax.set("struId", orgId);
                        ajax.start();
                    }
                    Hussar.confirm(DELETE_SURE, delOrg);
                }
            },
            export: {
                label: "组织导出",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/export.png",
                action: function (obj) {
                	OrgMaintenance.dataExport();
                }
            },
            import: {
                label: "组织导入",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/import.png",
                action: function (obj) {
                	OrgMaintenance.dataImport();
                }
            }
        };
        var length = node.parents.length;
        if (length == 1) {
            delete items.change;  // 删除节点 转移
            delete items.edit;  // 删除节点 修改
            delete items.delete;  // 删除节点 删除
        }
        var child = node.children;
        if (child.length <= 1) {
            delete items.sort;  // 删除节点 下级排序
        }
        
        var state = node.state;
        if(state.gradeDisabled){// 上级不可操作
        	delete items.add;
        	delete items.edit;
        	delete items.change;
        	delete items.up;
        	delete items.down;
        	delete items.sort;
        	delete items.delete;
        }
        if(state.changeDisabled){// 当前组织机构不可迁移、不可编辑、不可删除
        	delete items.change;
        	delete items.edit;
        	delete items.delete;
        }
        var id = node.id;
        var n = $("#" + id);
        if (n.index() == 0) {// 非第一个
            delete items.up;  // 删除节点 上移
        }
        if (n.next().length == 0) {// 非最后一个
            delete items.down;  // 删除节点 上移
        }
        
        // 导出导入右键菜单只有根节点存在
        if (node.parent != '#') {
            delete items.export;
            delete items.import;
        }else{
            var importData = $("#importData").val();
            var exportData = $("#exportData").val();
            
            if(importData!="true"){
                delete items.import;
            }
            if(exportData!="true"){
            	delete items.export;
            }
        }
        return items;
    };
    
    /**
     * 组织机构数据导入
     */
    OrgMaintenance.dataImport = function(){
    	var ensureImport = function(){
    		$("#import").click();
    	}
    	Hussar.confirm(IMPORT_DATA_SURE, ensureImport);
    }
    
    /**
	 * 组织机构数据导出
	 */
    OrgMaintenance.dataExport = function(){
    	  $('#dataExportTree').jstree("destroy");
    	  OrgMaintenance.initExportTree();
    	  layer.open({
              type: 1,
              btn: ['取消', '导出'],
              skin: 'confirm-class',
              area: ['350px', '500px'],
              shadeClose: false,
              zIndex: 9999,
              title: "组织机构数据导出",
              content: $('#dataExport'),
              success: function () {
                  $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                  $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe017</i>");
              },
              btn2: function (index) {
                  var nodes = OrgMaintenance.exportTree.jstree(true).get_checked();
                  if (nodes.length == 0) {
                      Hussar.info(CHOOSE_EXPORT_ORGANIZATION);
                  } else {
                      var exportFunction = function () {
                          var ids = nodes.join(",");
                          var url = Hussar.ctxPath + "/orgMain/exportData";
                          var form = $("<form></form>").attr("action", url).attr("method", "post");
                          form.append($("<input></input>").attr("type", "hidden").attr("name", "ids").attr("value", ids));
                          form.appendTo('body').submit().remove();
                          layer.close(index);
                      };
                      Hussar.confirm(EXPORT_ORGAN_SURE, exportFunction);
                  }
                  return false;
              }
          });
    };
    
    /**
     * 数据上传导入
     */
    var dataImport = upload.render({
        elem: '#import'
        , url: Hussar.ctxPath + '/orgMain/importData'
        , accept: 'file'
        , exts: 'hussar'
        , before: function (obj) {
        	OrgMaintenance.layIndex = layer.load(2);
        }
        , done: function (res, index, upload) {
            layer.close(OrgMaintenance.layIndex);	//关闭loading
            if (res.code == 200) {
                Hussar.success(res.message);
                OrgMaintenance.refreshTree();
            } else {
                Hussar.error(res.message);
            }
        }
        , error: function () {
            layer.close(OrgMaintenance.layIndex);	//关闭loading
            Hussar.error(IMPORT_FAIL);
        }
    });
  
    /**
	 * 初始化数据导出树
	 */
    OrgMaintenance.initExportTree = function () {
    	OrgMaintenance.exportTree = $('#dataExportTree');
    	OrgMaintenance.exportTree.jstree({
            core: {
                check_callback: true,
                data: {
                    "url": Hussar.ctxPath + "/orgMain/orgTree",
                    "data": function (node) {
                        return {
                            "parentId": node.id,
                            "isEmployee": "",
                            "level" : node.parents.length,
							"isExport" : true
                        };
                    }
                }
            },
            plugins: ['checkbox', 'types'],
            checkbox: {
                keep_selected_style: false,// 是否默认选中
                three_state: false,// 是否父子级别关联
                tie_selection: false
            },
            types: {
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/com.png"},
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/dept.png"},
                "3": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/station.png"},
                "9": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/empl.png"}
            }
        });
    	OrgMaintenance.exportTree.on('check_node.jstree', function (event, obj) {
            var currentNode = obj.node;
            var ref = OrgMaintenance.exportTree.jstree(true);
            // 根节点不能勾选
            if (currentNode.parent == '#') {
                ref.uncheck_node(currentNode.id);
                return;
            }
        });
    };
    /**
	 * 上移下移方法
	 * 
	 * @param id
	 *            组织机构id
	 * @param direction
	 *            方向 'up' | 'down'
	 */
    OrgMaintenance.singleMove = function (id, direction) {
        // var layerIndex = layer.open({type: 3});
        var ajax = new $ax(Hussar.ctxPath + "/orgMain/singleMove",
            function (data) {
                // layer.close(layerIndex);
                // Hussar.success("操作成功！");
                Hussar.success(data.message);
                OrgMaintenance.refreshTree();
            },
            function () {
                // layer.close(layerIndex);
                Hussar.error(OPERATE_FAIL);
            });
        ajax.set("orgId", id);
        ajax.set("isUp", direction == 'up');
        ajax.start();
    };
    /* 初始化组织机构树 */
    OrgMaintenance.initTreeView = function () {
        var $tree = $("#orgTree");
        $tree.jstree({
            core: {
                check_callback: true,
                data: {
                    "url": Hussar.ctxPath + "/orgMain/orgTree",
                    "data": function (node) {
                        return {
                            "parentId": node.id,
                            "isEmployee": "",
                            "level" : node.parents.length
                        };
                    }
                }
            },
            plugins: ['types', 'contextmenu'],
            contextmenu: {
                items: OrgMaintenance.menuList
            },
            types: {
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/com.png"},
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/dept.png"},
                "3": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/station.png"},
                "9": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/empl.png"}
            }
        });
        $tree.bind("activate_node.jstree", function (obj, e) {
            // 处理代码
            // 获取当前节点
            var currentNode = e.node;
            var struId = currentNode.id;
            var parent = currentNode.parent;
            if (parent == "#") {
                $("#orgInfo").attr("src", "")
            } else {
                $("#orgInfo").attr("src", Hussar.ctxPath + "/orgMain/orgInfo?struId=" + struId)
            }
        });
    }
    /* 刷新组织机构树 */
    OrgMaintenance.refreshTree = function () {
        $("#orgTree").jstree(true).refresh();
    }
    /* 初始化组织机构排序树 */
    OrgMaintenance.initOrderTreeView = function () {
        // 初始化数列表
        var $tree = $("#orgTreeOrder");
        $tree.data('jstree', false).empty();
        $tree.jstree({
            core: {
                check_callback: function (operation, node, node_parent, node_position, more) {
                    // 拖动排序时只允许同级拖动
                    if (operation == 'move_node') {
                        if (node.parent == node_parent.parent || node_parent.parent == null) {
                            return false;
                        } else {
                            return true;
                        }
                    } else {
                        return true;
                    }
                },
                data: null
            },
            plugins: ['types', "dnd", 'contextmenu'],
            contextmenu: {
                items: OrgMaintenance.menuList
            },
            sort: function (a, b) {
                return this.get_node(a).original.struOrder > this.get_node(b).original.struOrder ? 1 : -1;
            },
            types: {
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/com.png"},
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/dept.png"},
                "3": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/station.png"},
                "9": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/empl.png"}
            }
        });
        $tree.bind("activate_node.jstree", function (obj, e) {
            // 处理代码
            // 获取当前节点
            var currentNode = e.node;
            $("#orgInfo").attr("src", Hussar.ctxPath + "/orgMain/orgInfo?struId=" + currentNode.id)
        });
        // 移动树事件
        $tree.bind('move_node.jstree', function (e, data) {
            // 移动的组织ID
            var id = data.node.id;
            // 移动之前的位置
            var oldPosition = data.old_position;
            // 移动后的位置
            var position = data.position;
            // 原地未动
            if (oldPosition == position) {
                return;
            }
            var oldResult = JSON.parse($("#output").val());
            // 根据目前的位置对于树结果进行重新排序
            // 向上移动
            if (position - oldPosition < 0) {
                for (var i = 0; i < oldResult.length; i++) {
                    if (i < position) {
                        oldResult[i].struOrder = i + 1;
                    } else {
                        if (oldResult[i].id == id) {
                            oldResult[i].struOrder = position + 1;
                        } else {
                            if (i <= oldPosition) {
                                oldResult[i].struOrder = i + 2;
                            } else {
                                oldResult[i].struOrder = i + 1;
                            }
                        }
                    }
                }
            } else {// 向下移动
                for (var i = 0; i < oldResult.length; i++) {
                    if (i < oldPosition) {
                        oldResult[i].struOrder = i + 1;
                    } else {
                        if (oldResult[i].id == id) {
                            oldResult[i].struOrder = position + 1;
                        } else {
                            if (i <= position) {
                                oldResult[i].struOrder = i;
                            } else {
                                oldResult[i].struOrder = i + 1;
                            }
                        }
                    }
                }
            }
            oldResult.sort(OrgMaintenance.up);
            $("#output").val(window.JSON.stringify(oldResult));
        });
    }

    /* 初始化转移组织树 */
    OrgMaintenance.initChangeTreeView = function () {
        // 初始化数列表
        var $tree = $("#orgTreeChange");
        $tree.data('jstree', false).empty();
        $tree.jstree({
            plugins: ['types', 'checkbox'],
            core: {
                check_callback: true,
                data: null,
                multiple: false// 单选
            },
            sort: function (a, b) {
                return this.get_node(a).original.struOrder > this.get_node(b).original.struOrder ? 1 : -1;
            },
            checkbox: {
                keep_selected_style: false,
                three_state: false,
                tie_selection: false
            },
            types: {
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/com.png"},
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/dept.png"},
                "3": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/station.png"},
                "9": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/empl.png"}
            }
        });
        $tree.on('check_node.jstree', function (event, obj) {
            var currentNode = obj.node;
            var ref = $tree.jstree(true);
            var nodes = ref.get_checked(); // 使用get_checked方法
            var otherNode;
            otherNode = "";
            
            // 判断是否为无权限节点
            var state = currentNode.state;
            if(state.gradeDisabled){
            	ref.uncheck_node(obj.node.id);
                Hussar.info(CANNOT_MOVE_ORGANIZATION);
                return;
            }
            
            
            // 判断是否为相同节点，则不能移动
            if (OrgMaintenance.selectId == obj.node.id) {
                ref.uncheck_node(obj.node.id);
                Hussar.info(CANNOT_MOVE_ORGANIZATION);
                return;
            }
            // 限制选择不能选择当前子节点
            if (nodes.length > 0) {
                $.each(currentNode.parents, function (i, nd) {
                    if (nd == OrgMaintenance.selectId) {
                        ref.uncheck_node(obj.node.id);
                        Hussar.info(CANNOT_MOVE_ORGANIZATION);
                        return false;
                    }
                })
            }
            // 限制只能选一个
            if (nodes.length > 1) {
                $.each(nodes, function (i, nd) {
                    if (nd != obj.node.id) {
                        otherNode = nd;
                    }
                })
                ref.uncheck_node(otherNode);
            }
            var length = obj.node.parents.length;
            // 判断选择节点是否为根节点
            if (length == 1) {
                OrgMaintenance.isRootChange = '1';
            } else {
                OrgMaintenance.isRootChange = '0';
            }
            OrgMaintenance.changeLevel = obj.node.original.struLevel;
        });
    }
    /* 初始化按钮事件 */
    OrgMaintenance.initButtonEvent = function () {
        /* 排序树保存 */
        $("#treeBtnSave").click(function () {
            var saveTree = function () {
                var ajax = new $ax(Hussar.ctxPath + "/orgMain/orgTreeOrder",
                    function (data) {
                        OrgMaintenance.refreshTree();
                        Hussar.success(SAVE_SUCCESS);
                        OrgMaintenance.closeWindow();
                    },
                    function () {
                        Hussar.error(SAVE_FAIL);
                    });
                ajax.setAsync(false);
                ajax.set("treeInfo", $("#output").val());
                ajax.start();
            }
            Hussar.confirm(SAVE_SORT_SURE, saveTree);
        });
        /* 排序树重置 */
        $("#treeBtnReset").click(function () {
            OrgMaintenance.closeWindow();
        });
    }

    /* 右侧iframe置空方法 */
    OrgMaintenance.blank = function () {
        $("#orgInfo").attr("src", "");
    };

    /* 增加下级 */
    OrgMaintenance.addOrgInfo = function () {
        var data = $("#orgTypeSelect").serialize();
        if (data == null || data == "") {
            Hussar.info(CHOOSE_SUBORDINATE_TYPE);
            return false;
        }
        // 获取选中的组织类型
        var orgType = "";
        var orgTypeName = '';
        var orgTypes = $("input[name='orgType']");
        for (var i = 0; i < orgTypes.length; i++) {
            if (orgTypes[i].checked == true) {
                orgType = orgTypes[i].value;
                orgTypeName = orgTypes[i].title;
            }
        }
        // 获取上级组织机构ID
        var orgParentId = $("#orgParentId").val();
        // 获取上级组织机构子节点数量
        var childNum = $("#childNum").val();
        $("#orgInfo").attr("src", Hussar.ctxPath + "/orgMain/orgInfoAdd?orgParentId=" + orgParentId + "&orgType=" + orgType + "&childNum=" + childNum + "&orgTypeName=" + encodeURIComponent(orgTypeName));
        return true;
    }
    /* 排序 */
    OrgMaintenance.up = function (x, y) {
        return x.struOrder - y.struOrder
    }
    /* 关闭弹窗 */
    OrgMaintenance.closeWindow = function () {
        layer.close(OrgMaintenance.infoWin);
    };
    OrgMaintenance.initFrameHeight = function () {
        var h = $(window).height() - 3;
        $("#orgInfo").css("height", h + "px");
        $("#orgTree").css("height", h + "px");
    }

    $(function () {
        OrgMaintenance.initPage();
        $(window).resize(function () {
            OrgMaintenance.initFrameHeight();
        });
    });
});