
layui.define(['jquery', 'layer', 'HussarAjax'], function(exports) {
var $ = layui.jquery
    , $ax = layui.HussarAjax;
var Hussar = {
    ctxPath: hussar_path,
    addCtx: function (ctx) {
        if (this.ctxPath == "") {
            this.ctxPath = ctx;
        }
    },
    isRepeat:function(callBack){
    	layerView = layer.open({
			type : 2,
			area : [ '400px', '200px' ],
			title : "二次验证",
			shadeClose : true,//or false
			maxmin : false,
			content :hussar_path+ '/exception/repeat',
			skin: 'confirm-class',
			btn: ['取消', '确定'],
			btn2:function(index){
				window["layui-layer-iframe" + index].callbackdata(function(password){
					if(password=="AA=="){
						Hussar.valid("请输入密码！");
						return false;
					}else{
						callBack(password);
						layer.close(index);
					}
				});
			},  
			success: function() {
				$(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe605</i>");
			}
			});
    },
    confirm: function (tip, ensure,cacle) {//询问框
        layer.confirm(tip, {
            btn: ['取消', '确定'],
            skin: 'confirm-class',
            icon: 3,
            title : '提示',
            btn1: function (index) {
                if(undefined != cacle ){
                    cacle();
                }
                layer.close(index);
            },
            btn2: function (index) {
                if( undefined != ensure ){
                    ensure();
                }
                layer.close(index);
            }

        });
    },
    log: function (info) {
        console.log(info);
    },
    alert: function (info, iconIndex) {
        layer.msg(info, {
            icon: iconIndex
        });
    },
    info: function (info) {
    	Hussar.alert(info, 0);
    },
    valid: function (info) {
    	Hussar.alert(info, 5);
    },
    success: function (info) {
    	Hussar.alert(info, 1);
    },
    error: function (info) {
    	Hussar.alert(info, 2);
    },
    infoDetail: function (title, info) {
        var display = "";
        if (typeof info == "string") {
            display = info;
        } else {
            if (info instanceof Array) {
                for (var x in info) {
                    display = display + info[x] + "<br/>";
                }
            } else {
                display = info;
            }
        }
        layer.open({
            title: title,
            type: 1,
            skin: 'layui-layer-rim', //加上边框
            area: ['950px', '600px'], //宽高
            content: '<div style="padding: 20px;">' + display + '</div>'
        });
    },
    writeObj: function (obj) {
        var description = "";
        for (var i in obj) {
            var property = obj[i];
            description += i + " = " + property + ",";
        }
        layer.alert(description, {
            skin: 'layui-layer-molv',
            closeBtn: 0
        });
    },
    showInputTree: function (inputId, inputTreeContentId, leftOffset, rightOffset) {
        var onBodyDown = function (event) {
            if (!(event.target.id == "menuBtn" || event.target.id == inputTreeContentId || $(event.target).parents("#" + inputTreeContentId).length > 0)) {
                $("#" + inputTreeContentId).fadeOut("fast");
                $("body").unbind("mousedown", onBodyDown);// mousedown当鼠标按下就可以触发，不用弹起
            }
        };

        if(leftOffset == undefined && rightOffset == undefined){
            var inputDiv = $("#" + inputId);
            var inputDivOffset = $("#" + inputId).offset();
            $("#" + inputTreeContentId).css({
                left: inputDivOffset.left + "px",
                top: inputDivOffset.top + inputDiv.outerHeight() + "px"
            }).slideDown("fast");
        }else{
            $("#" + inputTreeContentId).css({
                left: leftOffset + "px",
                top: rightOffset + "px"
            }).slideDown("fast");
        }

        $("body").bind("mousedown", onBodyDown);
    },
    baseAjax: function (url, tip) {
        var ajax = new $ax(Hussar.ctxPath + url, function (data) {
        	Hussar.success(tip + "成功!");
        }, function (data) {
        	Hussar.error(tip + "失败!" + data.responseJSON.message + "!");
        });
        return ajax;
    },
    changeAjax: function (url) {
        return Hussar.baseAjax(url, "修改");
    },
    zTreeCheckedNodes: function (zTreeId) {
        var zTree = $.fn.zTree.getZTreeObj(zTreeId);
        var nodes = zTree.getCheckedNodes();
        var ids = "";
        for (var i = 0, l = nodes.length; i < l; i++) {
            ids += "," + nodes[i].id;
        }
        return ids.substring(1);
    },
    eventParseObject: function (event) {//获取点击事件的源对象
        event = event ? event : window.event;
        var obj = event.srcElement ? event.srcElement : event.target;
        return $(obj);
    },
    sessionTimeoutRegistry: function () {
        $.ajaxSetup({
            contentType: "application/x-www-form-urlencoded;charset=utf-8",
            complete: function (XMLHttpRequest, textStatus) {
                //通过XMLHttpRequest取得响应头，sessionstatus，
                var sessionstatus = XMLHttpRequest.getResponseHeader("sessionstatus");
                if (sessionstatus == "timeout") {
                    //如果超时就处理 ，指定要跳转的页面
                    window.location = Hussar.ctxPath + "/global/sessionError";
                }
            }
        });
    },
    sessionTimeoutCheck: function(res){
    	if(res.code == 300){
    		var tips = res.message;
    		  if(tips!='' && tips != undefined){
        		  var url = window.location.href;
        		  if(url.indexOf("?")>0){
        			  url = url +"&tips=" + tips;
        		  }else{
        			  url = url +"?tips=" + tips;
        		  }
        	  }
              top.location.href = url;
    	}
    },
    initValidator: function(formId,fields){
        $('#' + formId).bootstrapValidator({
            feedbackIcons: {
                valid: 'glyphicon glyphicon-ok',
                invalid: 'glyphicon glyphicon-remove',
                validating: 'glyphicon glyphicon-refresh'
            },
            fields: fields,
            live: 'enabled',
            message: '该字段不能为空'
        });
    },
    underLineToCamel: function (str) {
        var strArr = str.toLowerCase().split('_');
        for (var i = 1; i < strArr.length; i++) {
            strArr[i] = strArr[i].charAt(0).toUpperCase() + strArr[i].substring(1);
        }
        var result = strArr.join('');
        return result.charAt(0).toUpperCase() + result.substring(1);
    },
    /*
	 * @todo 弹出层，弹窗方法
	 * layui.use 加载layui.define 定义的模块，当外部 js 或 onclick调用 use 内部函数时，需要在 use 中定义 window 函数供外部引用
	 * http://blog.csdn.net/xcmonline/article/details/75647144 
	 */
	/*
	    参数解释：
	    title   标题
	    url     请求的url
	    id      需要操作的数据id
	    w       弹出层宽度（缺省调默认值）
	    h       弹出层高度（缺省调默认值）
	*/
    HussarShow : function(title, url,type, w, h) {
		if(title == null || title == '') {
			title = false;
		};
		if(url == null || url == '') {
			url = "404.html";
		};
		if(w == null || w == '') {
			w = ($(window).width() * 0.9);
		};
		if(h == null || h == '') {
			h = ($(window).height() - 50);
		};
		layer.open({
			type: type,
			area: [w + 'px', h + 'px'],
			fix: false, //不固定
			maxmin: true,
			shadeClose: true,
			shade: 0.4,
			title: title,
			content: url
		});
	},
	/*弹出层+传递ID参数*/
	HussarEdit :function(title, url,type,success,error, w, h) {
		if(title == null || title == '') {
			title = false;
		};
		if(url == null || url == '') {
			url = "404.html";
		};
		if(w == null || w == '') {
			w = ($(window).width() * 0.9);
		};
		if(h == null || h == '') {
			h = ($(window).height() - 50);
		};
		layer.open({
			type: type,
			area: [w + 'px', h + 'px'],
			fix: false, //不固定
			maxmin: true,
			shadeClose: true,
			shade: 0.4,
			title: title,
			content: url,
			success: success,
			error: error
		});
	}
    
};
window.Hussar = Hussar;
exports('Hussar', Hussar);
});
