/**
 * @Description: 资源管理脚本文件
 * @Author: sunZengXin
 * @Date: 2018/3/7.
 */
var ResourceManage = {
    treeId: "resTree",
    exportTree: null,
    orgTree:"",//组织机构树
    frameId: "moduleFrame",
    infoWin: null, //弹出窗口
    selectModuleId: "",//模块ID
    selectFunctionId: "",//功能ID
    layIndex: null
};
layui.use(['jquery', 'layer', 'Hussar', 'jstree', 'form', 'upload', 'HussarAjax'], function () {
    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var layer = layui.layer;
    var form = layui.form;
    var $ax = layui.HussarAjax;
    var upload = layui.upload;

    /*初始化页面*/
    ResourceManage.initPage = function () {
        ResourceManage.initFrameHeight();
        this.initTreeView();
        this.initOrderTreeView();
        this.initModuleChangeTreeView();
        this.initFunctionChangeTreeView();
        this.initResourceChangeTreeView();
        ResourceManage.orgTree = $("#orgTree");
    };

    /*加载资源树*/
    ResourceManage.initTreeView = function () {
        var $tree = $("#" + ResourceManage.treeId + "");
        $tree.jstree({
            core: {
                check_callback: true,
                data: {
                    "url": Hussar.ctxPath + "/resource/resTree",
                    "data": function (node) {
                        var isLeaf = "";
                        if (node.original != undefined) {
                            isLeaf = node.original.isLeaf;
                        }
                        return {
                            "isLeaf": isLeaf,
                            "nodeId": node.id,
                            "nodeType": node.type
                        };
                    }
                }
            },
            plugins: ['types', 'contextmenu', 'search'],
            types: {
                "isRoot": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/root.png"},
                "isModule": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/module.png"},
                "isFun": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/function.png"},
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/resource_menu.png"}, //菜单资源
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/resource_btn.png"},  //按钮资源
            },
            searcdh: ResourceManage.initTreeSearch(),
            contextmenu: {
                items: ResourceManage.menuList
            }
        });
        $tree.bind("activate_node.jstree", function (obj, e) {
            // 处理代码
            // 获取当前节点
            var currentNode = e.node;
            var moduleId = currentNode.id
            var parent = currentNode.parent
            var isLeaf = currentNode.original.isLeaf;
            var isFun = currentNode.original.isFun;
            var isRes = currentNode.original.isRes;
            //判断是否为根节点如果为根节点
            if (parent == "#") {
                $("#moduleFrame").attr("src", "")
            } else {
                if (isFun == 1) {
                    //功能详情跳转
                    $("#moduleFrame").attr("src", Hussar.ctxPath + "/resource/functionView?functionId=" + moduleId)
                } else {
                    if (isRes == 1) {
                        $("#moduleFrame").attr("src", Hussar.ctxPath + "/resource/resourceView?resourceId=" + moduleId)
                    } else {
                        $("#moduleFrame").attr("src", Hussar.ctxPath + "/resource/moduleView?moduleId=" + moduleId)
                    }
                }
            }
        });
    }

    /**
     * 回收资源时加载 组织机构树
     */
    ResourceManage.initOrgTree = function () {
        $orgTree = ResourceManage.orgTree;//组织机构树
        $orgTree.jstree({
            core: {
                check_callback: true,
                data: {
                    "url": Hussar.ctxPath + "/orgMain/orgTree",
                    "data": function (node) {
                        return {
                            "parentId": node.id,
                            "level" : node.parents.length,
                            "resourceId" : $('#resourceIdHidden').val(),
                            "type" : $('#typeHidden').val(),
                            "handle" : "retrieve"
                        };
                    }
                }
            },
            plugins: ['checkbox', 'search', 'types'],
            checkbox: {
                keep_selected_style: false,//是否默认选中
                three_state: false,//是否父子级别关联
                tie_selection: false
            },
            types: {
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/com.png"},
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/dept.png"},
                "3": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/station.png"},
                "9": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/empl.png"},
                "isRoot": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/root.png"}
            },
            search: ResourceManage.initTreeSearch()
        });
        $orgTree.on('check_node.jstree', function (event, obj) {
            var currentNode = obj.node;
            var ref = $orgTree.jstree(true);
            var checkedNodes = ref.get_checked(); //使用get_checked方法
            var otherNode;

            /*//判断是否勾选的是和原来相同的所属机构
            if (ResourceManage.selectId == currentNode.id) {
                ref.uncheck_node(currentNode.id);
                Hussar.info("变更机构不能和原所属机构相同！");
                return;
            }*/

            /*//根节点不能勾选
            if (currentNode.parent == '#') {
                ref.uncheck_node(currentNode.id);
                return;
            }*/

            /*//限制只能选一个
            if (checkedNodes.length > 1) {
                $.each(checkedNodes, function (i, nd) {
                    if (nd != currentNode.id) {
                        otherNode = nd;
                    }
                })
                ref.uncheck_node(otherNode);
            }*/
        });
    }

    /**
     * 下放资源时加载 组织机构树
     */
    ResourceManage.initOrgTree1 = function () {
        $orgTree = ResourceManage.orgTree;//组织机构树
        $orgTree.jstree({
            core: {
                check_callback: true,
                data: {
                    "url": Hussar.ctxPath + "/orgMain/orgTree",
                    "data": function (node) {
                        return {
                            "parentId": node.id,
                            "level" : node.parents.length,
                            "resourceId" : $('#resourceIdHidden').val(),
                            "type" : $('#typeHidden').val(),
                            "handle" : "delegate"
                        };
                    }
                }
            },
            plugins: ['checkbox', 'search', 'types'],
            checkbox: {
                keep_selected_style: false,//是否默认选中
                three_state: false,//是否父子级别关联
                tie_selection: false
            },
            types: {
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/com.png"},
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/dept.png"},
                "3": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/station.png"},
                "9": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/empl.png"},
                "isRoot": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/root.png"}
            },
            search: ResourceManage.initTreeSearch()
        });
        $orgTree.on('check_node.jstree', function (event, obj) {
            var currentNode = obj.node;
            var ref = $orgTree.jstree(true);
            var checkedNodes = ref.get_checked(); //使用get_checked方法
            var otherNode;

            /*//判断是否勾选的是和原来相同的所属机构
            if (ResourceManage.selectId == currentNode.id) {
                ref.uncheck_node(currentNode.id);
                Hussar.info("变更机构不能和原所属机构相同！");
                return;
            }*/

            /*//根节点不能勾选
            if (currentNode.parent == '#') {
                ref.uncheck_node(currentNode.id);
                return;
            }*/

            /*//限制只能选一个
            if (checkedNodes.length > 1) {
                $.each(checkedNodes, function (i, nd) {
                    if (nd != currentNode.id) {
                        otherNode = nd;
                    }
                })
                ref.uncheck_node(otherNode);
            }*/
        });
    }

    /*初始化功能模块排序树*/
    ResourceManage.initOrderTreeView = function () {
        //初始化数列表
        var $tree = $("#moduleTreeOrder");
        $tree.data('jstree', false).empty();
        $tree.jstree({
            core: {
                check_callback: function (operation, node, node_parent, node_position, more) {
                    //拖动排序时只允许同级拖动
                    if (operation == 'move_node') {
                        if (node.parent == node_parent.parent || node_parent.parent == null) {
                            return false;
                        } else {
                            return true;
                        }
                    } else {
                        return true;
                    }
                },
                data: null
            },
            plugins: ['types', "dnd"],
            sort: function (a, b) {
                return this.get_node(a).original.seq > this.get_node(b).original.seq ? 1 : -1;
            },
            types: {
                "isRoot": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/root.png"},
                "isModule": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/module.png"},
                "isFun": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/function.png"},
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/resource_menu.png"}, //菜单资源
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/resource_btn.png"},  //按钮资源
            }
        });
        $tree.bind("activate_node.jstree", function (obj, e) {
            // 处理代码
            // 获取当前节点
            var currentNode = e.node;
            loadOrgInfo(22);
        });
        //移动树事件
        $tree.bind('move_node.jstree', function (e, data) {
            //移动的组织ID
            var id = data.node.id;
            //移动之前的位置
            var oldPosition = data.old_position;
            //移动后的位置
            var position = data.position;
            //原地未动
            if (oldPosition == position) {
                return;
            }
            var oldResult = JSON.parse($("#output").val());
            //根据目前的位置对于树结果进行重新排序
            var newResult = [];
            //向上移动
            if (position - oldPosition < 0) {
                for (var i = 0; i < oldResult.length; i++) {
                    if (i < position) {
                        oldResult[i].seq = i + 1;
                    } else {
                        if (oldResult[i].id == id) {
                            oldResult[i].seq = position + 1;
                        } else {
                            if (i <= oldPosition) {
                                oldResult[i].seq = i + 2;
                            } else {
                                oldResult[i].seq = i + 1;
                            }

                        }
                    }

                }
            } else {//向下移动
                for (var i = 0; i < oldResult.length; i++) {
                    if (i < oldPosition) {
                        oldResult[i].seq = i + 1;
                    } else {
                        if (oldResult[i].id == id) {
                            oldResult[i].seq = position + 1;
                        } else {
                            if (i <= position) {
                                oldResult[i].seq = i;
                            } else {
                                oldResult[i].seq = i + 1;
                            }

                        }
                    }

                }
            }
            oldResult.sort(ResourceManage.up);
            $("#output").val(window.JSON.stringify(oldResult));
        });

    }

    /*初始化模块转移树*/
    ResourceManage.initModuleChangeTreeView = function () {
        //初始化数列表
        var $tree = $("#moduleTreeChange");
        $tree.data('jstree', false).empty();
        $tree.jstree({
            plugins: ['types', 'checkbox'],
            core: {
                check_callback: true,
                data: null,
                multiple: false//单选
            },
            sort: function (a, b) {
                return this.get_node(a).original.seq > this.get_node(b).original.seq ? 1 : -1;
            },
            checkbox: {
                keep_selected_style: false,
                three_state: false,
                tie_selection: false
            },
            types: {
                "isRoot": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/root.png"},
                "isModule": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/module.png"},
                "isFun": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/function.png"},
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/resource_menu.png"}, //菜单资源
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/resource_btn.png"},  //按钮资源
            }
        });
        $tree.bind("activate_node.jstree", function (obj, e) {
            // 处理代码
            // 获取当前节点
            var currentNode = e.node;
        });
        $tree.on('check_node.jstree', function (event, obj) {
            var currentNode = obj.node;
            var moduleName = obj.node.text;
            var isLeaf = obj.node.original.isLeaf;
            var ref = $tree.jstree(true);
            var nodes = ref.get_checked(); //使用get_checked方法
            var otherNode;
            otherNode = "";
            //判断是否为相同节点，则不能移动
            if (ResourceManage.selectModuleId == obj.node.id) {
                ref.uncheck_node(obj.node.id);
                Hussar.info(CANNOT_MOVE_MODULE);
                return;
            }
            //限制选择不能选择当前以及当前子节点
            if (nodes.length > 0) {
                $.each(currentNode.parents, function (i, nd) {
                    if (nd == ResourceManage.selectModuleId) {
                        ref.uncheck_node(obj.node.id);
                        Hussar.info(CANNOT_MOVE_MODULE);
                        return false;
                    }
                })

            }
            //限制只能选一个
            if (nodes.length > 1) {
                $.each(nodes, function (i, nd) {
                    if (nd != obj.node.id) {
                        otherNode = nd;
                    }
                });
                ref.uncheck_node(otherNode);
            }
        });
    };

    /*初始化功能转移树*/
    ResourceManage.initFunctionChangeTreeView = function () {
        //初始化数列表
        var $tree = $("#functionTreeChange");
        $tree.data('jstree', false).empty();
        $tree.jstree({
            plugins: ['types', 'checkbox'],
            core: {
                check_callback: true,
                data: null,
                multiple: false//单选
            },
            sort: function (a, b) {
                return this.get_node(a).original.struOrder > this.get_node(b).original.struOrder ? 1 : -1;
            },
            checkbox: {
                keep_selected_style: false,
                three_state: false,
                tie_selection: false
            },
            types: {
                "isRoot": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/root.png"},
                "isModule": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/module.png"},
                "isFun": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/function.png"},
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/resource_menu.png"}, //菜单资源
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/resource_btn.png"},  //按钮资源
            }
        });
        $tree.bind("activate_node.jstree", function (obj, e) {
            // 处理代码
            // 获取当前节点
            var currentNode = e.node;
        });
        $tree.on('check_node.jstree', function (event, obj) {
            var currentNode = obj.node;
            var moduleName = obj.node.text;
            var isLeaf = obj.node.original.isLeaf;
            var ref = $tree.jstree(true);
            var nodes = ref.get_checked(); //使用get_checked方法
            var otherNode;
            otherNode = "";
            //判断是否为相同节点，则不能移动
            if ("1" != isLeaf) {
                ref.uncheck_node(obj.node.id);
                Hussar.info(CANNOT_MOVE_MODULE);
                return;
            }
            //限制只能选一个
            if (nodes.length > 1) {
                $.each(nodes, function (i, nd) {
                    if (nd != obj.node.id) {
                        otherNode = nd;
                    }
                });
                ref.uncheck_node(otherNode);
            }
        });
    };

    /*初始化资源转移树*/
    ResourceManage.initResourceChangeTreeView = function () {
        //初始化数列表
        var $tree = $("#resourceTreeChange");
        $tree.data('jstree', false).empty();
        $tree.jstree({
            plugins: ['types', 'checkbox'],
            core: {
                check_callback: true,
                data: null,
                multiple: false//单选
            },
            sort: function (a, b) {
                return this.get_node(a).original.seq > this.get_node(b).original.seq ? 1 : -1;
            },
            checkbox: {
                keep_selected_style: false,
                three_state: false,
                tie_selection: false
            },
            types: {
                "isRoot": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/root.png"},
                "isModule": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/module.png"},
                "isFun": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/function.png"},
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/resource_menu.png"}, //菜单资源
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/resource_btn.png"},  //按钮资源
            }
        });
        $tree.bind("activate_node.jstree", function (obj, e) {
            // 处理代码
            // 获取当前节点
            var currentNode = e.node;
        });
        $tree.on('check_node.jstree', function (event, obj) {
            var currentNode = obj.node;
            var moduleName = obj.node.text;
            var isFun = obj.node.original.isFun;
            var ref = $tree.jstree(true);
            var nodes = ref.get_checked(); //使用get_checked方法
            var otherNode;
            otherNode = "";
            //判断是否为功能节点
            if ("1" != isFun) {
                ref.uncheck_node(obj.node.id);
                Hussar.info(CANNOT_MOVE_MODULE);
                return;
            }
            //限制只能选一个
            if (nodes.length > 1) {
                $.each(nodes, function (i, nd) {
                    if (nd != obj.node.id) {
                        otherNode = nd;
                    }
                });
                ref.uncheck_node(otherNode);
            }
        });
    };

    /**
     * 刷新功能模块树
     */
    ResourceManage.refreshTree = function () {
        $("#" + ResourceManage.treeId + "").jstree(true).refresh();
    };


    /**
     * 加载资源树右键点击菜单
     */
    ResourceManage.menuList = function (node) {
        var items = {
            create: null,
            remove: null,
            ccp: null,
            add: {
                label: "新增模块",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5011.png",
                action: function (obj) {
                    //获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    //alert(info.id+"+"+info.text);
                    //选中模块ID
                    var moduleId = clickedNode.id;
                    //选中模块名称
                    var moduleName = clickedNode.text;
                    //选中模块是否为根节点
                    var isLeaf = clickedNode.original.isLeaf;
                    //获取子节点数量
                    var childNum = clickedNode.children.length;
                    $("#moduleFrame").attr("src", Hussar.ctxPath + "/resource/moduleAdd?moduleId=" + moduleId)

                }
            },
            addFunction: {
                label: "新增功能",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5011.png",
                action: function (obj) {
                    //获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    //选中模块ID
                    var moduleId = clickedNode.id;
                    //选中模块编码
                    var moduleCode = clickedNode.original.code;
                    //选中模块名称
                    var moduleName = clickedNode.text;
                    //选中模块是否为根节点
                    var isLeaf = clickedNode.original.isLeaf;
                    //获取子节点数量
                    var childNum = clickedNode.children.length;
                    $("#moduleFrame").attr("src", Hussar.ctxPath + "/resource/functionAdd?moduleId=" + moduleId)
                }
            },
            addResource: {
                label: "新增资源",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5011.png",
                action: function (obj) {
                    //获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    //选中功能ID
                    var functionId = clickedNode.id;
                    //选中功能编码
                    var functionCode = clickedNode.original.code;
                    //选中功能名称
                    var functionName = clickedNode.text;
                    //选中模块是否为根节点
                    var isLeaf = clickedNode.original.isLeaf;
                    //获取子节点数量
                    var childNum = clickedNode.children.length;
                    $("#moduleFrame").attr("src", Hussar.ctxPath + "/resource/resourceAdd?functionId=" + functionId)
                }
            },
            edit: {
                label: "修改",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/53.png",
                action: function (obj) {
                    //获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    //选中模块ID
                    var moduleId = clickedNode.id;
                    //选中模块名称
                    var moduleName = clickedNode.text;
                    //选中模块是否为根节点
                    var isLeaf = clickedNode.original.isLeaf;
                    //获取子节点数量
                    var childNum = clickedNode.children.length;
                    $("#moduleFrame").attr("src", Hussar.ctxPath + "/resource/moduleEdit?moduleId=" + moduleId)
                }
            },
            changeModule: {
                label: "转移",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5411.png",
                action: function (obj) {
                    //获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    //选中模块ID
                    var moduleId = clickedNode.id;
                    layer.open({
                        type: 1,
                        btn: ['取消', '保存'],
                        skin: 'confirm-class',
                        area: ['350px', '500px'],
                        fix: false, //不固定
                        maxmin: false,
                        shadeClose: false,
                        shade: 0.4,
                        title: "模块选择",
                        content: $('#moduleTreeEditChange'),
                        btn2: function (index, layero) {
                            //获取选中节点
                            var nodes = $("#moduleTreeChange").jstree(true).get_checked();//使用get_checked方法
                            if (nodes.length == 0) {
                                Hussar.info(CHOOSE_SUPERIOR_MODULE);
                            } else {
                                //确认按钮回调
                                var saveTree = function () {
                                    var ajax = new $ax(Hussar.ctxPath + "/resource/moduleTreeChange",
                                        function (result) {
                                            ResourceManage.refreshTree();
                                            Hussar.success(MOVE_SUCCESS);
                                            layer.close(index);
                                        }, function (data) {
                                            Hussar.error(MOVE_FAIL);
                                        });
                                    ajax.set("moduleId", moduleId)
                                    ajax.set("parentId", nodes[0])
                                    ajax.start();
                                };
                                Hussar.confirm(MOVE_SURE, saveTree);
                                layer.close(index);
                            }
                        },
                        success: function (index) {
                            $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                            $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
                            $("#treeName").html("模块树");
                            var ajax = new $ax(Hussar.ctxPath + "/resource/moduleChangeById",
                                function (result) {
                                    ResourceManage.selectModuleId = moduleId;
                                    $("#moduleTreeChange").jstree(true).settings.core.data = result;
                                    $("#moduleTreeChange").jstree(true).refresh();
                                }, function (data) {
                                    Hussar.error(FAIL);
                                });
                            ajax.set("moduleId", moduleId)
                            ajax.set("isLeaf", "0")
                            ajax.start();
                        }
                    });
                }
            },
            moduleSort: {
                label: "下级排序",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5111.png",
                action: function (obj) {
                    //获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    //选中模块ID
                    var moduleId = clickedNode.id;
                    //选中模块名称
                    var moduleName = clickedNode.text;
                    //是否为根节点
                    var length = clickedNode.parents.length;
                    var isRoot;
                    if (length > 1) {
                        isRoot = false;
                    } else {
                        isRoot = true;
                    }
                    layer.open({
                        type: 1,
                        btn: ['取消', '保存'],
                        skin: 'confirm-class',
                        area: ['350px', '500px'],
                        fix: false, //不固定
                        maxmin: false,
                        shadeClose: false,
                        shade: 0.4,
                        title: "模块排序",
                        content: $('#treeEditOrder'),
                        btn2: function (index, layero) {
                            //确认按钮回调
                            var saveTree = function () {
                                var ajax = new $ax(Hussar.ctxPath + "/resource/moduleTreeOrder",
                                    function (result) {
                                        ResourceManage.refreshTree();
                                        Hussar.success(SAVE_SUCCESS);
                                        layer.close(index);
                                    }, function (data) {
                                        Hussar.error(SAVE_FAIL);
                                    });
                                ajax.set("treeInfo", $("#output").val())
                                ajax.start();
                            };
                            Hussar.confirm(SAVE_SORT_SURE, saveTree);
                            layer.close(index);
                        },
                        success: function () {
                            $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                            $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
                            var ajax = new $ax(Hussar.ctxPath + "/resource/moduleTreeById",
                                function (result) {
                                    $("#moduleTreeOrder").jstree(true).settings.core.data = result;
                                    $("#moduleTreeOrder").jstree(true).refresh();
                                    //返回值在页面显示
                                    var newResult = [];
                                    for (var i = 0; i < result.length; i++) {
                                        if (result[i].parent != "#") {
                                            newResult.push(result[i]);
                                        }
                                    }
                                    $("#output").val(window.JSON.stringify(newResult));
                                }, function (data) {
                                    Hussar.error(SAVE_FAIL);
                                });
                            ajax.set("moduleId", moduleId)
                            ajax.set("isRoot", isRoot)
                            ajax.start();
                        }
                    });
                }
            },
            editFunction: {
                label: "修改",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/53.png",
                action: function (obj) {
                    //获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    //选中功能ID
                    var functionId = clickedNode.id;
                    //选中功能名称
                    var functionName = clickedNode.text;
                    //选中模块是否为根节点
                    var isLeaf = clickedNode.original.isLeaf;
                    //获取子节点数量
                    var childNum = clickedNode.children.length;
                    $("#moduleFrame").attr("src", Hussar.ctxPath + "/resource/functionEdit?functionId=" + functionId)
                }
            },
            changeFunction: {
                label: "转移",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5411.png",
                action: function (obj) {
                    //获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    //选中功能ID
                    var functionId = clickedNode.id;
                    layer.open({
                        type: 1,
                        btn: ['取消', '保存'],
                        skin: 'confirm-class',
                        area: ['350px', '500px'],
                        fix: false, //不固定
                        maxmin: false,
                        shadeClose: false,
                        shade: 0.4,
                        title: "模块选择",
                        content: $('#functionTreeEditChange'),
                        btn2: function (index, layero) {
                            //获取选中节点
                            var nodes = $("#functionTreeChange").jstree(true).get_checked();//使用get_checked方法
                            if (nodes.length == 0) {
                                Hussar.info(CHOOSE_SUPERIOR_MODULE);
                            } else {
                                //确认按钮回调
                                var saveTree = function () {
                                    var ajax = new $ax(Hussar.ctxPath + "/resource/functionTreeChange",
                                        function (result) {
                                            ResourceManage.refreshTree();
                                            Hussar.success(MOVE_SUCCESS);
                                            layer.close(index);
                                        }, function (data) {
                                            Hussar.error(MOVE_FAIL);
                                        });
                                    ajax.set("functionId", functionId)
                                    ajax.set("parentId", nodes[0])
                                    ajax.start();
                                };
                                Hussar.confirm(MOVE_SURE, saveTree);
                                layer.close(index);
                            }
                        },
                        success: function (index) {
                            $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                            $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
                            $("#treeName").html("模块树");
                            var ajax = new $ax(Hussar.ctxPath + "/resource/moduleChangeById",
                                function (result) {
                                    if (result.length == 1) {
                                        Hussar.info(NO_SUPERIOR_MODULE_CAN_MOVE);
                                    } else {
                                        ResourceManage.selectFunctionId = functionId;
                                        $("#functionTreeChange").jstree(true).settings.core.data = result;
                                        $("#functionTreeChange").jstree(true).refresh();
                                    }
                                }, function (data) {
                                    Hussar.error(FAIL);
                                });
                            ajax.set("functionId", functionId)
                            ajax.set("isLeaf", "")
                            ajax.start();
                        }
                    });
                }
            },
            functionSort: {
                label: "下级排序",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5111.png",
                action: function (obj) {
                    //获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    //选中模块ID
                    var moduleId = clickedNode.id;
                    //选中模块名称
                    var moduleName = clickedNode.text;
                    //是否为根节点
                    var length = clickedNode.parents.length;
                    var isRoot;
                    if (length > 1) {
                        isRoot = false;
                    } else {
                        isRoot = true;
                    }
                    layer.open({
                        type: 1,
                        btn: ['取消', '保存'],
                        skin: 'confirm-class',
                        area: ['350px', '500px'],
                        fix: false, //不固定
                        maxmin: false,
                        shadeClose: false,
                        shade: 0.4,
                        title: "功能排序",
                        content: $('#treeEditOrder'),
                        btn2: function (index, layero) {
                            //确认按钮回调
                            var saveTree = function () {

                                var ajax = new $ax(Hussar.ctxPath + "/resource/functionTreeOrder",
                                    function (result) {
                                        ResourceManage.refreshTree();
                                        Hussar.success(SAVE_SUCCESS);
                                        layer.close(index);
                                    }, function (data) {
                                        Hussar.error(SAVE_FAIL);
                                    });
                                ajax.set("treeInfo", $("#output").val())
                                ajax.start();
                            };
                            Hussar.confirm(SAVE_SORT_SURE, saveTree);
                            layer.close(index);
                        },
                        success: function () {
                            $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                            $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");

                            var ajax = new $ax(Hussar.ctxPath + "/resource/functionTreeById",
                                function (result) {
                                    $("#moduleTreeOrder").jstree(true).settings.core.data = result;
                                    $("#moduleTreeOrder").jstree(true).refresh();
                                    //返回值在页面显示
                                    var newResult = [];
                                    for (var i = 0; i < result.length; i++) {
                                        if (result[i].parent != "#") {
                                            newResult.push(result[i]);
                                        }
                                    }
                                    $("#output").val(window.JSON.stringify(newResult));
                                }, function (data) {
                                    Hussar.error(FAIL);
                                });
                            ajax.set("moduleId", moduleId)
                            ajax.set("moduleName", moduleName)
                            ajax.set("isRoot", isRoot)
                            ajax.start();
                        }
                    });
                }
            },
            view: {
                label: "查看",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/55.png",
                action: function (obj) {
                    //获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    //选中模块ID
                    var moduleId = clickedNode.id;
                    //选中模块名称
                    var moduleName = clickedNode.text;
                    //选中模块是否为根节点
                    var isLeaf = clickedNode.original.isLeaf;
                    //获取子节点数量
                    var childNum = clickedNode.children.length;
                    $("#moduleFrame").attr("src", Hussar.ctxPath + "/resource/moduleView?moduleId=" + moduleId)
                }
            },
            delete: {
                label: "删除",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/57.png",
                action: function (obj) {
                    //获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    //选中组织ID
                    var moduleId = clickedNode.id;
                    var delOrg = function () {
                        var ajax = new $ax(Hussar.ctxPath + "/resource/delModule",
                            function (data) {
                                if (data.success == true) {
                                    ResourceManage.refreshPage();
                                    Hussar.success(DELETE_SUCCESS);
                                } else {
                                    Hussar.error(DELETE_FAIL+"（存在下级模块或下级功能！）");
                                }
                            }, function (data) {
                                Hussar.error(DELETE_FAIL);
                            });
                        ajax.set("moduleId", moduleId)
                        ajax.start();
                    };
                    Hussar.confirm(DELETE_SURE, delOrg);
                }
            },
            editResource: {
                label: "修改",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/53.png",
                action: function (obj) {
                    //获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    //选中功能ID
                    var resourceId = clickedNode.id;
                    //选中功能名称
                    var resourceName = clickedNode.text;
                    //选中模块是否为根节点
                    var isLeaf = clickedNode.original.isLeaf;
                    //获取子节点数量
                    var childNum = clickedNode.children.length;
                    $("#moduleFrame").attr("src", Hussar.ctxPath + "/resource/resourceEdit?resourceId=" + resourceId)
                }
            },
            changeResource: {
                label: "转移",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5411.png",
                action: function (obj) {
                    //获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    //选中资源ID
                    var resourceId = clickedNode.id;
                    layer.open({
                        type: 1,
                        btn: ['取消', '保存'],
                        skin: 'confirm-class',
                        area: ['350px', '500px'],
                        fix: false, //不固定
                        maxmin: false,
                        shadeClose: false,
                        shade: 0.4,
                        title: "功能选择",
                        content: $('#resourceTreeEditChange'),
                        btn2: function (index, layero) {
                            //获取选中节点
                            var nodes = $("#resourceTreeChange").jstree(true).get_checked();//使用get_checked方法
                            if (nodes.length == 0) {
                                Hussar.info(CHOOSE_SUPERIOR_MODULE);
                            } else {
                                //确认按钮回调
                                var saveTree = function () {
                                    var ajax = new $ax(Hussar.ctxPath + "/resource/resourceTreeChange",
                                        function (result) {
                                            ResourceManage.refreshTree();
                                            Hussar.success(MOVE_SUCCESS);
                                            layer.close(index);
                                        }, function (data) {
                                            Hussar.error(MOVE_FAIL);
                                        });
                                    ajax.set("resourceId", resourceId)
                                    ajax.set("parentId", nodes[0])
                                    ajax.start();
                                };
                                Hussar.confirm(MOVE_SURE, saveTree);
                                layer.close(index);
                            }
                        },
                        success: function (index) {
                            $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                            $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");

                            var ajax = new $ax(Hussar.ctxPath + "/resource/resourceChangeById",
                                function (result) {
                                    if (result.length == 1) {
                                        Hussar.info(NO_SUPERIOR_MODULE_CAN_MOVE);
                                    } else {
                                        $("#resourceTreeChange").jstree(true).settings.core.data = result;
                                        $("#resourceTreeChange").jstree(true).refresh();
                                    }
                                }, function (data) {
                                    Hussar.error(SAVE_FAIL);
                                });
                            ajax.set("resourceId", resourceId)
                            ajax.start();
                        }
                    });
                }
            },
            resourceSort: {
                label: "下级排序",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5111.png",
                action: function (obj) {
                    //获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    //选中功能ID
                    var functionId = clickedNode.id;
                    //选中功能名称
                    var functionName = clickedNode.text;
                    //是否为根节点
                    var length = clickedNode.parents.length;
                    var isRoot;
                    if (length > 1) {
                        isRoot = false;
                    } else {
                        isRoot = true;
                    }
                    layer.open({
                        type: 1,
                        btn: ['取消', '保存'],
                        skin: 'confirm-class',
                        area: ['350px', '500px'],
                        fix: false, //不固定
                        maxmin: false,
                        shadeClose: false,
                        shade: 0.4,
                        title: "资源排序",
                        content: $('#treeEditOrder'),
                        btn2: function (index, layero) {
                            //确认按钮回调
                            var saveTree = function () {
                                var ajax = new $ax(Hussar.ctxPath + "/resource/resourceTreeOrder",
                                    function (data) {
                                        if (data) {
                                            ResourceManage.refreshTree();
                                            Hussar.success(SAVE_SUCCESS);
                                            layer.close(index);
                                        } else {
                                            Hussar.error(SAVE_FAIL);
                                        }
                                    }, function (data) {
                                        Hussar.error(SAVE_FAIL);
                                    });
                                ajax.set("treeInfo", $("#output").val())
                                ajax.start();
                            };
                            Hussar.confirm(SAVE_SORT_SURE, saveTree);
                            layer.close(index);
                        },
                        success: function () {
                            $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                            $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");

                            var ajax = new $ax(Hussar.ctxPath + "/resource/resourceTreeById",
                                function (result) {

                                    $("#moduleTreeOrder").jstree(true).settings.core.data = result;
                                    $("#moduleTreeOrder").jstree(true).refresh();
                                    //返回值在页面显示
                                    var newResult = [];
                                    for (var i = 0; i < result.length; i++) {
                                        if (result[i].parent != "#") {
                                            newResult.push(result[i]);
                                        }
                                    }
                                    $("#output").val(window.JSON.stringify(newResult));
                                }, function (data) {
                                    Hussar.error(SAVE_FAIL);
                                });
                            ajax.set("functionId",functionId)
                            ajax.set("functionName",functionName)
                            ajax.set("isRoot",isRoot)
                            ajax.start();
                        }
                    });
                }
            },
            delFunction: {
                label: "删除",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/57.png",
                action: function (obj) {
                    //获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    //选中功能ID
                    var functionId = clickedNode.id;
                    //选中功能名称
                    var functionName = clickedNode.text;
                    //选中模块是否为根节点
                    var isLeaf = clickedNode.original.isLeaf;
                    //获取子节点数量
                    var childNum = clickedNode.children.length;
                    var delFunction = function () {
                        var ajax = new $ax(Hussar.ctxPath + "/resource/delFunction",
                            function (data) {
                                if (data.success == true) {
                                    ResourceManage.refreshPage();
                                    Hussar.success(DELETE_SUCCESS);
                                } else {
                                    Hussar.error(DELETE_FAIL + "（存在下级资源！）");
                                }
                            }, function (data) {
                                Hussar.error(DELETE_FAIL);
                            });
                        ajax.set("functionId", functionId)
                        ajax.start();
                    };
                    Hussar.confirm(DELETE_SURE, delFunction);
                }
            },
            delResource: {
                label: "删除",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/57.png",
                action: function (obj) {
                    //获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    //选中功能ID
                    var resourceId = clickedNode.id;
                    //选中功能名称
                    var resourceName = clickedNode.text;
                    //选中模块是否为根节点
                    var isLeaf = clickedNode.original.isLeaf;
                    //获取子节点数量
                    var childNum = clickedNode.children.length;
                    var delResource = function () {
                        var ajax = new $ax(Hussar.ctxPath + "/resource/delResource",
                            function (data) {
                                if (data.success == true) {
                                    ResourceManage.refreshPage();
                                    Hussar.success(DELETE_SUCCESS);
                                } else {
                                    Hussar.error(DELETE_FAIL + "（该资源已关联角色！）");
                                }
                            }, function (data) {
                                Hussar.error(DELETE_FAIL);
                            });
                        ajax.set("resourceId", resourceId)
                        ajax.start();
                    };
                    Hussar.confirm(DELETE_SURE, delResource);
                }
            },
            export: {
                label: "资源导出",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/export.png",
                action: function (obj) {
                    ResourceManage.resExport();

                }
            },
            import: {
                label: "资源导入",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/import.png",
                action: function (obj) {
                    $("#import").click();
                }
            },
            delegate: {
                label: "资源下放",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5211.png",
                action: function (obj) {
                    ResourceManage.delegateResource(node);	//用户机构转移
                }
            },
            retrieve: {
                label: "资源回收",
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5411.png",
                action: function (obj) {
                    ResourceManage.retrieveResource(node);	//组织机构资源回收
                }
            }
        };
        var length = node.parents.length;
        var isLeaf = node.original.isLeaf;
        var isFun = node.original.isFun;
        var isRes = node.original.isRes;
        var child = node.children;

        var state = node.state;
        if(state.gradeDisabled){//不可操作
        	 delete items.add;
        	 delete items.addResource;
        	 delete items.addFunction;
        	 delete items.edit;
        	 delete items.changeModule;
        	 delete items.moduleSort;
        	 delete items.editFunction;
        	 delete items.changeFunction;
        	 delete items.functionSort;
        	 delete items.view;
        	 delete items.delete;
        	 delete items.editResource;
        	 delete items.changeResource;
        	 delete items.resourceSort;
        	 delete items.delFunction;
        	 delete items.delResource;
        	 delete items.export;
        	 delete items.import;
//        	 delete items.delegate;
//        	 delete items.retrieve;
        }
        
        if(state.notLeafModule){//非末级模块，不可下放,不可回收
        	delete items.delegate;
        	delete items.retrieve;
        }else{
        	 var hasResource = false;
        	 var ajax = new $ax(Hussar.ctxPath + "/resource/checkHasResources",
                     function (data) {
                         if (data.code == 200) {
                         	hasResource = true;
                         } else {
                         	hasResource = false;
                         }
                     }, function (data) {
                         Hussar.error(DELETE_FAIL);
                     });
             ajax.set("resourceId", node.id)
             ajax.set("type", node.type)
             ajax.start();
             
             if(!hasResource){
            	 delete items.delegate;
             	delete items.retrieve;
             }
        }
    
        if (node.parent == '#') {
            delete items.delegate;
            delete items.retrieve;
        }

        if (node.parent != '#') {
            delete items.export;
            delete items.import;
        }
        if (child.length == 0) {
            delete items.moduleSort;  //删除节点 下级模块排序
            delete items.functionSort;  //删除节点 下级功能排序
            delete items.resourceSort;  //删除节点 下级资源排序
        }
        //判断是否为末级节点
        if (isLeaf == 0) {
            delete items.view;
            delete items.addFunction;
            delete items.functionSort;  //删除节点 下级功能排序
        } else {
            delete items.add;  //删除节点 增加下级
            delete items.moduleSort;  //删除节点 下级模块排序
            delete items.resourceSort;  //删除节点 下级资源排序
            delete items.view;
        }
        //判断是否为功能
        if (isFun == 1) {
            delete items.addFunction;
            delete items.add;  //删除节点 增加下级
            delete items.moduleSort;  //删除节点 下级模块排序
            delete items.functionSort;  //删除节点 下级功能排序
            delete items.view;
            delete items.delete;
            delete items.edit;
            delete items.changeModule; //删除节点  转移模块
        } else {
            delete items.delFunction;
            delete items.addResource;
            delete items.editFunction;
            delete items.changeFunction;//删除节点 转移功能
            delete items.resourceSort;  //删除节点 下级资源排序
        }
        //判断是否为资源
        if (isRes == 1) {
            delete items.add;  //删除节点 增加下级
            delete items.moduleSort;  //删除节点 下级模块排序
            delete items.functionSort;  //删除节点 下级功能排序
            delete items.resourceSort;  //删除节点 下级资源排序
            delete items.delete;
            delete items.edit;
            delete items.changeModule; //删除节点  转移模块
            delete items.changeFunction;//删除节点 转移功能
        } else {
            delete items.editResource;
            delete items.delResource;
            delete items.changeResource;//删除节点 转移资源
        }
        //判断是否为根节点
        if (length == 1) {
            delete items.edit;
            delete items.delete;
            delete items.view;
            delete items.addFunction;
            delete items.functionSort;  //删除节点 下级功能排序
            delete items.resourceSort;  //删除节点 下级资源排序
            delete items.changeModule; //删除节点  转移模块
            delete items.changeFunction;//删除节点 转移功能
        }
        return items;
    };


    /**
     * 初始化资源导出树
     */
    ResourceManage.initExportTree = function () {
        ResourceManage.exportTree = $('#resExportTree');
        ResourceManage.exportTree.jstree({
            core: {
                check_callback: true,
                data: function (obj, callback) {
                    var data;
                    var ajax = new $ax(Hussar.ctxPath + "/resource/resTree", function (result) {
                        data = result;
                    }, function (data) {
                        Hussar.error(LOAD_TREE_FAIL);
                    });
                    ajax.start();
                    callback.call(this, data);
                }
            },
            plugins: ['checkbox', 'types'],
            types: {
                "isModule": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/module.png"},
                "isFun": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/function.png"},
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/resource_menu.png"}, //菜单资源
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/resource_btn.png"}  //按钮资源
            },
            checkbox: {
                keep_selected_style: false,
                three_state: true,
                tie_selection: false
            }
        });
        ResourceManage.exportTree.on('check_node.jstree', function (event, obj) {
            var currentNode = obj.node;
            var ref = ResourceManage.exportTree.jstree(true);
            //根节点和两个字典分类不能勾选
            if (currentNode.parent == '#') {
                ref.uncheck_node(currentNode.id);
                return;
            }
        });
    };

    //资源回收
    ResourceManage.retrieveResource = function (node) {
        $('#resourceIdHidden').val(node.id);    //资源id
        $('#typeHidden').val(node.original.type);   //资源类型
        ResourceManage.orgTree.jstree("destroy");
        ResourceManage.initOrgTree();
        ResourceManage.layerIndex = layer.open({
            type: 1,
            btn: ['取消', '保存'],
            skin: 'confirm-class',
            title: '资源回收',
            area: ['350px', '500px'], //宽高
            fix: false, //不固定
            maxmin: false,
            shadeClose: false,
            content: $('#changeOrg'),
            btn2: function (index, layero) {
                ResourceManage.saveRetrieveResource();	//保存回收资源
                return false;
            },
            success: function () {
                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
            }

        });
    }

    //保存回收资源
    ResourceManage.saveRetrieveResource = function () {
        var ref = $("#orgTree").jstree(true);
        var nodeids = ref.get_checked();  //获取选中的节点对象id
        var stru_json = ref.get_json(); //当前组织机构树所有已经加载的数据
        var original = [];//已经加载的组织机构原始数据，只取id
        ResourceManage.treeToList(stru_json,original);
        //删选出要回收资源的组织id
        var str = "";
        if(nodeids.length!=0){
            for(var i = 0;i<nodeids.length;i++){
                if(i<nodeids.length-1){
                    str+=nodeids[i]+",";
                }else{
                    str+=nodeids[i]
                }
            }
        }
        $('#struIdHidden').val(str);    //组织id集合

        var data = $("#changeOrgForm").serialize();
        data = $.param({'original': JSON.stringify(original)}) + '&' + data;
        // 提交信息
        var ajax = new $ax(Hussar.ctxPath + "/resource/retrieveResource", function (data) {
            if (data.code == "200") {
                Hussar.success(data.message);
                layer.close(ResourceManage.layerIndex);
            } else if (data.code) {
                Hussar.error(data.message);
            } else {
                Hussar.error("回收失败!");
            }
        }, function (data) {
            Hussar.error("回收失败!");
        });
        ajax.setData(data);
        ajax.start();
    }
    //递归实现 树转list
    ResourceManage.treeToList = function (tree, result = [], level = 1) {
        tree.forEach(node => {
          result.push(node.id)
          node.level = level++
          node.children && ResourceManage.treeToList(node.children, result, level)
        })
        return result
    }
    //资源下放
    ResourceManage.delegateResource = function (node) {
        $('#resourceIdHidden').val(node.id);       //资源id
        $('#typeHidden').val(node.original.type);   //资源类型
        ResourceManage.orgTree.jstree("destroy");
        ResourceManage.initOrgTree1();
        ResourceManage.layerIndex = layer.open({
            type: 1,
            btn: ['取消', '保存'],
            skin: 'confirm-class',
            title: '资源下放',
            area: ['350px', '500px'], //宽高
            fix: false, //不固定
            maxmin: false,
            shadeClose: false,
            content: $('#changeOrg'),
            btn2: function (index, layero) {
                ResourceManage.saveDelegateResource();	//保存下放资源
                return false;
            },
            success: function () {
                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
            }

        });
    }

    //保存下放资源
    ResourceManage.saveDelegateResource = function () {
        var ref = $("#orgTree").jstree(true);
        var nodeids = ref.get_checked();  //获取选中的节点对象id
        if (nodeids.length == 0) {
            Hussar.info('请选择要下放的组织！');
        }else{
            var str = "";
            for(var i = 0;i<nodeids.length;i++){
                if(i<nodeids.length-1){
                    str+=nodeids[i]+",";
                }else{
                    str+=nodeids[i]
                }
            }
            $('#struIdHidden').val(str);     //组织id集合

            var data = $("#changeOrgForm").serialize();
            // 提交信息
            var ajax = new $ax(Hussar.ctxPath + "/resource/delegateResource", function (data) {
                if (data.code == "200") {
                    Hussar.success(data.message);
                    layer.close(ResourceManage.layerIndex);
                } else if (data.code) {
                    Hussar.info(data.message);
                } else {
                    Hussar.error("下放失败!");
                }
            }, function (data) {
                Hussar.error("下放失败!");
            });
            ajax.setData(data);
            ajax.start();
        }
    }

    /**
     * 数据导出
     */
    ResourceManage.resExport = function () {
        $('#resExportTree').jstree("destroy");
        ResourceManage.initExportTree();
        layer.open({
            type: 1,
            btn: ['取消', '导出'],
            skin: 'confirm-class',
            area: ['350px', '500px'],
            shadeClose: false,
            zIndex: 9999,
            title: "资源导出",
            content: $('#resExport'),
            success: function () {
                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe017</i>");
            },
            btn2: function (index) {
                var nodes = ResourceManage.exportTree.jstree(true).get_checked();
                if (nodes.length == 0) {
                    Hussar.info(CHOOSE_EXPORT_RESOURCES);
                } else {
                    var resExport = function () {
                        var ids = nodes.join(",");
                        var url = Hussar.ctxPath + "/resource/exportRes";
                        var form = $("<form></form>").attr("action", url).attr("method", "post");
                        form.append($("<input></input>").attr("type", "hidden").attr("name", "ids").attr("value", ids));
                        form.appendTo('body').submit().remove();
                        layer.close(index);
                    };
                    Hussar.confirm(EXPORT_RESOURCES_SURE, resExport);
                }
                return false;
            }
        });

    };

    /**
     * 数据上传导入
     */
    var dataImport = upload.render({
        elem: '#import'
        , url: Hussar.ctxPath + '/resource/importData'
        , accept: 'file'
        , exts: 'hussar'
        , before: function (obj) {
            ResourceManage.layIndex = layer.load(2);
        }
        , done: function (res, index, upload) {
            layer.close(ResourceManage.layIndex);	//关闭loading
            if (res.code == 200) {
                Hussar.success(res.message);
                ResourceManage.refreshPage();
            } else {
                Hussar.error(res.message);
            }
        }
        , error: function () {
            layer.close(ResourceManage.layIndex);	//关闭loading
            Hussar.error(IMPORT_FAIL);
        }
    });



    /*排序*/
    ResourceManage.up = function (x, y) {
        return x.seq - y.seq
    };
    ResourceManage.initFrameHeight = function () {
        var h = $(window).height() - 10;
        $("#moduleFrame").css("height", h + "px");
        $("#treeArea").css("height", h - 51 + "px");
    };


    /*初始化树查询*/
    ResourceManage.initTreeSearch = function () {
        var to = false;
        //资源树查询
        $("#resTreeSearch").keyup(function () {
            if (to) {
                clearTimeout(to);
            }
            to = setTimeout(function () {
                var v = $("#resTreeSearch").val();
                var temp = $("#resTree").is(":hidden");
                if (temp == true) {
                    $("#resTree").show();
                }
                $("#resTree").jstree(true).search(v);
                //添加索引
                if (v != '') {
                    var n = $(".jstree-search").length, con_html;
                    if (n > 0) {
                        con_html = "<em>" + n + "</em>个匹配项";
                    } else {
                        con_html = "无匹配项";
                    }
                    $(".search-results").html(con_html);
                    //定位到符合查询结果的树节点上
                    var searchResult = $("#resTree").jstree('search', v);
                    $(searchResult).find('.jstree-search').focus();
                } else {
                    $(".search-results").html("");
                }

            }, 250);
        });
        //组织树查询
        $("#orgTreeSearch").keyup(function () {
            if (to) {
                clearTimeout(to);
            }
            to = setTimeout(function () {
                var v = $("#orgTreeSearch").val();
                var temp = $orgTree.is(":hidden");
                if (temp == true) {
                    $orgTree.show();
                }
                $orgTree.jstree(true).search(v);
                //定位到符合查询结果的树节点上
                var searchResult = $orgTree.jstree('search', v);
                $(searchResult).find('.jstree-search').focus();
            }, 250);
        });
    };

    /**
     *  刷新页面，供子页面调用
     *  @author LiangDong
     */
    ResourceManage.refreshPage = function () {
        $("#" + ResourceManage.treeId + "").jstree(true).refresh();
        $("#moduleFrame").attr("src", "");
    };

    $(function () {
        ResourceManage.initPage();
//        var h = $(window).height();
//        $(".con-full").css("height", h + "px");
        $(window).resize(function () {
            ResourceManage.initFrameHeight();
        });
    });
});