/**
 * Created by zhaopengcheng on 2018/12/20.
 */
layui.define(['form','jquery','Hussar'], function(exports) {
    var $ = layui.jquery,
        form = layui.form,
        Hussar = layui.Hussar,
        cascade_select_val = [],
        cascade_select_count = 0;

    var cascadeSelect = {
        render: function (el) {
            // 没有指定容器，退出方法
            if (typeof(el.container) == 'undefined') {
                return
            }
            var str = el.container;
            // 指定容器
            var container = $(str);
            // 下拉框name属性的处理
            if (typeof(el.selectName) != 'undefined'){
                cascade_select_val[cascade_select_count] = el.selectName.split(",");
            }
            // 最大可联动下拉框数量
            var maxCount = el.cascadeCount;
            // 不同的id查询的表格不同
            var url = "";
            if (typeof(el.id) == 'undefined' || el.id == "") {
                url = "/sys/dic/selectListByParentId";
            } else {
                url = "/sys/dic/selectChildsById"
            }
            // 初始化下拉框
            $.ajax({
                type: 'post',
                url: Hussar.ctxPath + url,
                async: false,
                data: {id: el.id},
                contentType : "application/x-www-form-urlencoded;charset=UTF-8",
                success: function (data) {
                    if (data != null && (typeof(el.id) == 'undefined' || el.id == "")) {
                        container.append("<select data-cascade='cascadeJs' data-count='"+maxCount+"'" +
                            "name='"+cascade_select_val[cascade_select_count][0]+"'><option value=''></option></select>");
                    }else {
                        container.append("<select data-cascade='cascadeJs1' data-count='"+maxCount+"'" +
                            "name='"+cascade_select_val[cascade_select_count][0]+"'><option value=''></option></select>");
                    }
                    cascade_select_count ++;
                    var Dom = $(str + ">select:last-child");
                    var innerHtml = "<option value=''></option>";
                    for (var val in data) {
                        if (data != null && (typeof(el.id) == 'undefined' || el.id == "")) {
                            innerHtml += "<option value='" + data[val].typeName + "'>" + data[val].typeDescription + "</option>";
                        } else if (data != null) {
                            innerHtml += "<option data-id='"+data[val].id+"' value='" + data[val].value + "'>" + data[val].label + "</option>";
                        }
                    }
                    Dom.html(innerHtml);
                    form.render('select');
                },
                error: function (data) {
                    form.render('select');
                }
            })
        }
    };

    // 监听下拉框事件
    form.on("select", function (data) {
        // 获得改变值的下拉框
        var selectDom = $(data.elem);
        // 值为空，退出方法
        if (selectDom.val() == ""){
            return
        }
        var count1 = selectDom.parent().children("select").length;
        var count2 = selectDom.parent().children("select:first-child").data("count");
        // 判断最大联动数,达到最大则退出
        if (count1 >= count2 && selectDom[0].name == (selectDom.parent().children("select:last"))[0].name){
            return
        }
        // 判断下一级的name属性
        var nextName = "";
        for (var i = 0;i < cascade_select_val.length;i ++){
            for (var j = 0;j <cascade_select_val[0].length;j ++){
                if (selectDom[0].name == cascade_select_val[i][j]){
                    nextName = cascade_select_val[i][j+1]
                }
            }
        }
        // 判断是否为需要的下拉框
        if (selectDom.data("cascade") == "cascadeJs1") {
            // 清空此下拉框之后所有同级元素
            selectDom.nextAll().remove();
            addSelect_cascadeJs2(selectDom.find("option:selected").data("id"),selectDom.parent(),nextName);
        }else if (selectDom.data("cascade") == "cascadeJs"){
            // 清空此下拉框之后所有同级元素
            selectDom.nextAll().remove();
            addSelect_cascadeJs(selectDom.parent(),nextName);
        }
    });

    // 未指定id时的第二级下拉框
    addSelect_cascadeJs = function (parent,nextName) {
        $.ajax({
            type: 'post',
            url: Hussar.ctxPath + '/sys/dic/selectListByTypeName',
            async: false,
            contentType : "application/x-www-form-urlencoded;charset=UTF-8",
            data: {typeName: $("#"+parent[0].id + ">select:last-child").val()},
            success: function (data) {
                if (data.length != 0) {
                    parent.append("<select  data-cascade='cascadeJs1' name='"+nextName+"'><option value=''></option></select>");
                    var Dom = parent.children("select:last-child");
                    var innerHtml = "<option value=''></option>";
                    for (var val in data) {
                        innerHtml += "<option data-id='"+data[val].id+"' value='" + data[val].value + "'>" + data[val].label + "</option>";
                    }
                    Dom.html(innerHtml);
                    form.render('select');
                }else {
                    form.render('select');
                }
            }
        })
    };

    /**
     * 指定id时的无限级下拉框
     * @param data1 下拉框值
     * @param data2 下拉框选项的文本值
     */
    addSelect_cascadeJs2 = function (data,parent,nextName) {
        $.ajax({
            type: 'post',
            url: Hussar.ctxPath + '/sys/dic/selectChildsById',
            async: false,
            contentType : "application/x-www-form-urlencoded;charset=UTF-8",
            data: {id:data},
            success: function (data) {
                if (data.length != 0) {
                    parent.append("<select  data-cascade='cascadeJs1' name='"+nextName+"'><option value=''></option></select>");
                    var Dom = parent.children("select:last-child");
                    var innerHtml = "<option value=''></option>";
                    for (var val in data) {
                        innerHtml += "<option data-id='"+data[val].id+"' value='" + data[val].value + "'>" + data[val].label + "</option>";
                    }
                    Dom.html(innerHtml);
                    form.render('select');
                }else {
                    form.render('select');
                }
            }
        })
    };

    exports("cascadeSelect",cascadeSelect);
});