/**
 * @Description:职工维护脚本文件
 * @Author: sunZengXin
 * @Date: 2018/2/6.
 */

var EmplMaintenance = {
    treeId:"orgEmployeeTree",
    infoWin:null, //弹出窗口
    selectId:null,
    isRootChange:'0',
    changeLevel:null
};
layui.use(['jquery','layer','Hussar','jstree','form','HussarAjax'], function(){
		var Hussar = layui.Hussar;
		var $ = layui.jquery;
		var layer=layui.layer;
		var form = layui.form
		, $ax = layui.HussarAjax;

	/*初始化页面*/
	EmplMaintenance.initPage= function(){
		this.initTreeView();//初始化组织树
		this.initOrderTreeView();//初始化排序树
		this.initChangeTreeView();//初始化转移树
		this.initButtonEvent();
		EmplMaintenance.initFrameHeight();
	};
	/*组织机构树右键菜单*/
	EmplMaintenance.menuList=function(node){
		var items={
	                create: null,
	                remove: null,
	                ccp: null,
	                add: {
	                    label: "新增人员",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5011.png",
	                    action: function (obj) {
	                    	//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
							//新增组织类型
							var orgType = '9';
							//选中组织ID
							var orgParentId =clickedNode.id;
							//选中组织编码
							var orgParentCode =clickedNode.original.code;
							//选中上级组织机构名称
							var orgParentName =clickedNode.text;
							//选中上级组织机构层级
							var struLevel = clickedNode.original.struLevel;
							//获取子节点数量
							var childNum = clickedNode.children.length;
							//选中组织类型
							var parentType = clickedNode.original.struType;
							//选中不同组织机构类型编码(用户构建下级组织机构编码)
							var parentTypeCode = clickedNode.original.parentTypeCode;
							$("#employeeInfo").attr("src",Hussar.ctxPath+"/employee/employeeAdd?orgParentId="+orgParentId+"&orgParentCode="+orgParentCode+"&orgParentName="+orgParentName+"&orgType="+orgType+"&struLevel="+struLevel+"&childNum="+childNum+"&parentType="+parentType+"&parentTypeCode="+parentTypeCode)
	                    }
	                },
	                sort: {
	                    label: "下级排序",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5111.png",
	                    action: function (obj) {
	                    	//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
							if (clickedNode.children == undefined || clickedNode.children.length <2) {
								Hussar.error("下级节点数量小于2，无需排序!");
								return
							}
				        	//选中组织ID
				        	var orgId=clickedNode.id;
				        	layer.open({
		        				type: 1,
		        				btn: [ '取消','保存'],
		        				skin: 'confirm-class',
		        				area: ['350px','500px'],
		        				fix: false, //不固定
		        				maxmin: false,
		        				shadeClose: false,
		        				shade: 0.4,
		        				title: "下级排序",
		        				content: $('#treeEditOrder'),
		        				btn2: function(index, layero){
		        					//确认按钮回调
		        					var saveTree =function(){
		        						var ajax = new $ax(Hussar.ctxPath+"/orgMain/orgTreeOrder",
											function () {
                                                EmplMaintenance.refreshTree();
                                                Hussar.success(SAVE_SUCCESS);
                                                EmplMaintenance.closeWindow();
                                            },
											function () {
                                                Hussar.error(SAVE_FAIL);
                                            });
										ajax.setAsync(false);
										ajax.set("treeInfo",$("#output").val());
										ajax.start()
		        			    	};
		        			    	Hussar.confirm(SAVE_SORT_SURE, saveTree);
				                    layer.close(index);
		        				 },
		        				success:function(){
                                    $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                                    $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
                                    var ajax = new $ax(Hussar.ctxPath+"/orgMain/orgTreeById",
										function (result) {
                                            $("#orgTreeOrder").jstree(true).settings.core.data = result;
                                            $("#orgTreeOrder").jstree(true).refresh();
                                            //返回值在页面显示
                                            var newResult=[];
                                            for(var i=0;i<result.length;i++){
                                                if(result[i].parent!="#"){
                                                    newResult.push(result[i]);
                                                }
                                            }
                                            $("#output").val(window.JSON.stringify(newResult));
                                        },
										function (data) {

                                        });
									ajax.setAsync(false);
									ajax.set("orgId",orgId);
									ajax.set("isEmployee","1");
									ajax.start()
		        				}
		        			});
	                    }
	                },
	                edit: {
	                    label: "修改",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/53.png",
	                    action: function (obj) {
	                        //获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
							//选中组织ID
				        	var orgId=clickedNode.id;
					        $("#employeeInfo").attr("src",Hussar.ctxPath+"/employee/employeeEdit?orgId="+orgId);
	                    }
	                },
	                change: {
	                    label: "转移",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5411.png",
	                    action: function (obj) {
	                    	//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
				        	//选中组织ID
				        	var orgId=clickedNode.id;
				        	//选中组织类型
				        	var orgType = clickedNode.original.struType;
				        	layer.open({
		        				type: 1,
		        				btn: ['取消','保存'],
		        				skin: 'confirm-class',
		        				area: ['350px','500px'],
		        				fix: false, //不固定
		        				maxmin: false,
		        				shadeClose: false,
		        				shade: 0.4,
		        				title: "上级组织机构选择",
		        				content: $('#treeEditChange'),
		        				btn2: function(index, layero){
		        					//获取选中节点
	        	  					var nodes = $("#orgTreeChange").jstree(true).get_checked();//使用get_checked方法
	        	  					if(nodes.length==0){
	        	  						Hussar.info(CHOOSE_SUPERIOR_ORGANIZATION);
	        	  					}else{
		        					//确认按钮回调
		        					var saveTree =function(){
                                        var ajax = new $ax(Hussar.ctxPath+"/employee/staffTransfer",
                                            function (data) {
                                                if(data.success== true){
                                                    EmplMaintenance.refreshTree();
                                                    Hussar.success(data.msg);
                                                    layer.close(index);
                                                }else{
                                                    Hussar.error(data.msg);
                                                }
                                            },
                                            function () {
                                                Hussar.error(MOVE_FAIL);
                                            });
                                        ajax.set("orgId",orgId);
                                        ajax.set("orgType",orgType);
                                        ajax.set("parentId",nodes[0]);
                                        ajax.set("isRoot",EmplMaintenance.isRootChange);
                                        ajax.set("changeLevel",EmplMaintenance.changeLevel);
                                        ajax.setAsync(false);
                                        ajax.start();
		        			    	}
		        			    	Hussar.confirm(MOVE_SURE, saveTree);

				                    layer.close(index);
	        	  					}
		        				 },
		        				success:function(){
                                    $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                                    $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
                                    var ajax = new $ax(Hussar.ctxPath+"/orgMain/orgChangeById",
                                        function (result) {
                                            EmplMaintenance.selectId=orgId;
                                            $("#orgTreeChange").jstree(true).settings.core.data = result;
                                            $("#orgTreeChange").jstree(true).refresh();
                                        },
                                        function () {

                                        });
                                    ajax.set("orgId",orgId);
                                    ajax.set("isEmployee","");
                                    ajax.set("rootName","人员组织机构");
                                    ajax.setAsync(false);
                                    ajax.start();
		        				}
		        			});
	                    }
	                },
	                delete: {
	                    label: "删除",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/57.png",
	                    action: function (obj) {
	                    	//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
				        	//选中组织ID
				        	var orgId=clickedNode.id;
	                    	var delOrg =function(){
	                    	    var ajax = new $ax(Hussar.ctxPath+"/employee/delEmployeeById",
                                    function (data) {
                                        if(data.success==true){
											EmplMaintenance.blank()
                                            EmplMaintenance.refreshTree();
                                            Hussar.success(data.msg);
                                        }else{
                                            Hussar.error(data.msg);
                                        }
                                    },function () {
                                        Hussar.error(DELETE_FAIL);
                                    });
	                    	    ajax.set("orgId",orgId);
	                    	    ajax.setAsync(false);
	                    	    ajax.start();
	                    	}
	                    	Hussar.confirm(DELETE_SURE, delOrg);
	                    }
	                }
	           };
				var length = node.parents.length;
				if(length==1){
					delete items.change;  //删除节点 转移
					delete items.add;
					delete items.edit;
					delete items.delete;
					delete items.sort;
				}
				var child = node.children;
				if (child.length == 0) {
					delete items.sort;  //删除节点 下级排序
				}
				var isEmployee = node.original.isEmployee;
				if(isEmployee=="1"){
					delete items.sort;//删除节点下级排序
					delete items.add;//删除节点 增加
				}else{
					delete items.change;  //删除节点 转移
					delete items.delete;  //删除节点删除
					delete items.edit;//删除节点修改
				}
		var employeeAdd = $("#employeeAdd").val();
		var employeeDel = $("#employeeDel").val();
		var employeeEdit = $("#employeeEdit").val();
		var employeeStaffTransfer = $("#employeeStaffTransfer").val();
		var orgMain_orgTreeOrder = $("#orgMain_orgTreeOrder").val();
		if (employeeAdd != "true") {
			delete items.add;
		}
		if (employeeDel != "true") {
			delete items.delete;
		}
		if (employeeEdit != "true") {
			delete items.edit;
		}
		if (employeeStaffTransfer != "true") {
			delete items.change;
		}
		if (orgMain_orgTreeOrder != "true") {
			delete items.sort;
		}

			return items;

	}
	/*初始化组织机构人员树*/
	EmplMaintenance.initTreeView = function(){
	    var $tree = $("#orgEmployeeTree");
	    $tree.jstree({
	        core: {
	            check_callback: true,
				data:{
					"url"  :Hussar.ctxPath + "/employee/employeeTree",
					"data" : function (node) {
						return {
							"parentId" : node.id ,
							"isEmployee" : "1"
						};
					}
				}
	        },
	        plugins: ['types', 'contextmenu'],
	        contextmenu: {
	            items: EmplMaintenance.menuList
	        },
	        types:{
                "1":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/com.png"},
                "2":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/dept.png"},
                "3":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/station.png"},
                "9":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/empl.png"}
            }
	    });
	    $tree.bind("activate_node.jstree", function (obj, e) {
			// 处理代码
			// 获取当前节点
			var currentNode = e.node;
			var struId = currentNode.id
			var isEmployee = currentNode.original.isEmployee;
			if(isEmployee=="1"){
				$("#employeeInfo").attr("src",Hussar.ctxPath+"/employee/employeeInfo?struId=" + struId)
			}else{
				var parent = currentNode.parent;
				if(parent=="#"){
					$("#employeeInfo").attr("src","")
				}else{
					$("#employeeInfo").attr("src",Hussar.ctxPath+"/orgMain/orgInfo?struId=" + struId)
				}
			}
		});
	}
	/*刷新组织机构树*/
	EmplMaintenance.refreshTree = function(){
		$("#orgEmployeeTree").jstree(true).refresh();
	}
	/*初始化组织机构排序树*/
	EmplMaintenance.initOrderTreeView = function(){
	    //初始化数列表
	    var $tree = $("#orgTreeOrder");
	    $tree.data('jstree', false).empty();
	    $tree.jstree({
	        core: {
	            check_callback: function (operation, node, node_parent, node_position, more) {
	                //拖动排序时只允许同级拖动
	            	if(operation=='move_node'){
	                	if(node.parent==node_parent.parent||node_parent.parent==null){
	                    	return false;
	                    }else{
	                    	return true;
	                    }
	                }else{
	                	return true;
	                }
	            },
	            data: null
	        },
	        plugins: ['types',"dnd",'contextmenu'],
	        contextmenu: {
	            items: EmplMaintenance.menuList
	        },
	        sort:function(a,b){
	            return this.get_node(a).original.struOrder > this.get_node(b).original.struOrder ? 1 : -1;
	        },
	        types:{
                "1":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/com.png"},
                "2":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/dept.png"},
                "3":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/station.png"},
                "9":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/empl.png"}
            }
	    });
	    $tree.bind("activate_node.jstree", function (obj, e) {
			// 处理代码
			// 获取当前节点
			var currentNode = e.node;
            var struId = currentNode.id;
            var isEmployee = currentNode.original.isEmployee;
            if(isEmployee=="1"){
                $("#employeeInfo").attr("src",Hussar.ctxPath+"/employee/employeeInfo?struId=" + struId)
            }else{
                $("#employeeInfo").attr("src",Hussar.ctxPath+"/orgMain/orgInfo?struId=" + struId)
            }
		});
	    //移动树事件
	    $tree.bind('move_node.jstree', function (e, data) {
	    	//移动的组织ID
	    	var id = data.node.id;
	    	//移动之前的位置
	    	var oldPosition = data.old_position;
	    	//移动后的位置
	    	var position = data.position;
	    	//原地未动
	    	if(oldPosition==position){
	    		return;
	    	}
	    	var oldResult = JSON.parse($("#output").val());
	    	//根据目前的位置对于树结果进行重新排序
	    	//向上移动
	    	if(position-oldPosition<0){
	    		for(var i=0;i<oldResult.length;i++){
	        		if(i<position){
	        			oldResult[i].struOrder=i+1;
	        		}else{
	            		if(oldResult[i].id==id){
	            			oldResult[i].struOrder=position+1;
	            		}else{
	            			if(i<=oldPosition){
	            				oldResult[i].struOrder=i+2;
	            			}else{
	            				oldResult[i].struOrder=i+1;
	            			}
	            		}
	        		}
	        	}
	    	}else{//向下移动
	    		for(var i=0;i<oldResult.length;i++){
	        		if(i<oldPosition){
	        			oldResult[i].struOrder=i+1;
	        		}else{
	            		if(oldResult[i].id==id){
	            			oldResult[i].struOrder=position+1;
	            		}else{
	            			if(i<=position){
	            				oldResult[i].struOrder=i;
	            			}else{
	            				oldResult[i].struOrder=i+1;
	            			}
	            		}
	        		}
	        	}
	    	}
	    	oldResult.sort(EmplMaintenance.up);
	    	$("#output").val(window.JSON.stringify(oldResult));
	    });
	}

	/*初始化转移组织树*/
	EmplMaintenance.initChangeTreeView = function(){
		    //初始化数列表
		    var $tree = $("#orgTreeChange");
		    $tree.data('jstree', false).empty();
		    $tree.jstree({
		        plugins: ['types','checkbox'],
		        core: {
		            check_callback: true,
		            data: null,
			        multiple: false//单选
		        },
		        sort:function(a,b){
		            return this.get_node(a).original.struOrder > this.get_node(b).original.struOrder ? 1 : -1;
		        },
		        checkbox: {
		            keep_selected_style : false,
		            three_state : false,
		            tie_selection : false
		        },
		        types:{
                    "1":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/com.png"},
                    "2":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/dept.png"},
                    "3":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/station.png"},
                    "9":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/empl.png"}
                }
		    });
		   $tree.on('check_node.jstree', function(event, obj) {
			   var currentNode = obj.node;
              var ref =$tree.jstree(true);
              var nodes = ref.get_checked(); //使用get_checked方法
              var otherNode;
              otherNode="";
              //判断是否为根节点，则不能移动
              var length = obj.node.parents.length;
              if(length==1){
            	  ref.uncheck_node(obj.node.id);
            	  Hussar.info(CANNOT_MOVE_ORGANIZATION);
      			  return;
              }
              //判断是否为相同节点，则不能移动
              if(EmplMaintenance.selectId==obj.node.id){
            	  ref.uncheck_node(obj.node.id);
            	  Hussar.info(CANNOT_MOVE_ORGANIZATION);
      			  return;
              }
              //限制选择不能选择当前以及当前子节点
              if(nodes.length>0){
            	  $.each(currentNode.parents, function(i, nd) {
                		if(nd == EmplMaintenance.selectId){
                			ref.uncheck_node(obj.node.id);
                			Hussar.info(CANNOT_MOVE_ORGANIZATION);
                			return false;
                		}
                	})
              }
              //限制只能选一个
              if(nodes.length>1){
              	$.each(nodes, function(i, nd) {
              		if(nd != obj.node.id){
              			otherNode = nd;
              		}
              	})
              	ref.uncheck_node(otherNode);
              }

            //判断选择几点是否为根节点
              if(length==1){
            	  EmplMaintenance.isRootChange='1';
              }else{
            	  EmplMaintenance.isRootChange='0';
              }
              EmplMaintenance.changeLevel = obj.node.original.struLevel;
          });
		}
	/*初始化按钮事件*/
	EmplMaintenance.initButtonEvent = function(){
	    /*排序树保存*/
	    $("#treeBtnSave").click(function(){
	    	var saveTree =function(){
	    	    var ajax = new $ax(Hussar.ctxPath+"/orgMain/orgTreeOrder",
                    function (data) {
                        EmplMaintenance.refreshTree();
                        Hussar.success(SAVE_SUCCESS);
                        EmplMaintenance.closeWindow();
                    },
                    function () {
                        Hussar.error(SAVE_FAIL);
                    });
	    	    ajax.setAsync(false);
	    	    ajax.set("treeInfo",$("#output").val());
	    	    ajax.start();
	    	}
	    	Hussar.confirm(SAVE_SORT_SURE, saveTree);
	    });
	    /*排序树重置*/
	    $("#treeBtnReset").click(function(){
	    	EmplMaintenance.closeWindow();
	    });
	}
    /*右侧iframe置空方法*/
    EmplMaintenance.blank = function () {
        $("#employeeInfo").attr("src", "");
    };

	/*增加人员*/
	EmplMaintenance.addOrgInfo=function(){
		//获取选中的组织类型
		var orgType = $("#orgType").val();
		//获取上级组织机构ID
		var orgParentId = $("#orgParentId").val();
		//获取上级组织机构编码
		var orgParentCode = $("#orgParentCode").val();
		//获取上级组织机构名称
		var orgParentName = $("#orgParentName").val();
		//获取上级组织机构所在层级
		var struLevel = $("#struLevel").val();
		//获取上级组织机构子节点数量
		var childNum = $("#childNum").val();
		//上级组织机构类型
		var parentType = $("#parentType").val();
		//不同组织机构类型编码(用户构建下级组织机构编码)
		var parentTypeCode = $("#parentTypeCode").val();
		$("#employeeInfo").attr("src",Hussar.ctxPath+"/employee/employeeAdd?orgParentId="+orgParentId+"&orgParentCode="+orgParentCode+"&orgParentName="+orgParentName+"&orgType="+orgType+"&struLevel="+struLevel+"&childNum="+childNum+"&parentType="+parentType+"&parentTypeCode="+parentTypeCode)
	}
	/*排序*/
	EmplMaintenance.up=function(x,y){
		return x.struOrder-y.struOrder
	}
	/*关闭弹窗*/
	EmplMaintenance.closeWindow=function () {
	    layer.close(EmplMaintenance.infoWin);
	};
	EmplMaintenance.initFrameHeight=function(){
		var h = $(window).height()-3;
		$("#employeeInfo").css("height", h + "px");
		$("#orgEmployeeTree").css("height", h + "px");
	}
	$(function () {
		EmplMaintenance.initPage();
		$(window).resize(function() {
			EmplMaintenance.initFrameHeight();
		});
	});
});