/**
 * 初始化详情对话框
 */
var SysUsersAuditInfoDlg = {
    sysUsersAuditInfoData : {}
};

layui.use(['layer', 'Hussar', 'HussarAjax', 'laydate'], function(){
	var layer = layui.layer
        ,Hussar = layui.Hussar
	    ,$ = layui.jquery
	    ,laydate = layui.laydate
	    ,$ax = layui.HussarAjax;

/**
 * 清除数据
 */
SysUsersAuditInfoDlg.clearData = function() {
    this.sysUsersAuditInfoData = {};
};

/**
 * 设置对话框中的数据
 *
 * @param key 数据的名称
 * @param val 数据的具体值
 */
SysUsersAuditInfoDlg.set = function(key, val) {
    this.sysUsersAuditInfoData[key] = (typeof val == "undefined") ? $("#" + key).val() : val;
    return this;
};

/**
 * 设置对话框中的数据
 *
 * @param key 数据的名称
 * @param val 数据的具体值
 */
SysUsersAuditInfoDlg.get = function(key) {
    return $("#" + key).val();
};

/**
 * 关闭此对话框
 */
SysUsersAuditInfoDlg.close = function() {
    parent.layui.layer.close(window.parent.SysUsersAudit.layerIndex);
};

/**
 * 收集数据
 */
SysUsersAuditInfoDlg.collectData = function() {
    this
    .set('userId')
    .set('userName')
    .set('password')
    .set('accountStatus')
    .set('securityLevel')
    .set('maxSessions')
    .set('isSys')
    .set('isCpublic')
    .set('createTime')
    .set('lockTime')
    .set('expiredTime')
    .set('pswdUptTime')
    .set('pswdTime')
    .set('corporationId')
    .set('departmentId')
    .set('employeeId')
    .set('eMail')
    .set('wechat')
    .set('telephone')
    .set('mobile')
    .set('char1')
    .set('char2')
    .set('num1')
    .set('num2')
    .set('permissionStruId')
    .set('userOrder')
    .set('provinceCode')
    .set('userAccount')
    .set('typeProperty')
    .set('startTime')
    .set('lastLoginTime')
    .set('accessLoginStartTime')
    .set('accessLoginEndTime')
    .set('totpKey')
    .set('loginTimeLimit')
    .set('loginIpLimit');
};

/**
 * 提交添加
 */
SysUsersAuditInfoDlg.addSubmit = function() {

    this.clearData();
    this.collectData();

    //提交信息
    var ajax = new $ax(Hussar.ctxPath + "/sysUsersAudit/add", function(data){
        window.parent.layui.Hussar.success("添加成功!");
        window.parent.$('#SysUsersAuditTable').bootstrapTable('refresh');
        SysUsersAuditInfoDlg.close();
    },function(data){
        Hussar.error("添加失败!" + data.message + "!");
    });
    ajax.set(this.sysUsersAuditInfoData);
    ajax.start();
};

/**
 * 提交修改
 */
SysUsersAuditInfoDlg.editSubmit = function() {

    this.clearData();
    this.collectData();

    //提交信息
    var ajax = new $ax(Hussar.ctxPath + "/sysUsersAudit/update", function(data){
        window.parent.layui.Hussar.success(UPDATE_SUCCESS);
        window.parent.$('#SysUsersAuditTable').bootstrapTable('refresh');
        SysUsersAuditInfoDlg.close();
    },function(data){
        Hussar.error(UPDATE_FAIL + data.message + "!");
    });
    ajax.set(this.sysUsersAuditInfoData);
    ajax.start();
};

/**
 * 初始化时间控件
 */
SysUsersAuditInfoDlg.initLaydate = function() {
    var dateDom = $(".dateType");
    $.each($(".dateType"), function (i,dom) {
        laydate.render({
            elem: dom,
            type : 'datetime'
        });
    });
}

$(function() {
    SysUsersAuditInfoDlg.initLaydate();   //初始化时间控件
});

});