/**
 * @Description: 角色管理脚本文件
 * @Author: chenxin
 * @Date: 2018/2/27.
 */

layui.use(['jquery','layer','Hussar','jstree','HussarAjax','form','element','table'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer=layui.layer;
	var $ax=layui.HussarAjax;
	var jstree=layui.jstree;
    var RoleManage = {};
    var element=layui.element;
    var form=layui.form;
    var table = layui.table;


    /*初始化页面*/
    RoleManage.initPage = function() {
        this.initTable();
        this.initResTree();
        this.initUserTree();
        this.initButtonEvent();
        this.validator();
        this.initFrameHeight();
    };

    /**
     *  加载角色关联用户树
     */
    RoleManage.initUserTree = function () {
        var nodeId=$("#nodeId").val();
        var $userTree = $("#userTree");//用户树
        $userTree.jstree({
            core: {
                check_callback: true,
                // 2019/12/09修改为懒加载<此仅用作展示，修改改为其他控件>
                data: {
                    "url": Hussar.ctxPath + "/roleManager/lazyRoleUserTreeView",
                    "data": function (node) {
                        return {"nodeId": node.id,roleId:nodeId};
                    }
                }
            },
            plugins: ['types','search'],
            types:{
                "1":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/com.png"},
                "2":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/dept.png"},
                "3":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/station.png"},
                "9":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/empl.png"},
                "USER":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/user.png"},
                "isRoot":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/root.png"}
            },
            search: RoleManage.searchUser(),
            checkbox: {
                keep_selected_style : false,//是否默认选中
                three_state : true,//是否父子级别关联
                tie_selection : false
            }
        });
    };

    /**
     *  角色关联用户树查询
     */
    RoleManage.searchUser = function () {
        var to = false;
        $("#searchUser").keyup(function () {
            if (to) { clearTimeout(to); }
            to = setTimeout(function () {
                var v = $("#searchUser").val();
                var temp = $("#userTree").is(":hidden");
                if (temp == true) {
                    $("#userTree").show();
                }
                $("#userTree").jstree(true).search(v);
                //添加索引
                if(v!=''){
                    //定位到符合查询结果的树节点上
                    var searchResult = $("#userTree").jstree('search', v);
                    $(searchResult).find('.jstree-search').focus();
                }else {
                    $(".search-results1").html("");
                }
            }, 250);
        });
    };

    /**
     * 加载资源树
     */
    RoleManage.initResTree = function (roles) {
        var $retree = $("#resourceTree");//资源树
        $retree.jstree({
            core: {
                check_callback: true,
                data: function (obj, callback) {
                    var data;
                    var resource = [];
                    for(var i=0; i<roles.length; i++){
                        resource.push(roles[i].resourceId);
                    }
                    var ajax = new $ax(Hussar.ctxPath + "/resource/editResTree",function(result) {
                        data = result;
                    }, function(data) {
                        Hussar.error(LOAD_RESOURCES_TREE_FAIL);
                    });
                    ajax.set("rsourceIds",resource.join(','));
                    ajax.start();
                    callback.call(this, data);
                }
            },
            plugins: ['checkbox','search','types'],
            types:{
                "isModule":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/module.png"} ,
                "isFun":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/function.png"} ,
                "1":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/resource_menu.png"}, //菜单资源
                "2":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/resource_btn.png"},  //按钮资源
            },
            checkbox: {
                keep_selected_style : false,
                three_state : true,
                tie_selection : false
            },
            search : RoleManage.searchResource()
        });

    };

    /**
     * 资源树查询
     */
    RoleManage.searchResource = function () {
        var to = false;
        $("#searchResource").keyup(function () {
            if (to) { clearTimeout(to); }
            to = setTimeout(function () {
                var v = $("#searchResource").val();
                var temp = $("#resourceTree").is(":hidden");
                if (temp == true) {
                    $("#resourceTree").show();
                }
                $("#resourceTree").jstree(true).search(v);
                //添加索引
                if(v!=''){
                    //定位到符合查询结果的树节点上
                    var searchResult = $("#resourceTree").jstree('search', v);
                    $(searchResult).find('.jstree-search').focus();
                }else {
                    $(".search-results1").html("");
                }
            }, 250);
        });
    };

    RoleManage.initTable = function(){
        var nodeId=$("#nodeId").val();
        var ajax = new $ax(Hussar.ctxPath + "/roleManager/roleView",function(result) {
            if(result[2].length!=0){
                $("#roleMsg1").css("display","block");
                $("#groupMsg").css("display","none");
            }else{
                $("#roleMsg1").css("display","none");
                $("#groupMsg").css("display","block");
            }
            form.render();
            $('#resourceTree').jstree("destroy");
            RoleManage.initResTree(result[1]);
        },function(data) {
            Hussar.error(LOAD_ROLE_INFO_FAIL);
        });
        ajax.set("id",nodeId)
        ajax.start();
    }

    /**
     * 获取选中资源id
     */
    RoleManage.getCheckedId = function () {
        var ref = $("#resourceTree").jstree(true);
        var nodes = ref.get_checked(true);  //使用get_checked方法
        var nds ='';
        $.each(nodes, function(i, nd) {
            var type=nd.original.isRes;
            if(type==1){
                nds +=","+nd.id;
            }
        });
            $("#nds").val("");//选择之前重置nds
            $("#nds").val(nds.substring(1));
    }


    /**
     * 初始化按钮事件
     */
    RoleManage.initButtonEvent = function () {
        form.on('submit(verify)', function (data) {
            var data = $("#nodeId").val();//选中角色树的节点
            var roleName = $("#roleName").val();//角色名称
            var roleYw = $("#roleYw").val();//角色业务含义
            var ajax = new $ax(Hussar.ctxPath + "/roleManager/editRole", function (obj) {
                if (obj.code == "200") {
                    Hussar.success(obj.message);
                    $("#saveRole").css("display", "none");
                    $("#reset").css("display", "none");
                    $("#resourceMsg").click();
                } else {
                    Hussar.error(obj.message);
                }
            }, function () {
                Hussar.error(SAVE_FAIL);
            });
            ajax.set("roleId", data);
            ajax.set("roleName", roleName);
            ajax.set("roleAlias", roleYw);
            ajax.start();
        });

        /**
         * 保存选择资源
         */
        $("#saveResource").click(function () {
            RoleManage.getCheckedId();
            var ids = $("#nds").val();//选中资源树的节点
            var ajax = new $ax(Hussar.ctxPath + "/roleManager/saveResource", function (data) {
                Hussar.success(data.message);
                $("#userMsg").click();
            }, function (data) {
                Hussar.error(SAVE_FAIL);
            });
            ajax.set("ids", ids);
            ajax.set("roId", $("#nodeId").val());
            ajax.start();
        });

        /**
         * 初始化左侧的懒加载的组织机构树
         */
        RoleManage.initLeftUserTree = function () {
            $userTree = $("#leftOrgTree");
            $userTree.jstree({
                core: {
                    check_callback: true,
                    data: {
                        "url": Hussar.ctxPath + "/orgMain/orgTree",
                        "data": function (node) {
                            return {
                                "parentId": node.id,
                                "isEmployee": ""
                            };
                        }
                    }
                },
                plugins: ['types'],
                types: {
                    "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/com.png"},
                    "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/dept.png"},
                    "3": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/station.png"},
                    "9": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/empl.png"}
                }
                // search: UserMgr.search()
            });

            // 节点单击事件
            $userTree.bind("activate_node.jstree", function (obj, e) {
                // 记录下当前节点的id
                RoleManage.orgNode = e.node.original.id;
                // 刷新列表
                table.reload("checkedTable",{
                    where:{
                        roleId: $("#nodeId").val(),
                        orgId: RoleManage.orgNode
                    },
                    page: {
                        curr: 1
                    }
                })
            });
        };

        /**
         * 初始化右侧表格
         */
        RoleManage.initRightTable = function () {
            // 修改的角色id
            var roleId = $("#nodeId").val();
            // 当前组织机构节点的id
            var orgId = RoleManage.orgNode;

            // 渲染表格，以复选框标识当前部门下，用户是否拥有该角色
            // 数据表格根据字段值默认选中checkbox
            table =  $.extend(table, {config: {checkName: 'hasRole'}});
            table.render({
                 elem: '#checkedTable'
                ,url: Hussar.ctxPath + "/roleManager/getRoleOrgUser"
                ,where:{
                     roleId:roleId,
                     orgId:orgId
                }
                ,page: true
                ,limit: 10
                , cols: [[ //表头
                    {type: 'checkbox'},
                    {title: '序号', type: 'numbers'},
                    {title: '用户名', field: 'text',align:'center'},
                    {title: '用户登录账号', field: 'account',align:'center'},
                    {title: '主键', field: 'id',hide:true}
                ]]
                , even: true
                , height: $("#userTrans").height() - $(".layui-form").outerHeight(true)
            });
        };

        /**
         * 修改关联用户
         */
        $("#saveUser").click(function () {
            // 初始化展示左边树
            RoleManage.initLeftUserTree();
            // 初始化右边的表格
            RoleManage.initRightTable();

            layer.open({
                type: 1,
                title: '修改角色关联用户',
                area: ['90%', '90%'], //宽高
                fix: false, //不固定
                maxmin: false,
                closeBtn: 1,
                content: $("#userTrans"),
                end:function () {
                    // 刷新树
                    var $userTree = $("#userTree");//用户树
                    $userTree.jstree(true).refresh();
                }
            });
        });

        /**
         * 查询按钮
         */
        $("#queryTable").click(function () {
            // 修改的角色id
            var roleId = $("#nodeId").val();
            // 当前组织机构节点的id
            var orgId = RoleManage.orgNode;
            var name = $("#name").val();
            var account = $("#account").val();
            table.reload("checkedTable",{
                where:{
                    roleId: roleId,
                    orgId: orgId,
                    name: name,
                    account: account
                },
                page:{
                    curr: 1
                }
            })
        });

        /**
         * 重置按钮
         */
        $("#resetTable").click(function () {
            // 修改的角色id
            var roleId = $("#nodeId").val();
            // 当前组织机构节点的id
            var orgId = RoleManage.orgNode;
            $("#name").val("");
            $("#account").val("");
            table.reload("checkedTable",{
                where:{
                    roleId: roleId,
                    orgId: orgId,
                    name: "",
                    account: ""
                },
                page:{
                    curr:1
                }
            })
        });

        /**
         * 提交按钮
         */
        $("#commitTable").click(function () {
            // 表格缓存的数据
            var tableCache = layui.table.cache.checkedTable;
            // 处理数据
            var addList = [];
            var delList = [];
            if (tableCache.length > 0) {
                for (var i = 0;i < tableCache.length;i ++) {
                    var cacheObj = tableCache[i];
                    if (cacheObj.hasRole) {
                        addList.push(cacheObj);
                    } else {
                        delList.push(cacheObj)
                    }
                }
                if (addList.length > 0 || delList.length > 0) {
                    var ajax = new $ax(Hussar.ctxPath + "/roleManager/addOrDelUserRole",function(data) {
                        if (data.code === 200) {
                            Hussar.success(data.message)
                        } else {
                            Hussar.error("提交失败:" + data.message)
                        }
                        // 刷新表格
                        // 修改的角色id
                        var roleId = $("#nodeId").val();
                        // 当前组织机构节点的id
                        var orgId = RoleManage.orgNode;
                        var name = $("#name").val();
                        var account = $("#account").val();
                        table.reload("checkedTable",{
                            where:{
                                roleId: roleId,
                                orgId: orgId,
                                name: name,
                                account: account
                            }
                        })
                    },function(err) {
                        Hussar.error("提交失败")
                    });
                    ajax.set("adds",JSON.stringify(addList));
                    ajax.set("dels",JSON.stringify(delList));
                    ajax.set("roleId",$("#nodeId").val());
                    ajax.start();
                } else {
                    Hussar.info("请修改数据后进行提交操作！")
                }
            }  else {
                Hussar.info("请修改数据后进行提交操作！")
            }
        })
    };

    /**
     * 初始化数据
     */
    RoleManage.initData = function () {
        RoleManage.orgNode = null;
    };

    /**
     * 验证表单
     */
    RoleManage.validator = function() {
        //自定义校验
        form.verify({
            required : function(value, item){
                if(value.trim()==""){
                    return '必填项不能为空！';
                }
            },
            roleName : function(value, item){
                if(!new RegExp("^[a-zA-Z0-9_\u4e00-\u9fa5\\s·]+$").test(value)){
                    return '输入项不能有特殊字符！';
                }
            },
            sameRoleName : function(value, item){
                var oldRoleName=$("#oldRoleName").val().trim();
                if(oldRoleName!=value){
                    var msg="";
                    var ajax = new $ax(Hussar.ctxPath + "/roleManager/sameRoleName", function(data) {
                        if(data.length!=0){
                            msg= '角色名称已存在！';
                        }
                    }, function(data) {
                        Hussar.error(SELECT_ROLE_NAME_ISHAVE_FAIL);
                    });
                    ajax.set("sameRoleName",value);
                    ajax.start();
                    return msg;
                }
            }
        })
    };

    RoleManage.initFrameHeight=function(){
        var h3 = $(window).height()-181;
        $("#contentInfo").css("height", h3 + "px");
    };
    /**
     * 初始化
     */
    $(function() {
        // 初始化数据
        RoleManage.initData();
        RoleManage.initPage();
        $(window).resize(function() {
            RoleManage.initFrameHeight();
        });
    });
});