/**
 * @Description: 接口管理脚本文件
 * @Author: chenxin
 * @Date: 2018/3/7.
 */

/**
 * 用户角色初始化
 */
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','form'], function(){
	
var Hussar = layui.Hussar;
var $ = layui.jquery;
var layer=layui.layer;
var $ax=layui.HussarAjax;
var form=layui.form;
var table1;
var layerView;

var InterfaceManager = {
	seItem : null
};

/**
 * 页面初始化
 */
InterfaceManager.initPage = function () {
	this.initTable();
	this.initButton();
}

/**
 * 加载列表
 */
InterfaceManager.initTable = function() {
	layui.use('table', function() {
		var table = layui.table;
        var userName = $('#userName').val();
		table.render({
			elem : '#interfaceTable',
			url : Hussar.ctxPath+'/interfaceManager/list',
			cols : [ [
			          {type: 'checkbox',width:40} ,
			          {title : '序号', type : 'numbers', align : 'center',width:50},
			          {title : '接口用户名称', field: 'userName', align : 'center',event : 'interEvents',style:'cursor: pointer;color:#00a4ff'},
			          {title : '应用系统名称', field: 'sysName', align : 'center'},
			          {title : '应用系统地址', field: 'sysUrl', align : 'center'},
			          {title : '锁定状态', field: 'isLock', align : 'center', templet : evts}
			          ] ],
			page : true,
			even: true,
			id : 'interfaceTable',
            height:$("body").height() - $(".layui-form").outerHeight(true)-30,
            where : {
                name : userName
            }
		});
		
		// 监听单元格事件
		table.on('tool(interfaceTable)', function(obj) {
			var data = obj.data;
			if (obj.event == 'interEvents') {
				layerWindow=layer.open({
					type : 1,
					area : [ '70%', '75%' ],
					//shift : 1,
					shadeClose: false,
					title : '接口用户详情',
					maxmin : true,
					content : $("#interDetail"),
					success : function() {
						var timestamp=new Date().getTime();
						if(data.tokenEndTime!=null||data.tokenEndTime!=""){
							var tokenEndTime =new Date(data.tokenEndTime).getTime();
						}
						if(data.tokenEndTime!=null||data.tokenEndTime!=""){
							var tokenEndTime =new Date(data.tokenEndTime).getTime();
						}
						if(data.isLock=='0'){
							data.isLock='打开';
						}
						if(data.isLock=='1'){
							data.isLock='锁定';
						}
						if(data.tokenEndTime==""||data.tokenEndTime==null){
							data.tokenStatus='未生成';
						}
						if(timestamp<=tokenEndTime){
							data.tokenStatus='生效';
						}
						if(timestamp>tokenEndTime){
							data.tokenStatus='失效';
						}
						$("#userNameView").html(data.userName);$("#sysNameView").html(data.sysName);
						$("#sysUrlView").html(data.sysUrl);$("#isLockView").html(data.isLock);
						$("#tokenStartTimeView").html(data.tokenStartTime);$("#tokenStatusView").html(data.tokenStatus);
						$("#tokenEndTimeView").html(data.tokenEndTime);$("#connectNumView").html(data.connectNum);
						$("#lastTimeView").html(data.lastTime);$("#tokenValue").html(data.tokenValue);
						form.render();
					}
				});
			}
		});
		
		
		//状态formmate
		function url(d) {
			return '<a class="layui-table-link" target="_blank" href='+d.sysUrl+'>'+d.sysUrl+'</a>';
		};
		
		function evts(d) {
			if(d.isLock==1){
				return '<span style="color:red">锁定</span>';
			}
			if(d.isLock==0){
				return '<span style="color:green">打开</span>';
			}
		};
		table1 = table;
	});
};

/**
 * 选中一条结果
 */
InterfaceManager.check = function() {
	var checkStatus = table1.checkStatus('interfaceTable'), data = checkStatus.data;
	if (data.length == 0 || data.length > 1) {
        Hussar.info(PLEASE_CHOOSE_ONE);
		return false;
	} else {
		InterfaceManager.seItem = data[0];
		return true;
	}
};

/**
 * 选中多条结果
 */
InterfaceManager.checks = function() {
	var checkStatus = table1.checkStatus('interfaceTable'), data = checkStatus.data;
	var ids = [];
	if (data.length == 0) {
		Hussar.info(PLEASE_SELECT_AT_LEAST_ONE);
		return false;
	} else {
		for (var i = 0, l = data.length; i < l; i++) {
			var r = data[i];
			ids.push(r.userId);
		}
		var eId = ids.join(',');
		InterfaceManager.seItem = eId;
		return true;
	}
};

/**
 * 按钮操作
 */
InterfaceManager.initButton = function () {
	
	/**
	 * 查询
	 */
	$('#search').on('click', function() {
		var userName = $('#userName');
		// 执行重载
		table1.reload('interfaceTable', {
			page : {
				curr : 1
			// 重新从第 1 页开始
			},
			where : {
				name : userName.val()
			}
		});
	});
	
	/**
	 * 新增
	 */
	$("#add").click(function(){
		$("#status").val("add");
		layerView=layer.open({
			type : 1,
			area : [ '400px', '260px' ],
			//shift : 6,
			shadeClose : false,
			maxmin : false,
			title : '接口新增',
			content : $("#viewEvent"),
			success : function() {
				$('#addForm')[0].reset();
				form.render();
			}
		});
	});
	
	/**
	 * 修改
	 */
	$("#edit").click(function(){
		if (InterfaceManager.check()) {
			$("#status").val("edit");
			$("#oldName").val(InterfaceManager.seItem.userName);
			$("#userId").val(InterfaceManager.seItem.userId);
			layerView=layer.open({
				type : 1,
				area : [ '400px', '260px' ],
				//shift : 6,
				shadeClose : false,
				maxmin : false,
				title : '接口修改',
				content : $("#viewEvent"),
				success : function() {
					var ajax = new $ax(Hussar.ctxPath + "/interfaceManager/selectInUser", function(data) {
						$("[name=userName]").val(data.userName);
						$("[name=sysName]").val(data.sysName);
						$("[name=sysUrl]").val(data.sysUrl);
						var isSys = $("input[name='isLock']");
	        			for(var i=0; i<isSys.length; i++){
	        				if(isSys[i].value == data.isLock){
	        					isSys[i].checked = true;
	        				}
	        			}
						form.render();
        		    }, function(data) {
        		        Hussar.error(SELECT_INTERFACE_USER_INFO_FAIL);
        		    });
        		    ajax.set("userId",InterfaceManager.seItem.userId);
        		    ajax.start();
				}
			});
		}
	});
	
	/**
	 * 删除
	 */
	$("#del").click(function() {
		if (InterfaceManager.checks()) {
			var operation =function(){
				var ajax = new $ax(Hussar.ctxPath + "/interfaceManager/delByIds",
					function(data) {
						if (data.code == 200){
							$(".layui-laypage-btn").click();
							Hussar.success(data.message);
						}else {
							Hussar.error(data.message);
						}

					}, function(data) {
						Hussar.error(DELETE_FAIL);
				});
				ajax.set("id", InterfaceManager.seItem);
				ajax.start();
			};
			Hussar.confirm(DELETE_SURE, operation);
		}
	});
	
	/**
	 * 保存
	 */
	$("#btnSave").click(function(){
		form.on('submit(verify)', function(data){
		    // 提交信息
			var type=$("#status").val();
			var url;
			if(type=="add"){
				url="/interfaceManager/add";
			}else{
				url="/interfaceManager/edit";
			}
		    var ajax = new $ax(Hussar.ctxPath + url, function(data) {
		        if (data.code == "200") {
		            Hussar.success(data.message);
		            layer.close(layerView);
		            $('#search').click();
		            $('#searchForm')[0].reset();
		            $('#addForm')[0].reset();
		        } else if (data.code = "500") {
		            Hussar.error(data.message);
		        } else {
		            Hussar.error(data.message);
		        }
		    }, function(data) {
		        Hussar.error(SAVE_FAIL);
		    });
		    ajax.setData(data.field);
		    ajax.start();
		});
	});
	
	/**
	 * 关闭
	 */
	$("#btnClose").click(function(){
		layer.close(layerView);
	})

}


/**
 * 初始化
 */
$(function() {
	InterfaceManager.initPage();
});

});