/**
 * @Description: 用户管理脚本文件
 * @Author: liangdong
 * @Date: 2018/2/27.
 */
layui.use(['jquery', 'layer', 'Hussar', 'jstree', 'HussarAjax', 'element', 'form', 'laydate'], function () {
    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var layer = layui.layer;
    var laydate = layui.laydate;
    var $ax = layui.HussarAjax;
    var form = layui.form;
    var element = layui.element;
    var layerView;

    var UserMgr = {
        userTree: $("#userTree"),//用户树
        roleTree: $("#roleTree"),//角色树
        orgTree: $("#orgTree"),//组织机构树
        orderTree: $("#orderTree"),//排序树
        copyRoleTree: $("#copyRoleTree"),//复制角色树
        chooseStaffTree: $("#chooseStaffTree"),//职工选择树
        itemTemplate: $("#itemTemplate").html(),
        delIdString: [],
        mutiString: "",		//拼接字符串内容(拼接字典条目)
        addORedit: '',
        layerIndex: -1,
        selectId: null,	//选中的节点id

        public_role: 'public_role',	//公用角色的id
        sys_role_group: 'sys_role_group'	//系统角色分组id
    };

    /**
     * 初始化用户树
     */
    UserMgr.initUserTree = function () {
        $userTree = UserMgr.userTree;//用户树
        $userTree.jstree({
            core: {
                check_callback: true,
                data: {
                    "url": Hussar.ctxPath + "/user/userTree",
                    "data": function (node) {
                        return {"parentId": node.id};
                    }
                }
            },
            contextmenu: {
                select_node: false,
                show_at_node: true,
                'items': UserMgr.contextmenu
            },
            plugins: ['contextmenu', 'types', 'search'],
            types: {
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/com.png"},
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/dept.png"},
                "3": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/station.png"},
                "9": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/empl.png"},
                "USER": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/user.png"},
                "isRoot": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/root.png"}
            },
            search: UserMgr.search()
        });

        $userTree.bind("activate_node.jstree", function (obj, e) {
            var node = e.node;
            if (node.original.code == 'USER') {
                $("#sData").hide();
                $("#eData").hide();
                UserMgr.detailView(node.id);	//显示用户详情
            } else {
                $('#addEvent').addClass('hide');
            }
        });
    };

    /**
     * 用户树节点右键菜单
     */
    UserMgr.contextmenu = function (node) {
        //不同节点菜单不一样
        var items = {
            'item1': {
                'label': '新增用户',
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5011.png",
                'action': function () {
                    UserMgr.addUser(node);	//新增用户
                }
            },
            'item3': {
                'label': '修改',
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/53.png",
                'action': function () {
                    UserMgr.selectId = node.id;
                    UserMgr.editUser(node.id);	//修改用户
                }
            },
            'item5': {
                'label': '转移',
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5411.png",
                'action': function () {
                    UserMgr.changeOrgEvent(node);	//用户机构转移
                }
            },
            'item6': {
                'label': '用户排序',
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5111.png",
                'action': function () {
                    UserMgr.userOrderEvent(node.id);	//用户排序操作
                }
            },
            'item7': {
                'label': '复制角色',
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5211.png",
                'action': function () {
                    UserMgr.copyRoleEvent(node);
                }
            },
            'item4': {
                'label': '删除',
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/57.png",
                'action': function () {
                    UserMgr.delUser(node);	//用户删除
                }
            },
            'item8': {
                'label': '注销',
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/66.png",
                'action': function () {
                    UserMgr.cancelUser(node);	//用户注销
                }
            },

        }
        if (node != undefined) {
            //权限判断
            var shiroAdd = $("#shiroAdd").val();
            var shiroEdit = $("#shiroEdit").val();
            var shiroDel = $("#shiroDel").val();
            var shiroChgOrg = $("#shiroChgOrg").val();
            var shiroCopyRole = $("#shiroCopyRole").val();
            var shiroOrder = $("#shiroOrder").val();

            if (node.parent == '#') {	//根节点没有右键菜单
                delete items.item3;
                delete items.item4;
                delete items.item5;
                delete items.item7;
                delete items.item1;
                delete items.item6;
                delete items.item8;
            } else if (node.original.code != 'USER') {	//组织机构
                delete items.item3;
                delete items.item4;
                delete items.item5;
                delete items.item7;
                delete items.item8;
                if (shiroAdd != "hasPermission") {
                    delete items.item1;
                }
                if (shiroOrder != "hasPermission") {
                    delete items.item6;
                }
            } else {	//用户
                if (node.original.parent == '11') {
                    //系统用户不允许任何操作
                    delete items.item3;
                    delete items.item4;
                    delete items.item5;
                    delete items.item7;
                    delete items.item1;
                    delete items.item6;
                    delete items.item8;
                }
                delete items.item1;
                delete items.item6;
                if (shiroEdit != "hasPermission") {
                    delete items.item3;
                }
                if (shiroDel != "hasPermission") {
                    delete items.item4;
                }
                if (shiroChgOrg != "hasPermission") {
                    delete items.item5;
                }
                if (shiroCopyRole != "hasPermission") {
                    delete items.item7;
                }
                // 注销用户没有按钮
                if (node.original.accountStatus == '4') {
                    delete items.item3;
                    delete items.item4;
                    delete items.item5;
                    delete items.item7;
                    delete items.item1;
                    delete items.item6;
                    delete items.item8;
                }
            }
            return items;
        }

    }

    /**
     * 加载角色树
     */
    UserMgr.initroleTree = function (roles) {
        //显示详情时不显示复选框
        var plugins = [];
        if (UserMgr.addORedit == 'view') {
            plugins = ['search', 'types'];
        } else {
            plugins = ['checkbox', 'search', 'types'];
        }

        $roleTree = UserMgr.roleTree;//角色树
        $roleTree.jstree({
            core: {
                check_callback: true,
                data: function (obj, callback) {
                    var data;
                    var ajax = new $ax(Hussar.ctxPath + "/roleManager/roleTree",
                        function (result) {
                            if (UserMgr.addORedit == 'add') {
                                var arrays = [];
                                for (var i = 0; i < result.length; i++) {
                                    var arr = {
                                        id: result[i].id,
                                        parent: result[i].parent,
                                        text: result[i].text,
                                        code: result[i].code,
                                        type: result[i].type,
                                        state: {selected: false, checked: false, disabled: false}
                                    }
                                    //公用角色默认勾选且不可编辑
                                    if (UserMgr.public_role == result[i].id) {
                                        arr.state.checked = true;
                                        arr.state.selected = true;
                                        arr.state.disabled = true;
                                    }
                                    //系统管理员角色不可勾选
                                    if (UserMgr.sys_role_group == result[i].parent) {
                                        arr.state.disabled = true;
                                    }
                                    arrays.push(arr);
                                }
                                data = arrays;
                            } else if (UserMgr.addORedit == 'edit') {
                                var arrays = [];
                                for (var i = 0; i < result.length; i++) {
                                    var arr = {
                                        id: result[i].id,
                                        parent: result[i].parent,
                                        text: result[i].text,
                                        code: result[i].code,
                                        type: result[i].type,
                                        state: {selected: false, checked: false, disabled: false}
                                    }
                                    //公用角色默认勾选且不可编辑
                                    if (UserMgr.public_role == result[i].id) {
                                        arr.state.checked = true;
                                        arr.state.selected = true;
                                        arr.state.disabled = true;
                                    }
                                    //系统管理员角色不可勾选
                                    if (UserMgr.sys_role_group == result[i].parent) {
                                        arr.state.disabled = true;
                                    }
                                    for (var j = 0; j < roles.length; j++) {
                                        if (roles[j] == result[i].id) {
                                            arr.state.checked = true;
                                            arr.state.selected = true;
                                            break;
                                        }
                                    }
                                    arrays.push(arr);
                                }
                                data = arrays;
                            } else if (UserMgr.addORedit == 'view') {
                                var arrays = [];
                                var ajax = new $ax(Hussar.ctxPath + "/roleManager/selfRoleTree", function (result) {
                                    for (var i = 0; i < result.length; i++) {
                                        var arr = {
                                            id: result[i].id,
                                            parent: result[i].parent,
                                            text: result[i].text,
                                            code: result[i].code,
                                            type: result[i].type,
                                            state: {selected: false, checked: false, disabled: true}
                                        }

                                        for (var j = 0; j < roles.length; j++) {
                                            if (roles[j] == result[i].id) {
                                                arr.state.checked = true;
                                                arr.state.selected = true;
                                                break;
                                            }
                                        }
                                        arrays.push(arr);
                                    }

                                }, function (data) {
                                    Hussar.error(LOAD_ROLE_TREE_FAIL);
                                });
                                ajax.set("roleIds", roles.join(','));
                                ajax.start();

                                data = arrays;
                            }
                        }, function (data) {
                            Hussar.error(LOAD_ROLE_TREE_FAIL);
                        });
                    ajax.start();
                    callback.call(this, data);
                }
            },
            plugins: plugins,
            checkbox: {
                keep_selected_style: false,//是否默认选中
                three_state: true,//是否父子级别关联
                tie_selection: false
            },
            types: {
                "GROUP": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/roleGroup.png"},
                "ROLE": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/role.png"},
                "isRoot": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/root.png"}
            },
            search: UserMgr.search()
        });
    }

    /**
     * 加载 组织机构树（变更所属部门）
     */
    UserMgr.initOrgTree = function () {
        $orgTree = UserMgr.orgTree;//组织机构树
        $orgTree.jstree({
            core: {
                check_callback: true,
                data: {
                    "url": Hussar.ctxPath + "/orgMain/orgTree",
                    "data": function (node) {
                        return {"parentId": node.id};
                    }
                }
            },
            plugins: ['checkbox', 'search', 'types'],
            checkbox: {
                keep_selected_style: false,//是否默认选中
                three_state: false,//是否父子级别关联
                tie_selection: false
            },
            types: {
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/com.png"},
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/dept.png"},
                "3": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/station.png"},
                "9": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/empl.png"},
                "isRoot": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/root.png"}
            },
            search: UserMgr.search()
        });
        $orgTree.on('check_node.jstree', function (event, obj) {
            var currentNode = obj.node;
            var ref = $orgTree.jstree(true);
            var checkedNodes = ref.get_checked(); //使用get_checked方法
            var otherNode;

            //判断是否勾选的是和原来相同的所属机构
            if (UserMgr.selectId == currentNode.id) {
                ref.uncheck_node(currentNode.id);
                Hussar.info("变更机构不能和原所属机构相同！");
                return;
            }

            //根节点不能勾选
            if (currentNode.parent == '#') {
                ref.uncheck_node(currentNode.id);
                return;
            }

            //限制只能选一个
            if (checkedNodes.length > 1) {
                $.each(checkedNodes, function (i, nd) {
                    if (nd != currentNode.id) {
                        otherNode = nd;
                    }
                })
                ref.uncheck_node(otherNode);
            }
        });
    }

    /**
     * 初始化职工选择树
     */
    UserMgr.initChooseStaffTree = function () {
        var orgId = $('#corporationId').val();
        $chooseStaffTree = UserMgr.chooseStaffTree;		//职工选择树
        $chooseStaffTree.jstree({
            core: {
                check_callback: true,
                data: function (obj, callback) {
                    var data;
                    var ajax = new $ax(Hussar.ctxPath + "/employee/employeeTreeById",
                        function (result) {
                            data = result;
                        },
                        function (data) {
                            Hussar.error("加载职工选择树失败!");
                        });
                    ajax.set("orgId", orgId);
                    ajax.start();
                    callback.call(this, data);
                }

            },
            plugins: ['checkbox', 'types'],
            types: {
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/com.png"},
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/dept.png"},
                "3": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/station.png"},
                "9": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/empl.png"},
                "isRoot": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/root.png"}
            },
            checkbox: {
                keep_selected_style: false,//是否默认选中
                three_state: false,//是否父子级别关联
                tie_selection: false
            },

        });
        $chooseStaffTree.on('check_node.jstree', function (event, obj) {
            var currentNode = obj.node;
            var ref = $chooseStaffTree.jstree(true);
            var checkedNodes = ref.get_checked(); //使用get_checked方法
            var otherNode;

            //判断选择的是否是职工，否则不能勾选
            if (currentNode.original.type != '9') {
                ref.uncheck_node(currentNode.id);
                return;
            }

            //限制只能选一个
            if (checkedNodes.length > 1) {
                $.each(checkedNodes, function (i, nd) {
                    if (nd != currentNode.id) {
                        otherNode = nd;
                    }
                });
                ref.uncheck_node(otherNode);
            }
        });
    };

    /**
     * 初始化复制角色树
     */
    UserMgr.initCopyRoleTree = function () {
        $copyRoleTree = UserMgr.copyRoleTree;	//角色复制树
        $copyRoleTree.jstree({
            core: {
                check_callback: true,
                data: {
                    "url": Hussar.ctxPath + "/user/userTree",
                    "data": function (node) {
                        return {"parentId": node.id};
                    }
                }
            },
            plugins: ['checkbox', 'search', 'types'],
            checkbox: {
                keep_selected_style: false,//是否默认选中
                three_state: false,//是否父子级别关联
                tie_selection: false
            },
            types: {
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/com.png"},
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/dept.png"},
                "3": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/station.png"},
                "9": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/empl.png"},
                "USER": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/user.png"},
                "isRoot": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/root.png"}
            },
            search: UserMgr.search()
        });
        $copyRoleTree.on('check_node.jstree', function (event, obj) {
            var currentNode = obj.node;
            var ref = $copyRoleTree.jstree(true);
            var checkedNodes = ref.get_checked(); //使用get_checked方法
            var otherNode;
            if (currentNode.original.code == 'USER' && currentNode.original.parent == '11') {
                ref.uncheck_node(currentNode.id);
                Hussar.info("不能将角色复制到系统用户上");//角色不可复制到系统级用户上
                return;
            }

            //判断选择的是否是用户，否则不能勾选
            if (currentNode.original.code != 'USER') {
                ref.uncheck_node(currentNode.id);
                return;
            }
            //判断是否为相同用户节点，否则不能复制
            if (UserMgr.selectId == currentNode.id) {
                ref.uncheck_node(currentNode.id);
                Hussar.info("不能将角色复制到本用户上");
                return;
            }
        });
    };

    /**
     * 加载 排序树
     */
    UserMgr.initOrderTree = function (orgId) {
        $orderTree = UserMgr.orderTree;	//排序树
        $orderTree.jstree({
            core: {
                check_callback: function (operation, node, node_parent, node_position, more) {
                    if (operation == 'move_node') {
                        if (node.parent == node_parent.parent || node_parent.parent == null) {
                            return false;
                        } else {
                            return true;
                        }
                    } else {
                        return true;
                    }
                },
                data: function (obj, callback) {
                    var data;
                    var ajax = new $ax(Hussar.ctxPath + "/user/orderTree", function (result) {
                        data = result;
                        //返回值在页面显示
                        var newResult = [];
                        for (var i = 0; i < data.length; i++) {
                            if (data[i].parent != "#") {
                                newResult.push(data[i]);
                            }
                        }
                        $("#output").val(window.JSON.stringify(newResult));

                    }, function (data) {
                        Hussar.error("加载用户排序树失败!");
                    });
                    ajax.set("orgId", orgId);
                    ajax.start();
                    callback.call(this, data);
                }
            },
            plugins: ['state', 'types', "dnd", 'search'],
            types: {
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/com.png"},
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/dept.png"},
                "3": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/station.png"},
                "9": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/empl.png"},
                "USER": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/user.png"},
                "isRoot": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/root.png"}
            },
            search: UserMgr.search(),
            sort: function (a, b) {
                return this.get_node(a).original.struOrder > this.get_node(b).original.struOrder ? 1 : -1;
            }
        });

        //移动树事件
        $orderTree.bind('move_node.jstree', function (e, data) {
            //移动的组织ID
            var id = data.node.id;
            //移动之前的位置
            var oldPosition = data.old_position;
            //移动后的位置
            var position = data.position;
            //原地未动
            if (oldPosition == position) {
                return;
            }
            var oldResult = JSON.parse($("#output").val());
            //根据目前的位置对于树结果进行重新排序
            var newResult = [];
            //向上移动
            if (position - oldPosition < 0) {
                for (var i = 0; i < oldResult.length; i++) {
                    if (i < position) {
                        oldResult[i].struOrder = i + 1;
                    } else {
                        if (oldResult[i].id == id) {
                            oldResult[i].struOrder = position + 1;
                        } else {
                            if (i <= oldPosition) {
                                oldResult[i].struOrder = i + 2;
                            } else {
                                oldResult[i].struOrder = i + 1;
                            }
                        }
                    }
                }
            } else {//向下移动
                for (var i = 0; i < oldResult.length; i++) {
                    if (i < oldPosition) {
                        oldResult[i].struOrder = i + 1;
                    } else {
                        if (oldResult[i].id == id) {
                            oldResult[i].struOrder = position + 1;
                        } else {
                            if (i <= position) {
                                oldResult[i].struOrder = i;
                            } else {
                                oldResult[i].struOrder = i + 1;
                            }
                        }
                    }
                }
            }
            oldResult.sort(UserMgr.up);
            $("#output").val(window.JSON.stringify(oldResult));
        });
    };

    /**
     * 排序
     */
    UserMgr.up = function (x, y) {
        return x.struOrder - y.struOrder;
    };

    /**********************************************Some Operation Start***************************************************/
    //角色复制操作
    UserMgr.copyRoleEvent = function (node) {
        UserMgr.copyRoleTree.jstree("destroy");
        UserMgr.initCopyRoleTree();	//加载复制角色树
        UserMgr.layerIndex = layer.open({
            type: 1,
            btn: ['取消', '保存'],
            area: ['350px', '500px'],
            skin: 'confirm-class',
            fix: false, //不固定
            maxmin: false,
            shadeClose: false,
            shade: 0.4,
            title: "选择角色复制到的用户",
            content: $('#copyRole'),
            btn2: function (index, layero) {
                UserMgr.saveCopyRole();
                return false;
            },
            success: function () {
                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
                UserMgr.selectId = node.id;	//	获得要复制的用户id
            }
        });
    };

    //保存角色复制
    UserMgr.saveCopyRole = function () {
        var nodes = $copyRoleTree.jstree(true).get_checked();//获得要复制到的用户
        if (nodes.length == 0) {
            Hussar.info("请选择要复制到的用户！");
        } else {
            var data = {
                copyFrom: UserMgr.selectId,
                copyTo: nodes.join(",")
            };
            var saveCopyRole = function () {
                var ajax = new $ax(Hussar.ctxPath + "/user/copyRole", function (data) {
                    if (data.code == "200") {
                        Hussar.success("角色复制成功！");
                    } else if (data.code) {
                        Hussar.error(data.message);
                    } else {
                        Hussar.error("复制失败!");
                    }
                }, function (data) {
                    Hussar.error("复制失败!");
                });
                ajax.setData(data);
                ajax.start();
                layer.close(UserMgr.layerIndex);
            };
            Hussar.confirm("确定要将角色复制到选择的用户上吗?", saveCopyRole);
        }
    }

    //用户排序操作
    UserMgr.userOrderEvent = function (orgId) {
        UserMgr.orderTree.jstree("destroy");
        UserMgr.initOrderTree(orgId);	//加载排序树
        UserMgr.layerIndex = layer.open({
            type: 1,
            btn: ['取消', '保存'],
            skin: 'confirm-class',
            area: ['350px', '500px'],
            fix: false, //不固定
            maxmin: false,
            shadeClose: false,
            shade: 0.4,
            title: "下级用户排序",
            content: $('#userOrder'),
            btn2: function (index, layero) {
                UserMgr.saveUserOrder();
                return false;
            },
            success: function () {
                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
            }
        });
    };

    //保存用户排序
    UserMgr.saveUserOrder = function () {
        var saveTree = function () {
            var treeInfo = $("#output").val();	//排序信息
            var ajax = new $ax(Hussar.ctxPath + "/user/saveUserOrder", function (data) {
                if (data.code == "200") {
                    Hussar.success(data.message);
                    layer.close(UserMgr.layerIndex);
                    $("#userTree").jstree(true).refresh();//刷新用户树
                } else if (data.code) {
                    Hussar.error(data.message);
                } else {
                    Hussar.error(SAVE_FAIL);
                }
            }, function (data) {
                Hussar.error(SAVE_FAIL);
            });
            ajax.set("treeInfo", treeInfo);
            ajax.start();
        }
        Hussar.confirm(SAVE_SORT_SURE, saveTree);
    }

    //加载用户详情
    UserMgr.detailView = function (id) {
        $('#addEvent').addClass('hide');//先隐藏，数据加载完后再显示
        $('.must').addClass('hide');//隐藏必填标识
        UserMgr.addORedit = 'view';
        $("#opsType").html("用户信息");
        document.getElementById("userForm").reset();
        UserMgr.userTree.jstree("select_node", id);//选中节点
        $("#sDataView").hide();
        $("#eDataView").hide();
        $("#accessStartView").hide();
        $("#accessEndView").hide();
        $("#idLimitView").hide();
        //表单不可编辑，隐藏保存按钮
        $('#userForm input').attr('disabled', true);
        $('.con-full-l input').attr('disabled', false);
        $('#userForm select').attr('disabled', true);
        $('#btnDiv').addClass('hide');
        UserMgr.roleTree.jstree("destroy");

        var ajax = new $ax(Hussar.ctxPath + "/user/userInfo",
            function (result) {
                /*基本信息开始*/
                $(".layui-table-r").show();
                $(".addone").hide();
                var user = result[0];
                $('#corporationId').val(user.corporationId);
                $('#userAccountView').html(user.userAccount);
                $('#userNameView').html(user.userName);
//	    			$('#securityLevel').val(user.securityLevel);
                $('#maxSessionsView').html(user.maxSessions);
                $('#eMailView').html(user.eMail);
                $('#mobileView').html(user.mobile);
                $('#weChatView').html(user.weChat);
                $('#telephoneView').html(user.telephone);
                var imgUrl = Hussar.ctxPath + "/qrcode/getTotpKey?code=" + user.totpKey + "&userName=" + user.userName;
                if (user.totpKey != "") {
                    var html = " <img   class=\"q_code\" src='" + imgUrl + "' style=\"margin: 1%  2%\"/>"
                    document.getElementById("totpKeyView").innerHTML = html;
                } else {
                    document.getElementById("totpKeyView").innerHTML = "";
                }
                var isSys = $("input[name='isSysView']");
                for (var i = 0; i < isSys.length; i++) {
                    if (isSys[i].value == user.isSys) {
                        isSys[i].checked = true;
                    }
                }
                var state = $("input[name='accountStatusView']");
                for (var i = 0; i < state.length; i++) {
                    if (state[i].value == user.accountStatus) {
                        state[i].checked = true;
                    }
                }
                var type = $("input[name='typePropertyView']");
                for (var i = 0; i < type.length; i++) {
                    if (type[i].value == user.typeProperty) {
                        type[i].checked = true;
                    }
                }
                // 登陆时间限制
                var timeLimit = $("input[name='loginTimeLimitView']");
                for (var i = 0; i < type.length; i++) {
                    if (timeLimit[i].value == user.loginTimeLimit) {
                        timeLimit[i].checked = true;
                    }
                }
                // 登陆ip限制
                var ipLimit = $("input[name='loginIpLimitView']");
                for (var i = 0; i < type.length; i++) {
                    if (ipLimit[i].value == user.loginIpLimit) {
                        ipLimit[i].checked = true;
                    }
                }
                // 账号属性
                if ('0' == user.typeProperty) {
                    $("#sDataView").show();
                    $("#eDataView").show();
                    $('#startTimeView').html(user.startTime);
                    $('#expiredTimeView').html(user.expiredTime);
                }
                // 登录时间限制
                if ('1' == user.loginTimeLimit) {
                    $("#accessStartView").show();
                    $("#accessEndView").show();
                    $('#accessLoginStartTimeView').html(user.accessLoginStartTime);
                    $('#accessLoginEndTimeView').html(user.accessLoginEndTime);
                }
                //登录ip限制
                if ('1' == user.loginIpLimit) {
                    $("#idLimitView").show();
                    $('#accessLoginIpView').html(result[5]);
                }

                /*基本信息结束*/

                /*角色信息开始*/
                var grantRole = result[1];
                var roles = [];
                for (var i = 0; i < grantRole.length; i++) {
                    roles.push(grantRole[i].grantedRole);
                }
                UserMgr.initroleTree(roles);
                /*角色信息结束*/

                $('#baseInfo').click();//Tab标签回到一般信息
                $('#addEvent').removeClass('hide');//显示div
            },
            function (data) {
                Hussar.error(LOAD_USER_INFO_FAIL);
            });
        ajax.set("id", id);
        ajax.start();
        $('#addEvent').removeClass('hide');//显示新增(修改)div
    }


    //用户删除
    UserMgr.delUser = function (node) {
        var operation = function () {
            var ajax = new $ax(Hussar.ctxPath + "/user/delete",
                function (data) {
                    if (data.code == '200') {
                        Hussar.success(data.message);
                        $('#addEvent').addClass('hide');
                        $("#userTree").jstree(true).refresh();//刷新用户树
                    } else {
                        Hussar.error(data.message);
                    }
                },
                function (data) {
                    Hussar.error(DELETE_FAIL);
                });
            ajax.set("userId", node.id);
            ajax.start();

        }
        Hussar.confirm("确定要删除该用户吗?", operation);
    }

    //用户注销
    UserMgr.cancelUser = function (node) {
        var operation = function () {
            var ajax = new $ax(Hussar.ctxPath + "/user/cancelUser",
                function (data) {
                    if (data.code == '200') {
                        Hussar.success(data.message);
                        $('#addEvent').addClass('hide');
                        $("#userTree").jstree(true).refresh();//刷新用户树
                    } else {
                        Hussar.error(data.message);
                    }
                },
                function (data) {
                    Hussar.error("注销失败!");
                });
            ajax.set("userId", node.id);
            ajax.start();

        }
        Hussar.confirm("确定要注销该用户吗?", operation);
    }

    //用户修改
    UserMgr.editUser = function (userId) {
        $('#addEvent').addClass('hide');//先隐藏，数据加载完后再显示
        $('#addORedit').attr('value', 'edit');
        UserMgr.addORedit = 'edit';
        document.getElementById("userForm").reset();
        $("#opsType").html("用户修改");
        $(".addone").show();
        $(".layui-table-r").hide();
        //去掉不可编辑的状态
        $('#userForm input').attr('disabled', false);
        $('#userForm select').attr('disabled', false);
        $('#btnDiv').removeClass('hide');
        $('.must').removeClass('hide');//显示必填标识

        $('#baseInfo').click();//Tab标签回到一般信息
        UserMgr.roleTree.jstree("destroy");
        UserMgr.chooseStaffTree.jstree("destroy");
        UserMgr.initChooseStaffTree();	//初始化职工选择树
        var ajax = new $ax(Hussar.ctxPath + "/user/userInfo",
            function (result) {
                /*基本信息开始*/
                var user = result[0];
                $('#corporationId').val(user.corporationId);
                $('#userId').val(user.userId);
                $('#userAccount').val(user.userAccount);
                $("#userAccount").attr("readonly", true);//用户名不可修改
                $('#userName').val(user.userName);
//        			$('#securityLevel').val(user.securityLevel);
                $('#maxSessions').val(user.maxSessions);
                $('#employeeId').val(user.employeeId);
                $('#eMail').val(user.eMail);
                $('#mobile').val(user.mobile);
                $('#telephone').val(user.telephone);
                $('#weChat').val(user.weChat);
                $('#accessLoginIp').val(result[5]);
                var isSys = $("input[name='isSys']");
                for (var i = 0; i < isSys.length; i++) {
                    if (isSys[i].value == user.isSys) {
                        isSys[i].checked = true;
                    }
                }
                var state = $("input[name='accountStatus']");
                for (var i = 0; i < state.length; i++) {
                    if (state[i].value == user.accountStatus) {
                        state[i].checked = true;
                    }
                }
                var type = $("input[name='typeProperty']");
                for (var i = 0; i < type.length; i++) {
                    if (type[i].value == user.typeProperty) {
                        type[i].checked = true;
                    }
                }
                // 登陆时间限制
                var timeLimit = $("input[name='loginTimeLimit']");
                for (var i = 0; i < type.length; i++) {
                    if (timeLimit[i].value == user.loginTimeLimit) {
                        timeLimit[i].checked = true;
                    }
                }
                // 登陆ip限制
                var ipLimit = $("input[name='loginIpLimit']");
                for (var i = 0; i < type.length; i++) {
                    if (ipLimit[i].value == user.loginIpLimit) {
                        ipLimit[i].checked = true;
                    }
                }
                if ('0' == user.typeProperty) {
                    $("#sData").show();
                    $("#eData").show();
                    $('#startTime').val(user.startTime);
                    $('#expiredTime').val(user.expiredTime);
                    $('#startTime').attr('lay-verify', 'required');
                    $('#expiredTime').attr('lay-verify', 'required');
                } else {
                    $("#sData").hide();
                    $("#eData").hide();
                    $('#startTime').attr('lay-verify', '');
                    $('#expiredTime').attr('lay-verify', '');
                }
                if ('1' == user.loginTimeLimit) {
                    $("#accessStart").show();
                    $("#accessEnd").show();
                    $('#accessLoginStartTime').attr('lay-verify', 'required');
                    $('#accessLoginEndTime').attr('lay-verify', 'required');
                    $('#accessLoginStartTime').val(user.accessLoginStartTime);
                    $('#accessLoginEndTime').val(user.accessLoginEndTime);
                } else {
                    $("#accessStart").hide();
                    $("#accessEnd").hide();
                    $("input[id='accessLoginStartTime']").val("");
                    $("input[id='accessLoginEndTime']").val("");
                    $('#accessLoginStartTime').attr('lay-verify', '');
                    $('#accessLoginEndTime').attr('lay-verify', '');
                }
                if ('1' == user.loginIpLimit) {
                    $("#idLimit").show();
                    $('#accessLoginIp').attr('lay-verify', 'required');
                } else {
                    $("#idLimit").hide();
                    $("input[id='accessLoginIp']").val("");
                    $('#accessLoginIp').attr('lay-verify', '');
                    // 清空用户的ip
                    document.getElementById("itemsArea").innerHTML = "";
                }

                /*基本信息结束*/

                /*角色信息开始*/
                var grantRole = result[1];
                var roles = [];
                for (var i = 0; i < grantRole.length; i++) {
                    roles.push(grantRole[i].grantedRole);
                }
                UserMgr.initroleTree(roles);
                /*角色信息结束*/

                $('#addEvent').removeClass('hide');//显示div
            },
            function (data) {
                Hussar.error(LOAD_USER_INFO_FAIL);
            });
        ajax.set("id", userId);
        ajax.start();
        $('#addEvent').removeClass('hide');//显示新增(修改)div
    }

    //用户转移机构
    UserMgr.changeOrgEvent = function (node) {
        var parent = UserMgr.userTree.jstree("get_node", node.parent);//获取父节点
        UserMgr.selectId = parent.id;
        $('#userIdHidden').val(node.id);
        $('#corporationIdHidden').val(parent.id);
        $('#permitIdHidden').val(parent.original.PERMITID);
        UserMgr.orgTree.jstree("destroy");
        UserMgr.initOrgTree();
        UserMgr.layerIndex = layer.open({
            type: 1,
            btn: ['取消', '保存'],
            skin: 'confirm-class',
            title: '机构变更',
            area: ['350px', '500px'], //宽高
            fix: false, //不固定
            maxmin: false,
            shadeClose: false,
            content: $('#changeOrg'),
            btn2: function (index, layero) {
                UserMgr.saveChangeOrg();	//保存用户机构转移
                return false;
            },
            success: function () {
                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
            }

        });
    }

    //保存用户机构转移
    UserMgr.saveChangeOrg = function () {
        var ref = $("#orgTree").jstree(true);
        var nodeids = ref.get_checked();  //获取选中的节点对象id
        if (nodeids.length == 0) {
            Hussar.info('请选择要变更的机构！');
        } else if (nodeids.length > 1) {
            Hussar.info('只能选择一个要变更的机构！');
        } else if (nodeids[0] == $('#corporationIdView').val()) {
            Hussar.info('变更机构不能和原所属机构相同！');
        } else {
            $('#corporationIdHidden').val(nodeids[0]);

            var data = $("#changeOrgForm").serialize();
            // 提交信息
            var ajax = new $ax(Hussar.ctxPath + "/user/changeOrg", function (data) {
                if (data.code == "200") {
                    Hussar.success(data.message);
                    layer.close(UserMgr.layerIndex);
                    $("#userTree").jstree(true).refresh();//刷新用户树
                } else if (data.code) {
                    Hussar.error(data.message);
                } else {
                    Hussar.error("变更失败!");
                }
            }, function (data) {
                Hussar.error("变更失败!");
            });
            ajax.setData(data);
            ajax.start();
        }
    }

    //新增用户
    UserMgr.addUser = function (node) {
        $('#addORedit').attr('value', 'add');
        UserMgr.addORedit = 'add';//js中使用
        document.getElementById("userForm").reset();//重置表单
        $("#opsType").html("用户新增");
        $(".addone").show();
        $("#sData").hide();
        $("#eData").hide();
        $("#accessStart").hide();
        $("#accessEnd").hide();
        UserMgr.mutiString = ""
        $("#idLimit").hide();
        document.getElementById("itemsArea").innerHTML = "";
        $(".layui-table-r").hide();
        // 去掉必须验证的字段
        $('#accessLoginStartTime').attr('lay-verify', '');
        $('#accessLoginEndTime').attr('lay-verify', '');
        $('#startTime').attr('lay-verify', '');
        $('#expiredTime').attr('lay-verify', '');
        $('#accessLoginIp').attr('lay-verify', '');
        //去掉不可编辑的状态
        $("#userAccount").attr("readonly", false);
        $('#userForm input').attr('disabled', false);
        $('#userForm select').attr('disabled', false);
        $('#btnDiv').removeClass('hide');
        $('.must').removeClass('hide');//显示必填标识

        $('#baseInfo').click();//Tab标签回到一般信息
        $('#corporationId').val(node.id);//公司结构编码
        $('#permissionStruId').val(node.original.PERMITID);//所属权限组织编码
        UserMgr.roleTree.jstree("destroy");
        UserMgr.initroleTree(); //初始化角色树
        $('#addEvent').removeClass('hide');//显示新增(修改)div
    }

    //重置按钮操作
    UserMgr.resetEvent = function () {
        if (UserMgr.addORedit == 'add') {
            //因为form中有隐藏的元素，所以不能直接用form.reset
            $("input[id='userId']").val("");
            var isSys = $("input[name='isSys']");
            for (var i = 0; i < isSys.length; i++) {
                if (isSys[i].value == '0') {
                    isSys[i].checked = true;
                }
            }
            $("input[id='userName']").val("");
            $("input[id='maxSessions']").val("1");
            $("input[id='eMail']").val("");
            // $("input[id='qq']").val("");
            $("input[id='weChat']").val("");
            $("input[id='mobile']").val("");
            $("input[id='telephone']").val("");
            var accountStatus = $("input[name='accountStatus']");
            for (var i = 0; i < accountStatus.length; i++) {
                if (accountStatus[i].value == '1') {
                    accountStatus[i].checked = true;
                }
            }
            form.render();
        } else if (UserMgr.addORedit == 'edit') {
            UserMgr.editUser(UserMgr.selectId);
        }
    }

    //中文名称点击事件
    UserMgr.nameClickEvent = function () {
        var isSys = $("input[name='isSys']:checked").val();
        if (isSys == '1') {	//如果是系统管理员
            //中文名称手动输入，不需要关联人员
            $("input[id='userName']").attr("readonly", false);
        } else if (isSys == '0') {	//如果不是系统管理员
            //中文名称通过关联人员来获取
            $("input[id='userName']").attr("readonly", true);
            UserMgr.chooseStaffTree.jstree("destroy");
            UserMgr.initChooseStaffTree();	//初始化职工选择树
            layer.open({
                type: 1,
                btn: ['取消', '保存'],
                skin: 'confirm-class',
                title: '选择人员',
                area: ['350px', '500px'], //宽高
                fix: false, //不固定
                maxmin: false,
                shadeClose: false,
                content: $('#chooseStaffView'),
                btn2: function (index, layero) {
                    var nodes = $chooseStaffTree.jstree(true).get_checked(true);//获得选中的员工节点
                    if (nodes.length == 0) {
                        Hussar.info("请选择一个人员！");
                    } else if (nodes.length != 1) {
                        Hussar.info("只能选择一个人员！");
                    } else {
                        $("#employeeId").val(nodes[0].id);
                        $("input[id='userName']").val(nodes[0].text);
                        layer.close(index);
                    }
                    return false;
                },
                success: function () {
                    $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                    $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
                }
            });
        }
    }


    //限制IP点击事件
    UserMgr.limitIpClickEvent = function () {
        var userId = $("#userId").val();
        var accessLoginIp = $("#accessLoginIp").val();
        layerView = layer.open({
            type: 1,
            area: ['450px', '400px'],
            shadeClose: false,
            maxmin: false,
            title: '用户IP限制',
            content: $("#userIp"),
            success: function () {
                if (userId != "" && accessLoginIp != "") {
                    var html = "";
                    var obj = accessLoginIp.split(",")
                    for (var i = 0; i < obj.length; i++) {
                        html = html + "<div class=\"layui-form\" name=\"ipItem\">\n" +
                            "        <div class=\"layui-form-item\">\n" +
                            "            <label class=\"layui-form-label\"><span style=\"color:red\">*</span>IP：</label>\n" +
                            "            <div class=\"layui-input-inline\">\n" +
                            "                <input type=\"text\" name=\"userIp\" maxlength=\"99\" lay-verify=\"required\" value='" + obj[i] + "' placeholder=\"请输入IP\" autocomplete=\"off\" class=\"layui-input\">\n" +
                            "            </div>\n" +
                            "            <button class=\"layui-btn\" onclick=\"deleteItem(event)\" type=\"button\"><i class=\"layui-icon\">&#xe640;</i>删除</button>\n" +
                            "        </div>\n" +
                            "    </div>"
                    }
                    document.getElementById("itemsArea").innerHTML = html;
                }
            }
        });
    }

    //限制ip保存事件
    UserMgr.collectDataSubmit = function () {
        UserMgr.mutiString = "";
        if (!UserMgr.checkNullDom()) {
            layer.msg("必填项不能为空！", {
                icon: 5, shift: 6
            });
            return false;
        }
        var checkerName = [], checker = true, isIp = true;
        //获取数据并检查重复项
        $("[name='ipItem']").each(function () {
            var userIp = $(this).find("[name='userIp']").val().trim();
            var exp = /^(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$/;
            var reg = userIp.match(exp);
            if (reg == null) {
                isIp = false
                return false
            }
            if (checkerName.indexOf(userIp) > -1) {
                checker = false;
                return false;
            } else {
                checkerName.push(userIp);
                UserMgr.mutiString = UserMgr.mutiString + userIp + ","
            }
        });
        if (!isIp) {
            layer.msg("存在不合法的IP，请检查！", {
                icon: 5, shift: 6
            });
            return false;
        }
        if (!checker) {
            layer.msg("存在重复的IP，请检查！", {
                icon: 5, shift: 6
            });
            return false;
        }
        if ("" != UserMgr.mutiString) {
            UserMgr.mutiString = UserMgr.mutiString.substr(0, UserMgr.mutiString.length - 1)
            $("#accessLoginIp").val(UserMgr.mutiString)
        } else {
            $("#accessLoginIp").val("")
        }
        layer.close(layerView)
    }
    //限制IP点击事件
    UserMgr.addItem = function () {
        $("#itemsArea").append(UserMgr.itemTemplate);
        // $("#ipItem").attr("id", this.newId());
    }
    UserMgr.checkNullDom = function () {
        var flag = true;
        $("[name='ipItem']").each(function () {
            var userIp = $(this).find("[name='userIp']");
            [userIp].every(function (v) {
                if (!v.val().trim()) {
                    flag = false;
                    v.focus();
                    return false;
                }
                return true;
            });
            if (!flag) {
                return false;
            }
        });
        return flag;
    };
    //用户保存操作
    UserMgr.save = function () {
        UserMgr.getChecked(); //获得树上选中的节点
        var data = $("#userForm").serialize();
        var typeProperty = $("input[name='typeProperty']:checked").val();
        var startTime = $('#startTime').val()
        var expiredTime = $('#expiredTime').val()
        if (typeProperty === '0') {
            if (startTime > expiredTime) {
                Hussar.info("结束时间不能早于开始时间！");
                return false;
            }
        }
        var date1 = $('#accessLoginStartTime').val()
        var date2 = $('#accessLoginEndTime').val()
        if (date1 > date2) {
            Hussar.info("准入时间(结束)不能早于准入时间(开始)！");
            return false;
        }
        // 提交信息
        if (UserMgr.addORedit == 'add') {
            var ajax = new $ax(Hussar.ctxPath + "/user/add", function (data) {
                if (data.code == "200") {
                    Hussar.success(SAVE_SUCCESS);
                    $("#userTree").jstree(true).refresh();//刷新用户树
                    UserMgr.detailView(data.message);//加载详情
                } else if (data.code) {
                    Hussar.error(data.message);
                } else {
                    Hussar.error(SAVE_FAIL);
                }
            }, function (data) {
                Hussar.error(SAVE_FAIL);
            });
            ajax.setData(data);
            ajax.start();
        } else if (UserMgr.addORedit == 'edit') {
            var ajax = new $ax(Hussar.ctxPath + "/user/edit", function (data) {
                if (data.code == "200") {
                    Hussar.success(data.message);
                    $("#userTree").jstree(true).refresh();//刷新用户树
                    UserMgr.detailView(UserMgr.selectId);//加载详情
                } else if (data.code) {
                    Hussar.error(data.message);
                } else {
                    Hussar.error(SAVE_FAIL);
                }
            }, function (data) {
                Hussar.error(SAVE_FAIL);
            });
            ajax.setData(data);
            ajax.start();
        }
    }

    //用户保存时  获取3棵树上被选中的节点
    UserMgr.getChecked = function () {
        //角色树
        var roleNodes = UserMgr.roleTree.jstree(true).get_checked(true);
        var rolends = '';
        $.each(roleNodes, function (i, nd) {
            if (nd.original.code == 'ROLE') {
                rolends += "," + nd.original.id;
            }
        });
        $("#roleIds").val(rolends.substring(1));

    }


    /**********************************************Some Operation End*****************************************************/

    /**
     * 所有树的模糊查询
     */
    UserMgr.search = function () {
        var to = false;
        //用户树查询
        $("#userTreeSearch").keyup(function () {
            if (to) {
                clearTimeout(to);
            }
            to = setTimeout(function () {
                var v = $("#userTreeSearch").val();
                var temp = $userTree.is(":hidden");
                if (temp == true) {
                    $userTree.show();
                }
                $userTree.jstree(true).search(v);
                //添加索引
                if (v != '') {
                    var n = $(".jstree-search").length, con_html;
                    if (n > 0) {
                        con_html = "<em>" + n + "</em>个匹配项";
                    } else {
                        con_html = "无匹配项";
                    }
                    $("#userTreeSearchResult").html(con_html);
                    //定位到符合查询结果的树节点上
                    var searchResult = $userTree.jstree('search', v);
                    $(searchResult).find('.jstree-search').focus();
                } else {
                    $("#userTreeSearchResult").html("");
                }
            }, 250);
        });
        //角色复制树查询
        $("#copyRoleTreeSearch").keyup(function () {
            if (to) {
                clearTimeout(to);
            }
            to = setTimeout(function () {
                var v = $("#copyRoleTreeSearch").val();
                var temp = $copyRoleTree.is(":hidden");
                if (temp == true) {
                    $copyRoleTree.show();
                }
                $copyRoleTree.jstree(true).search(v);
                //定位到符合查询结果的树节点上
                var searchResult = $copyRoleTree.jstree('search', v);
                $(searchResult).find('.jstree-search').focus();
            }, 250);
        });
        //排序树查询
        $("#orderTreeSearch").keyup(function () {
            if (to) {
                clearTimeout(to);
            }
            to = setTimeout(function () {
                var v = $("#orderTreeSearch").val();
                var temp = $orderTree.is(":hidden");
                if (temp == true) {
                    $orderTree.show();
                }
                $orderTree.jstree(true).search(v);
                //定位到符合查询结果的树节点上
                var searchResult = $orderTree.jstree('search', v);
                $(searchResult).find('.jstree-search').focus();
            }, 250);
        });
        //变更所属部门树查询
        $("#orgTreeSearch").keyup(function () {
            if (to) {
                clearTimeout(to);
            }
            to = setTimeout(function () {
                var v = $("#orgTreeSearch").val();
                var temp = $orgTree.is(":hidden");
                if (temp == true) {
                    $orgTree.show();
                }
                $orgTree.jstree(true).search(v);
                //定位到符合查询结果的树节点上
                var searchResult = $orgTree.jstree('search', v);
                $(searchResult).find('.jstree-search').focus();
            }, 250);
        });
        //角色树查询
        $("#roleTreeSearch").keyup(function () {
            if (to) {
                clearTimeout(to);
            }
            to = setTimeout(function () {
                var v = $("#roleTreeSearch").val();
                var temp = $roleTree.is(":hidden");
                if (temp == true) {
                    $roleTree.show();
                }
                $roleTree.jstree(true).search(v);
                //定位到符合查询结果的树节点上
                var searchResult = $roleTree.jstree('search', v);
                $(searchResult).find('.jstree-search').focus();
            }, 250);
        });

    };

    /**
     * 初始化按钮事件
     */
    UserMgr.initButtonEvent = function () {
        /* $('#accessLoginIp').on('focus', function () {
             layer.tips('多个使用逗号隔开。示例：192.168.2.1,192.168.2.2', {
                 tips: [3, '']
             });
         });*/
        //重置按钮事件
        $("#btnReset").click(function () {
            UserMgr.resetEvent();
        });

        //保存按钮事件
        $("#btnSave").click(function () {
            form.on('submit(go)', function (data) {
                UserMgr.save();
            });
        });
        //增加字段
        $("#addItem").click(function () {
            UserMgr.addItem();
        });
        //保存字段
        $("#itemLimitIpSave").click(function () {
            UserMgr.collectDataSubmit();
        });

        //是否系统管理员radio选择事件
        form.on('radio(isSys)', function (data) {
            //清空中文名称和关联的员工id
            $("input[id='userName']").val("");
            $("input[id='employeeId']").val("");
        });
        //属性状态radio选择事件
        form.on('radio(typeProperty)', function (data) {
            if (data.value === '0') {
                $("#sData").show();
                $("#eData").show();
                $('#startTime').attr('lay-verify', 'required');
                $('#expiredTime').attr('lay-verify', 'required');
            } else {
                $("#sData").hide();
                $("#eData").hide();
                $("input[id='startTime']").val("");
                $("input[id='expiredTime']").val("");
                $('#startTime').attr('lay-verify', '');
                $('#expiredTime').attr('lay-verify', '');
            }
        });
        //是否时间限制radio选择事件
        form.on('radio(loginTimeLimit)', function (data) {
            if (data.value === '1') {
                $("#accessStart").show();
                $("#accessEnd").show();
                $('#accessLoginStartTime').attr('lay-verify', 'required');
                $('#accessLoginEndTime').attr('lay-verify', 'required');
            } else {
                $("#accessStart").hide();
                $("#accessEnd").hide();
                $("input[id='accessLoginStartTime']").val("");
                $("input[id='accessLoginEndTime']").val("");
                $('#accessLoginStartTime').attr('lay-verify', '');
                $('#accessLoginEndTime').attr('lay-verify', '');
            }
        });
        //是否ip限制radio选择事件
        form.on('radio(loginIpLimit)', function (data) {
            if (data.value === '1') {
                $("#idLimit").show();
                $('#accessLoginIp').attr('lay-verify', 'required');
            } else {
                $("#idLimit").hide();
                $("input[id='accessLoginIp']").val("");
                $('#accessLoginIp').attr('lay-verify', '');
            }
        });
        //中文名称点击事件
        $("input[id='userName']").click(function () {
            UserMgr.nameClickEvent();
        });
        //中文名称点击事件
        $("input[id='accessLoginIp']").click(function () {
            UserMgr.limitIpClickEvent();
        });
    };

    /**
     * 初始化表单验证
     */
    UserMgr.initValidate = function () {
        form.verify({
            required: function (value, item) {
                if (value.trim() == "") {
                    $("#baseInfo").click();
                    return '必填项不能为空';
                }
            },
            phone: function (value, item) {
                if (value == null || value == "") {
                    //非必填项，内容为空时不校验
                    return;
                }
                if (!/^1[3|4|5|7|8]\d{9}$/.test(value)) {
                    $("#baseInfo").click();
                    return '请输入正确的手机号'
                }
            },
            email: function (value, item) {
                if (value == null || value == "") {
                    //非必填项，内容为空时不校验
                    return;
                }
                if (!/^[a-z0-9._%-]+@([a-z0-9-]+\.)+[a-z]{2,4}$|^1[3|4|5|7|8]\d{9}$/.test(value)) {
                    $("#baseInfo").click();
                    return '请输入正确的邮箱'
                }
            },
            // qq : function(value, item){
            // 	if(value == null || value == ""){
            // 		//非必填项，内容为空时不校验
            // 		return;
            // 	}
            // 	if(!/^[1-9][0-9]{4,14}$/.test(value)){
            // 		$("#baseInfo").click();
            // 		return '请输入正确的QQ号'
            // 	}
            // },
            sessionNum: function (value, item) {
                if (!/^(0|[1-9][0-9]*|-1)$/.test(value)) {
                    $("#baseInfo").click();
                    return '请输入正确的会话数，-1为不限会话数'
                }
            },
            account: function (value, item) {
                if (!/^[\u0391-\uFFE5\w]{1,16}$/.test(value)) {
                    $("#baseInfo").click();
                    return '登录账号由16位以内中文、英文、数字或下划线组成'
                }
            },
            weChat: function (value, item) {
                if (value == null || value == "") {
                    //非必填项，内容为空时不校验
                    return;
                }
                if (!(/^[a-zA-Z]{1}[-_a-zA-Z0-9]{5,19}$/.test(value)
                    || /^[1-9][0-9]{4,14}$/.test(value)
                    || /^1[3|4|5|7|8]\d{9}$/.test(value)
                    || /^[a-z0-9._%-]+@([a-z0-9-]+\.)+[a-z]{2,4}$|^1[3|4|5|7|8]\d{9}$/.test(value))) {
                    $("#baseInfo").click();
                    return '请输入正确的微信号'
                }
            },
            telephone: function (value, item) {
                if (value == null || value == "") {
                    //非必填项，内容为空时不校验
                    return;
                }
                if (!/^[0-9_-]{4,16}$/.test(value)) {
                    $("#baseInfo").click();
                    return '请输入正确的办公电话'
                }
            },
        });
    }

    /**
     * 高度自适应调整
     */
    UserMgr.initFrameHeight = function () {
        var h = $(window).height() - 51;
        var h2 = $(window).height();
        $("#treeArea").css("height", h + "px");
        $(".layui-col-md9").css("height", h2 + "px");
    };

    /**
     * 初始化日期控件
     */
    UserMgr.initLaydate = function () {
        laydate.render({
            elem: '#startTime',
            trigger: 'click'
        });
        laydate.render({
            elem: '#expiredTime',
            trigger: 'click'
        });
        laydate.render({
            elem: '#accessLoginStartTime',
            type: 'time',
            trigger: 'click'
        });
        laydate.render({
            elem: '#accessLoginEndTime',
            type: 'time',
            trigger: 'click'
        });
    };

    $(function () {
        UserMgr.initUserTree(); //初始化用户树
        UserMgr.initLaydate(); //初始化日期控件
        UserMgr.initButtonEvent();	//初始化按钮事件
        UserMgr.initValidate();	//初始化表单验证
        UserMgr.initFrameHeight();	//初始化高度
        $(window).resize(function () {
            UserMgr.initFrameHeight();
        });
    });
    /**
     * 删除item
     */
    deleteItem = function (event) {
        event = event ? event : window.event;
        var obj = event.srcElement ? event.srcElement : event.target;
        obj = $(obj);
        obj = obj.is('button') ? obj : obj.parent();
        obj.parent().parent().remove();
        // 删除的如果是已有字段的item，则将其id加入删除数组
        var objNew = obj.parent().children('input:first-child');
        if (objNew.length > 0) {
            UserMgr.delIdString.push(objNew.attr("value"));
        }
    };
});

