/**
 * 初始化
 */
var Code = {
    ztreeInstance: null,
    tableName: "",
    submitData: {},
    switchs: {}
};

layui.use(['jquery', 'layer', 'form', 'Hussar', 'HussarAjax'], function(){

    var $ = layui.$
        , layer = layui.layer
        , form = layui.form
        , Hussar = layui.Hussar
        , $ax = layui.HussarAjax;

    /**
     * 定义表单验证规则
     */
    form.verify({
        required : function(value, item){
            if(value.trim()==""){
                return '必填项不能为空！';
            }
        },
        packageName: function(value, item){
            var label = $(item).parent().prev().text();
            if(!/^([a-zA-Z]+[a-zA-Z0-9]*)+([.][a-zA-Z]+[a-zA-Z0-9]*)+/.test(value)){
                return '包名格式不正确！(' + label + ')';
            }
        },
        moduleName: function(value){
            if(!/^[a-zA-Z\$_][a-zA-Z\d_]*$/.test(value)){
                return '模块名称格式不正确！'
            }
        }
    });

    /**
     * 选择table的事件
     */
    form.on('select(tableList)', function(data){
        var tableName = data.value; //得到被选中的值
        Code.clearCheckBox();
        Code.tableName = tableName;
        Code.setTableName(tableName);
    });

    /**
     * 选择模板的事件
     */
    form.on('checkbox(checkSingleModule)', function(data){
        var state = data.elem.checked; //是否被选中，true或者false
        var templateKey = data.value; //复选框value值，也可以通过data.elem.value得到
        if (Code.tableName != "") {
            Code.switchs[templateKey] = state == true;
            if(!state) {
                $('input[name=checkAllModules]').prop("checked", false);
                form.render('checkbox');
                $('.genPath-' + templateKey).hide();
            } else {
                $('.genPath-' + templateKey).show();
            }
        } else {
            Code.clearCheckBox();
            Hussar.info("请先选择数据表！");
        }
    });
    form.on('checkbox(checkAllModules)', function(data){
        var state = data.elem.checked == true; //是否被选中，true或者false
        if (Code.tableName != "") {
            $('input[name^=genTemplateKey]').each(function(i, v){
                v = $(v);
                Code.switchs[v.val()] = state;
                v.prop("checked", state);
            });
            form.render('checkbox');
            if(state){
                $('.genPath').show();
            } else {
                $('.genPath').hide();
            }
        } else {
            Code.clearCheckBox();
            Hussar.info("请先选择数据表！");
        }
    });

    /**
     * 提交表单事件
     */
    form.on('submit(codeGenSubmit)', function(data){
        Code.checkExist();
        return false; //阻止表单跳转
    });

    /**
     * 清空模版复选框
     */
    Code.clearCheckBox = function(){
        Code.switchs = {};
        $('.genPath').hide();
        $('input[name^=genTemplateKey]').prop("checked", false);
        $('input[name=checkAllModules]').prop("checked", false);
        form.render('checkbox');
    };

    /**
     * 点击生成，先检测文件存在性
     */
    Code.checkExist = function () {
        //必填验证
        if (Code.tableName == "") {
            Hussar.info("请先选择数据表！");
            return false;
        }
        if($('input[name^=genTemplateKey]:checked').length < 1){
            Hussar.info("未选择要生成的模板！");
            return false;
        }
        //前缀验证
        var testPrefix = $("#ignoreTabelPrefix").val();
        if(testPrefix){
            if(testPrefix.length >= Code.tableName.length
            || Code.tableName.substring(0, testPrefix.length) != testPrefix){
                Hussar.info("前缀与表名称不符合或长度过长！");
                return false;
            }
        }
        //将生成的文件的存在性验证
        Code.submitData = {};
        Code.submitData.tableName = Code.tableName;
        Code.set('projectPath').set('author').set('projectPackage').set('corePackage').set('ignoreTabelPrefix')
            .set('bizName').set('moduleName').set('parentMenuName');
        var ajax = new $ax(Hussar.ctxPath + "/code/fileCheck", function (data) {
            //查询成功!
            if(data.length > 0){
                Hussar.confirm('存在已生成的文件！是否覆盖旧文件？<br /><br />' + data.join('<br /><br />'), Code.generate);
            }else{
                Code.generate();
            }
        }, function (data) {
            Hussar.confirm('检查文件存在性失败! 是否继续操作？（确认将覆盖旧文件）' + data.responseJSON.message + '！',
                Code.generate);
        });

        for (var item in Code.switchs) {
            Code.submitData[item] = Code.switchs[item];
        }
        ajax.setData(Code.submitData);
        ajax.start();
    };

    /**
     * 生成文件发送ajax
     */
    Code.generate = function () {
        Code.submitData = {};
        Code.submitData.tableName = Code.tableName;
        Code.set('projectPath').set('author').set('projectPackage').set('corePackage').set('ignoreTabelPrefix')
            .set('bizName').set('moduleName').set('parentMenuName');
        var baseAjax = Hussar.baseAjax("/code/generate", "生成代码");
        for (var item in Code.switchs) {
            Code.submitData[item] = Code.switchs[item];
        }
        baseAjax.setData(Code.submitData);
        baseAjax.start();
    };

    /**
     * 设置表名称
     */
    Code.setTableName = function (tableName) {
        var pre = $("#ignoreTabelPrefix").val() || "";
        var className = Hussar.underLineToCamel(tableName.substring(pre.length));

        $("#tableName").val(tableName);
        $("#className").val(className);
        Code.refreshClassName(className);
    };

    Code.reloadPrefix = function (e) {
        var prefix = e.currentTarget.value || "";
        var className = Hussar.underLineToCamel(Code.tableName.substring(prefix.length));

        $("#className").val(className);
        Code.refreshClassName(className);
    };

    Code.set = function (key, val) {
        Code.submitData[key] = (typeof value == "undefined") ? $("#" + key).val() : value;
        return this;
    };

    Code.refreshClassName = function(className){
        var frontName = Code.convertFrontName(className);
        $(".genString-className").text(className);
        $(".genString-frontName").text(frontName);
    };

    Code.convertFrontName = function(className){
        if(className){
            var a = className.split('');
            a[0] = a[0].toLowerCase();
            return a.join('');
        }
    };

    Code.refreshPath = function(e){
        var text = e.currentTarget.value || "";
        var id = e.currentTarget.id;
        if(id == 'projectPackage'){
            text = text.replace(/[.]/g, '/');
            id = 'packageStr';
        }
        $(".genString-"+ id).text(text);
    };

    $().ready(function(){
        ['projectPath', 'moduleName'].forEach(function(v){
            $(".genString-"+ v).text($("#"+v).val());
        });
        $(".genString-packageStr").text($("#projectPackage").val().replace(/[.]/g, '/'));
    });
});