/**
 * 初始化
 */
var LogMongo = {
    id: "LogMongoTable",	//表格id
    table: null,
    layerIndex: -1
};


layui.use(['table','laydate','Hussar'], function(){
    var table = layui.table
    , $ = layui.jquery
    ,laydate = layui.laydate,
    Hussar = layui.Hussar;
    $(function () {
        $('#LogMongoTable').attr('lay-even', true);
        table.render({
            elem: '#LogMongoTable'
            ,url: Hussar.ctxPath +'/logMongo/find'
            ,cols: [[
                {title: '序号',type : 'numbers',width:50},
                {title: '类', field: 'className', align: 'center'},
                {title: '方法', field: 'methodName', align: 'center'},
                {title: '文件', field: 'fileName', align: 'center'},
                {title: '行号', field: 'lineNumber', align: 'center', width:70},
                {title: '日志信息', field: 'message', align: 'left'},
                {title: '日期', field: 'date', align: 'center',sort: true}
            ]]
            ,page: true
            ,even: true
            , height:$("body").height() - $(".layui-form").outerHeight(true)-26
        });
        
        /**
         * 初始化时间控件
         */
        var ts = laydate.render({
		   	 elem: '#dateSelectStrat',
	         type : 'datetime',
	         done: function (value,date) {	
	        	 if (value !== '') {
	        		 te.config.min.year = date.year;
		        	 te.config.min.month = date.month - 1;
		        	 te.config.min.date = date.date;
		        	 te.config.min.hours = date.hours;
		        	 te.config.min.minutes = date.minutes;
		        	 te.config.min.seconds = date.seconds;
	        	 } else {
	        		 te.config.min.year = '';
		        	 te.config.min.month = '';
		        	 te.config.min.date = '';
		        	 te.config.min.hours = '';
		        	 te.config.min.minutes = '';
		        	 te.config.min.seconds = '';
	        	 }
	        	 	        	 
	         }
		});
		var te = laydate.render({
		   	 elem: '#dateSelectEnd',
		     type : 'datetime',              
		     done: function (value,date) {			    	 
		    	 if (value !== '') {
		    		 ts.config.max.year = date.year;
		        	 ts.config.max.month = date.month - 1;
		        	 ts.config.max.date = date.date;
		        	 ts.config.max.hours = date.hours;
		        	 ts.config.max.minutes = date.minutes;
		        	 ts.config.max.seconds = date.seconds;
		    	 } else {
		    		 ts.config.max.year = '2099';
		        	 ts.config.max.month = '11';
		        	 ts.config.max.date = '31';
		        	 ts.config.max.hours = '0';
		        	 ts.config.max.minutes = '0';
		        	 ts.config.max.seconds = '0';
		    	 }
		    	 	 
		     }
		});

        
    });
        

    /**
     * 下载
     */
    LogMongo.dowlond = function () {
        $("#download_level").val($("#level").val());
        $("#download_fileName").val($("#fileName").val());
        $("#download_methodName").val($("#methodName").val());
        $("#download_dateSelectStrat").val($("#dateSelectStrat").val());
        $("#download_dateSelectEnd").val($("#dateSelectEnd").val());
        var dowloadForm = document.getElementById("dowload_form");

        dowloadForm.action = Hussar.ctxPath +"/logMongo/dowlond";
        dowloadForm.submit();

    };
});



/**
 * 查询
 */
LogMongo.search = function () {
    layui.use(['table'], function() {
        var table = layui.table
        , $ = layui.jquery;
        table.reload('LogMongoTable', {page: {curr: 1},where:{
            message: $("#level").val(),
            fileName: $("#fileName").val(),
            methodName: $("#methodName").val(),
            dateSelectStrat: $("#dateSelectStrat").val(),
            dateSelectEnd: $("#dateSelectEnd").val()
        }});
    });

};

