/**
* @Description:    资源查看页面 脚本文件
* @Author:         LiangDong
* @CreateDate:     2018/9/17 9:06
* @UpdateUser:     LiangDong
* @UpdateDate:     2018/9/17 9:06
* @UpdateRemark:   修改内容
* @Version:        1.0
*/
layui.use(['jquery','layer','Hussar','form', 'HussarAjax', 'element', 'jstree'], function(){
    var form=layui.form,
        $ = layui.jquery,
        $ax=layui.HussarAjax,
        element=layui.element,
        jstree=layui.jstree,
        Hussar = layui.Hussar;

    var ResourceView={

    };

    /**
     *  初始化资源关联角色树
     */
    ResourceView.initRoleTree = function () {
        var resourceId=$("#resourceId").val();
        var $roleTree = $("#roleTree");//角色树
        $roleTree.jstree({
            core: {
                check_callback: true,
                data: function (obj, callback) {
                    var data;
                    var ajax = new $ax(Hussar.ctxPath + "/resource/roleTreeView",
                        function(result) {
                            data = result;
                        },
                        function(data) {
                            Hussar.error("加载资源关联角色树失败！");
                        });
                    ajax.set("resourceId",resourceId);
                    ajax.start();
                    callback.call(this, data);
                }
            },
            plugins: ['types','search'],
            types:{
                "GROUP":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/roleGroup.png"},
                "ROLE":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/role.png"},
                "isRoot":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/root.png"}
            },
            search: ResourceView.searchRole()
        });
    };


    /**
     *  资源关联角色树查询
     */
    ResourceView.searchRole = function () {
        var to = false;
        $("#searchRole").keyup(function () {
            if (to) { clearTimeout(to); }
            to = setTimeout(function () {
                var v = $("#searchRole").val();
                var temp = $("#roleTree").is(":hidden");
                if (temp == true) {
                    $("#roleTree").show();
                }
                $("#roleTree").jstree(true).search(v);
                //添加索引
                if(v!=''){
                    //定位到符合查询结果的树节点上
                    var searchResult = $("#roleTree").jstree('search', v);
                    $(searchResult).find('.jstree-search').focus();
                }else {
                }
            }, 250);
        });
    }


    /**
     *  页面初始化
     */
    $(function() {
        ResourceView.initRoleTree();
    });
	




});
