Power = {
	version : "1.0",
	type : "spring",
	rootPath : "",
	contextPath : "",
	jsPath : "/static/js/",
	cssPath : "/static/css/",
	imgPath : "/static/img/",
	filePath : ""
};
Power.getTopWinow = function() {
	var a = window;
	while (a != a.parent) {
		a = a.parent
	}
	return a
};
Power.isSupportHtml5 = function() {
	var a = document.createElement("canvas");
	return (a.getContext && a.getContext("2d"))
};
Power.initIframe = function(a, b) {
	this.rootPath = a + "/";
	this.contextPath = b + "/";
	this.jsPath = a + "/static/js/";
	this.cssPath = a + "/static/css/";
	this.imgPath = a + "/static/img/"
};
Power.util = {};
Power.form = {};
Power.util.format = {};
Power.command = function(a, b) {
	this.action = a;
	if (b == null) {
		this.method = "POST"
	} else {
		this.method = b
	}
	this.type = "index";
	this.params = {};
	this.returns = null
};
Power.command.prototype = {
	setParameter : function(a, b) {
		this.params[a] = b
	},
	execute : function(e, f) {
		this.type = e;
		if (f == null) {
			f = true
		}
		if (this.action == null) {
			var d = {};
			d.s = "fail";
			d.s = "请输入处理路径！";
			return d
		}
		if (this.type == null) {
			var d = {};
			d.s = "fail";
			d.s = "请输入处理方法！";
			return d
		}
		var a = {};
		var b = this.action;
		if (Power.type == "spring") {
			if (this.action.startWith("http:")
					|| this.action.startWith("https:")) {
				b = this.action + "?method=" + this.type
			} else {
				b = Power.rootPath + this.action + "?method=" + this.type
			}
		} else {
			if (this.action.startWith("http:")
					|| this.action.startWith("https:")) {
				b = this.action + "/" + this.type
			} else {
				b = Power.rootPath + this.action + "/" + this.type
			}
		}
		if (this.params != null) {
			a = Power.code.encode(this.params)
		}
		var g = {
			type : this.method,
			async : !f,
			url : b,
			data : a,
			dataType : "json",
			success : function(h) {
				if (this.target) {
					this.target.returns = h
				}
			},
			error : function(i, k, j) {
				if (this.target) {
					var h = {};
					h.state = 0;
					h.message = k;
					this.target.returns = h;
					this.target.error = h.message
				}
			},
			target : this
		};
		$.ajax(g);
		if (f) {
			if (this.returns == null) {
				var c = {};
				c.state = 0;
				c.message = "获取服务器端数据为空，请稍后再试！";
				this.returns = c;
				this.error = c.message
			}
			return this.returns
		}
	}
};
Power.submit = function(b, a) {
	this.formId = b;
	this.action = a;
	this.method = "POST";
	this.type = "index";
	this.params = {};
	this.returns = null
};
Power.submit.prototype = {
	setParameter : function(a, b) {
		this.params[a] = b
	},
	execute : function(e, f) {
		this.type = e;
		if (f == null) {
			f = true
		}
		if (this.action == null) {
			var d = {};
			d.s = "fail";
			d.s = "请输入处理路径！";
			return d
		}
		if (this.type == null) {
			var d = {};
			d.s = "fail";
			d.s = "请输入处理方法！";
			return d
		}
		var a = Power.rootPath;
		if (this.action.startWith("http:") || this.action.startWith("https:")) {
			a = this.action + "?method=" + this.type
		} else {
			a = a + this.action + "?method=" + this.type
		}
		for ( var c in this.params) {
			a += "&" + c + "=" + this.params[c]
		}
		//var formdata = $("#" + this.formId).serializeArray();
		//$.each(formdata,function(idx,obj) {
		//	obj.value = Power.code.escapeString(obj.value);
		//});
		var g = {
			type : this.method,
			async : !f,
			url : a,
			data : $("#" + this.formId).serialize(),
			success : function(h) {
				if (this.target) {
					this.target.returns = h
				}
			},
			error : function(i, k, j) {
				if (this.target) {
					var h = {};
					h.state = 0;
					h.message = k;
					this.target.returns = h;
					this.target.error = h.message
				}
			},
			target : this
		};
		$.ajax(g);
		if (f) {
			if (this.returns == null) {
				var b = {};
				b.state = 0;
				b.message = "获取服务器端数据为空，请稍后再试！";
				this.returns = b;
				this.error = b.message
			}
			return this.returns
		}
	}
};
Power.dialog = function(b) {
	b.background = "#ccc";
	b.opacity = 0.5;
	b.padding = "0";
	b.dblclickHide = false;
	if (b.title != null) {
		if (b.width != null) {
			if (typeof (b.width) == "number") {
				var a = b.width / 14;
				if (a < b.title.length) {
					b.title = b.title.substring(0, a) + "..."
				}
			}
		}
	}
	if (b.lock == null) {
		b.lock = true
	}
	if (b.width == null) {
		b.width = $(window).width() * 0.8
	}
	if (b.url) {
		$.ajax({
			url : Power.rootPath + b.url,
			success : function(c) {
				b.content = c;
				if (b.parent == true) {
					this._dialogContent = $.dialog.through(b)
				} else {
					this._dialogContent = $.dialog(b)
				}
			},
			cache : false
		})
	} else {
		if (b.parent == true) {
			this._dialogContent = $.dialog.through(b)
		} else {
			this._dialogContent = $.dialog(b)
		}
	}
};
Power.dialog.alert = function(a) {
	return $.dialog.through({
		id : "Alert",
		title : "系统提示",
		icon : "warning",
		fixed : true,
		lock : true,
		content : a,
		ok : true
	})
};
Power.dialog.alertSuccess = function(a) {
	return $.dialog.through({
		id : "Alert-Success",
		icon : "succeed",
		fixed : true,
		lock : true,
		width : 200,
		title : "系统提示",
		content : a,
		ok : true
	})
};
Power.dialog.alertError = function(a) {
	return $.dialog.through({
		id : "Alert-Error",
		icon : "error",
		fixed : true,
		lock : true,
		width : 200,
		title : "系统提示",
		content : a,
		ok : true
	})
};
Power.dialog.tips = function(a, c) {
	var b = "<div style='padding: 1em 3.7em;'>" + a + "</div>";
	return $.dialog.through({
		id : "Tips",
		title : false,
		content : b,
		cancel : false,
		fixed : true,
		lock : false,
		width : 200,
		time : (c || 10)
	})
};
Power.dialog.confirm = function(a, c, b) {
	Power.dialog({
		id : "Confirm",
		icon : "question",
		title : "系统提示",
		fixed : true,
		lock : true,
		opacity : 0.1,
		width : 200,
		content : a,
		ok : function(d) {
			return c.call(this, d)
		},
		cancel : function(d) {
			return b && b.call(this, d)
		}
	})
};
Power.dialog.notice = function(k) {
	var c = k || {}, h, a, g, b, j, e = 800;
	var d = {
		id : "Notice",
		left : "100%",
		top : "100%",
		title : "温馨提示",
		fixed : true,
		drag : false,
		resize : false,
		follow : null,
		lock : false,
		init : function(i) {
			h = this;
			a = h.config;
			b = h.DOM.wrap;
			j = parseInt(b[0].style.top);
			g = j + b[0].offsetHeight;
			b.css("top", g + "px").animate({
				top : j + "px"
			}, e, function() {
				c.init && c.init.call(h, i)
			})
		},
		close : function(i) {
			b.animate({
				top : g + "px"
			}, e, function() {
				c.close && c.close.call(this, i);
				a.close = $.noop;
				h.close()
			});
			return false
		}
	};
	for ( var f in c) {
		if (d[f] === undefined) {
			d[f] = c[f]
		}
	}
	return Power.dialog(d)
};
Power.dialog.open = function(c, b, a) {
	if (b == null) {
		b = {
			title : false
		}
	}
	if (a == null) {
		a = false
	}
	return artDialog.open(c, b, a)
};
Power.dialog.prototype = {
	openDialog : function(a, c, b) {
		$.ajax({
			url : a,
			success : function(d) {
				this.dialogContent = $.dialog({
					title : c,
					content : d,
					button : b
				})
			},
			cache : false
		})
	},
	init : function() {
		this.dialogContent.init()
	},
	close : function() {
		this.dialogContent.close()
	},
	getDialogContent : function() {
		return this._dialogContent
	}
};
Power.dialog.getId = function(a) {
	return a === undefined ? $.dialog.list : $.dialog.list[a]
};
Power.dialog.close = function(e) {
	var c = (parent.$.dialog == null) ? $.dialog : parent.$.dialog;
	var b = c.dialog.list;
	for ( var a in b) {
		if (a == e) {
			b[a].close();
			break
		}
	}
};
Power.util.alert = function(c, a) {
	var e = null;
	var b = {};
	b.okValue = "确 定";
	b.ok = function() {
		e.close()
	};
	b.width = 300;
	b.title = "温馨提示";
	if (a != null) {
		if (a == true) {
			c = '<i class="glyphicons glyphicons-ok"></i>' + c
		} else {
			c = '<span class="glyphicons glyphicons-remove"></span>' + c
		}
	}
	b.content = c;
	seajs.use([ "jquery", Power.jsPath + "dialog/src/dialog.js" ], function(f,
			d) {
		e = d(b);
		e.show()
	})
};
Power.util.dialog = function(b, c, a) {
	if (!b.okValue && c != null) {
		b.okValue = "确 定";
		b.ok = c
	}
	if (!b.cancelValue && a != null) {
		b.cancelValue = "取消";
		b.cancel = a
	}
	seajs.use([ "jquery", Power.jsPath + "dialog/src/dialog.js" ], function(f,
			e) {
		var g = e(b);
		g.show()
	})
};
Power.util.dragDialog = function(b, c, a) {
	if (!b.okValue && c != null) {
		b.okValue = "确 定";
		b.ok = c
	}
	if (!b.cancelValue && a != null) {
		b.cancelValue = "取消";
		b.cancel = a
	}
	seajs.use([ "jquery", Power.jsPath + "dialog/src/dialog-drag.js" ],
			function(f, e) {
				var g = e(b);
				g.show()
			})
};
Power.util.ajaxDialog = function(a) {
	seajs.use([ "jquery", Power.jsPath + "dialog/src/dialog-drag.js" ],
			function(c, b) {
				if (a.width == null) {
					a.width = 900
				}
				if (a.url) {
					c.ajax({
						url : Power.rootPath + a.url,
						success : function(f) {
							a.content = f;
							var g = b(a);
							g.showModal()
						},
						cache : false
					})
				} else {
					var e = b(a);
					e.showModal()
				}
			})
};
Power.form.set = function(a, b, c) {
	if (c == null) {
		c = "field"
	}
	$("#" + a + " [" + c + "]").each(function(e, g) {
		var h = $(this);
		var d = h.attr(c);
		if (b[d] != undefined) {
			var f = b[d];
			if (h.is("span")) {
				h.html(f)
			} else {
				if (h.is("div")) {
					h.html(f)
				} else {
					if ("radio" == h.attr("type")) {
						if (f == h.val()) {
							h.prop("checked", true)
						} else {
							h.prop("checked", false)
						}
					} else {
						if ("checkbox" == h.attr("type")) {
							f = "," + f + ",";
							if (f.indexOf(h.val()) > -1) {
								h.prop("checked", true)
							} else {
								h.prop("checked", false)
							}
						} else {
							h.val(f)
						}
					}
				}
			}
		}
	})
};
Power.form.get = function(a, b) {
	if (b == null) {
		b = "field"
	}
	var c = {};
	$("#" + a + " [" + b + "]").each(function(g, h) {
		var i = $(this);
		var d = i.attr(b);
		if (i.is("span")) {
			c[d] = i.html()
		} else {
			if ("radio" == i.attr("type")) {
				if (i.prop("checked") == true) {
					c[d] = i.val()
				}
			} else {
				if ("checkbox" == i.attr("type")) {
					if (i.prop("checked") == true) {
						var e = i.val();
						if (c[d] == undefined) {
							c[d] = e
						} else {
							var f = c[d];
							f = "," + f + ",";
							if (f.indexOf(i.val()) < 0) {
								c[d] = c[d] + "," + e
							}
						}
					}
				} else {
					if ("editor" != i.attr("class")) {
						c[d] = i.val()
					}
				}
			}
		}
	});
	return c
};
Power.form.validate = function(c, b, a) {
	if (a == null) {
		a = {}
	}
	a.btnSubmit = "#" + b;
	if (!a.tiptype) {
		a.tiptype = 2
	}
	a.showAllError = true;
	return $("#" + c).Validform(a)
};
Power.form.editor = function(style, containerId, config, fun) {
	KindEditor.basePath = Power.rootPath + "/static/js/kindeditor/";
	switch (style) {
	case "simple":
		config = {
			themeType : "simple",
			resizeType : 1,
			allowPreviewEmoticons : false,
			uploadJson : Power.rootPath + "/server/file/attachUpload",
			fileManagerJson : Power.rootPath + "/server/file/manage",
			allowImageUpload : true,
			afterCreate : function() {
				this.sync()
			},
			afterBlur : function() {
				this.sync()
			},
			items : [ "fontname", "fontsize", "|", "forecolor", "hilitecolor",
					"bold", "italic", "underline", "removeformat", "|",
					"justifyleft", "justifycenter", "justifyright",
					"insertorderedlist", "insertunorderedlist", "|",
					"emoticons", "image", "link" ]
		};
		break;
	case "qq":
		config = {
			themeType : "qq",
			uploadJson : Power.rootPath + "/server/file/attachUpload",
			fileManagerJson : Power.rootPath + "/server/file/manage",
			allowImageUpload : true,
			afterCreate : function() {
				this.sync()
			},
			afterBlur : function() {
				this.sync()
			},
			items : [ "bold", "italic", "underline", "fontname", "fontsize",
					"forecolor", "hilitecolor", "plug-align", "plug-order",
					"plug-indent", "insertfile", "link" ]
		};
		break;
	default:
		config = {
			themeType : "default",
			afterCreate : function() {
				this.sync()
			},
			afterBlur : function() {
				this.sync()
			}
		}
	}
	var obj = KindEditor.create('textarea[id="' + containerId + '"]', config);
	if (fun != undefined) {
		var s = eval(fun);
		s.call(s, obj, containerId)
	}
	obj.sync();
	return obj
};
Power.form.removeEditor = function(a) {
	KindEditor.remove('textarea[id="' + a + '"]')
};
Power.form.tree = function(treeId, setting, data, fun) {
	this.tree = $.fn.zTree.init($("#" + treeId), setting, data);
	if (fun != undefined) {
		var s = eval(fun);
		s.call(s, this.tree)
	}
	return this.tree
};
Power.form.tree.prototype = {
	getTree : function(a) {
		if ($.fn.zTree == undefined) {
			Power.dialog.alert("请先初始化树形组件!");
			return null
		}
		return $.fn.zTree.getZTreeObj(a)
	}
};
Power.form.fineuploader = function(a) {
	if (a.id == null) {
		Power.dialog.alert("上传组件ID必须设置!");
		return
	} else {
		a.element = $("#" + a.id)[0]
	}
	if (a.request == null) {
		a.request = {
			endpoint : Power.rootPath + "/server/file/upload"
		}
	}
	if (a.deleteFile == null) {
		a.deleteFile = {
			enabled : true,
			endpoint : Power.rootPath + "/server/file/delete"
		}
	}
	if (a.retry == null) {
		showButton: true, a.retry = {
			enableAuto : true
		}
	}
	if (a.validation == null) {
		a.validation = {
			allowedExtensions : [ "pdf", "doc", "docx", "xls", "xlsx", "ppt",
					"pptx", "jpeg", "jpg", "gif", "png", "zip" ],
			itemLimit : 5,
			sizeLimit : 15000000
		}
	}
	if (a.text == null) {
		a.text = {
			uploadButton : '<i class="icon-cloud-upload"> &nbsp;上传</i>'
		}
	}
	if (a.failedUploadTextDisplay == null) {
		a.failedUploadTextDisplay = {
			mode : "custom",
			maxChars : 40,
			responseProperty : "error",
			enableTooltip : false
		}
	}
	a.classes = {
		success : "alert alert-success",
		fail : "alert alert-error"
	};
	return new qq.FineUploader(a)
};
Power.form.flexgrid = function(c, a) {
	if (a.url == null) {
		Power.dialog.alert("请配置程序参数!");
		return null
	}
	if (a.title == null) {
		a.title = "数据列表"
	}
	if (a.buttons == null) {
		a.buttons = [ {
			name : "添加",
			bclass : "class_button_add",
			onpress : call
		}, {
			separator : true
		}, {
			name : "修改",
			bclass : "class_button_edit",
			onpress : call
		}, {
			separator : true
		}, {
			name : "删除",
			bclass : "class_button_del",
			onpress : call
		}, {
			separator : true
		} ]
	}
	if (a.sortorder == null) {
		a.sortorder = "asc"
	}
	if (a.usepager == null) {
		a.usepager = true
	}
	if (a.rp == null) {
		a.rp = 10
	}
	if (a.width == null) {
		a.width = "auto"
	}
	if (a.hegiht == null) {
		a.height = "auto"
	}
	if (a.showcheckbox == null) {
		a.showcheckbox = true
	}
	var b = $("#" + c).flexigrid({
		url : Power.rootPath + a.url,
		dataType : "json",
		colModel : a.colModel,
		searchitems : a.searchitems,
		buttons : a.buttons,
		sortname : a.sortname,
		sortorder : a.sortorder,
		striped : true,
		usepager : a.usepager,
		title : "区划列表",
		useRp : true,
		rp : a.rp,
		autoload : true,
		showTableToggleBtn : true,
		width : "auto",
		height : "auto",
		showcheckbox : a.showcheckbox,
		gridClass : "bui-grid",
		onSubmit : false
	});
	return b
};
Power.template = function(e, h) {
	if (e.url == null) {
		Power.dialog.alert("请配置模板访问的URL服务地址！")
	}
	var i = {};
	var f = new Power.command(e.url);
	if (e.page == null) {
		e.page = 1
	}
	f.setParameter("page", e.page);
	if (e.rows == null) {
		e.rows = 1
	}
	f.setParameter("param", e.param);
	f.setParameter("rows", e.rows);
	var c = e.name;
	var a = e.name;
	if (e.method) {
		a = e.method
	}
	if (a == null) {
		i = f.execute()
	} else {
		i = f.execute(a)
	}
	if (h == null) {
		h = "webfinal-"
	}
	var d = h + c + "-template";
	var b = d + "-content";
	if (!i.error && i.state == 1) {
		var g = template(d, i);
		$("#" + b).empty();
		$("#" + b).html(g);
		if (e.callback != null) {
			e.callback(i)
		}
	} else {
		$("#" + b)
				.html(
						"<span style='color:red;line-height:32px;padding-left:10px;'><i class='icon-comment'></i>&nbsp;服务器忙,未读取到数据!</span>")
	}
};
Power.form.fineUpload = function(d, b, c, a) {
	if (b.url == null) {
		b.url = Power.index.filePath + "main/rest/upload"
	}
	if (b.dataType == null) {
		b.dataType = "json"
	}
	if (b.formData == null) {
		b.formData = param
	}
	if (b.autoUpload == null) {
		b.autoUpload = true
	}
	if (b.acceptFileTypes == null) {
		b.acceptFileTypes = /(\.|\/)(pdf|doc|docx|xls|xlsx|ppt|pptx|zip|gif|jpe?g|png)$/i
	}
	if (b.maxNumberOfFiles == null) {
		b.maxNumberOfFiles = 1
	}
	if (b.maxFileSize == null) {
		b.maxFileSize = 5000000
	}
	b.forceIframeTransport = true;
	if (b.done == null) {
		b.done = c
	}
	if (b.fail == null) {
		b.fail = a
	}
	$("#" + d).fileupload(b)
};
Power.form.datePicker = function(b, a) {
	if (a == null) {
		a = {}
	}
	if (a.format == null) {
		a.format = "yyyy-mm-dd"
	}
	a.autoclose = true;
	a.language = "zh-CN";
	$(b).datepicker(a)
};
Power.pageJump = function(b, f, e, c, a, d) {
	if (c > 0) {
		if (f >= 1 && f <= c) {
			var g = {};
			if (a.indexOf("?") != -1) {
				g = Power.parseQueryString(a);
				a = a.substring(0, a.indexOf("?"))
			}
			Power.template({
				name : b,
				page : f,
				rows : e,
				url : a,
				param : g
			}, d)
		}
	}
};
Power.form.dateTimePicker = function(b, a) {
	if (a == null) {
		a = {}
	}
	if (a.format == null) {
		a.format = "yyyy-mm-dd"
	}
	if (a.weekStart == null) {
		a.weekStart = 1
	}
	if (a.todayBtn == null) {
		a.todayBtn = 1
	}
	if (a.autoclose == null) {
		a.autoclose = 1
	}
	if (a.todayHighlight == null) {
		a.todayHighlight = true
	}
	if (a.startView == null) {
		a.startView = 2
	}
	if (a.forceParse == null) {
		a.forceParse = 0
	}
	if (a.showMeridian == null) {
		a.showMeridian = 1
	}
	a.icons = {
		leftArrow : "fa-arrow-left",
		rightArrow : "fa-arrow-right"
	};
	a.icontype = "fa";
	a.language = "zh-CN";
	$("#" + b).datetimepicker(a)
};
Power.jqPaginator = function(b, a) {
	if (a.totalCounts == null) {
		a.totalCounts = 0
	}
	if (a.pageSize == null) {
		a.pageSize = 0
	}
	if (a.visiblePages == null) {
		a.visiblePages = 5
	}
	if (a.currentPage == null) {
		a.currentPage = 1
	}
	if (a.first == null) {
		a.first = "<li class='prev'><a href='#' onclick=Power.pageJump('"
				+ a.modelName + "',1," + a.pageSize + ",{{totalPages}},'"
				+ a.url + "','" + a.prefix + "')>首页</a></li>"
	}
	if (a.prev == null) {
		a.prev = "<li><a href='#' onclick=Power.pageJump('" + a.modelName
				+ "',{{page}}," + a.pageSize + ",{{totalPages}},'" + a.url
				+ "','" + a.prefix + "')>上一页</a></li>"
	}
	if (a.next == null) {
		a.next = "<li><a href='#' onclick=Power.pageJump('" + a.modelName
				+ "',{{page}}," + a.pageSize + ",{{totalPages}},'" + a.url
				+ "','" + a.prefix + "')>下一页</a></li>"
	}
	if (a.last == null) {
		a.last = "<li><a href='#' onclick=Power.pageJump('" + a.modelName
				+ "',{{totalPages}}," + a.pageSize + ",{{totalPages}},'"
				+ a.url + "','" + a.prefix + "');>尾页</a></li>"
	}
	if (a.page == null) {
		a.page = "<li><a href='#' onclick=Power.pageJump('" + a.modelName
				+ "',{{page}}," + a.pageSize + ",{{totalPages}},'" + a.url
				+ "','" + a.prefix + "')>{{page}}</a></li>"
	}
	$("#" + b).jqPaginator(a)
};
(function() {
	var g = "James_cookie_sYQDUGqqzH";
	var f = "";
	var a = "/";
	function b(m) {
		m = g + m;
		var k = m + "=";
		var o = k.length;
		var h = document.cookie.length;
		var n = 0;
		while (n < h) {
			var l = n + o;
			if (document.cookie.substring(n, l) == k) {
				return c(l)
			}
			n = document.cookie.indexOf(" ", n) + 1;
			if (n == 0) {
				break
			}
		}
		return null
	}
	function e(j, k, n) {
		j = g + j;
		var m = e.arguments.length;
		var h = e.arguments;
		var l = (m > 5) ? h[5] : false;
		var i = new Date();
		if (n == null || n == 0) {
			n = 1
		}
		i.setTime(i.getTime() + 3600000 * 24 * n);
		document.cookie = j + "=" + escape(k) + ("; path=" + a)
				+ ((f == "") ? "" : ("; domain=" + f))
				+ ((l == true) ? "; secure" : "") + ";expires="
				+ i.toGMTString()
	}
	function d(h) {
		var j = new Date();
		j.setTime(j.getTime() - 1);
		var i = b(h);
		h = g + h;
		document.cookie = h + "=" + i + ";expires=" + j.toGMTString()
	}
	function c(i) {
		var h = document.cookie.indexOf(";", i);
		if (h == -1) {
			h = document.cookie.length
		}
		return unescape(document.cookie.substring(i, h))
	}
	Power.cookie = {};
	Power.cookie.get = b;
	Power.cookie.set = e;
	Power.cookie.del = d
}());
Power.code = {};
(function($) {
	$.fn.serializeObject = function() {
		var o = {};
		var a = this.serializeArray();
		$.each(a, function() {
			if (o[this.name]) {
				if (!o[this.name].push) {
					o[this.name] = [ o[this.name] ]
				}
				o[this.name].push(this.value || "")
			} else {
				o[this.name] = this.value || ""
			}
		});
		return o
	};
	$.toJSON = function(o) {
		if (typeof (JSON) == "object" && JSON.stringify) {
			return JSON.stringify(o)
		}
		var type = typeof (o);
		if (o === null) {
			return "null"
		}
		if (type == "undefined") {
			return undefined
		}
		if (type == "number" || type == "boolean") {
			return o + ""
		}
		if (type == "string") {
			return $.quoteString(o)
		}
		if (type == "object") {
			if (typeof o.toJSON == "function") {
				return $.toJSON(o.toJSON())
			}
			if (o.constructor === Date) {
				var month = o.getUTCMonth() + 1;
				if (month < 10) {
					month = "0" + month
				}
				var day = o.getUTCDate();
				if (day < 10) {
					day = "0" + day
				}
				var year = o.getUTCFullYear();
				var hours = o.getUTCHours();
				if (hours < 10) {
					hours = "0" + hours
				}
				var minutes = o.getUTCMinutes();
				if (minutes < 10) {
					minutes = "0" + minutes
				}
				var seconds = o.getUTCSeconds();
				if (seconds < 10) {
					seconds = "0" + seconds
				}
				var milli = o.getUTCMilliseconds();
				if (milli < 100) {
					milli = "0" + milli
				}
				if (milli < 10) {
					milli = "0" + milli
				}
				return '"' + year + "-" + month + "-" + day + "T" + hours + ":"
						+ minutes + ":" + seconds + "." + milli + 'Z"'
			}
			if (o.constructor === Array) {
				var ret = [];
				for ( var i = 0; i < o.length; i++) {
					ret.push($.toJSON(o[i]) || "null")
				}
				return "[" + ret.join(",") + "]"
			}
			var pairs = [];
			for ( var k in o) {
				var name;
				var type = typeof k;
				if (type == "number") {
					name = '"' + k + '"'
				} else {
					if (type == "string") {
						name = $.quoteString(k)
					} else {
						continue
					}
				}
				if (typeof o[k] == "function") {
					continue
				}
				var val = $.toJSON(o[k]);
				pairs.push(name + ":" + val)
			}
			return "{" + pairs.join(", ") + "}"
		}
	};
	$.evalJSON = function(src) {
		if (typeof (JSON) == "object" && JSON.parse) {
			return JSON.parse(src)
		}
		return eval("(" + src + ")")
	};
	$.secureEvalJSON = function(src) {
		if (typeof (JSON) == "object" && JSON.parse) {
			return JSON.parse(src)
		}
		var filtered = src;
		filtered = filtered.replace(/\\["\\\/bfnrtu]/g, "@");
		filtered = filtered
				.replace(
						/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,
						"]");
		filtered = filtered.replace(/(?:^|:|,)(?:\s*\[)+/g, "");
		if (/^[\],:{}\s]*$/.test(filtered)) {
			return eval("(" + src + ")")
		} else {
			throw new SyntaxError("Error parsing JSON, source is not valid.")
		}
	};
	$.quoteString = function(string) {
		if (string.match(_escapeable)) {
			return '"'
					+ string.replace(_escapeable, function(a) {
						var c = _meta[a];
						if (typeof c === "string") {
							return c
						}
						c = a.charCodeAt();
						return "\\u00" + Math.floor(c / 16).toString(16)
								+ (c % 16).toString(16)
					}) + '"'
		}
		return '"' + string + '"'
	};
	$.escapeString = function(string) {
		if (string.match(_escapeable)) {
			return string.replace(_escapeable, function(a) {
						var c = _meta[a];
						if (typeof c === "string") {
							return c
						}
						c = a.charCodeAt();
						return "\\u00" + Math.floor(c / 16).toString(16)
								+ (c % 16).toString(16)
					})
		}
		return string
	};
	var _escapeable = /["\\\x00-\x1f\x7f-\x9f]/g;
	var _meta = {
		"\b" : "\\b",
		"\t" : "\\t",
		"\n" : "\\n",
		"\f" : "\\f",
		"\r" : "\\r",
		'"' : '\\"',
		"\\" : "\\\\"
	}
})(jQuery);
Power.code.encode = $.toJSON;
Power.code.decode = $.evalJSON;
Power.code.escapeString = $.escapeString;
Power.code.guid = function(a) {
	var b = "";
	for ( var c = 1; c <= 32; c++) {
		var d = Math.floor(Math.random() * 16).toString(16);
		b += d;
		if (a) {
			if ((c == 8) || (c == 12) || (c == 16) || (c == 20)) {
				b += "-"
			}
		}
	}
	return b
};
Power.code.unicodeToByte = function unicodeToByte(c) {
	var a = [];
	for ( var b = 0; b < c.length; b++) {
		a.push(c.charCodeAt(b) >> 8, c.charCodeAt(b) & 255)
	}
	return a
};
Power.code.byteToUnicode = function byteToUnicode(a) {
	for ( var b = 0; b < a.length; b += 2) {
		result += String.fromCharCode((a[b] << 8) + a[b + 1])
	}
	return result
};
Power.code.encodeBase64 = function encodeBase64(f) {
	var d, b = "", c = 0;
	var a = Power.code.unicodeToByte(f);
	c = a.length % 3;
	if (c == 1) {
		a.push(0, 0)
	} else {
		if (c == 2) {
			a.push(0)
		}
	}
	for ( var e = 0; e < a.length; e += 3) {
		d = (a[e] << 16) + (a[e + 1] << 8) + a[e + 2];
		b += map.charAt(d >> 18) + map.charAt(d >> 12 & 63)
				+ map.charAt(d >> 6 & 63) + map.charAt(d & 63)
	}
	if (c == 1) {
		resultresult = b.replace(/AA$/g, "==")
	} else {
		if (c == 2) {
			resultresult = b.replace(/A$/g, "=")
		}
	}
	return b
};
Power.code.decodeBase64 = function decodeBase64(str) {
	var s = "var base64={";
	for ( var i = 0; i < 64; i++) {
		s += '"' + map.charAt(i) + '":' + i + ","
	}
	s += '"=":0};';
	eval(s);
	var buffer, result = [];
	for (i = 0; i < str.length; i += 4) {
		buffer = (base64[str.charAt(i)] << 18)
				+ (base64[str.charAt(i + 1)] << 12)
				+ (base64[str.charAt(i + 2)] << 6) + base64[str.charAt(i + 3)];
		result.push(buffer >> 16, buffer >> 8 & 255, buffer & 255)
	}
	if (/==$/g.test(str)) {
		result.pop();
		result.pop()
	} else {
		if (/=$/g.test(str)) {
			result.pop()
		}
	}
	return Power.byteToUnicode(result)
};
Power.code.urlEncode = function(a) {
	if (!a) {
		return ""
	}
	var b = [];
	for ( var h in a) {
		var c = a[h], d = encodeURIComponent(h);
		var g = typeof c;
		if (g == "undefined") {
			b.push(d, "=&")
		} else {
			if (g != "function" && g != "object") {
				b.push(d, "=", encodeURIComponent(c), "&")
			} else {
				if (LEx.isDate(c)) {
					var j = LEx.encode(c).replace(/"/g, "");
					b.push(d, "=", j, "&")
				} else {
					if (LEx.isArray(c)) {
						if (c.length) {
							for ( var e = 0, f = c.length; e < f; e++) {
								b
										.push(
												d,
												"=",
												encodeURIComponent(c[e] === undefined ? ""
														: c[e]), "&")
							}
						} else {
							b.push(d, "=&")
						}
					}
				}
			}
		}
	}
	b.pop();
	return b.join("")
};
Power.code.urlDecode = function(f, h) {
	if (!f || !f.length) {
		return {}
	}
	var d = {};
	var b = f.split("&");
	var c, a, j;
	for ( var e = 0, g = b.length; e < g; e++) {
		c = b[e].split("=");
		a = decodeURIComponent(c[0]);
		j = decodeURIComponent(c[1]);
		if (h !== true) {
			if (typeof d[a] == "undefined") {
				d[a] = j
			} else {
				if (typeof d[a] == "string") {
					d[a] = [ d[a] ];
					d[a].push(j)
				} else {
					d[a].push(j)
				}
			}
		} else {
			d[a] = j
		}
	}
	return d
};
Power.code.encodeHtml = function(b) {
	var a = "";
	if (b.length == 0) {
		return ""
	}
	a = b.replace(/&/g, "&gt;");
	a = a.replace(/</g, "&lt;");
	a = a.replace(/>/g, "&gt;");
	a = a.replace(/ /g, "&nbsp;");
	a = a.replace(/\'/g, "&#39;");
	a = a.replace(/\"/g, "&quot;");
	a = a.replace(/\n/g, "<br>");
	return a
};
Power.code.decodeHtml = function(b) {
	var a = "";
	if (b.length == 0) {
		return ""
	}
	a = b.replace(/&gt;/g, "&");
	a = a.replace(/&lt;/g, "<");
	a = a.replace(/&gt;/g, ">");
	a = a.replace(/&nbsp;/g, " ");
	a = a.replace(/&#39;/g, "'");
	a = a.replace(/&quot;/g, '"');
	a = a.replace(/<br>/g, "\n");
	return a
};
Power.code.Encoder = (function create_Encoder() {
	var a = {
		encode : function(c) {
			return String.replace(/./g, function(e, d) {
				return e.match(/[\w\d]/) ? e : "%"
						+ e.charCodeAt(0).toString(16).toUpperCase()
			})
		},
		decode : function(c) {
			return String.replace(/%[0-9A-Fa-f]{2}/g, function(e, d) {
				return String.fromCharCode(parseInt(e.substring(1), 16))
			})
		}
	};
	var b = {
		encode : function(c) {
			return String.replace(/./g, function(e, d) {
				return e.match(/[\w\d]/) ? e : "&#" + e.charCodeAt(0) + ";"
			})
		},
		decode : function(c) {
			return String.replace(/&#[0-9]+;/g, function(e, d) {
				return String.fromCharCode(e.match(/[0-9]+/)[0])
			})
		}
	};
	return {
		encodeUrl : a.encode,
		decodeUrl : a.decode,
		encodeHtml : b.encode,
		decodeHtml : b.decode
	}
})();
Power.util = {};
if (Power.util.format == null) {
	Power.util.format = {}
}
String.prototype.startWith = function(b) {
	var a = new RegExp("^" + b);
	return a.test(this)
};
String.prototype.endWith = function(b) {
	var a = new RegExp(b + "$");
	return a.test(this)
};
String.prototype.trim = function() {
	return this.replace(/(^\s*)|(\s*$)/g, "")
};
String.prototype.IsInt = function() {
	if (this == "NaN") {
		return false
	}
	return this == parseInt(this).toString()
};
String.prototype.left = function(a) {
	return this.slice(0, a)
};
String.prototype.right = function(a) {
	return this.slice(this.length - a)
};
String.prototype.HTMLEncode = function() {
	var c = this;
	var a = [ /x26/g, /x3C/g, /x3E/g, /x20/g ];
	var d = [ "&", "<", ">", " " ];
	for ( var b = 0; b < a.length; b++) {
		c = c.replace(a[b], d[b])
	}
	return c
};
String.prototype.ascW = function() {
	var a = "";
	for ( var b = 0; b < this.length; b++) {
		a += "&#" + this.charCodeAt(b) + ";"
	}
	return a
};
String.prototype.format = function() {
	var a = arguments;
	return this.replace(/\{(\d+)\}/g, function(c, b) {
		return a[b]
	})
};
Date.prototype.format = function(a) {
	var d = {
		"M+" : this.getMonth() + 1,
		"d+" : this.getDate(),
		"h+" : this.getHours() % 12 == 0 ? 12 : this.getHours() % 12,
		"H+" : this.getHours(),
		"m+" : this.getMinutes(),
		"s+" : this.getSeconds(),
		"q+" : Math.floor((this.getMonth() + 3) / 3),
		S : this.getMilliseconds()
	};
	var c = {
		"0" : "\u65e5",
		"1" : "\u4e00",
		"2" : "\u4e8c",
		"3" : "\u4e09",
		"4" : "\u56db",
		"5" : "\u4e94",
		"6" : "\u516d"
	};
	if (/(y+)/.test(a)) {
		a = a.replace(RegExp.$1, (this.getFullYear() + "")
				.substr(4 - RegExp.$1.length))
	}
	if (/(E+)/.test(a)) {
		a = a
				.replace(
						RegExp.$1,
						((RegExp.$1.length > 1) ? (RegExp.$1.length > 2 ? "\u661f\u671f"
								: "\u5468")
								: "")
								+ c[this.getDay() + ""])
	}
	for ( var b in d) {
		if (new RegExp("(" + b + ")").test(a)) {
			a = a.replace(RegExp.$1, (RegExp.$1.length == 1) ? (d[b])
					: (("00" + d[b]).substr(("" + d[b]).length)))
		}
	}
	return a
};
Date.MONTH_DAYS = [ 31, 0, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 ];
Date.ENG_MONTH_MAP = {
	Jan : 1,
	Feb : 2,
	Mar : 3,
	Apr : 4,
	May : 5,
	Jun : 6,
	Jul : 7,
	Aug : 8,
	Sep : 9,
	Oct : 10,
	Nov : 11,
	Dec : 12
};
Date.MONTH_ENG_MAP = [ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug",
		"Sep", "Oct", "Nov", "Dec" ];
Date.prototype.diffDayHourString = function(c) {
	var d = this;
	var b;
	if (typeof d == "object") {
		b = c.getTime() - d.getTime()
	} else {
		b = c - d
	}
	var f = Math.floor(b / (24 * 3600 * 1000));
	var e = b % (24 * 3600 * 1000);
	var a = Math.floor(e / (3600 * 1000));
	return f + "D " + a + "H"
};
Date.prototype.addTime = function(c) {
	var a = this;
	var b = new Date(a - 0 + c * 86400000);
	return b
};
Date.prototype.addMonth = function(b) {
	var a = this;
	a.setMonth(a.getMonth() + b);
	return a
};
Date.prototype.addYear = function(b) {
	var a = this;
	a.setFullYear(a.getFullYear() + b);
	return a
};
Date.prototype.addHour = function(b) {
	var a = this;
	a.setHours(a.getHours() + b);
	return a
};
Date.prototype.addMinute = function(b) {
	var a = this;
	a.setMinutes(a.getMinutes() + b);
	return a
};
Date.prototype.getChinaMonth = function() {
	var b = this;
	var a = b.getMonth() + 1;
	if (a > 9) {
		return a.toString()
	}
	return "0" + a
};
Date.prototype.diffHourInt = function(c) {
	var d = this;
	var b;
	if (typeof d == "object") {
		b = c.getTime() - d.getTime()
	} else {
		b = c - d
	}
	var f = Math.floor(b / (24 * 3600 * 1000));
	var e = b % (24 * 3600 * 1000);
	var a = Math.floor(e / (3600 * 1000));
	return f * 24 + a
};
Date.prototype.getMonthDays = function(a, b) {
	a -= 0;
	b -= 0;
	if (b == 1) {
		if (0 == a % 4 && ((a % 100 != 0) || (a % 400 == 0))) {
			return 29
		} else {
			return 28
		}
	} else {
		return Date.MONTH_DAYS[b]
	}
};
Date.prototype.getMonthWeek = function() {
	var b = this, a = b.getDay(), c = b.getDate();
	return Math.ceil((c + 6 - a) / 7)
};
Date.prototype.getYearWeek = function() {
	var b = this, a = new Date(b.getFullYear(), 0, 1), c = Math.round((b
			.valueOf() - a.valueOf()) / 86400000);
	return Math.ceil((c + (((a.getDay() || 7) + 1) - 1)) / 7)
};
Power.util.format.formatDate = function(v, dateFormat) {
	try {
		if (dateFormat == undefined || typeof dateFormat != "string") {
			dateFormat = "yyyy-MM-dd"
		}
		if ((typeof v) == "number") {
			var o = new Date(v * 1000);
			return o.format(dateFormat)
		}
		if ((typeof v) == "string" && v.indexOf("/Date(") == 0) {
			var date = eval("new " + eval(v).source);
			return date.format(dateFormat)
		}
		if (v.time) {
			var o = new Date(v.time);
			return o.format(dateFormat)
		} else {
			if (v != "") {
				v = v.replace(/\//g, "-");
				if (v.split(" ")) {
					var myDate = v.split(" ")[0]
				} else {
					var myDate = v
				}
				myDate = myDate.replace("-0", "-").replace("-0", "-");
				var nowDate = new Date();
				if (myDate.split("-")[0] == nowDate.getFullYear()) {
					return myDate.split("-")[1] + "月" + myDate.split("-")[2]
							+ "日"
				} else {
					return myDate.split("-")[0] + "年" + myDate.split("-")[1]
							+ "月" + myDate.split("-")[2] + "日"
				}
			}
		}
	} catch (e) {
	}
	return ""
};
Power.util.format.formatJson = function(str) {
	var json = eval("(" + str + ")");
	return json
};
Power.util.format.formatNumber = function(b) {
	var a = (b * 100).toString().substring(0, 6);
	return "<font size='1'>" + a + "%</font>"
};
Power.util.format.formatUtil = function(a, b) {
	a = parseFloat(a);
	if (a < 10000) {
		if (b == "天") {
			return a.toFixed(2) + "" + b
		} else {
			return a.toFixed(0) + "" + b
		}
	} else {
		if (a < 100000000 && a >= 10000) {
			return parseFloat(a / 10000).toFixed(2) + "万" + b
		} else {
			return parseFloat(a / 100000000).toFixed(2) + "亿" + b
		}
	}
	return a + "" + b
};
Power.util.format.formatDateX = function(c) {
	if (c) {
		if (c.length > 0) {
			if (c.split(" ")) {
				var b = c.split(" ")[0]
			} else {
				var b = c
			}
			b = b.replace("-0", "-").replace("-0", "-");
			var a = new Date();
			if (b.split("-")[0] == a.getFullYear()) {
				return b.split("-")[1] + "月" + b.split("-")[2] + "日"
			} else {
				return b.split("-")[0] + "年" + b.split("-")[1] + "月"
						+ b.split("-")[2] + "日"
			}
		}
	}
};
Power.util.format.formatMoney = function(a) {
	a = a.toString().replace(/\$|\,/g, "");
	if (isNaN(a)) {
		a = "0"
	}
	sign = (a == (a = Math.abs(a)));
	a = Math.floor(a * 100 + 0.50000000001);
	cents = a % 100;
	a = Math.floor(a / 100).toString();
	if (cents < 10) {
		cents = "0" + cents
	}
	for ( var b = 0; b < Math.floor((a.length - (1 + b)) / 3); b++) {
		a = a.substring(0, a.length - (4 * b + 3)) + ","
				+ a.substring(a.length - (4 * b + 3))
	}
	return (((sign) ? "" : "-") + "¥" + a + "." + cents)
};
Power.util.makerTotal = function(b) {
	if (b.id == null) {
		alert("此方法至少需要提供【id】参数");
		return
	}
	if (b.startCol == null) {
		b.startCol = 1
	}
	if (b.startRow == null) {
		b.startRow = 1
	}
	if (b.dm == null) {
		b.dm = 2
	}
	if (b.allowFoot == null) {
		b.allowFoot = true
	}
	if (b.ignore == null) {
		b.ignore = []
	}
	if (b.align == null) {
		b.align = "center"
	}
	var m = $("#" + b.id);
	var f = 0;
	var n = m.find("tr:first");
	var c = m.find("tfoot");
	if (c != null) {
		c.html("")
	}
	var j = n.find("td,th");
	var e = [];
	j.each(function(o) {
		var d = 1;
		try {
			d = $(this).attr("colSpan");
			if (null != d) {
				d = 1
			}
		} catch (q) {
			d = 1
		}
		for ( var o = 0; o < d; o++) {
			var p = {};
			p.num = 0;
			p.show = $(this).css("display");
			e[f + o] = p
		}
		f += d
	});
	var g = m.find("tr");
	g.each(function(o) {
		if (o >= b.startRow) {
			var i = $(this);
			var d = i.find("td,th");
			d.each(function(p) {
				if (p >= b.startCol) {
					var u = $(this);
					u.css("text-align", b.align);
					var q = false;
					for ( var r = 0; r < b.ignore.length; r++) {
						if (p == b.ignore[r]) {
							q = true;
							break
						}
					}
					if (!q) {
						var t = 0;
						if (u.html() == "") {
							u.html("—")
						} else {
							try {
								t = parseFloat(u.html())
							} catch (s) {
							}
							if (!isNaN(t)) {
								if (t != 0) {
									u.html(t.toFixed(b.dm));
									if (e[p] == undefined) {
										e[p] = {};
										e[p].num = 0
									}
									e[p].num = e[p].num + t
								} else {
									u.html("—")
								}
							}
						}
					}
				}
			})
		}
	});
	var l = [];
	l.push("<tr style='background:#F3F3F3;'>");
	l
			.push("<td style='text-align:center;border-top:solid 1px #dddddd;' colspan=\""
					+ b.startCol + '">合计</td>');
	for ( var a = 0; a < e.length; a++) {
		if (a >= b.startCol) {
			var k = "—";
			if (e[a] != null && e[a].num != 0) {
				k = e[a].num.toFixed(b.dm)
			}
			l.push("<td style='text-align:" + b.align
					+ ";border-top:solid 1px #dddddd;display:" + e[a].show
					+ ";'>" + k + "</td>")
		}
	}
	l.push("</tr>");
	if (b.allowFoot) {
		var h = document.getElementById(b.id);
		if (h.tFoot == null) {
			h.createTFoot()
		}
		m.find("tfoot").html(l.join(""))
	} else {
		m.find("tbody").append(l.join(""))
	}
};

/**
 * dfsupload文件上传
 */
Power.dfsupload = function(uploadId, callback, fileId, fileNameId,config) {
	if (uploadId == null) {
		uploadId = "uploader";
	}
	if (fileId == null) {
		fileId = "#file_id";
	}
	if (fileNameId == null) {
		fileNameId = "#file_name";
	}
	if(config==null){
		config = {};
	}
	if(config.url==null){
		config.url = WebFinal.rootPath + 'upload/dfsupload';
	}
	if(config.max_file_size==null){
		config.max_file_size = '10mb';
	}
	if(config.max_file_size==null){
		config.mime_types = [ {
			title : "Office files",
			extensions : "doc,docx,xls,xlsx,ppt,pptx"
		}, {
			title : "Image files",
			extensions : "jpg,gif,png"
		}, {
			title : "PDF files",
			extensions : "pdf"
		}, {
			title : "Zip files",
			extensions : "zip"
		} ];
	}
	var uploader = new plupload.Uploader(
			{
				runtimes : 'html5,flash,silverlight,html4',
				browse_button : uploadId, // you can pass an id...'uploader'
				url : config.url,
				flash_swf_url : WebFinal.rootPath
						+ '/static/js/upload/Moxie.swf',
				silverlight_xap_url : WebFinal.rootPath
						+ '/static/js/upload/Moxie.xap',
				filters : {
					max_file_size : config.max_file_size,
					mime_types : config.mime_types,
					prevent_duplicates : true
				// 不允许选取重复文件
				},
				init : {
					PostInit : function() {
					},
					FilesAdded : function(up, files) {
						plupload.each(files, function(file) {
							$(fileId).val(file.id);
							$(fileNameId).val(file.name);
						});
						var file = $(fileNameId).val();
						if (file != null && file.length > 1) {
							uploader.start(); // 调用实例对象的start()方法开始上传文件，当然你也可以在其他地方调用该方法
						} else {
							Power.dialog
									.alert( "<font color='red'><@webfinal.m 'webfinal.app.selectFile'/></font>");
						}
					},
					UploadProgress : function(up, file) {
						// var wid = $(fileNameId).width()*(file.percent/100);
						// $("#sample").css("border-bottom:1px solid blue");
						// document.getElementById(file.id).getElementsByTagName('b')[0].innerHTML
						// = '<span>' + file.percent + "%</span>";
					},
					FileUploaded : function(up, file, responseObject) {
						if (responseObject.status == 200) {
							var response = JSON.parse(responseObject.response);
							if (response.code == "0000") {
								//网络错误
								Power.dialog
										.alertError("网络错误：<font color='red'>"
												+ response.msg + "</font>");
							} else if(response.code == "0002"){
								Power.dialog
								.alertError("格式错误：<font color='red'>"
										+ response.msg + "</font>");
							}else {
								Power.dialog
										.alertSuccess("<font color='green'>恭喜您，上传成功！</font>");
								callback(response);
							}
							// alert(responseObject.response);
						} else {
							Power.dialog
									.alertError("<font color='red'>对不起，上传失败！</font>");
						}
					},
					Error : function(up, err) {
						Power.dialog.alertError("Error #" + err.code + ": "
								+ err.message);
					}
				}
			});
	uploader.init();
	return uploader;
};