var SysOrganAuditDlg = {
    SysOrganAuditData: {}
};
layui.use(['jquery', 'layer', 'Hussar', 'HussarAjax', "form", "table", "laydate"], function () {

    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var layer = layui.layer;
    var $ax = layui.HussarAjax;
    var form = layui.form;
    var table = layui.table;
    var table1;
    var layerView;

    var SysOrganAudit = {
        seItem: null,
        type: null,
    };

    /**
     * 初始化按钮事件
     */
    SysOrganAudit.initButtonEvent = function () {
        $("#btnClose").click(function () {
            SysOrganAudit.closeIndex();
            layer.closeAll();
        });
        //重置
        $("#reset").click(function () {
            SysOrganAudit.reset();
        });
        //查询
        $("#search").click(function () {
            SysOrganAudit.search();
        });
    };
    /**
     * 查询
     */
    SysOrganAudit.search = function () {
        var organName = $('#organName').val();
        var type = $('#type').val();
        SysOrganAudit.initTable()
    }
    /**
     * 重置
     */
    SysOrganAudit.reset = function () {
        $('#organName').val("");
        $('#type').val("");
        // 执行重载
     //   SysOrganAudit.search();
    }

    /**
     * 查看
     */
    SysOrganAudit.view = function (struId, type, realStruId, state) {
        var width;
        //如果是新增 删除
        if ("1" == type || "3" == type) {
            width = "550px"
        } else {
            width = "700px"
        }
        layer.open({
            type: 2,
            area: [width, '500px'],
            title: "查看详情",
            shadeClose: true,
            maxmin: false,
            content: Hussar.ctxPath + '/sysStruAudit/detail?struId=' + struId + '&type=' + type + '&realStruId=' + realStruId + '&state=' + state,
            skin: 'confirm-class'
        });
    }

    /**
     * 审核
     */
    SysOrganAudit.verify = function (struId, type, inUse, realStruId) {
        var ac = "通过"
        if ("2" == type) {
            ac = "驳回"
        }
        var operation = function () {
            var ajax = new $ax(Hussar.ctxPath + "/sysStruAudit/verify",
                function (data) {
                    if (data.code == 200) {
                        $(".layui-laypage-btn").click();
                        Hussar.success(ac + "成功！");
                        SysOrganAudit.search()
                    } else {
                        Hussar.error(ac + "失败！")
                    }
                }, function (data) {
                    Hussar.error(ac + "失败！");
                });
            ajax.set("struId", struId);
            ajax.set("type", type);
            ajax.set("inUse", inUse);
            ajax.set("realStruId", realStruId);
            ajax.start();
        };
        Hussar.confirm("确定要" + ac + "吗 ?", operation);
    }
    /**
     * 获取状态option
     */
    SysOrganAudit.queryOption = function () {
        var ajax = new $ax(Hussar.ctxPath + "/userRoleReview/statusOption",
            function (json) {
                $("#type").html("");
                for (var i = 0; i < json.length; i++) {
                    $("#type").append("<option value='" + json[i].value + "'>" + json[i].label + "</option>");
                }
                form.render();
            }, function (data) {
                Hussar.error("获取审核类型失败！");
            });
        ajax.start();
    };
    /**
     * 初始化列表
     */
    SysOrganAudit.initTable = function () {
        layui.use('table', function () {
            var table = layui.table;
            var type = $("#type option:selected").val();
            var str = [{type: 'checkbox', width: 40},
                {
                title: '序号',
                type: 'numbers',
                align: 'center'
            }, {
                field: 'ORGANNAME',
                title: '组织机构名称',
                align: 'center',
                sort: false
            }, {
                field: 'TYPENAME',
                width: 100,
                title: '类型',
                align: 'center',
                sort: false
            }, {
                field: 'PARENTNAME',
                title: '上级组织机构名称',
                align: 'center',
                sort: false
            }, {
                field: 'INUSE',
                title: '操作类型',
                width: 100,
                sort: false,
                align: 'center',
                templet: function (value) {
                    if (value.INUSE == '1') {
                        return "新增"
                    } else if (value.INUSE == '2') {
                        return "修改"
                    } else if (value.INUSE == '3') {
                        return "删除"
                    } else if (value.INUSE == '4') {
                        return "转移"
                    } else {
                        return ""
                    }
                }
            }, {
                field: 'STATE',
                title: '审核类型',
                sort: false,
                width: 100,
                align: 'center',
                templet: function (value) {
                    if (value.STATE == '0') {
                        return "未审核"
                    } else if (value.STATE == '1') {
                        return "已通过"
                    } else if (value.STATE == '2') {
                        return "已驳回"
                    } else {
                        return ""
                    }
                }
            }, ]

            if (type == "0"){
                str.push({
                    field: 'operate',
                    title: '操作',
                    width: 300,
                    sort: false,
                    align: 'center',
                    toolbar: "#operate"
                })
            }
            table.render({
                elem: '#SysOrganAudit',
                height: $("body").height() - $(".layui-form").outerHeight(true) - 26,
                url: Hussar.ctxPath + '/sysStruAudit/list',
                cols: [str],
                page: true,
                id: 'SysOrganAudit',
                even: true,
                limit: 10,
                where: {
                    type: type
                }
            });
            table1 = table;
        });
    };
    //监听工具条
    table.on('tool(SysOrganAudit)', function (obj) {
        var data = obj.data;
        if (obj.event === 'view') {
            SysOrganAudit.view(data.STRUID, data.INUSE, data.REALSTRUID, data.STATE)
        } else if (obj.event === 'pass') {
            SysOrganAudit.verify(data.STRUID, "1", data.INUSE, data.REALSTRUID)
        } else {
            SysOrganAudit.verify(data.STRUID, "2", data.INUSE, data.REALSTRUID)
        }
    })
    /**
     * 初始化
     */
    $(function () {
        SysOrganAudit.queryOption();
        SysOrganAudit.initTable();
        SysOrganAudit.initButtonEvent();
    });

    SysOrganAudit.closeIndex = function () {
        layer.close(layerView);
        SysOrganAudit.search()
    }

    /**
     * 关闭此对话框
     */
    SysOrganAuditDlg.close = function () {
        SysOrganAudit.closeIndex();
    };
});
