/**
 * TextAreaAutoHeight
 * TextArea 文本域自动调整高度 
 */

(function (factory) {
    if (typeof define === 'function' && define.amd) {
        define(['jquery'], factory);
    }
    else if (window.layui && layui.define) {
        layui.define(['jquery'], function (exports) { //layui加载
            exports('autoHeight', factory(layui.jquery));
        });
    }
    else {
        // No AMD. Register plugin with global jQuery object.
        factory(jQuery);
    }
}(function ($) {
	$.fn.autoHeight = function(){
	    function autoHeight(elem){
	        elem.style.height = 'auto';
	        elem.scrollTop = 0; //防抖动
	        elem.style.height = elem.scrollHeight + 'px';
	    }
	    this.each(function(){
	        autoHeight(this);
	        $(this).on('keyup', function(){
	            autoHeight(this);
	        });
	    });
	}
	$('textarea[autoHeight]').autoHeight();
}));