layui.define([ 'jquery', 'layer', 'HussarEncrypt' ], function(exports) {
    var $ = layui.jquery;
    var layer = layui.layer;
    var HussarEncrypt = layui.HussarEncrypt;
    var HussarAjax = function(url, success, error) {
        this.url = url;
        this.type = "post";
        this.data = {};
        this.dataType = "";
        // this.contentType = "application/json",
        this.contentType = "application/x-www-form-urlencoded;charset=UTF-8",
        this.async = false;
        this.success = success;
        this.error = error;
        this.encryptEnable = false;
        this.csrfToken = "";
    };

    HussarAjax.prototype = {

        /**
		 * 密码重鉴别请求
		 */
        start: function () {
            var me = this;
            var reUrl = this.url;
            var flag;
            $.ajax({
                url: "/resource/checkResource",
                async: false,
                data: {"resourceUrl": reUrl},
                success: function (result) {
                    flag = result.flag;
                    me.csrfToken = result.csrfToken;
                }
            });
            if (flag===true) {
                var isclose = false
                var msg = ''
                repeatDialog = layer.open({
                    type: 2,
                    area: ['420px', '220px'],
                    title: "二次验证",
                    shadeClose: true,
                    maxmin: false,
                    content: hussar_path + '/exception/repeat',
                    skin: 'confirm-class',
                    btn: ['取消', '确定'],
                    btn2: function (index) {
                        window["layui-layer-iframe" + index].callbackdata(function (userName, cipher) {
                            if (cipher == null || cipher == "" || cipher == undefined) {
                                msg = '动态密码不能为空'
                                isclose = false
                            } else {
                                $.ajax({
                                    url: "/user/reChecking",
                                    async: false,
                                    data: {"userName": userName, "cipher": cipher, "reUrl": reUrl},
                                    success: function (result) {
                                        if (!result) {
                                            msg = '动态密码错误'
                                            isclose = false
                                        } else {
                                            isclose =true
                                            layer.close(index);
                                            me.realStart()
                                        }
                                    }
                                });
                            }

                        });
                        if (!isclose) {
                            layer.msg(msg, {icon: 2});
                            return false
                        }
                    }
                });
            } else {
                this.realStart()
            }
        },

        /**
		 * 数据请求
		 */
        realStart : function() {
            var me = this;

            if (this.url.indexOf("?") == -1) {
                this.url = this.url + "?jstime=" + new Date().getTime();
            } else {
                this.url = this.url + "&jstime=" + new Date().getTime();
            }

            $.ajax({
                type : this.type,
                url : this.url,
                dataType : this.dataType,
                contentType: this.contentType,
                async : this.async,
                data : this.data,
                beforeSend : function(xhr) {
                	xhr.setRequestHeader("x-csrf-token",me.csrfToken)
                    if (me.encryptEnable) {
                        xhr.setRequestHeader("Content-Type", "application/encryptjson");
                        var params = arguments[1].data; // urlcode编码格式的数据,需转成json
                        var contentType  = arguments[1].contentType;
                        if("application/json" == contentType && params.length>0){
                            var jsonData = {}
                            var array = params.split("&");
                            $(array).each(function (i) {
                                jsonData[decodeURIComponent(array[i].split("=")[0],true)] = decodeURIComponent(array[i].split("=")[1],true);
                            })
                            var enc = new HussarEncrypt();
                            var paramsString = enc.encrypt(JSON.stringify(jsonData));
                            // 修改参数
                            arguments[1].data = paramsString;
                        }
                    }
                },
                success : function(responsedata, textStatus, request) {

                    try{
                        var dataJson;
                        if(typeof responsedata == 'string'){
                            if(responsedata.trim().startsWith("{") && responsedata.trim().endsWith("}")){
                                dataJson = JSON.parse(responsedata);
                            }
                        }else{
                            dataJson = responsedata;
                        }
                        if(dataJson.code == 300){
                            var tips = dataJson.message;
                            if(tips!='' && tips != undefined){
                                var url = window.location.href;
                                if(url.indexOf("?")>0){
                                    url = url +"&tips=" + tips;
                                }else{
                                    url = url +"?tips=" + tips;
                                }
                            }
                            top.location.href = url;
                        }
                    }catch(e){
                    	console.debug(e);
                    }


                    var responseJson;
                    if(typeof responsedata == 'string'){
                        try{
                            responseJson = JSON.parse(responsedata);
                        }catch(err){
                            me.success(responsedata);
                            return;
                        }
                    }
                    else{
                        responseJson = responsedata;
                    }

                    var contentType = request.getResponseHeader('content-type')
                    if("application/encryptjson"== contentType &&  responseJson.key && responseJson.data){
                        var enc = new HussarEncrypt();
                        var data = enc.decrypt(responseJson);
                        me.success(data);
                    }else{
                        me.success(responsedata);
                    }
                },
                error : function(data) {
                    if (data.responseJSON === undefined) {
                        window.location.href = hussar_path + "/login";
                        return false;
                    }
                    var responseJson = data.responseJSON;
                    var contentType = data.getResponseHeader("content-type");
                    if("application/encryptjson"== contentType && responseJson.key && responseJson.data){
                        var enc = new HussarEncrypt();
                        responseJson = enc.decrypt(responseJson);

                    }
                    if (responseJson.result == "NOPERMISSION") {
                        window.location.href = hussar_path
                            + "/exception/noPermission";
                        return false;
                    }
                    if (responseJson.result == "UNAUTHENTICATED") {
                        window.location.href = hussar_path + "/login";
                        return false;
                    }
                    if (responseJson.result == "REPLAY") {
                        window.location.href = hussar_path
                            + "/exception/exception";
                        return false;
                    }

                    if (responseJson.result == "NOTREPEATAUTHENTICATE") {
                        layer.msg("密码错误！", {
                            icon : 2
                        });
                        return false;
                    }

                    if (responseJson.result == "UNKNOWNEXCEPTION") {
                        layer.msg("系统未知异常！", {
                            icon : 2
                        });
                        return false;
                    }
                    me.error(responseJson);
                }
            });
        },

        set : function(key, value) {
            if (typeof key == "object") {
                for ( var i in key) {
                    if (typeof i == "function")
                        continue;
                    this.data[i] = key[i];
                }
            } else {
                this.data[key] = (typeof value == "undefined") ? $("#" + key)
                    .val() : value;
            }
            return this;
        },

        setData : function(data) {
            if(this.encryptEnable){
                if(typeof data == 'string'){
                    try{
                        this.data = JSON.parse(data);
                    }catch(err){
                        this.data = data;
                    }
                }else{
                    this.data = data;
                }
            }else{
                if(this.contentType == "application/json"){
                    this.data = JSON.stringify(data);
                }else{
                    this.data = data;
                }
            }
            return this;
        },

        clear : function() {
            this.data = {};
            return this;
        },

        setAsync : function(data) {
            this.async = data;
            return this;
        },

        setDataType : function(data) {
            this.dataType = data;
            return this;
        },

        setContentType : function(data) {
            this.contentType = data;
            return this;
        },

        setEncryptEnable : function(flag) {
            this.encryptEnable = new Boolean(flag).valueOf();
            if(this.encryptEnable){
                this.setDataType("json").setContentType("application/json");
                if(JSON.stringify(this.data) != "{}"){
                    try{
                        this.data = JSON.parse(this.data);
                    }catch(err){
                        console.log(err);
                    }
                }
            }
            return this;
        }
    };

    window.HussarAjax = HussarAjax;

    exports('HussarAjax', HussarAjax);
});