/**
* @Description:    工作日历事件操作脚本文件
* @Author:         LiangDong
* @CreateDate:     2019/2/14 16:01
* @UpdateUser:     LiangDong
* @UpdateDate:     2019/2/14 16:01
* @UpdateRemark:   修改内容
* @Version:        1.0
*/
var EventOption = {
    layerIndex: -1
};
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','form','laydate'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer = layui.layer;
	var $ax = layui.HussarAjax;
	var form = layui.form;
	var laydate = layui.laydate;


    /**
     * 取消按钮关闭弹窗
     */
    EventOption.closeWin = function () {
        window.parent.layui.layer.close(window.parent.Calendar.layerIndex);
    };


    /**
     * 初始化时间控件
     */
    EventOption.initLaydate = function () {
        var ts = laydate.render({
            elem: '#start',
            type : 'date',
            trigger: 'click',
            done: function (value,date) {
                if (value !== '') {
                    te.config.min.year = date.year;
                    te.config.min.month = date.month - 1;
                    te.config.min.date = date.date;
                } else {
                    te.config.min.year = '';
                    te.config.min.month = '';
                    te.config.min.date = '';
                }
            }
        });
        var te = laydate.render({
            elem: '#end',
            type : 'date',
            trigger: 'click',
            done: function (value,date) {
                if (value !== '') {
                    ts.config.max.year = date.year;
                    ts.config.max.month = date.month - 1;
                    ts.config.max.date = date.date;
                } else {
                    ts.config.max.year = '2099';
                    ts.config.max.month = '11';
                    ts.config.max.date = '31';
                }
            }
        });

        var delts = laydate.render({
            elem: '#delstart',
            type : 'date',
            trigger: 'click',
            done: function (value,date) {
                if (value !== '') {
                    delte.config.min.year = date.year;
                    delte.config.min.month = date.month - 1;
                    delte.config.min.date = date.date;
                } else {
                    delte.config.min.year = '';
                    delte.config.min.month = '';
                    delte.config.min.date = '';
                }
            }
        });
        var delte = laydate.render({
            elem: '#delend',
            type : 'date',
            trigger: 'click',
            done: function (value,date) {
                if (value !== '') {
                    delts.config.max.year = date.year;
                    delts.config.max.month = date.month - 1;
                    delts.config.max.date = date.date;
                } else {
                    delts.config.max.year = '2099';
                    delts.config.max.month = '11';
                    delts.config.max.date = '31';
                }
            }
        });
    };



    /**
     *  新增保存
     */
    EventOption.save = function (data) {
        var formData = data.field;
        //将事件下拉框的显示内容[汉字]赋给事件字段title
        formData.title = $("select[name='title'] option:selected").text();
        var ajax = new $ax(Hussar.ctxPath + "/calendar/addEvent", function(data) {
            if (data.code == '200') {
                window.parent.Calendar.refreshCalendar();
            } else {
                Hussar.error(data.message);
            }
        }, function(data) {
            Hussar.error("保存失败！");
        });
        ajax.setData(formData);
        ajax.start();
    };

    /**
     *  新增单日事件保存
     */
    EventOption.saveOne = function (data) {
        var formData = data.field;
        //将事件下拉框的显示内容[汉字]赋给事件字段title
        formData.title = $("select[name='title'] option:selected").text();
        var ajax = new $ax(Hussar.ctxPath + "/calendar/addOneEvent", function(data) {
            if (data.code == '200') {
                window.parent.Calendar.refreshCalendar();
            }
        }, function(data) {
            Hussar.error("保存失败！");
        });
        ajax.setData(formData);
        ajax.start();
    };

    /**
     *  事件修改保存
     */
    EventOption.edit = function (data) {
        var formData = data.field;
        //将事件下拉框的显示内容[汉字]赋给事件字段title
        formData.title = $("select[name='title'] option:selected").text();
        var ajax = new $ax(Hussar.ctxPath + "/calendar/editEvent", function(data) {
            if (data.code == '200') {
                window.parent.Calendar.refreshCalendar();
            } else {
                Hussar.error("修改失败！");
            }
        }, function(data) {
            Hussar.error("修改失败！");
        });
        ajax.setData(formData);
        ajax.start();
    };

    /**
     *  删除单个事件
     */
    EventOption.delOne = function () {
        var id = $('#id').val();
        var ajax = new $ax(Hussar.ctxPath + "/calendar/delOneEvent", function(data) {
            if (data.code == '200') {
                window.parent.Calendar.refreshCalendar();
            } else {
                Hussar.error("删除失败！");
            }
        }, function(data) {
            Hussar.error("删除失败！");
        });
        ajax.set("id",id);
        ajax.start();
    };

    /**
     *  删除事件
     */
    EventOption.del = function (data) {
        var formData = data.field;
        var ajax = new $ax(Hussar.ctxPath + "/calendar/delEvent", function(data) {
            if (data.code == '200') {
                window.parent.Calendar.refreshCalendar();
            }
        }, function(data) {
            Hussar.error("删除失败！");
        });
        ajax.setData(formData);
        ajax.start();
    };

    /**
     * 初始化按钮事件
     */
    EventOption.initButtonEvent = function () {
        //新增保存按钮
        $("#btnSave").click(function(){
            form.on('submit(add)', function(data){
                EventOption.save(data);
            });
        });
        //新增单日事件保存按钮
        $("#btnSaveOne").click(function(){
            form.on('submit(addOne)', function(data){
                EventOption.saveOne(data);
            });
        });
        //修改按钮
        $("#btnEdit").click(function(){
            form.on('submit(edit)', function(data){
                EventOption.edit(data);
            });
        });
        //删除单个事件按钮
        $("#btnDeleteOne").click(function(){
            var operation = function () {
                EventOption.delOne();
            };
            Hussar.confirm("确定要删除该事件吗?", operation);
        });
        //确定删除按钮
        $("#btnDelete").click(function () {
            form.on('submit(del)', function(data){
                EventOption.del(data);
            });
        });
        //取消按钮
        $("button[name='btnClose']").click(function(){
            EventOption.closeWin();
        });

        //新增事件类型下拉框选择监听
        form.on('select(addtitle)', function(data){
            $('#className').val(data.value);
        });

        //新增单日事件类型下拉框选择监听
        form.on('select(addOneTitle)', function(data){
            $('#addOneClassName').val(data.value);
        });

        //修改事件类型下拉框选择监听
        form.on('select(edittitle)', function(data){
            $('#editClassName').val(data.value);
        })
    };

	$(function () {
        EventOption.initLaydate();     //初始化时间控件
        EventOption.initButtonEvent();     //初始化按钮事件
	});
	
});




