/**
 * 初始化用户欢迎页配置详情对话框
 */
var SysWelcomeInfoDlg = {
    sysWelcomeInfoData : {}
};

layui.use(['jquery', 'layer', 'Hussar', 'HussarAjax',"form"], function () {

    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var layer=layui.layer;
    var $ax=layui.HussarAjax;
    var form=layui.form;
    var table1;
    var layerView;

    var SysWelcome = {
        seItem: null,
        type:null
    };

    /**
     * 初始化按钮事件
     */
    SysWelcome.initButtonEvent = function () {
        $("#add").click(function(){
            SysWelcome.openAddSysWelcome();
        });
        $("#del").click(function(){
            SysWelcome.delete();
        });
        $("#btnClose").click(function(){
            SysWelcome.closeIndex();
            layer.closeAll();
        });
    };

    /**
     * 选中一条结果
     */
    SysWelcome.check = function() {
        var checkStatus = table1.checkStatus('SysWelcomeTable'),
            data = checkStatus.data;
        if (data.length == 0 || data.length > 1) {
            Hussar.info("请选择一条记录！");
            return false;
        } else {
            SysWelcome.seItem = data[0];
            return true;
        }
    };

    /**
     * 选中多条结果
     */
    SysWelcome.checks = function() {
        var checkStatus = table1.checkStatus('SysWelcomeTable'),
            data = checkStatus.data;
        var ids = "";
        if (data.length == 0) {
            Hussar.info("请至少选择一条记录！");
            return false;
        } else {
            for (var i = 0, l = data.length; i < l; i++) {
                ids += data[i].userId + ",";
            }
            SysWelcome.seItem = ids;
            return true;
        }
    };

    /**
     * 点击添加用户欢迎页配置
     */
    SysWelcome.openAddSysWelcome = function () {
        $("#select").attr("lay-verify","required");
        $("#val").show();
        $("#status").val("add");
        layerView=layer.open({
            type : 1,
            area : [ '400px', '300px' ],
            shadeClose : false,
            maxmin : false,
            title : '新增',
            content : $("#viewEvent"),
            success : function() {
                $('#addForm')[0].reset();
                form.render();
            },end : function() {
                $("#userName").val("");
                $("#userId").val("");
                $("#welcomeUrl").val("");
                $("#oldUrl").val("");
                form.render();
            }
        });
    };

    /**
     * 删除用户欢迎页配置
     */
    SysWelcome.delete = function () {
        if (SysWelcome.checks()) {
            var operation =function(){
                var ajax = new $ax(Hussar.ctxPath + "/sysWelcome/delete",
                    function(data) {
                        if (data.code == 200){
                            $(".layui-laypage-btn").click();
                            Hussar.success("删除成功！");
                            table1.reload();
                        }else {
                            Hussar.error("删除失败！")
                        }
                    }, function(data) {
                        Hussar.error("删除失败！");
                    });
                ajax.set("userIds",SysWelcome.seItem);
                ajax.start();
            };
            Hussar.confirm("确定要删除吗 ?", operation);
        }
    };


    SysWelcome.initTable = function () {
        layui.use('table', function () {
            var table = layui.table;
            table.render({
                elem: '#SysWelcomeTable',
                height: $("body").height() - $(".layui-form").outerHeight(true) - 26,
                url: Hussar.ctxPath + '/sysWelcome/list',
                cols: [
                    [{
                        type: 'checkbox',
                        width:40
                    },{
                        title: '序号',
                        type: 'numbers',
                        align: 'center'
                    }, {
                        field: 'userName',
                        title: '用户名',
                        sort:false,
                        align:'center'
                    }, {
                        field: 'welcomeUrl',
                        title: '访问地址',
                        align: 'center',
                        sort:false
                    },{
                        field: 'types',
                        title: '类型',
                        sort:false,
                        align:'center',
                        templet:function(value){
                            if (value.types === '1'){
                                return "角色";
                            }else {
                                return "人员";
                            }
                        }
                    }
                    ]],
                page: true,
                id: 'SysWelcomeTable',
                even: true,
                limit: 10
            });
            table1 = table;
        });
    }
    /**
     * 初始化
     */
    $(function () {
        SysWelcome.zero = $("#dataZero").val();
        SysWelcome.one = $("#dataOne").val();
        SysWelcome.initTable();
        SysWelcome.initButtonEvent(); //初始化按钮事件
    });
    SysWelcome.closeIndex = function () {
        layer.close(layerView);
        // 执行重载
        table1.reload('SysWelcomeTable', {
            page : {
                curr : 1
            }
        });
    }

    /**
     * 关闭此对话框
     */
    SysWelcomeInfoDlg.close = function() {
        SysWelcome.closeIndex();
    };
});
