/**
 * 表格的初始化
 */
var RedisThawPwd = {
    id: "RedisThawPwdTable",	//表格id
    seItem: null,		//选中的条目 array
    table: null,
    layerIndex: -1
};



layui.use(['jquery', 'layer', 'table', 'HussarAjax', 'Hussar'], function() {

    var  table = layui.table
        , $ = layui.jquery
        , $ax = layui.HussarAjax
        , Hussar = layui.Hussar;


    /**
     * 检查是否选中
     */
    RedisThawPwd.check = function () {
        var flag = false;
        var selected = table.checkStatus('RedisThawPwdTable').data;
        if (selected && selected.length > 0) {
            RedisThawPwd.seItem = selected;
            flag = true;
        } else {
            Hussar.info("请至少选择一条记录！");
        }
        return flag;
    };

    /**
     * 删除字段
     */
    RedisThawPwd.delete = function () {
        if (RedisThawPwd.check()) {
            var idArr = [];
            RedisThawPwd.seItem.forEach(function (v) {
                idArr.push(v.key);
            });
            var operation = function () {
                var ajax = new $ax(Hussar.ctxPath+"/thawPwd/deleteNoSQLKeys", function (data) {
                    if(data.status == 'success'){
                        Hussar.success("删除成功！");
                        RedisThawPwd.search();
                    }else{
                        Hussar.error("删除失败！（" + data.mess + "）")
                    }
                }, function (data) {
                    Hussar.error("删除失败！（" + data.responseJSON.message + "）");
                });
                ajax.set("keys", JSON.stringify(idArr));
                ajax.start();
            };

            Hussar.confirm("确定要删除吗？", operation);
        }
    };

    /**
     * 查询字段列表
     */
    RedisThawPwd.search = function () {
        table.reload('RedisThawPwdTable');
    };

    $(function () {
        var bodyH = $("body").height();
        $(".tree-box").css("height", bodyH + "px");

        table.render({
            elem: '#RedisThawPwdTable'
            ,url: Hussar.ctxPath+'/thawPwd/showRedisValue' //数据接口
            ,page: false //开启分页
            ,cols: [[ //表头
                {type:'checkbox', width: 40},
                {title: '序号', type: 'numbers',width:50},
                {title: '键名', field: 'key'},
                {title: '值', field: 'value'}
            ]]
            ,even: true
            ,height: bodyH - $(".layui-form").outerHeight(true)-26
        });
    });
});
