layui.use(['jquery', 'layer', 'Hussar', 'HussarAjax', 'element', 'form', 'table'], function () {
    var Hussar = layui.Hussar,
        table = layui.table;
    var $ = layui.jquery;
    var layer = layui.layer;
    var $ax = layui.HussarAjax;
    var form = layui.form;
    var layerView;
    var close;
    var dataForTable;
    /**
     * 保存
     */
    $("#btnSave").click(function () {
        var day = $("#days").val();
        if (!/^[0-9]*$/.test(day)) {
            Hussar.error("请输入正确的未登录天数!");
            return
        }
        var data = $("#addForm").serialize();
        var ajax = new $ax(Hussar.ctxPath + "/sysScanStrategy/save", function (data) {
            Hussar.info(data);
            sysScanStrategyDlg.close();
            if (close == 'edit'){
                layer.close(layerView)
                close = ''
            }
        }, function (data) {
            Hussar.error("保存失败!");
        });
        ajax.setData(data);
        ajax.start();
    });

    /**
     * 选中一条结果
     */
    function check() {
        var checkStatus = table.checkStatus('SysScanStrategy'),
            data = checkStatus.data;
        if (data.length == 0 || data.length > 1) {
            Hussar.info("请选择一条记录！");
            return false;
        } else {
            dataForTable = data[0];
            return true;
        }
    }

    /**
     * 点击修改用户欢迎页配置
     */
    $("#edit").click(function () {
        if (check()) {
            close = "edit";
            layerView = layer.open({
                type: 1,
                area: ['400px', '300px'],
                shadeClose: false,
                maxmin: false,
                title: '修改',
                content: $("#viewEvent"),
                success: function () {
                    var ajax = new $ax(Hussar.ctxPath + "/sysScanStrategy/detail", function (data) {
                        $("#days").val(data.days);
                        $("#id").val(data.id);
                        var status = $("input[name='status']");
                        for (var i = 0; i < status.length; i++) {
                            if (status[i].value == data.status) {
                                status[i].checked = true;
                            }
                        }
                        var inUse = $("input[name='inUse']");
                        for (var i = 0; i < status.length; i++) {
                            if (inUse[i].value == data.inUse) {
                                inUse[i].checked = true;
                            }
                        }
                        form.render();
                    }, function (data) {
                        Hussar.error("查询信息失败！");
                    });
                    ajax.set("sysScanStrategyId", dataForTable.id);
                    ajax.start();
                }
            });
        }
    });
});