var sysScanStrategyDlg = {
    sysScanStrategyData: {}
};
layui.use(['jquery', 'layer', 'Hussar', 'HussarAjax', "form", "table"], function () {

    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var layer = layui.layer;
    var $ax = layui.HussarAjax;
    var form = layui.form;
    var table = layui.table;
    var table1;
    var layerView;

    var SysScanStrategy = {
        seItem: null,
        type: null
    };

    /**
     * 初始化按钮事件
     */
    SysScanStrategy.initButtonEvent = function () {
        $("#add").click(function () {
            SysScanStrategy.openAdd();
        });
        $("#del").click(function () {
            SysScanStrategy.delete();
        });
        $("#btnClose").click(function () {
            SysScanStrategy.closeIndex();
            layer.closeAll();
        });
        $("#updateUserStatus").click(function () {
            SysScanStrategy.updateUserStatus();
        });
        $("#use").click(function () {

        });
        $("#notuse").click(function () {

        });
    };
    /**
     * 初始化表单验证
     */
    SysScanStrategy.initValidate = function () {
        form.verify({
            required: function (value, item) {
                if (value.trim() === "") {
                    return '必填项不能为空';
                }
            },
            /*   days: function (value, item) {
                   if (!/^(0|[1-9][0-9])$/.test(value)) {
                       return '请输入正确的未登录天数'
                   }
               }*/
        });
    };
    /**
     * 选中一条结果
     */
    SysScanStrategy.check = function () {
        var checkStatus = table1.checkStatus('SysWelcomeTable'),
            data = checkStatus.data;
        if (data.length == 0 || data.length > 1) {
            Hussar.info("请选择一条记录！");
            return false;
        } else {
            SysScanStrategy.seItem = data[0];
            return true;
        }
    };

    /**
     * 选中多条结果
     */
    SysScanStrategy.checks = function () {
        var checkStatus = table1.checkStatus('SysScanStrategy'),
            data = checkStatus.data;
        var ids = "";
        if (data.length === 0) {
            Hussar.info("请至少选择一条记录！");
            return false;
        } else {
            for (var i = 0, l = data.length; i < l; i++) {
                ids += data[i].id + ",";
            }
            SysScanStrategy.seItem = ids;
            return true;
        }
    };

    /**
     * 添加
     */
    SysScanStrategy.openAdd = function () {
        layerView = layer.open({
            type: 1,
            area: ['400px', '300px'],
            shadeClose: false,
            maxmin: false,
            title: '新增',
            content: $("#viewEvent"),
            success: function () {
                $('#addForm')[0].reset();
                form.render();
            }
        });
    };

    /**
     * 删除
     */
    SysScanStrategy.delete = function () {
        if (SysScanStrategy.checks()) {
            var operation = function () {
                var ajax = new $ax(Hussar.ctxPath + "/sysScanStrategy/delete",
                    function (data) {
                        if (data.code === 200) {
                            $(".layui-laypage-btn").click();
                            Hussar.success("删除成功！");
                            table1.reload();
                        } else {
                            Hussar.error("删除失败！")
                        }
                    }, function (data) {
                        Hussar.error("删除失败！");
                    });
                ajax.set("sysScanStrategyId", SysScanStrategy.seItem);
                ajax.start();
            };
            Hussar.confirm("确定要删除吗 ?", operation);
        }
    };
    /**
     * 删除
     */
    SysScanStrategy.updateUserStatus = function () {
        var operation = function () {
            var ajax = new $ax(Hussar.ctxPath + "/user/updateUserStatus",
                function (data) {
                    if (data.code === 200) {
                        Hussar.success("执行成功！");
                    } else {
                        Hussar.error("执行失败！")
                    }
                }, function (data) {
                    Hussar.error("执行失败！");
                });
            ajax.start();
        };
        Hussar.confirm("确定要执行吗 ?", operation);
    };

    /**
     * 启用 禁用
     */
    SysScanStrategy.operate = function (ids, isuse) {
        var title;
        if ('1' == isuse) {
            title = '启用'
        } else {
            title = '禁用'
        }
        var operation = function () {
            var ajax = new $ax(Hussar.ctxPath + "/sysScanStrategy/operate",
                function (data) {
                    $(".layui-laypage-btn").click();
                    Hussar.success(data);
                    table1.reload();
                }, function (data) {
                    Hussar.error("失败！");
                });
            ajax.set("sysScanStrategyId", ids);
            ajax.set("isuse", isuse);
            ajax.start();
        };
        Hussar.confirm("确定要" + title + "吗 ?", operation);
    };

    SysScanStrategy.initTable = function () {
        layui.use('table', function () {
            var table = layui.table;
            table.render({
                elem: '#SysScanStrategy',
                height: $("body").height() - $(".layui-form").outerHeight(true) - 26,
                url: Hussar.ctxPath + '/sysScanStrategy/list',
                cols: [
                    [{
                        type: 'checkbox',
                        width: 40
                    }, {
                        title: '序号',
                        type: 'numbers',
                        align: 'center'
                    }, {
                        field: 'days',
                        title: '未登录天数',
                        sort: false,
                        align: 'center'
                    }, {
                        field: 'status',
                        title: '处理状态',
                        align: 'center',
                        sort: false,
                        templet: function (value) {
                            if (value.status == '0') {
                                return "锁定";
                            } else {
                                return "休眠";
                            }
                        }
                    }, {
                        field: 'inUse',
                        title: '是否启用',
                        sort: false,
                        align: 'center',
                        templet: function (value) {
                            if (value.inUse == '0') {
                                return "禁用";
                            } else {
                                return "启用";
                            }
                        }
                    }, {
                        field: 'operate',
                        title: '操作',
                        sort: false,
                        align: 'center',
                        toolbar: "#operate"
                    }
                    ]],
                page: true,
                id: 'SysScanStrategy',
                even: true,
                limit: 10
            });
            table1 = table;
        });
    };
    //监听工具条
    table.on('tool(SysScanStrategy)', function (obj) {
        var data = obj.data;
        if (obj.event === 'use') {
            SysScanStrategy.operate(data.id, '1')
        } else if (obj.event === 'notuse') {
            SysScanStrategy.operate(data.id, '0')
        }
    });
    /**
     * 初始化
     */
    $(function () {
        SysScanStrategy.initTable();
        SysScanStrategy.initButtonEvent();
        SysScanStrategy.initValidate();
    });
    SysScanStrategy.closeIndex = function () {
        layer.close(layerView);
        // 执行重载
        table1.reload('SysScanStrategy', {
            page: {
                curr: 1
            }
        });
    }

    /**
     * 关闭此对话框
     */
    sysScanStrategyDlg.close = function () {
        SysScanStrategy.closeIndex();
    };
});
