/**
 * @Description: 角色管理脚本文件
 * @Author: chenxin
 * @Date: 2018/2/27.
 */

/**
 * 用户管理初始化
 */
layui.use(['jquery','layer','Hussar','HussarAjax','form','element'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer=layui.layer;
	var $ax=layui.HussarAjax;
	var form=layui.form;
    var RoleManage = {};
    var element=layui.element;
    var form;
/*初始化页面*/
RoleManage.initPage = function() {
    this.initButtonEvent();
    this.validator();
    RoleManage.initFrameHeight();
}
/**
 * 初始化按钮事件
 */
RoleManage.initButtonEvent = function () { 	
    
    /**
	 * 保存角色分组
	 */
	$("#saveGroup").click(function(){
		form.on('submit(saveGroup)', function(data){
			var saveType=$('#saveType').val();//操作类型
    		var url;
			if(saveType=="add"){
				url="/roleManager/saveGroup";
			}else{
				url="/roleManager/editGroup";
			}
			var ajax = new $ax(Hussar.ctxPath + url, function(data) {
				if(data.code=="200"){
					parent.location.reload();
					Hussar.success("保存成功！");
				}else{
					Hussar.error(data.message+"！");
				}
		    }, function(data) {
		        Hussar.error("保存失败！");
		    });
		    ajax.set("groupName",$('#groupName').val());
		    ajax.set("groupAlias",$('#groupAlias').val());
		    ajax.set("checkId",$("#nodeId").val());
		    ajax.start();
		});
	});
}

/**
 * 验证表单
 */
RoleManage.validator = function() {
	//自定义校验
	form.verify({
		required : function(value, item){
			if(value.trim()==""){
				return '必填项不能为空！';
			}
		},
		roleName : function(value, item){
			if(!new RegExp("^[a-zA-Z0-9_\u4e00-\u9fa5\\s·]+$").test(value)){
				return '输入项不能有特殊字符！';
			}
		},
		sameRoleName : function(value, item){
			var oldRoleName=$("#oldRoleName").val().trim();
			if(oldRoleName!=value){
				var msg="";
				var ajax = new $ax(Hussar.ctxPath + "/roleManager/sameRoleName", function(data) {
					if(data.length!=0){
						msg= '角色名称已存在！';
					}
			    }, function(data) {
			        Hussar.error("查询角色名称是否存在失败！");
			    });
			    ajax.set("sameRoleName",value);
			    ajax.start();
			    return msg;
			}
		},
		sameGroupName : function(value, item){
			var oldGroupName=$("#oldGroupName").val().trim();
			if(oldGroupName!=value){
				var msg="";
				var ajax = new $ax(Hussar.ctxPath + "/roleManager/sameGroupName", function(data) {
					if(data.length!=0){
						msg= '分组名称已存在！';
					}
			    }, function(data) {
			        Hussar.error("查询分组名称是否存在失败！");
			    });
			    ajax.set("sameGroupName",value);
			    ajax.start();
			    return msg;
			}
		}
	})
};

RoleManage.initFrameHeight=function(){
	var h = $(window).height()-60;
	var h2 = $(window).height()-10;
	$("#roleIframe").css("height", h2 + "px");
	$("#roleInfo").css("height", h + "px");
};

/**
 * 初始化
 */
$(function() {
    RoleManage.initPage();
    $(window).resize(function() {
    	RoleManage.initFrameHeight();
	});
});
});