/**
 * @Description: 不相容角色集脚本文件
 * @Author: chenxin
 * @Date: 2018/3/05.
 */

/**
 * 不相容角色集初始化
 */
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','form','element','multiselect'], function(){

	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer=layui.layer;
	var $ax=layui.HussarAjax;
	var form=layui.form;
	var element=layui.element;
    var IncompatibleRoles = {};
    var layerView;

    var IncompatibleRoles = {
    		seItem : null, // 选中的条目
    		setRow : null // 选中的条目
    	};
    
/*初始化页面*/
IncompatibleRoles.initPage = function() {
	this.initTable();
	this.initButtonEvent();
	this.initOrganTreeView();
	this.validator();
}

IncompatibleRoles.initTable = function() {
	layui.use('table', function() {
		var table = layui.table;
        var rolesName = $('#name').val();
		table.render({
			elem : '#rolesTable',
			height:$("body").height() - $(".layui-form").outerHeight(true)-26,
			url : Hussar.ctxPath + '/incompatibleRoles/list',
			cols : [
				[ {
				type : 'checkbox',
				width : 40
			}, {
				title : '序号',
				type : 'numbers',
				align : 'center',
					width:50
			}, {
				field : 'SET_NAME',
				title : '角色集名称',
				align : 'center'
			}, {
				field : 'CARDINALITY',
				title : '基数',
				align : 'center'
			}] ],
			page : true,
			id : 'testReload',
			even: true,
			where: {
                rolesName : rolesName
			}
		});
		table1 = table;
	});
}




/**
 * 获取资源不相容角色
 */
IncompatibleRoles.multiselect = function (selectId) {
	var ajax = new $ax(Hussar.ctxPath + "/incompatibleRoles/selectInRoles",function(json) {
		$("#search").html("");
		for (var i = 0; i < json.length; i++) {  
            $("#search").append("<option value='" + json[i]['roleId'] + "'>" + json[i]['roleName'] + "</option>");  
        }
	}, function(data) {
		Hussar.error("获取角色资源树失败！");
  });
	ajax.set("selectId",selectId);
	ajax.start();
    $('#search').multiselect({
        search: {
            left: '<input type="text" name="q" id="queryLeft" class="layui-input" placeholder="可用角色查询..." />',
            right: '<input type="text" name="q" id="queryRight" class="layui-input" placeholder="不相容角色查询..." />',
        },
        fireSearch: function(value) {
        	if(value!=""){
        		return value.length >0;//数据长度从0开始
        	}
        },
        noRightSelect:function(){
        	Hussar.info("请至少选择一条不相容角色！");
        	return false;
        },
        noLeftSelect:function(){
        	Hussar.info("请至少选择一条可用角色！");
        	return false;
        },
        noSelect:function(){
        	Hussar.info("暂无可选角色！");
        	return false;
        }
    });
};

/**
 * 初始化按钮事件
 */
IncompatibleRoles.initButtonEvent = function(){
	
	/**
	 * 查询
	 */
	$('#searchRoles').on('click', function() {
		var rolesName = $('#name');
		var searchOrgId = $('#searchOrgId');
		// 执行重载
		table1.reload('testReload', {
			page : {
				curr : 1
			// 重新从第 1 页开始
			},
			where : {
				rolesName : rolesName.val(),
				orgId : searchOrgId.val()
			}
		});
	});

	$("#reset").click(function(){
		$("#searchOrgName").val("");
		$("#searchOrgId").val("");
	})
	
	/**
	 * 修改
	 */
	$("#edit").click(function() {
		if (IncompatibleRoles.check()) {
			$("#saveType").val("edit");
			$("#count").attr("disabled", "disabled");
			$("#setId").val(IncompatibleRoles.setRow.SET_ID);
			layerView = layer.open({
				type : 1,
				area : [ '388px', '200px' ],
				title : "不相容角色集修改",
				shadeClose : true,
				maxmin : false,
				shadeClose:false,
				content : $("#addEvent"),
				success : function() {
					// 重置form
					var ajax = new $ax(Hussar.ctxPath + "/incompatibleRoles/selectInRole", function(data) {
						$("[name=setName]").val(data.setName);
	                    $("[name=oldRolesName]").val(data.setName);
	                    $("[name=organName]").val(IncompatibleRoles.setRow.ORGAN_NAME);
	                    $("[name=cardinality]").val(data.cardinality);
	                    $("[name=corporationId]").val(data.corporationId);
                        form.render();
        		    }, function(data) {
        		        Hussar.error("查询不相容角色集信息失败！");
        		    });
        		    ajax.set("setId",IncompatibleRoles.setRow.SET_ID);
        		    ajax.start();
                    form.render();
				}
			});
		}
	});
	
	/**
	 * 添加
	 */
	$("#add").click(function() {
		$("#count").removeAttr("disabled");
		layerView = layer.open({
			type : 1,
			area : [ '388px', '200px' ],
			title : "不相容角色集新增",
			shadeClose : true,
			maxmin : false,
			content : $("#addEvent"),
			shadeClose:false,
			success : function() {
				$("[name=oldRolesName]").val("");
				$("#saveType").val("add");
				// 重置form
		        $('#addRolesForm')[0].reset();
				form.render();
			}
		});
	});
	
	/**
	 * 删除
	 */
	$("#del").click(function() {
		if (IncompatibleRoles.checkIds()) {
			var operation =function(){
				var ajax = new $ax(Hussar.ctxPath + "/incompatibleRoles/delRole",function() {
							$(".layui-laypage-btn").click();
								Hussar.success("删除成功！");
							}, function(data) {
								Hussar.error("删除失败！");
						});
						ajax.set("id", IncompatibleRoles.seItem);
						ajax.start();
						};
				Hussar.confirm("确定要删除吗 ?", operation);
			}
		});
	
	/**
	 * 选择不相容角色
	 */
	$("#checkInRoles").click(function() {
		if (IncompatibleRoles.check()) {
			layerView = layer.open({
				type : 1,
				area : [ '488px', '390px' ],
				title : "不相容角色",
				shadeClose : true,
				maxmin : true,
				content : $("#rolesEvent"),
				shadeClose:false,
				success : function() {
					$("#queryLeft").val("");
					$("#queryRight").val("");
					$("#setId").val(IncompatibleRoles.setRow.SET_ID);
					var selectId="";
					$("#search_to").html("");
						var ajax = new $ax(Hussar.ctxPath + "/incompatibleRoles/roleView",function(result) {
		                for (var i = 0; i < result[1].length; i++) {
		                    $("#search_to").append("<option value='" + result[1][i]['ROLE_ID'] + "'>" + result[1][i]['ROLE_ALIAS'] + "</option>"); 
		                    selectId+=","+result[1][i]['ROLE_ID'];
		                }
		                $("#searchCount").val(result[0][0].cardinality);
		                IncompatibleRoles.multiselect(selectId);//获取右侧选中的不相容角色，过滤左侧不相容角色
		    	  },function(data) {
					Hussar.error("加载角色信息失败！");
				});
		    	ajax.set("id",IncompatibleRoles.setRow.SET_ID)
				ajax.start();
					$(".layui-form-select").remove();
				}
			});
		}
	});
	
	/**
	 * 关闭
	 */
	$("#btnClose").click(function(){
		layer.close(layerView);
	});
	$("#close").click(function(){
		layer.close(layerView);
	});
	
	/* 提交操作 */
	$("#btnSave").click(function(){
		form.on('submit(verify)', function(data){
			var data = $("#addRolesForm").serialize();
			var saveType=$("#saveType").val();
	        var url;
			if(saveType=="add"){
				url="/incompatibleRoles/addRole";
			}else{
				url="/incompatibleRoles/editRole";
			}
	        var ajax = new $ax(Hussar.ctxPath + url, function (data) {
	        	if(data.code==200){
					layer.close(layerView);
					Hussar.success("保存成功！");
					$("#searchRoles").click();
				}else{
					Hussar.error("保存失败！");
				}

	        }, function () {
				Hussar.error("保存失败！");
	        });
	        ajax.setData(data);
	        ajax.start();
		});
    });
	
	/* 提交选择不相容角色 */
	$("#rolesSave").click(function(){
		$("#queryRight").val("");
		$('#queryRight').keyup();
		form.on('submit(rolesSave)', function(data){
			var data=document.getElementById("search_to");//获取不相容角色
			var rolesId=$("#setId").val();
	        var roIds="";
	        for (i=0;i<data.length;i++) {//下拉框的长度就是它的选项数.
	              roIds+=','+data[i].value;//获取当前选择项的文本.
	           }
	        var ajax = new $ax(Hussar.ctxPath + "/incompatibleRoles/saveInRoles", function () {
	            layer.close(layerView);
	        	Hussar.success("保存成功！");
	        	$("#searchRoles").click();
	        }, function () {
				Hussar.error("保存失败！");
	        });
	        ajax.set("ids",roIds.substring(1));
	        ajax.set("setId",rolesId);
	        ajax.start();
		});
    });
	
	//选择所属组织机构
	  $("#organName").click(function(){
		  layer.open({
			type: 1,
			btn: ['关闭','确认'],
			area: ['500px','400px'],
			skin: 'confirm-class',
			fix: false, //不固定
			maxmin: true,
			shadeClose: false,
			shade: 0.4,
			title: "选择所属组织机构",
			content: $("#orgTreeDiv"),
			cancel:function(index, layero){
				$("#orgArea").val("");
				$("#orgArea").keyup();
				$(".search-results1").html("");
				layer.close(index);
			},
			btn1:function(index, layero){
				$("#orgArea").val("");
				$("#orgArea").keyup();
				$(".search-results1").html("");
				layer.close(index);
			},
			btn2: function(index, layero){
				//获取选中节点
				var nodes = $("#orgTree").jstree(true).get_checked();//使用get_checked方法
				if(nodes.length==0){
					Hussar.info("请选择所属组织机构！");
				}else{
					var resourceName = $("#orgNameHidden").val();
					$("#organName").val(resourceName);
					$("#orgId").val(nodes[0]);
					 layer.close(index);
				}
				return false;
			},
			success:function(){
				$(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006;</i>");
				$(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009;</i>");
    		$("#orgNameHidden").val("");
    		var data;
                var ajax = new $ax(Hussar.ctxPath + "/orgMain/orgTree",function(result) {
                    var orgid=$("[name=corporationId]").val();
                    var arrays = [];
                    for(var i=0; i<result.length; i++){
                        var arr = {
                            id	:	result[i].id,
                            parent : result[i].parent,
                            text : result[i].text,
                            organId:result[i].organId
                        }
                        if(result[i].parent=="#"){
                            arr.state = {opened : true};
                        }else{
                            arr.state = {opened : false};
                        }
                        arrays.push(arr);
                    }
                    data=arrays;
                    $("#orgTree").jstree(true).settings.core.data = data;
                    $("#orgTree").jstree(true).refresh();
                }, function(data) {
                    Hussar.error("加载树失败！");
                });
                ajax.start();
			}
		});
	  });
	  
	  $("#orgName").click(function(){
		  layerView=layer.open({
			type: 1,
			btn: ['关闭','确认'],
			area: ['500px','400px'],
			skin: 'confirm-class',
			fix: false, //不固定
			maxmin: true,
			shadeClose: false,
			shade: 0.4,
			title: "选择所属组织机构",
			content: $("#orgTreeDiv"),
			cancel:function(index, layero){
				$("#orgArea").val("");
				$("#orgArea").keyup();
				$(".search-results1").html("");
				layer.close(index);
			},
			btn1:function(index, layero){
				$("#orgArea").val("");
				$("#orgArea").keyup();
				$(".search-results1").html("");
				layer.close(index);
			},
			btn2: function(index, layero){
				//获取选中节点
				var nodes = $("#orgTree").jstree(true).get_checked();//使用get_checked方法
				if(nodes.length==0){
					Hussar.info("请选择所属组织机构！");
				}else{
					var searchOrgName = $("#searchOrgName").val();
					$("#orgName").val(searchOrgName);
					$("#searchOrgId").val(nodes[0]);
					 layer.close(index);
				}
               return false;
			}, 
			success:function(){
				$(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006;</i>");
				$(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009;</i>");
				$("#orgNameHidden").val("");
				var data;
                var ajax = new $ax(Hussar.ctxPath + "/orgMain/orgTree",
                    function (result) {
                        var arrays = [];
                        for(var i=0; i<result.length; i++){
                            var arr = {
                                id	:	result[i].id,
                                parent : result[i].parent,
                                text : result[i].text,
                                organId:result[i].organId
                            }
                            if(result[i].parent=="#"){
                                arr.state = {opened : true};
                            }else{
                                arr.state = {opened : false};
                            }
                            arrays.push(arr);
                        }
                        data=arrays;
                        $("#orgTree").jstree(true).settings.core.data = data;
                        $("#orgTree").jstree(true).refresh();
                    }, function (data) {
                        Hussar.error("加载树失败!");
                    });
                ajax.setData(formData);
                ajax.start();
                IncompatibleRoles.initFrameHeight();
			}
		});
	  });
	
}

/*初始化组织机构树*/
IncompatibleRoles.initOrganTreeView = function(){
	    //初始化数列表
	    var $tree = $("#orgTree");
	    $tree.data('jstree', false).empty();
	    $tree.jstree({
	        plugins: ['state', 'types','checkbox','search'],
	        core: {
	            check_callback: true,
	            data: null,
		        multiple: false//单选
	        },
	        sort:function(a,b){
	            return this.get_node(a).original.seq > this.get_node(b).original.seq ? 1 : -1;
	        },
	        checkbox: {
	            keep_selected_style : false,
	            three_state : false,
	            tie_selection : false
	        },
	        search : IncompatibleRoles.searchOrg()
	    });
	    $tree.bind("activate_node.jstree", function (obj, e) {
			// 处理代码
			// 获取当前节点
				var currentNode = e.node;
		});
	   $tree.on('check_node.jstree', function(event, obj) {
		   var currentNode = obj.node;
	   	   var menuName = obj.node.text;
            var ref =$tree.jstree(true);
            var nodes = ref.get_checked(); //使用get_checked方法
            var otherNode;
            var length = obj.node.parents.length;
            if(length==1){
            	ref.uncheck_node(obj.node.id);
            	Hussar.info("不能选择到当前组织机构");
            	return;
            }
            //限制只能选一个
            if(nodes.length>0){
            	$.each(nodes, function(i, nd) {
            		if(nd != obj.node.id){
            			otherNode = nd;
            		}
            	})
            	ref.uncheck_node(otherNode);
            	$("#orgNameHidden").val(menuName);
            	$("#searchOrgName").val(menuName);
            }
      });
	};

	/**
	 * 树查询
	 */
	IncompatibleRoles.searchOrg = function () {
	    var to = false;
	    $("#orgArea").keyup(function () {
	        if (to) { clearTimeout(to); }
	        to = setTimeout(function () {
	            var v = $("#orgArea").val();
	            var temp = $("#orgArea").is(":hidden");
	            if (temp == true) {
	                $("#orgTree").show();
	            }
	            $("#orgTree").jstree(true).search(v);
	            //添加索引
	            if(v!=''){
	                var n = $(".jstree-search").length,con_html;
	                if(n>0){
	                    con_html = "<em>&nbsp;&nbsp;&nbsp;&nbsp;"+ n +"</em>个匹配项";
	                }else{
	                    con_html = "无匹配项";
	                }
	                $(".search-results1").html(con_html);
	            }else {
	                $(".search-results1").html("");
	            }
	        }, 250);
	    });
	}

/**
 * 验证表单
 */
IncompatibleRoles.validator = function() {
	//自定义校验
	form.verify({
		required : function(value, item){
			if(value.trim()==""){
				$("#rolesMsg").click();
				return '必填项不能为空！';
			}
		},
		number : function(value, item){
			var reg = /^\+?(0|[1-9][0-9]*)$/;
			if(!reg.test(value)){
				$("#rolesMsg").click();
				return"请输入大于等于2的正整数！";
			}
		},
		sameRolesName : function(value, item){
			var oldRolesName=$("#oldRolesName").val().trim();
			if(oldRolesName!=value){
				var msg="";
				var ajax = new $ax(Hussar.ctxPath + "/incompatibleRoles/sameRolesName", function(data) {
					if(data.length!=0){
						msg= '角色集名称已存在！';
					}
			    }, function(data) {
			        Hussar.error("查询角色集名称是否存在失败！");
			    });
			    ajax.set("sameRolesName",value);
			    ajax.start();
			    return msg;
			}
		},
		count : function(value, item){
			var count = $("#count").val();
			if(parseInt(count)<2){
				$("#rolesMsg").click();
				return '请输入大于等于2的正整数！';
			}
		},
		search_to : function(value, item){
			var data=document.getElementById("search_to");//获取不相容角色
			var count = $("#searchCount").val();
	    	if(data.length < parseInt(count)){
	    		$("#inRoles").click();
	    		return '不相容的角色个数要大于等于基数！'; 
	    	}
		}
	})
};

/**
 * 选中一条结果
 */
IncompatibleRoles.check = function() {
	var checkStatus = table1.checkStatus('testReload'), data = checkStatus.data;
	if (data.length == 0 || data.length > 1) {
        Hussar.info("请选择一条记录！");
		return false;
	} else {
		IncompatibleRoles.setRow = data[0];
		return true;
	}
};

/**
 * 选中多条结果
 */
IncompatibleRoles.checkIds = function() {
	var checkStatus = table1.checkStatus('testReload'), data = checkStatus.data;
	var ids = [];
	if (data.length == 0) {
		Hussar.info("请至少选择一条记录！");
		return false;
	} else {
		for (var i = 0, l = data.length; i < l; i++) {
			var r = data[i];
			ids.push(r.SET_ID);
		}
		var eId = ids.join(',');
		IncompatibleRoles.seItem = eId;
		return true;
	}
};

IncompatibleRoles.initFrameHeight=function(){
	var h3 = $(window).height()-338;
	$("#contentInfo").css("height", h3 + "px");
};
/**
 * 初始化
 */
$(function() {
	IncompatibleRoles.initPage();
	$(".layui-form-select").remove();
});
});