/**
 * @Description: 菜单维护脚本文件
 * @Author: sunZengXin
 * @Date: 2018/3/15
 */

var MenuManage = {
    treeId:"menuTree",
    infoWin:null, //弹出窗口
    selectId:"",
    childLevel:1,
    $exportTree: null,
    layIndex: null
};

layui.use(['jquery','layer','Hussar','jstree','form','HussarAjax', 'upload'], function(){
		var Hussar = layui.Hussar;
		var $ = layui.jquery;
		var layer=layui.layer;
		var form = layui.form;
		var $ax = layui.HussarAjax;
		var upload = layui.upload;

	/*初始化页面*/
	MenuManage.initPage= function(){
		this.initTreeView();
		this.initOrderTreeView();
		this.initChangeTreeView();
		this.initButtonEvent();
		MenuManage.initFrameHeight();
	};

	/*组织机构树右键菜单*/
	MenuManage.menuList=function(node){
		var items={
	                create: null,
	                remove: null,
	                ccp: null,
	                add: {
	                    label: "新增菜单",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5011.png",
	                    action: function (obj) {
	                    	//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
				        	//选中菜单ID
				        	var menuId=clickedNode.id;
				        	//选中菜单名称
				        	var menuName=clickedNode.text;
				        	//选中菜单的层级
				        	var length = clickedNode.parents.length;
				        	//获取子节点数量
				        	var childNum = clickedNode.children.length;
				        	$("#menuFrame").attr("src",Hussar.ctxPath+"/menu/menuAdd?menuId=" + menuId+"&length="+length)
	                    }
	                },
	                edit: {
	                    label: "修改",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/53.png",
	                    action: function (obj) {
	                        //获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
							//选中菜单ID
				        	var menuId=clickedNode.id;
				        	//选中菜单的层级
				        	var length = clickedNode.parents.length;
				        	$("#menuFrame").attr("src",Hussar.ctxPath+"/menu/menuInfoEdit?menuId="+menuId+"&length="+length);
	                    }
	                },
	                change: {
	                    label: "转移",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5411.png",
	                    action: function (obj) {
	                    	//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
				        	//选中菜单
				        	var menuId=clickedNode.id;
				        	//所选节点包含多少级
				        	var childLevel = 1;
				        	//获取下级数量
				        	var childNum = clickedNode.children.length;
				        	//全部下级数量
				        	var totalChildNum = clickedNode.children_d.length;
				        	if(childNum!=0){
				        		if(childNum == totalChildNum){
				        			childLevel +=1;
				        		}else{
				        			childLevel+=2;
				        		}
				        	}
				        	layer.open({
		        				type: 1,
		        				btn: ['取消','保存'],
		        				skin: 'confirm-class',
		        				area: ['350px','500px'],
		        				fix: false, //不固定
		        				maxmin: false,
		        				shadeClose: true,
		        				shade: 0.4,
		        				title: "上级菜单选择",
		        				content: $('#treeEditChange'),
		        				btn2: function(index, layero){
		        					//获取选中节点
	        	  					var nodes = $("#menuTreeChange").jstree(true).get_checked();//使用get_checked方法
	        	  					if(nodes.length==0){
	        	  						Hussar.info("请先选择上级菜单！");
	        	  					}else{
		        					//确认按钮回调
		        					var saveTree =function(){
										var ajax = new $ax(Hussar.ctxPath + "/menu/menuTreeChange",
											function(data) {
												MenuManage.refreshTree();
												Hussar.success("转移成功！");
												layer.close(index);
											}, function(data) {
												Hussar.error("转移失败!");
											});
										ajax.set("menuId",menuId)
										ajax.set("parentId",nodes[0])
										ajax.start();
		        			    	};
		        			    	Hussar.confirm("确定要转移吗？", saveTree);
				                    layer.close(index);
	        	  					}
		        				 },
		        				success:function(){
                                    $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                                    $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
                                    var ajax = new $ax(Hussar.ctxPath+"/menu/menuTree",
										function (result) {
                                            MenuManage.selectId=menuId;
                                            MenuManage.childLevel=childLevel;
                                            $("#menuTreeChange").jstree(true).settings.core.data = result;
                                            $("#menuTreeChange").jstree(true).refresh();
                                        },function () {

                                        });
                                    ajax.set("menuId",menuId);
                                    ajax.setAsync(false);
                                    ajax.start();
		        				}
		        			});
	                    }
	                },
	                up:{
	                	label: "上移",
	                	icon : Hussar.ctxPath+"/static/assets/img/treeContext/511101.png",
	                	action: function (obj) {
	                		//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
				        	//选中菜单ID
				        	var menuId=clickedNode.id;
				        	MenuManage.singleMove(menuId, 'up');
	                	}
	                },
	                down:{
	                	label: "下移",
	                	icon : Hussar.ctxPath+"/static/assets/img/treeContext/511102.png",
	                	action: function (obj) {
	                		//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
				        	//选中菜单ID
				        	var menuId=clickedNode.id;
				        	MenuManage.singleMove(menuId, 'down');
	                	}
	                },
	                sort: {
	                    label: "下级排序",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5111.png",
	                    action: function (obj) {
	                    	//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
				        	//选中菜单ID
				        	var menuId=clickedNode.id;
				        	
				        	//是否为根节点
				        	var length = clickedNode.parents.length;
				        	var isRoot;
				        	if(length>1){
				        		isRoot=false;
				        	}else{
				        		isRoot=true;
				        	}
				        	//选中菜单名称
				        	var menuName=clickedNode.text;
				        	layer.open({
		        				type: 1,
		        				btn: ['取消','保存'],
		        				skin: 'confirm-class',
		        				area: ['350px','500px'],
		        				fix: false, //不固定
		        				maxmin: false,
		        				shadeClose: true,
		        				shade: 0.4,
		        				title: "下级排序",
		        				content: $('#treeEditOrder'),
		        				btn2: function(index, layero){
		        					//确认按钮回调
		        					var saveTree =function(){
		        						var ajax = new $ax(Hussar.ctxPath+"/menu/menuTreeOrder",
											function () {
                                                MenuManage.refreshTree();
                                                Hussar.success("保存成功！");
                                                MenuManage.closeWindow();
                                            },
											function () {
                                                Hussar.error("保存失败！");
                                            });
		        						ajax.setAsync(false);
		        						ajax.set("treeInfo",$("#output").val());
		        						ajax.start();
		        			    	};
		        			    	Hussar.confirm("确定要保存排序吗？", saveTree);
				                    layer.close(index);
		        				 },
		        				success:function(){
                                    $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                                    $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
                                    var ajax = new $ax(Hussar.ctxPath+"/menu/menuTreeById",
										function (result) {
                                            $("#menuTreeOrder").jstree(true).settings.core.data = result;
                                            $("#menuTreeOrder").jstree(true).refresh();
                                            //返回值在页面显示
                                            var newResult=[];
                                            for(var i=0;i<result.length;i++){
                                                if(result[i].parent!="#"){
                                                    newResult.push(result[i]);
                                                }
                                            }
                                            $("#output").val(window.JSON.stringify(newResult));
                                        },
										function () {

                                        });
                                    ajax.setAsync(false);
                                    ajax.set("menuId",menuId);
                                    ajax.set("isRoot",isRoot);
                                    ajax.start();
		        				}
		        			});
	                    }
	                },
	                delete: {
	                    label: "删除",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/57.png",
	                    action: function (obj) {
	                    	//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
							var menuIds = [];	//要删除的菜单id

                            var delMenus = function () {
                                var ajax = new $ax(Hussar.ctxPath + "/menu/delMenuById",
                                    function(data) {
                                		if ( data.code == 200 ) {
                                			Hussar.success("删除成功！");
                                            MenuManage.refreshTree();		//删除成功后刷新菜单树
										}else {
											Hussar.error("删除失败！");
										}
                                    },
                                    function(data) {
                                    });
                                ajax.set("menuIds",menuIds.join(','));
                                ajax.start();
                            };

							if ( inst.is_parent(clickedNode.id) ) {
								//如果当前节点包含下级
                                menuIds = clickedNode.children_d;
                                menuIds.push(clickedNode.id);
                                Hussar.confirm("当前菜单包含下级，确定要全部删除？", delMenus);
							} else {
								//如果当前节点是末级节点
                                menuIds.push(clickedNode.id);
								Hussar.confirm("确定要删除该菜单？", delMenus);
							}
	                    }
	                },
					export:{
						label: "菜单导出",
						icon : Hussar.ctxPath+"/static/assets/img/treeContext/export.png",
						action: function (obj) {
                            MenuManage.menuExport();
						}
					},
					import:{
						label: "菜单导入",
						icon : Hussar.ctxPath+"/static/assets/img/treeContext/import.png",
						action: function (obj) {
                            $("#import").click();
						}
					}
	           };

		       var shiroAdd=$("#shiroAdd").val();
		       var shiroOrder=$("#shiroOrder").val();
		       var shiroChange=$("#shiroChange").val();
			   var shiroEdit=$("#shiroEdit").val();
		       var shiroDel=$("#shiroDel").val();
		       if(shiroAdd!="add"){
		    	   delete items.add;
		       }
		       if(shiroOrder!="order"){
		    	   delete items.sort;
		       }
		       if(shiroChange!="change"){
		    	   delete items.change;
		       }
		       if(shiroEdit!="edit"){
		    	   delete items.edit;
		       }
		       if(shiroDel!="del"){
		    	   delete items.delete;
		       }
			   if(node.parent=="#"){
				   //如果为根节点没有删除，修改功能
				   delete items.delete;  //删除节点 删除
				   delete items.edit;  //删除节点 修改
				   delete items.change;//删除节点转移 
			   }else{
			   		//如果不是根节点，删除导出导入功能
                   delete items.export;
                   delete items.import;
			   }
	           var child = node.children;
	           if(child.length==0){
	           	delete items.sort;  //删除节点 下级排序  
	           };
	           //判断是否为末及菜单
	           if(node.original.isLeaf=='1'){
	        	   delete items.add; //删除节点 新增 
	           }
	           //上移下移
	           var id = node.id;
               var n = $("#"+id);
               if (n.index() == 0) {//非第一个
            	   delete items.up;  //删除节点 上移  
               }
               if (n.next().length == 0) {//非最后一个
            	   delete items.down;  //删除节点 上移 
               }
			return items;
	};

    /**
	 * 菜单导出树
     */
    MenuManage.exportTree = function () {
        MenuManage.$exportTree = $('#menuExportTree');
        MenuManage.$exportTree.jstree({
            core: {
                check_callback: true,
                data: function (obj, callback) {
                    var data;
                    var ajax = new $ax(Hussar.ctxPath+"/menu/menuTree",
                        function(result) {
                            data = result;
                            callback.call(this, data);
                        },
                        function(data) {
                            Hussar.error("加载菜单导出树失败！");
                        });
                    ajax.start();
                }
            },
            plugins: ['types', 'checkbox'],
            types:{
                "isRoot":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/root.png"},
                "0":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/menu.png"},
                "1":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/rootMenu.png"}
            },
            checkbox: {
                keep_selected_style : false,//是否默认选中
                three_state : true,//是否父子级别关联
                tie_selection : false
            }
        });
        MenuManage.$exportTree.on('check_node.jstree', function(event, obj) {
            var currentNode = obj.node;
            var ref =MenuManage.$exportTree.jstree(true);
            //根节点和两个字典分类不能勾选
            if (currentNode.parent=='#') {
                ref.uncheck_node(currentNode.id);
                return;
            }
        });
		
    };

    /**
	 * 菜单数据导出
     */
    MenuManage.menuExport = function () {
        $('#menuExportTree').jstree("destroy");
        MenuManage.exportTree();
        layer.open({
            type: 1,
            btn: ['取消', '导出'],
            skin: 'confirm-class',
            area: ['350px','500px'],
            shadeClose: false,
            zIndex: 9999,
            title: "菜单导出",
            content: $('#menuExport'),
            success:function(){
                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe017</i>");
            },
            btn2: function(index){
                var nodes = MenuManage.$exportTree.jstree(true).get_checked();
                if (nodes.length == 0) {
                    Hussar.info("请选择要导出的菜单！");
                } else {
                    var menuExport = function(){
                        var menuIds = nodes.join(",");
                        var url = Hussar.ctxPath + "/menu/exportMenu";
                        var form = $("<form></form>").attr("action", url).attr("method", "post");
                        form.append($("<input></input>").attr("type", "hidden").attr("name", "menuIds").attr("value", menuIds));
                        form.appendTo('body').submit().remove();
                        layer.close(index);
                    };
                    Hussar.confirm("确定要导出选中的菜单吗？", menuExport);
                }
                return false;
            }
        });

    };

    /**
     * 菜单数据导入
     */
    var dataImport = upload.render({
        elem: '#import'
        ,url: Hussar.ctxPath+'/menu/importData'
        ,accept: 'file'
        ,exts: 'hussar'
        ,before: function (obj) {
            MenuManage.layIndex = layer.load(2);
        }
        ,done: function(res, index, upload){
            layer.close(MenuManage.layIndex);	//关闭loading
            if(res.code == 200){
                Hussar.success(res.message);
                MenuManage.refreshTree();
            }else{
                Hussar.error(res.message);
            }
        }
        ,error: function(){
            layer.close(MenuManage.layIndex);	//关闭loading
            Hussar.error("导入失败！");
        }
    });

    /**
     * 上移下移方法
     * @param id 组织机构id
     * @param direction 方向 'up' | 'down'
     */
	MenuManage.singleMove = function(id, direction){
        // var layerIndex = layer.open({type: 3});
        var ajax = new $ax(Hussar.ctxPath+"/menu/singleMove",
			function () {
                // layer.close(layerIndex);
                Hussar.success("操作成功！");
                MenuManage.refreshTree();
            },
			function () {
                // layer.close(layerIndex);
                Hussar.error("操作失败！");
            });
        ajax.setAsync(false);
        ajax.set("menuId",id);
        ajax.set("isUp",direction == 'up');
        ajax.start();
    };
	/*初始化菜单树*/
	MenuManage.initTreeView = function(){
	    var $tree = $("#menuTree");
	    $tree.jstree({
	        core: {
	            check_callback: true,
	            data: function (obj, callback) {
	                var data;
	                var ajax = new $ax(Hussar.ctxPath+ "/menu/menuTree",
						function (result) {
                            data = result;
                            $("#menuInfo").attr("src","")
                        },
						function () {

                        });
	                ajax.setAsync(false);
	                ajax.start();
	                callback.call(this, data);
	            }
	        },
	        plugins: ['types', 'contextmenu', 'search'],
	        contextmenu: {
	            items: MenuManage.menuList
	        },
            search: MenuManage.initTreeSearch(),
	        types:{
	        	"isRoot":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/root.png"},
	        	"0":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/menu.png"},
	        	"1":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/rootMenu.png"}
	        }
	    });
	    $tree.bind("activate_node.jstree", function (obj, e) {
			// 处理代码
			// 获取当前节点
				var currentNode = e.node;
	    		var menuId = currentNode.id;
	    		var parent = currentNode.parent;
	    		//选中菜单的层级
	        	var length = currentNode.parents.length;
	    		//判断是否为根节点如果为根节点
	    		if(parent=="#"){
	    			$("#menuFrame").attr("src","")
	    		}else{
	    			$("#menuFrame").attr("src",Hussar.ctxPath+"/menu/menuInfo?menuId=" + menuId+"&length="+length)
	    		}
		});
	};
	/*刷新菜单树*/
	MenuManage.refreshTree = function(){
		$("#menuTree").jstree(true).refresh();
		$("#menuFrame").attr("src","");
	};
	/*初始化组织机构排序树*/
	MenuManage.initOrderTreeView = function(){
	    //初始化数列表
	    var $tree = $("#menuTreeOrder");
	    $tree.data('jstree', false).empty();
	    $tree.jstree({
	        core: {
	            check_callback: function (operation, node, node_parent, node_position, more) {
	                //拖动排序时只允许同级拖动
	            	if(operation=='move_node'){
	                	if(node.parent==node_parent.parent||node_parent.parent==null){
	                    	return false;
	                    }else{
	                    	return true;
	                    }
	                }else{
	                	return true;
	                }
	            },
	            data: null
	        },
	        plugins: ['types',"dnd",'contextmenu'],
	        contextmenu: {
	            items: MenuManage.menuList
	        },
	        types:{
	        	"isRoot":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/root.png"},
	        	"0":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/menu.png"},
	        	"1":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/rootMenu.png"}
	        },
	        sort:function(a,b){
	            return this.get_node(a).original.seq > this.get_node(b).original.seq ? 1 : -1;
	        }
	    });
	    $tree.bind("activate_node.jstree", function (obj, e) {
			// 处理代码
			// 获取当前节点
				var currentNode = e.node;
				loadMenuInfo(22);
		});
	    //移动树事件
	    $tree.bind('move_node.jstree', function (e, data) {
	    	//移动的组织ID
	    	var id = data.node.id;
	    	//移动之前的位置
	    	var oldPosition = data.old_position;
	    	//移动后的位置
	    	var position = data.position;
	    	//原地未动
	    	if(oldPosition==position){
	    		return;
	    	}
	    	var oldResult = JSON.parse($("#output").val());
	    	//根据目前的位置对于树结果进行重新排序
	    	var newResult=[];
	    	//向上移动
	    	if(position-oldPosition<0){
	    		for(var i=0;i<oldResult.length;i++){
	        		if(i<position){
	        			oldResult[i].seq=i+1;
	        		}else{
	            		if(oldResult[i].id==id){
	            			oldResult[i].seq=position+1;
	            		}else{
	            			if(i<=oldPosition){
	            				oldResult[i].seq=i+2;
	            			}else{
	            				oldResult[i].seq=i+1;
	            			}
	            			
	            		}
	        		}
	        		
	        	}
	    	}else{//向下移动
	    		for(var i=0;i<oldResult.length;i++){
	        		if(i<oldPosition){
	        			oldResult[i].seq=i+1;
	        		}else{
	            		if(oldResult[i].id==id){
	            			oldResult[i].seq=position+1;
	            		}else{
	            			if(i<=position){
	            				oldResult[i].seq=i;
	            			}else{
	            				oldResult[i].seq=i+1;
	            			}
	            		}
	        		}
	        	}
	    	}
	    	oldResult.sort(MenuManage.up);
	    	$("#output").val(window.JSON.stringify(oldResult));
	    });
	};

	/*初始化转移菜单树*/
	MenuManage.initChangeTreeView = function(){
		    //初始化数列表
		    var $tree = $("#menuTreeChange");
		    $tree.data('jstree', false).empty();
		    $tree.jstree({
		        plugins: ['types','checkbox'],
		        core: {
		            check_callback: true,
		            data: null,
			        multiple: false//单选
		        },
		        sort:function(a,b){
		            return this.get_node(a).original.seq > this.get_node(b).original.seq ? 1 : -1;
		        },
		        checkbox: {
		            keep_selected_style : false,
		            three_state : false,
		            tie_selection : false
		        },
		        types:{
		        	"isRoot":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/root.png"},
		        	"0":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/menu.png"},
		        	"1":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/rootMenu.png"}
		        }
		    });
		    $tree.bind("activate_node.jstree", function (obj, e) {
				// 处理代码
				// 获取当前节点
					var currentNode = e.node;
			});
		   $tree.on('check_node.jstree', function(event, obj) {
			   var currentNode = obj.node;
		   	   var menuName = obj.node.text;
		   	   var isLeaf=obj.node.original.isLeaf;
              var ref =$tree.jstree(true);
              var nodes = ref.get_checked(); //使用get_checked方法

              var otherNode;
              otherNode="";
              //如果菜单为末级菜单则不能移动
              if(isLeaf==1){
            	  ref.uncheck_node(obj.node.id);
            	  Hussar.info("不能转移到末级菜单！");
      			  return;
              }
              //判断是否为相同节点，则不能移动
              if(MenuManage.selectId==obj.node.id){
            	  ref.uncheck_node(obj.node.id);
            	  Hussar.info("不能转移到当前菜单！");
      			  return;
              }
              //限制选择不能选择当前以及当前子节点
              if(nodes.length>0){
            	  $.each(currentNode.parents, function(i, nd) {
                		if(nd == MenuManage.selectId){
                			ref.uncheck_node(obj.node.id);
                			Hussar.info("不能转移到当前菜单！");
                			return false;
                		}
                	})
                  
              }
              //限制只能选一个
              if(nodes.length>1){
              	$.each(nodes, function(i, nd) {
              		if(nd != obj.node.id){
              			otherNode = nd;
              		}
              	});
              	ref.uncheck_node(otherNode);
              }
          });
		};

	/*初始化按钮事件*/
	MenuManage.initButtonEvent = function(){
	    /*排序树保存*/
	    $("#treeBtnSave").click(function(){
	    	var saveTree =function(){
	    		var ajax = new $ax(Hussar.ctxPath+"/menu/menuTreeOrder",
					function () {
                        MenuManage.refreshTree();
                        Hussar.success("保存成功！");
                        MenuManage.closeWindow();
                    },
					function () {
                        Hussar.error("保存失败！");
                    });
	    		ajax.setAsync(false);
	    		ajax.set("treeInfo",$("#output").val());
	    		ajax.start();
	    	};
	    	Hussar.confirm("确定要保存排序吗？", saveTree);
	    });
	    /*排序树重置*/
	    $("#treeBtnReset").click(function(){
	    	MenuManage.closeWindow();
	    });

	};

	/*根据组织机构ID展示组织机构信息*/
	MenuManage.loadMenuInfo=function(id){
		$("#menuInfo").attr("src",Hussar.ctxPath+"/menu/menuInfo?struId=" + id)
	};
	/*增加下级*/
	MenuManage.addMenuInfo=function(){
		 layer.close(MenuManage.infoWin);
		//获取选中的组织类型
		var orgType = $("#orgType").val();
		//获取上级组织机构ID
		var orgParentId = $("#orgParentId").val();
		//获取上级组织机构编码
		var orgParentCode = $("#orgParentCode").val();
		//获取上级组织机构名称
		var orgParentName = $("#orgParentName").val();
		//获取上级组织机构所在层级
		var struLevel = $("#struLevel").val();
		//获取上级组织机构子节点数量
		var childNum = $("#childNum").val();
		$("#menuInfo").attr("src",Hussar.ctxPath+"/menu/menuInfoAdd?orgParentId="+orgParentId+"&orgParentCode="+orgParentCode+"&orgParentName="+orgParentName+"&orgType="+orgType+"&struLevel="+struLevel+"&childNum="+childNum)
	};
	/*排序*/
	MenuManage.up=function(x,y){
		return x.seq-y.seq
	};
	/*关闭弹窗*/
	MenuManage.closeWindow=function () {
	    layer.close(MenuManage.infoWin);
	};
	MenuManage.initFrameHeight=function(){
        var h = $(window).height()-10;
		$("#menuFrame").css("height", h + "px");
		$("#treeArea").css("height", h-51 + "px");
	};

	/*初始化树查询*/
    MenuManage.initTreeSearch = function () {
        var to = false;
        //菜单树查询
        $("#menuTreeSearch").keyup(function () {
            if (to) { clearTimeout(to); }
            to = setTimeout(function () {
                var v = $("#menuTreeSearch").val();
                var temp = $("#menuTree").is(":hidden");
                if (temp == true) {
                    $("#menuTree").show();
                }
                $("#menuTree").jstree(true).search(v);
                //添加索引
                if(v!=''){
                    var n = $(".jstree-search").length,con_html;
                    if(n>0){
                        con_html = "<em>"+ n +"</em>个匹配项";
                    }else{
                        con_html = "无匹配项";
                    }
                    $(".search-results").html(con_html);
                    //定位到符合查询结果的树节点上
                    var searchResult = $("#menuTree").jstree('search', v);
                    $(searchResult).find('.jstree-search').focus();
                }else {
                    $(".search-results").html("");
                }

            }, 250);
        });
    };

	$(function () {
		MenuManage.initPage();
		$(window).resize(function() {
			MenuManage.initFrameHeight();
		});
	});
});