//需要置顶的字段
var TOP_SET_KEYS = ['keyspace_hits', 'keyspace_misses', 'redis_version', 'redis_mode', 'os', 'arch_bits',
    'connected_clients', 'total_system_memory_human', 'tcp_port'];

$(document).ready(function () {
    Highcharts.setOptions({
        global: {
            useUTC: false
        }
    });

    var chart;
    $('#container').highcharts({
        chart: {
            type: 'area',
            animation: Highcharts.svg,
            // don't animate in old IE
            marginRight: 20,
            marginTop: 70,
            backgroundColor: '#fcfcfc',
            borderWidth: 0,
            borderRadius: 0,
            events: {
                load: function () {
                    // set up the updating of the chart each second
                    var series = this.series[0];
                    setInterval(function () {
                            $.getJSON(hussar_path+'/redis/getMemeryInfo?timestamp=' + new Date().getTime(),
                                function (data) {
                                    data = JSON.parse(data);
                                    var x = Number(data.create_time),
                                    // current time
                                        y = data.used_memory / 1024;
                                    series.addPoint([x, y], true, true);
                                });
                        },
                        2000);
                }
            }
        },
        colors: ["#119f8e"],
        title: {
            text: '内存占用',
            style: {"color": "#1ea496"}
        },
        xAxis: {
            type: 'datetime',
            gridLineColor: "#ececec",
            tickPixelInterval: 150,
            crosshair: {
                width: 1,
                color: '#119f8e'
            }
        },
        yAxis: {
            title: {
                align: 'high',
                offset: 0,
                text: '内存占用(KB)',
                rotation: 0,
                y: -10,
                color: "#5c5c5c"
            },
            gridLineColor: "#ececec",
            lineColor: '#a6a59e',
            lineWidth: 1,
            crosshair: {
                width: 0
            }
        },
        tooltip: {
            formatter: function () {
                return '<b>' + this.series.name + '</b><br/>' + Highcharts.dateFormat('%Y-%m-%d %H:%M:%S', this.x)
                    + '<br/>' + Highcharts.numberFormat(this.y, 2);
            }
        },
        legend: {
            enabled: false
        },
        exporting: {
            enabled: false
        },

        plotOptions: {
            area: {
                fillColor: {
                    linearGradient: {
                        x1: 0,
                        y1: 0,
                        x2: 0,
                        y2: 1
                    },
                    stops: [
                        [0, 'rgba(17,159,142,0.4)'],
                        [1, 'rgba(17,159,142,0)']
                    ]
                },
                marker: {
                    radius: 2
                },
                lineWidth: 1,
                states: {
                    hover: {
                        lineWidth: 1
                    }
                },
                threshold: null
            }
        },
        series: [{
            name: '内存占用',
            data: (function () {
                var data = [],
                    time = (new Date()).getTime(),
                    i;

                for (i = -19; i <= 0; i++) {
                    data.push({
                        x: time + i * 1000,
                        y: 0//Math.random() * (1000 - 800) + 800
                    });
                }
                return data;
            })()
        }]
    });
    $('#keysChart').highcharts({
        chart: {
            type: 'area',
            animation: Highcharts.svg,
            // don't animate in old IE
            marginRight: 20,
            marginTop: 70,
            backgroundColor: '#fcfcfc',
            borderWidth: 0,
            borderRadius: 0,
            events: {
                load: function () {
                    // set up the updating of the chart each second
                    var series = this.series[0];
                    setInterval(function () {
                            $.getJSON(hussar_path+'/redis/getKeysSize?timestamp=' + new Date().getTime(),
                                function (data) {
                                    data = JSON.parse(data);
                                    var x = Number(data.create_time),
                                    // current time
                                        y = Number(data.dbSize);
                                    series.addPoint([x, y], true, true);
                                });
                        },
                        2000);
                }
            }
        },
        colors: ["#056bba"],
        title: {
            text: '字段数',
            style: {color: "#056bba"}
        },
        xAxis: {
            type: 'datetime',
            tickPixelInterval: 150,
            gridLineColor: "#ececec",
            crosshair: {
                width: 1,
                color: '#056bba'
            }
        },
        yAxis: {
            title: {
                align: 'high',
                offset: 0,
                text: '个数',
                rotation: 0,
                y: -10,
                color: "#5c5c5c"
            },
            gridLineColor: "#ececec",
            lineColor: '#a6a59e',
            lineWidth: 1,
            crosshair: {
                width: 0
            }
        },
        tooltip: {
            formatter: function () {
                return '<b>' + this.series.name + '</b><br/>' + Highcharts.dateFormat('%Y-%m-%d %H:%M:%S', this.x) + '<br/>' + Highcharts.numberFormat(this.y, 2);
            }
        },
        legend: {
            enabled: false
        },
        exporting: {
            enabled: false
        },

        plotOptions: {
            area: {
                fillColor: {
                    linearGradient: {
                        x1: 0,
                        y1: 0,
                        x2: 0,
                        y2: 1
                    },
                    stops: [
                        [0, 'rgba(5,107,186,0.4)'],
                        [1, 'rgba(5,107,186,0)']
                    ]
                },
                marker: {
                    radius: 2
                },
                lineWidth: 1,
                states: {
                    hover: {
                        lineWidth: 1
                    }
                },
                threshold: null
            }
        },
        series: [{
            name: '字段数',
            data: (function () {
                var data = [],
                    time = (new Date()).getTime(),
                    i;

                for (i = -19; i <= 0; i++) {
                    data.push({
                        x: time + i * 1000,
                        y: 0
                    });
                }
                return data;
            })()
        }]
    });
});

function empty() {
    parent.layer.confirm("确认要清空所有日志信息", {
            btn: ["确认", "取消"]
        },
        function () {
            $.ajax({
                type: "POST",
                url: hussar_path+"/redis/logEmpty",
                success: function (result) {
                    if (result == "OK") {
                        parent.layer.msg('日志清空成功！', {
                            icon: 6,
                            anim: 6,
                            offset: 't'
                        });
                    } else {
                        parent.layer.msg('日志清空失败，请重试！', {
                            icon: 5,
                            anim: 6,
                            offset: 't'
                        });
                    }
                }
            });
        },
        function () {
        })
}

function tableReorder() {
    var hits = Number($('#redisInfo-keyspace_hits').find('td:last').text()) || 0;
    var misses = Number($('#redisInfo-keyspace_misses').find('td:last').text()) || 0;
    var hitRate = ((hits / (hits + misses)) || 0) * 100;
    var rateKey = 'keyspace_hit_rate';

    var targetEl = $(
        "<tr class='redisInfoTableItems' id='redisInfo-" + rateKey + "'><td>" + rateKey +
        "</td><td>查找数据库键的成功命中率</td><td>" + hitRate.toFixed(2) + "%</td></tr>"
    ).insertAfter($('#redisInfoTableHeadRow'));
    TOP_SET_KEYS.forEach(function (v) {
        targetEl = $('#redisInfo-' + v).insertAfter(targetEl).show();
    });
}

layui.use(['flow'], function(){

    tableReorder();

    var $ = layui.jquery,
        flow = layui.flow,
        items = $(".redisInfoTableItems"),
        topLen = TOP_SET_KEYS.length,
        totalP = Math.ceil((items.length - topLen)/10);

    flow.load({
        elem: '#redisInfoTableBody',
        isAuto: false,
        done: function(page, next){
            if(page == 1){
                next('', page < totalP);
                $(".layui-flow-more").wrap("<tr><td colspan='3'></td></tr>");
                return;
            }
            page = page - 1;
            for(var i = 0; i < 10; i++){
                var item = items[i + topLen + (page - 1) * 10];
                if(item) $(item).show();
            }
            next('', page < totalP);
        }
    });
});