/**
 * @Description: 定义代办事件脚本文件
 * @Author: liangdong
 * @Date: 2018/4/20.
 */
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','form','table', 'laydate'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer = layui.layer;
	var $ax = layui.HussarAjax;
	var form = layui.form;
	var table = layui.table;
	var laydate = layui.laydate;
	
	/**
	 * 代办事件的单例
	 */
	var SysTodo = {
	    id: "ruleTable",	//表格id
	    seItem: null,		//选中的条目
	    table: null,
	    layerIndex: -1
	};

	/**
	 * 搜索代办事件
	 */
	SysTodo.search = function () {    
		var sendUserName = $('#sendUserName').val();
	    var taskTypeId = $('#taskTypeId').val();
	    var startTime = $('#startTime').val();
	    var endTime = $('#endTime').val();
	    
	    table.reload('todoTable', {page: {curr: 1},where:{
	    	sendUserName : sendUserName,
	    	taskTypeId : taskTypeId,
	    	startTime : startTime,
	    	endTime : endTime
        }});
	}

	/**
	 * 检查是否选中一条记录
	 */
	SysTodo.check = function () {
		var flag = false;
	    var selected = table.checkStatus('ruleTable').data;
	    if (selected && selected.length == 1) {
	    	SysTodo.seItem = selected;
	        flag = true;
	    } else {		
            Hussar.info("请选择一条记录！");
	    }
	    return flag;
	}
	
	/**
	 * 检查是否选中多条记录
	 */
	SysTodo.checkIds = function() {
		var selected = table.checkStatus('ruleTable').data;
		var ids = [];
		if (selected.length == 0) {
			Hussar.info("请至少选择一条记录！");
			return false;
		} else {
			for (var i = 0, l = selected.length; i < l; i++) {
				var r = selected[i];
				ids.push(r.ruleId);
			}
			var eId = ids.join(',');
			SysTodo.seItem = eId;
			return true;
		}
	};

	/**
	 * 关闭弹出窗
	 */
	SysTodo.closeWin = function () {
	    layer.close(SysTodo.layerIndex);
	}
	
	/**
	 * 初始化按钮事件
	 */
	SysTodo.initButtonEvent = function () {
		//查询按钮事件
		$("#btnSearch").click(function(){
			SysTodo.search();
	    });		
	}

	/**
	 * 初始化表格
	 */
	SysTodo.initTableView = function () {
        var sendUserName = $('#sendUserName').val();
        var taskTypeId = $('#taskTypeId').val();
        var startTime = $('#startTime').val();
        var endTime = $('#endTime').val();
		table.render({
			elem: '#todoTable',				
			url:Hussar.ctxPath+ '/sysTodo/list',
			page: true,	
			id: 'todoTable',
			even: true,
            height:$("body").height() - $(".layui-form").outerHeight(true)-26, 		
			cols: [[
			        {type: 'numbers', title: '序号', align: 'center',width:50},
//			        {title: '待办名称', field: 'todoName',  align: 'center', width: 150},	
			        {title: '业务名称', field: 'taskTypeName',  align: 'center', width: 150},	
		            {title: '发送人名称', field: 'sendUserName',  align: 'center', width: 130},		            	            
		            {title: '发送时间', field: 'sendTime',  align: 'center', width: 160},
		            {title: '业务详情', field: 'taskDetail',  align: 'left', },		            
			]],
			where: {
                sendUserName : sendUserName,
                taskTypeId : taskTypeId,
                startTime : startTime,
                endTime : endTime
			}
		});	
	}
	
	/**
	 * 初始化时间控件
	 */
	SysTodo.initLaydate = function () {
		var ts = laydate.render({
		   	 elem: '#startTime',
	         type : 'datetime',
	         done: function (value,date) {	
	        	 if (value !== '') {
	        		 te.config.min.year = date.year;
		        	 te.config.min.month = date.month - 1;
		        	 te.config.min.date = date.date;
		        	 te.config.min.hours = date.hours;
		        	 te.config.min.minutes = date.minutes;
		        	 te.config.min.seconds = date.seconds;
	        	 } else {
	        		 te.config.min.year = '';
		        	 te.config.min.month = '';
		        	 te.config.min.date = '';
		        	 te.config.min.hours = '';
		        	 te.config.min.minutes = '';
		        	 te.config.min.seconds = '';
	        	 }
	        	 	        	 
	         }
		});
		var te = laydate.render({
		   	 elem: '#endTime',
		     type : 'datetime',              
		     done: function (value,date) {			    	 
		    	 if (value !== '') {
		    		 ts.config.max.year = date.year;
		        	 ts.config.max.month = date.month - 1;
		        	 ts.config.max.date = date.date;
		        	 ts.config.max.hours = date.hours;
		        	 ts.config.max.minutes = date.minutes;
		        	 ts.config.max.seconds = date.seconds;
		    	 } else {
		    		 ts.config.max.year = '2099';
		        	 ts.config.max.month = '11';
		        	 ts.config.max.date = '31';
		        	 ts.config.max.hours = '0';
		        	 ts.config.max.minutes = '0';
		        	 ts.config.max.seconds = '0';
		    	 }
		    	 	 
		     }
		});
	}
	
	/**
	 * 初始化下拉框
	 */
	SysTodo.initSelectOption = function () {
		var ajax = new $ax(Hussar.ctxPath + "/sysTodo/todoTypeOption",
				function(data) {			
					$("select[name='taskTypeId']").html("<option value=''>业务名称</option>");					
					for (var i = 0; i < data.length; i++) {
						$("select[name='taskTypeId']").append(
								"<option value='" + data[i].value + "'>"
										+ data[i].label + "</option>");
					}
				}, function(data) {
					Hussar.error("获取代办类型失败!");
				});		
		ajax.start();
		form.render();
	}

	$(function () { 		
		SysTodo.initTableView(); //初始化表格    	    
	    SysTodo.initButtonEvent(); //初始化按钮事件
	    SysTodo.initLaydate();	//初始化时间控件
	    SysTodo.initSelectOption();	//初始化下拉框
	});
	
});


