/**
 * @Description: 解冻密码脚本文件
 * @Author: ChenXin
 * @Date: 2019/2/21.
 */
/**
 * 表格的初始化
 */
var ThawPwd = {
	id: "ThawPwdTable",	//表格id
	seItem: null,		//选中的条目 array
	table: null,
	layerIndex: -1,
	currentDBName: 'Login_Lock'
};

layui.use(['jquery', 'layer', 'table', 'HussarAjax', 'Hussar'], function() {

	var layer = layui.layer
		, table = layui.table
		, $ = layui.jquery
		, $ax = layui.HussarAjax
		, Hussar = layui.Hussar;


	/**
	 * 	初始化表格
	 */
	ThawPwd.initTableView = function () {
		layui.use('table', function(){
			var table = layui.table;
			table.render({
				elem: '#ThawPwdTable',
				url: Hussar.ctxPath+'/ehcache/list',
				page: false,
				id: 'ThawPwdTable',
				limit:9999999,
				even: true,
				height:$("body").height() - $(".layui-form").outerHeight(true)-26,
				cols: [[{type: 'checkbox',width:40},
					{type: 'numbers', title: '序号', align: 'center',width:50},
					{field: 'key', title: '键名', align:'center'},
					{field: 'value', title: '值', align:'center', templet:value}
				]],
				where: {
					cacheName: ThawPwd.currentDBName,
					key: ''
				}
			});

		});
	}

	function value(d) {
		return JSON.stringify(d);
	};



	/**
	 * 检查是否选中
	 */
	ThawPwd.check = function () {
		var flag = false;
		var selected = table.checkStatus('ThawPwdTable').data;
		if (selected && selected.length > 0) {
			ThawPwd.seItem = selected;
			flag = true;
		} else {
			// layer.confirm("请至少选择一条记录！ ", { btn: ['确认'],title:'信息'});
			Hussar.info("请至少选择一条记录！");
		}
		return flag;
	};

	/**
	 * 删除字段
	 */
	ThawPwd.delete = function () {
		if (ThawPwd.check()) {
			var idArr = [];
			ThawPwd.seItem.forEach(function (v) {
				idArr.push(v.key);
			});
			var operation = function () {
				var ajax = new $ax(Hussar.ctxPath+"/ehcache/deleteByKeys", function (data) {
					if(data.code == '200'){
						Hussar.success("删除成功！");
						ThawPwd.search();
					}else{
						Hussar.error("删除失败！（" + data.mess + "）")
					}
				}, function (data) {
					Hussar.error("删除失败！（" + data.responseJSON.message + "）");
				});
				ajax.set("keys", JSON.stringify(idArr));
				ajax.set("cacheName", ThawPwd.currentDBName);
				ajax.start();
			};
			Hussar.confirm("确定要删除吗？", operation);
		}
	};

	/**
	 * 查询字段列表
	 */
	ThawPwd.search = function () {
		var queryData = {};
		queryData['key'] = $("#condition").val();
		queryData['cacheName'] = ThawPwd.currentDBName;
		table.reload('ThawPwdTable', {where: queryData});
	};

	$(function () {
		var bodyH = $("body").height();
		$(".tree-box").css("height", bodyH + "px");
		ThawPwd.initTableView();
	});
});
