/**
* @Description: Tab标签操作工具
* @CreateDate:     2018/10/31 17:52
* @Version:        1.0
*/
var tab = {
};
layui.define(['jquery', 'form', 'layer', 'element', 'Hussar'], function(exports) {
    var $ = layui.jquery,
        form = layui.form,
        layer = layui.layer,
        element = parent.parent.layui.element,
        Hussar = layui.Hussar;
    var menu = [];
    var curMenu;
    /*
     * @todo tab触发事件：增加、删除、切换
     */
    $(function() {
        tab = {
            tabAdd: function(title, url, id) {
                //判断当前id的元素是否存在于tab中
                // var li = parent.$("#WeTabTip li[lay-id=" + id + "]").length;
                var li = 0;
                if(li > 0) {
                    //tab已经存在，直接切换到指定Tab项
                    //console.log(">0");
                    element.tabChange('wenav_tab', id);
                } else {
                    //该id不存在，新增一个Tab项
                    //console.log("<0");
                    element.tabAdd('wenav_tab', {
                        title: title,
                        content: '<iframe tab-id="' + id + '" frameborder="0" src="' + url + '" scrolling="yes" class="weIframe"></iframe>',
                        id: id
                    });
                    element.tabChange('wenav_tab', id);
                    //当前窗口内容
                    //setStorageMenu(title, url, id);
                }
               CustomRightClick(id); //绑定右键菜单
                FrameWH(); //计算框架高度

            },
            tabDelete: function(id) {
                element.tabDelete("wenav_tab", id); //删除
                //removeStorageMenu(id);

            },
            tabChange: function(id,src) {
                //切换到指定Tab项
                element.tabChange('wenav_tab', id);
                //切换到指定tab页并刷新tab页
                var othis = parent.$('.layui-tab-title').find('>li[lay-id="' + id + '"]'),
                    index = othis.parent().children('li').index(othis),
                    parents = othis.parents('.layui-tab').eq(0),
                    item = parents.children('.layui-tab-content').children('.layui-tab-item');
                if(src == null || src == undefined){
                    src = item.eq(index).find('iframe').attr("src");
                }
                item.eq(index).find('iframe').attr("src", src);
            },
            tabDeleteAll: function(ids) { //删除所有
                $.each(ids, function(i, item) {
                    if(item != '000000'){
                        element.tabDelete("wenav_tab", item);
                    }
                })

            }
        };
    });

    /*
     * @todo 监听右键事件,绑定右键菜单
     * 先取消默认的右键事件，再绑定菜单，触发不同的点击事件
     */
    function CustomRightClick(id) {
        //取消右键
        parent.$('.layui-tab-title li').on('contextmenu', function() {
            return false;
        });
        parent.$('.layui-tab-title,.layui-tab-title li').on('click', function() {
            $('.rightMenu').hide();
        });
        //桌面点击右击
        parent.$('.layui-tab-title li').on('contextmenu', function(e) {
            var index;
            if(parent){
                index = parent.$('.layui-tab-title li').index(this);
            }else{
                index = $('.layui-tab-title li').index(this);
            }
            if(index>0){
                var aid = $(this).attr("lay-id"); //获取右键时li的lay-id属性
                var popupmenu = parent.$(".rightMenu");
                popupmenu.find("li").attr("data-id", aid);
                //console.log("popopmenuId:" + popupmenu.find("li").attr("data-id"));
                l = (parent.$(document).width() - e.clientX) < popupmenu.width() ? (e.clientX - popupmenu.width()) : e.clientX;
                t = (parent.$(document).height() - e.clientY) < popupmenu.height() ? (e.clientY - popupmenu.height()) : e.clientY;
                popupmenu.css({
                    left: l,
                    top: t
                }).show();
                //alert("右键菜单")
            }else {
                parent.$('.rightMenu').hide();
            }

            return false;
        });
    };


    parent.$("#rightMenu li").click(function() {
        var type = $(this).attr("data-type");
        var layId = $(this).attr("data-id")
        if(type == "current") {
            //console.log("close this:" + layId);
            tab.tabDelete(layId);
        } else if(type == "all") {
            //console.log("closeAll");
            var tabtitle;
            if(parent){
                tabtitle = parent.$(".layui-tab-title li");
            }else{
                tabtitle = $(".layui-tab-title li");
            }
            var ids = new Array();
            $.each(tabtitle, function(i) {
                if($(this).attr("lay-id") != '000000'){
                    ids[i] = $(this).attr("lay-id");
                }
            })
            tab.tabDeleteAll(ids);
        } else if(type == "fresh") {
            //console.log("fresh:" + layId);
            tab.tabChange($(this).attr("data-id"));
            var othis = parent.$('.layui-tab-title').find('>li[lay-id="' + layId + '"]'),
                index = othis.parent().children('li').index(othis),
                parents = othis.parents('.layui-tab').eq(0),
                item = parents.children('.layui-tab-content').children('.layui-tab-item'),
                src = item.eq(index).find('iframe').attr("src");
            item.eq(index).find('iframe').attr("src", src);
        } else if(type == "other") {
            var thisId = layId;
            if(parent){
                parent.$('.layui-tab-title').find('li').each(function(i, o) {
                    var layId = parent.$(o).attr('lay-id');
                    if(layId != thisId && layId != 0) {
                        tab.tabDelete(layId);
                    }
                });
            }

        }
        if(parent){
            parent.$('.rightMenu').hide();
        }
    });

    /*
     * @todo 重新计算iframe高度
     */
    function FrameWH() {
        var h = parent.$(".layui-tab-content").innerHeight() -20;
        parent.$("iframe").css("height", h + "px");
    };
    parent.$(window).resize(function() {
        FrameWH();
    });
    /*弹出层+传递ID参数*/
    window.WeAdminEdit = function(title, url, id, w, h) {
        if(title == null || title == '') {
            title = false;
        };
        if(url == null || url == '') {
            url = "404.html";
        };
        if(w == null || w == '') {
            w = (parent.$(window).width() * 0.9);
        };
        if(h == null || h == '') {
            h = (parent.$(window).height() - 50);
        };
        layer.open({
            type: 2,
            area: [w + 'px', h + 'px'],
            fix: false, //不固定
            maxmin: true,
            shadeClose: true,
            shade: 0.4,
            title: title,
            content: url,
            success: function(layero, index) {
                //向iframe页的id=house的元素传值  // 参考 https://yq.aliyun.com/ziliao/133150
                var body = layer.getChildFrame('body', index);
                body.contents().find("#dataId").val(id);
                console.log(id);
            },
            error: function(layero, index) {
                alert("aaa");
            }
        });
    };

    /**
     *@todo tab监听：点击tab项对应的关闭按钮事件
     */
    parent.$('.layui-tab-close').click(function(event) {
        if(parent){
            parent.$('.layui-tab-title li').eq(0).find('i').remove();
        }
    });
    /**
     *@todo tab切换监听
     * tab切换监听不能写字初始化加载$(function())方法内，否则不执行
     */
    element.on('tab(wenav_tab)', function(data) {
        //console.log(this); //当前Tab标题所在的原始DOM元素
        //setStorageCurMenu();
    });
    /*
     * @todo 监听layui Tab项的关闭按钮，改变本地存储
     */
    element.on('tabDelete(wenav_tab)', function(data) {
        var layId = $(this).parent('li').attr('lay-id');
        //console.log(layId);
        //removeStorageMenu(layId);
    });
    /**
     *@todo 本地存储 localStorage
     * 为了保持统一，将sessionStorage更换为存储周期更长的localStorage
     */
    //本地存储记录所有打开的窗口
    function setStorageMenu(title, url, id) {
        var menu = JSON.parse(sessionStorage.getItem(userId+"menu"));
        if(menu) {
            var deep = false;
            for(var i = 0; i < menu.length; i++) {
                if(menu[i].id == id) {
                    deep = true;
                    menu[i].title = title;
                    menu[i].url = url;
                    menu[i].id = id;
                }
            }
            if(!deep) {
                menu.push({
                    title: title,
                    url: url,
                    id: id
                })
            }
        } else {
            var menu = [{
                title: title,
                url: url,
                id: id
            }]
        }
        sessionStorage.setItem(userId+"menu", JSON.stringify(menu));
    };
    //本地存储记录当前打开窗口
    function setStorageCurMenu() {
        var curMenu = sessionStorage.getItem(userId+'curMenu');
        var text = $('.layui-tab-title').find('.layui-this').text();
        text = text.split('ဆ')[0];
        var url = $('.layui-tab-content').find('.layui-show').find('.weIframe').attr('src');
        var id =  $('.layui-tab-title').find('.layui-this').attr('lay-id');
        //console.log(text);
        curMenu = {
            title: text,
            url: url,
            id: id
        }
        sessionStorage.setItem(userId+'curMenu', JSON.stringify(curMenu));
    };
    //本地存储中移除删除的元素
    function removeStorageMenu(id) {
        var menu = JSON.parse(sessionStorage.getItem(userId+"menu"));
        //var curMenu = JSON.parse(localStorage.getItem(userId+'curMenu'));
        if(menu) {
            var deep = false;
            for(var i = 0; i < menu.length; i++) {
                if(menu[i].id == id) {
                    deep = true;
                    menu.splice(i, 1);
                }
            }
        } else {
            return false;
        }
        sessionStorage.setItem(userId+"menu", JSON.stringify(menu));
    };

    /**
     *@todo Frame内部的按钮点击打开其他frame的tab
     */

    exports('admin', {});
});