/**
* @Description:    工作日历脚本文件
* @Author:         LiangDong
* @CreateDate:     2018/5/15 15:33
* @UpdateUser:     LiangDong
* @UpdateDate:     2018/5/15 15:33
* @UpdateRemark:   修改内容
* @Version:        1.0
*/
var Calendar = {
    permission: false,
    layerIndex: -1
};
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','form','laydate'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer = layui.layer;
	var $ax = layui.HussarAjax;


    /**
	 * 初始化工作日历
     */
    Calendar.initWorkCalendar = function () {
        $('#calendar').fullCalendar({
            customButtons: {
                addButton: {
                    text: '新增',
                    click: function() {
                        if (Calendar.permission) {
                            Calendar.openAddWin();      //打开新增对话框
                        } else {
                            Calendar.noPermissionInfo();
                        }
                    }
                },
                delButton: {
                    text: '删除',
                    click: function () {
                        if (Calendar.permission) {
                            Calendar.openDelWin();      //打开删除对话框
                        } else {
                            Calendar.noPermissionInfo();
                        }
                    }
                }
            },
            header: {
                left: 'prevYear,prev,next,nextYear, today ',
                center: 'title',
                right: 'addButton,delButton'
            },
            editable: true,
            eventLimit: true, // allow "more" link when too many events
            locale: 'zh-cn',
            weekends: true, //是否显示周末
            selectable: true,
            weekMode: 'liquid',
            eventStartEditable: false,  //事件不可拖拉
            events: function (start, end, timezone, callback) {
                var events = [];
                var ajax = new $ax(Hussar.ctxPath + "/calendar/list",
                    function(data) {
                        events = data;
                        callback(events);
                    },
                    function(data) {
                        Hussar.error("获取事件失败!");
                    });
                ajax.set("startTime", start.format('YYYY-MM-DD') );
                ajax.set("endTime", end.format('YYYY-MM-DD') );
                ajax.start();
            },
            dayClick: function(date, allDay, jsEvent, view) {
                var events = $('#calendar').fullCalendar('clientEvents', function(event) {
                    var eventStart = event.start.format('YYYY-MM-DD');
                    var eventEnd = event.end ? event.end.format('YYYY-MM-DD') : null;
                    var theDate = date.format('YYYY-MM-DD');
                    // Make sure the event starts on or before date and ends afterward
                    // Events that have no end date specified (null) end that day, so check if start = date
                    return (eventStart <= theDate && (eventEnd >= theDate) && !(eventStart < theDate && (eventEnd == theDate))) || (eventStart == theDate && (eventEnd === null));
                });
                if (events.length == 0) {
                    //如果当天没有事件，就弹出新增当天事件的对话框
                    if (Calendar.permission) {
                        Calendar.openAddOneWin(date);
                    }
                }

            },
            eventClick: function (event, jsEvent, view) {
                if (Calendar.permission) {
                    Calendar.openEditWin(event);     // 打开修改对话框
                }
            },
            eventMouseover: function (event, jsEvent, view) {
                if (event.remark.length != 0){
                    var that = this;
                    layer.tips(event.remark,
                        that, {
                            tips: [1, '#FF9966'],
                            time: 0
                        });
                }
            },
            eventMouseout: function (event, jsEvent, view) {
                layer.closeAll('tips');
            }
        });
    };


    /**
     *  打开新增对话框
     */
    Calendar.openAddWin = function () {
        Calendar.layerIndex = layer.open({
            type: 2,
            title: '新增事件',
            area: ['450px', '400px'], //宽高
            fix: false, //不固定
            maxmin: false,
            shadeClose: false,
            content: Hussar.ctxPath+'/calendar/addView'
        });
    };

    /**
     *  打开新增单日事件对话框
     */
    Calendar.openAddOneWin = function (date) {
        var theDate = date.format('YYYY-MM-DD');
        Calendar.layerIndex = layer.open({
            type: 2,
            title: '新增事件',
            area: ['450px', '300px'], //宽高
            fix: false, //不固定
            maxmin: false,
            shadeClose: false,
            content: Hussar.ctxPath+'/calendar/addOneView/'+theDate
        });
    };

    /**
     *  打开修改对话框
     */
    Calendar.openEditWin = function (event) {
        Calendar.layerIndex = layer.open({
            type: 2,
            title: '修改事件',
            area: ['450px', '300px'], //宽高
            fix: false, //不固定
            maxmin: false,
            shadeClose: false,
            content: Hussar.ctxPath+'/calendar/editView/'+ event.id
        });
    };

    /**
     *  打开删除对话框
     */
    Calendar.openDelWin = function () {
        Calendar.layerIndex = layer.open({
            type: 2,
            title: '删除事件',
            area: ['450px', '400px'], //宽高
            fix: false, //不固定
            maxmin: false,
            shadeClose: false,
            content: Hussar.ctxPath+'/calendar/deleteView'
        });
    };


    /**
     * 刷新工作日历[供子页面调用]
     */
    Calendar.refreshCalendar = function () {
        $('#calendar').fullCalendar('refetchEvents');
        layer.close(Calendar.layerIndex);
    };

    /**
     * 没有权限时的提示
     */
    Calendar.noPermissionInfo = function () {
        Hussar.info("对不起，您没有操作权限！");
    };

    /**
     * 鉴定当前用户是否具有操作权限
     */
    Calendar.authentication = function () {
        Calendar.permission = $("#permission").val() == "true";
    };


	$(function () {
        Calendar.authentication();
		Calendar.initWorkCalendar();	//初始化工作日历
	});
	
});




