/**
 * @Description: 定义修改密码脚本文件
 * @Author: liangdong
 * @Date: 2018/3/14.
 */
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','form','HussarSecurity'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer = layui.layer;
	var $ax = layui.HussarAjax;
	var form = layui.form;
	var Security = layui.HussarSecurity;
	
	var ChangePwd = {		    
		    layerIndex: -1
		};
	
	ChangePwd.initButtonEvent = function () {
		$("#btnSave").click(function(){
			form.on('submit(go)', function(data){
				ChangePwd.save();
			});			
	    });
		$("#btnClose").click(function(){
			closeWin();
	    });
	}
	
	closeWin = function () {//关闭弹出窗口
		var index = parent.layer.getFrameIndex(window.name);
		parent.layer.close(index);
	}
	
	ChangePwd.save = function () {//保存修改密码
//		var data = encode64($("#pwdForm").serialize());		//前台加密	

		var data = Security.encode($("#pwdForm").serialize());//调用加密方法进行加密

		// 提交信息
		var ajax = new $ax(Hussar.ctxPath + "/user/updatePwd", function(data) {
			if (data.code == "200") {					
				closeWin();
				parent.layui.Hussar.success("密码修改成功!");	
			} else if (data.code) {
				Hussar.error(data.message);
			} else {
				Hussar.error("密码修改失败!");
			}			
		}, function(data) {
			Hussar.error("密码修改失败!");
		});
		ajax.set("data",data);
		ajax.start();			
	}
	
	/**
	 * 表单验证
	 */
	ChangePwd.initValidate = function () {
		form.verify({
			required : function(value, item){
				if(value==""){					
					return '必填项不能为空';
				}
			},
			pwd: [/^[\S]{6,12}$/ , '密码必须6到12位，且不能出现空格'] 
		});						
	}

	$(function () { 
		ChangePwd.initButtonEvent();	
		ChangePwd.initValidate();
		Security.initSecurityKey();// 初始化加密密钥
	});
	
});




