/**
 * @Description: 角色管理脚本文件
 * @Author: chenxin
 * @Date: 2018/2/27.
 */
var RoleManage = {
    layIndex: null
};
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','form','element'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer=layui.layer;
	var $ax=layui.HussarAjax;
	var jstree=layui.jstree;
    var element=layui.element;


    RoleManage.initTree = function () {
        var $tree = $("#roleTree");//角色树
        $tree.jstree({
            core: {
                check_callback: true,
                data: function (obj, callback) {
                    var data;
                    var ajax = new $ax(Hussar.ctxPath + "/roleManager/roleTree",function(result) {
                        data = result;
                    }, function(data) {
                        Hussar.error("加载角色列表失败！");
                    });
                    ajax.start();
                    callback.call(this, data);
                }
            },
            contextmenu:{
                select_node:true,
                show_at_node:true,
                'items' : RoleManage.contextmenu
            },
            plugins: ['contextmenu','types','search'],
            types: {
                "GROUP":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/roleGroup.png"},
                "ROLE":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/role.png"},
                "isRoot":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/root.png"}
            },
            search : RoleManage.search()
        });
        $tree.bind('activate_node.jstree', function (obj,e){
            if(e.node.original.code == 'ROLE'){
                $("#roleIframe").attr("src",Hussar.ctxPath + "/roleManager/roleViewPage?id=" + e.node.id)
            }else if(e.node.original.code == 'GROUP'&&e.node.original.parent != '#'){
                $("#roleIframe").attr("src",Hussar.ctxPath + "/roleManager/roleGroupViewPage?id=" + e.node.id)
            }else{
                $("#roleIframe").attr("src","")
            }
        })
    };

    /**
     * 树查询
     */
    RoleManage.search = function () {
        var to = false;
        $("#txtIndustryArea").keyup(function () {
            if (to) { clearTimeout(to); }
            to = setTimeout(function () {
                var v = $("#txtIndustryArea").val();
                var temp = $("#roleTree").is(":hidden");
                if (temp == true) {
                    $("#roleTree").show();
                }
                $("#roleTree").jstree(true).search(v);
                //添加索引
                if(v!=''){
                    var n = $(".jstree-search").length,con_html;
                    if(n>0){
                        con_html = "<em>"+ n +"</em>个匹配项";
                    }else{
                        con_html = "无匹配项";
                    }
                    $(".search-results").html(con_html);
                    //定位到符合查询结果的树节点上
                    var searchResult = $("#roleTree").jstree('search', v);
                    $(searchResult).find('.jstree-search').focus();
                }else {
                    $(".search-results").html("");
                }
            }, 250);
        });
    };

    /**
     * 右键菜单
     */
    RoleManage.contextmenu = function (node) {
    //不同节点菜单不一样
        var items = {
            'item1' : {
                    'label' : '新增角色分组',
                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5011.png",
                    'action' : function () {
                        $("#roleIframe").attr("src",Hussar.ctxPath + "/roleManager/roleAddGroupPage?type=add&id="+node.id);
                    }
                },
            'item2' : {
                'label' : '新增角色',
                'action' : function () { /* 写点击处理函数 */
                    $("#roleIframe").attr("src",Hussar.ctxPath + "/roleManager/roleAddPage?id="+node.id);
                },
                'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5011.png"
            },
            'item3' : {
                'label' : '修改',
                'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/53.png",
                'action' : function () {
                    $("#roleIframe").attr("src",Hussar.ctxPath + "/roleManager/roleEditPage?id="+node.id);
                }
            },
            'item4' : {
                'label' : '回收权限',
                'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5411.png",
                'action' : function () {
                    var operation = function() {
                        var ajax = new $ax(Hussar.ctxPath + "/roleManager/reclaimPerm",
                            function() {
                                Hussar.success("回收权限成功！");
                                $("#roleIframe").attr("src",Hussar.ctxPath + "/roleManager/roleViewPage?id=" + node.id)
                            },
                            function(data) {
                                Hussar.error("回收权限成功！");
                            });
                        ajax.set("id", node.id);
                        ajax.start();
                    };
                    Hussar.confirm("确定要回收权限吗?", operation);
                }
            },
            'item5' : {
                'label' : '删除',
                'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/57.png",
                'action' : function () {
                        var operation = function() {
                            var ajax = new $ax(Hussar.ctxPath + "/roleManager/delRole",
                                function(data) {
                                if(data.code=="200"){
                                    Hussar.success("删除成功！");
                                    RoleManage.refreshPage();
                                }
                                else if (data.code == "409") {
                                    Hussar.error("删除失败！("+data.message+")");
                                }else {
                                    Hussar.error(data.message+"！");
                                }
                                },
                                function(data) {
                                    Hussar.error("删除失败！");
                                });
                            ajax.set("id", node.id);
                            ajax.start();
                        };
                        Hussar.confirm("确定要删除吗?", operation);

                }
            },
            'item6' : {
                'label' : '修改',
                'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/53.png",
                'action' : function () {
                    $("#roleIframe").attr("src",Hussar.ctxPath + "/roleManager/roleAddGroupPage?type=edit&id="+node.id);
                }
            },
            'item7' : {
                'label' : '删除',
                'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/57.png",
                'action' : function () {
                        var operation = function() {
                            var ajax = new $ax(Hussar.ctxPath + "/roleManager/searchRoleToGroup",
                                    function(data) {
                                if(data.length!=0){
                                    Hussar.info("请先删除角色！");
                                }else{
                                    var ajax = new $ax(Hussar.ctxPath + "/roleManager/delGroup",
                                            function(data) {
                                        if(data.code=="200"){
                                            Hussar.success("删除成功！");
                                            RoleManage.refreshPage();
                                        }else{
                                            Hussar.error(data.message+"！");
                                        }
                                            },
                                            function(data) {
                                                Hussar.error("删除失败！");
                                            });
                                        ajax.set("id", node.id);
                                        ajax.start();
                                }
                                    },
                                    function(data) {
                                        Hussar.error("查询角色分组下是否存在角色失败！");
                                    });
                                ajax.set("id", node.id);
                                ajax.start();
                        };
                        Hussar.confirm("确定要删除吗?", operation);

                }
            },
            'item8' : {
                'label' : '分组排序',
                'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5111.png",
                'action' : function () {
                    RoleManage.groupOrder(node);

                }
            },
            'item9' : {
                'label' : '角色排序',
                'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5111.png",
                'action' : function () {
                    RoleManage.roleOrder(node);
                }
            }
        };
        if(node!=undefined){
            if(node.original.code == 'ROLE'){
                var ajax = new $ax(Hussar.ctxPath + "/roleManager/queryPerm",function(json) {//角色是否有权限
                    if(json.length==0){//角色下无权限删除回收权限菜单
                        delete items.item4;
                    }
                }, function(data) {
                    Hussar.error("获取角色权限失败！");
                });
                ajax.set("id", node.id);
                ajax.start();
            }

                if (node.original.code == 'GROUP'&&node.original.parent != '#') {
                    //角色分组拥有的右键菜单
                    var shiroAdd=$("#shiroAdd").val();
                    var editGroup=$("#editGroup").val();
                    var delGroup=$("#delGroup").val();
                    if(shiroAdd!="add"){
                        delete items.item2;
                    }
                    if(editGroup!="editGroup"){
                        delete items.item6;
                    }
                    if(delGroup!="delGroup"){
                        delete items.item7;
                    }
                    delete items.item1;
                    delete items.item3;
                    delete items.item4;
                    delete items.item5;
                    delete items.item8;
                } else if(node.original.parent == '#'){
                    //根节点右键菜单
                    var saveGroup=$("#saveGroup").val();
                    if(saveGroup!="saveGroup"){
                        delete items.item1;
                    }
                    delete items.item3;
                    delete items.item4;
                    delete items.item5;
                    delete items.item6;
                    delete items.item7;
                }else{
                    //角色排序
                    var shiroEdit=$("#shiroEdit").val();
                    var shiroDel=$("#shiroDel").val();
                    var shiroRec=$("#shiroRec").val();
                    if(shiroEdit!="edit"){
                        delete items.item3;
                    }
                    if(shiroRec!="rec"){
                        delete items.item4;
                    }
                    if(shiroDel!="del"){
                        delete items.item5;
                    }
                    delete items.item1;  //删除节点 items
                    delete items.item2;
                    delete items.item6;
                    delete items.item7;
                    delete items.item8;
                    delete items.item9;
                }
                return items;
        }

    };

    RoleManage.initFrameHeight=function(){
        var h = $(window).height()-60;
        var h2 = $(window).height()-10;
        $("#roleIframe").css("height", h2 + "px");
        $("#roleInfo").css("height", h + "px");
    };

    /**
     *  刷新页面，供子页面调用
     *  @author LiangDong
     */
    RoleManage.refreshPage = function () {
        $("#roleTree").jstree(true).refresh();
        $("#roleIframe").attr("src","");
    };


    /**
     * 初始化排序树
     */
    RoleManage.initOrderTree = function () {
        var $orderTree = $("#orderTree"); //排序树
        $orderTree.jstree({
            core: {
                check_callback: function (operation, node, node_parent, node_position, more) {
                    if(operation=='move_node'){
                        if(node.parent==node_parent.parent||node_parent.parent==null){
                            return false;
                        }else{
                            return true;
                        }
                    }else{
                        return true;
                    }
                },
                data: null
            },
            plugins: ['types', "dnd"],
            types: {
                "GROUP":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/roleGroup.png"},
                "ROLE":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/role.png"},
                "isRoot":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/root.png"}
            },
            sort:function(a,b){
                return this.get_node(a).original.seq > this.get_node(b).original.seq ? 1 : -1;
            }
        });

        //移动树事件
        var resultDom = $("#output");   //隐藏结果集dom
        $orderTree.bind('move_node.jstree', function (e, data) {
            //移动的组织ID
            var id = data.node.id;
            //移动之前的位置
            var oldPosition = data.old_position;
            //移动后的位置
            var position = data.position;
            //原地未动
            if(oldPosition==position){
                return;
            }
            var oldResult = JSON.parse(resultDom.val());
            //向上移动
            if(position-oldPosition<0){
                for(var i=0;i<oldResult.length;i++){
                    if(i<position){
                        oldResult[i].seq=i+1;
                    }else{
                        if(oldResult[i].id==id){
                            oldResult[i].seq=position+1;
                        }else{
                            if(i<=oldPosition){
                                oldResult[i].seq=i+2;
                            }else{
                                oldResult[i].seq=i+1;
                            }
                        }
                    }
                }
            }else{//向下移动
                for(var i=0;i<oldResult.length;i++){
                    if(i<oldPosition){
                        oldResult[i].seq=i+1;
                    }else{
                        if(oldResult[i].id==id){
                            oldResult[i].seq=position+1;
                        }else{
                            if(i<=position){
                                oldResult[i].seq=i;
                            }else{
                                oldResult[i].seq=i+1;
                            }
                        }
                    }
                }
            }
            oldResult.sort(RoleManage.up);
            resultDom.val(window.JSON.stringify(oldResult));
        });
        
    };

    /**
     * 角色排序
     */
    RoleManage.up = function (x,y) {
        return x.seq-y.seq;
    };

    /**
     * 分组排序
     * @param node
     */
    RoleManage.groupOrder = function (node) {
        RoleManage.layIndex = layer.open({
            type: 1,
            btn: ['取消', '保存'],
            skin: 'confirm-class',
            area: ['350px','500px'],
            fix: false, //不固定
            maxmin: false,
            shadeClose: false,
            shade: 0.4,
            title: "分组排序",
            content: $('#roleOrder'),
            btn2: function(index, layero){
                //保存角色分组排序
                var operation = function () {
                    var info = $("#output").val();
                    var ajax = new $ax(Hussar.ctxPath + "/roleManager/saveGroupOrder",function(data) {
                        if (data.code == "200") {
                            Hussar.success("保存成功!");
                            layer.close(RoleManage.layIndex);
                            $("#roleTree").jstree(true).refresh();
                        } else if (data.code) {
                            Hussar.error(data.message);
                        } else {
                            Hussar.error("保存失败!");
                        }
                    }, function(data) {
                        Hussar.error("角色分组排序保存失败！");
                    });
                    ajax.set("info",info);
                    ajax.start();
                };
                Hussar.confirm("确定要保存排序吗？", operation);
                return false;
            },
            success:function(){
                //添加按钮图标
                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
                //加载排序树数据
                var ajax = new $ax(Hussar.ctxPath + "/roleManager/groupOrderTree",function(result) {
                    //排序树数据
                    $("#orderTree").jstree(true).settings.core.data = result;
                    $("#orderTree").jstree(true).refresh();
                    //除根节点数据保存到隐藏域里
                    var newResult=[];
                    for(var i=0;i<result.length;i++){
                        if(result[i].parent!="#"){
                            newResult.push(result[i]);
                        }
                    }
                    $("#output").val(window.JSON.stringify(newResult));
                }, function(data) {
                    Hussar.error("加载角色分组树失败！");
                });
                ajax.start();
            }
        });
    };

    /**
     * 角色排序
     * @param node
     */
    RoleManage.roleOrder = function (node) {
        RoleManage.layIndex = layer.open({
            type: 1,
            btn: ['取消', '保存'],
            skin: 'confirm-class',
            area: ['350px','500px'],
            fix: false, //不固定
            maxmin: false,
            shadeClose: false,
            shade: 0.4,
            title: "角色排序",
            content: $('#roleOrder'),
            btn2: function(index, layero){
                var operation = function () {
                    //保存角色分组排序
                    var info = $("#output").val();
                    var ajax = new $ax(Hussar.ctxPath + "/roleManager/saveRoleOrder",function(data) {
                        if (data.code == "200") {
                            Hussar.success("保存成功!");
                            layer.close(RoleManage.layIndex);
                            $("#roleTree").jstree(true).refresh();
                        } else if (data.code) {
                            Hussar.error(data.message);
                        } else {
                            Hussar.error("保存失败!");
                        }
                    }, function(data) {
                        Hussar.error("角色分组排序保存失败！");
                    });
                    ajax.set("info",info);
                    ajax.start();
                };
                Hussar.confirm("确定要保存排序吗？", operation);
                return false;
            },
            success:function(){
                //添加按钮图标
                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
                //加载排序树数据
                var ajax = new $ax(Hussar.ctxPath + "/roleManager/roleOrderTree",function(result) {
                    //排序树数据
                    $("#orderTree").jstree(true).settings.core.data = result;
                    $("#orderTree").jstree(true).refresh();
                    //除根节点数据保存到隐藏域里
                    var newResult=[];
                    for(var i=0;i<result.length;i++){
                        if(result[i].parent!="#"){
                            newResult.push(result[i]);
                        }
                    }
                    $("#output").val(window.JSON.stringify(newResult));
                }, function(data) {
                    Hussar.error("加载角色分组树失败！");
                });
                var parent = node.id;
                ajax.set("parent", parent);
                ajax.start();
            }
        });
        
    };


/**
 * 初始化
 */
$(function() {
    RoleManage.initTree();
    RoleManage.initOrderTree();
    RoleManage.contextmenu();
    RoleManage.initFrameHeight();
    $(window).resize(function() {
    	RoleManage.initFrameHeight();
	});
});



});


