/**
 * @Description: 组织机构新增
 * @Author: sunZengXin
 * @Date: 2018/2/6.
 */
layui.use(['jquery','layer','Hussar','form', 'laydate','table'], function(){
	var form=layui.form,
		laydate = layui.laydate,
		$ = layui.jquery,
		Hussar = layui.Hussar,
		table = layui.table;
	var OrgInfoAdd={
			id:"orgInfoAdd"
	}
	OrgInfoAdd.initPage=function(){
		  //日期
		  laydate.render({
		    elem: '#beginDate'
		  });
		  laydate.render({
		    elem: '#endDate'
		  });
		OrgInfoAdd.initButtonEvent();
	}
	OrgInfoAdd.initButtonEvent=function(){
		//负责人选择
		$("#principalName").click(function(){
			layer.open({
  				type: 1,
  				btn: ['取消','保存'],
  				skin: 'confirm-class',
  				area: ['750px', '500px'], //宽高
  				fix: false, //不固定
  				maxmin: false,
  				shadeClose: false,
  				shade: 0.4,
  				title: "选择负责人",
  				content: $("#principalDiv"),
  				btn2: function(index, layero){
  					var checkRadioStatus =  table.checkStatus("principalReload");
  					if(checkRadioStatus.data.length==0){
  						Hussar.info("请选择一条记录！");
  						return false;
  					}
  					var data = checkRadioStatus.data[0];
  					$("#principalName").val(data.USERNAME);
  					$("#principalId").val(data.USERID);
  					layer.close(index);
  				 },
  				success:function(){
                    $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                    $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
  					table.render({
  					    elem: '#principal'
  					    ,url:Hussar.ctxPath+'/orgMain/principalSelect'
  					    ,request: {
  					    		  pageName: 'curr' //页码的参数名称，默认：page
  					    		  ,limitName: 'nums' //每页数据量的参数名，默认：limit
  					    		},
  					    height: '340px',
  					    method:"post"
  					    ,cols: [[
                            { type : 'radio', align : 'center',width:50},
                            {title : '序号', type : 'numbers', align : 'center',width:50},
                            {title: '姓名', field:'USERNAME', align : 'center',width:150}
                            ,{title: '所属部门', field:'DEPARTMENTNAME' }
  					    ]]
  					  ,page: true,
  					  even: true,
  					  id:"principalReload"
  					 });
  					
  				}
  			});
		})
		  //监听提交
		  form.on('submit(orgInfoAdd)', function(data){
			  var formData = data.field;
			  if(formData.beginDate>formData.endDate){
				  Hussar.info("失效日期不能早于生效日期！");
				  return false;
			  }
			  $.ajax({
					type:"POST",
					contentType:"application/x-www-form-urlencoded",
					url:Hussar.ctxPath+"/orgMain/orgInfoSave",
					data:formData,
					async:false,
					success:function(data){
						Hussar.success("保存成功!");
						//刷新父页面
						parent.location.reload();
					},
					error:function(){
						Hussar.error("保存失败!");			
					}
				})
		    return false;
		  });
		table.on('checkbox(principal)', function(obj){
			var checkStatus = table.checkStatus('principal');
			  console.log(obj.checked); //当前是否选中状态
			  console.log(obj.data); //选中行的相关数据
			  console.log(obj.type); //如果触发的是全选，则为：all，如果触发的是单选，则为：one
		});
		$('#search').on('click', function() {
			var userName = $('#userName').val();
			var departmentName = $('#departmentName').val();
			// 执行重载
			table.reload('principalReload', {
				page : {
					curr : 1
				// 重新从第 1 页开始
				},
				where : {
					userName : userName,
					departmentName : departmentName
				}
			});
		});
	}
	$(function(){
		OrgInfoAdd.initPage();
	})
});