/**
 * @Description: 定义登陆页面脚本文件
 * @Author: liangdong
 * @Date: 2018/3/14.
 */

layui.use([ 'jquery', 'layer', 'Hussar', 'HussarAjax', 'form' ,'HussarSecurity'], function() {
    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var layer = layui.layer;
    var $ax = layui.HussarAjax;
    var form = layui.form;
    var Security = layui.HussarSecurity;

    var Login = {
        layerIndex : -1,
    };

    Login.initButtonEvent = function() {

        $("#kaptcha").on('click', function () {
            $("#kaptcha").attr('src', Hussar.ctxPath+'/kaptcha?' + Math.floor(Math.random() * 100)).fadeIn();
        });

        $("#login").click(function() {
            var kaptchaOnOff=$("#kaptchaOnOff").val();
            if (kaptchaOnOff=="true") {
                //如果开启了验证码
                var username = $("input[name='username']").val().trim();
                var cipher = $("input[name='cipher']").val().trim();
                var kaptcha = $("input[name='kaptcha']").val().trim();
                if (username == "") {
                    $(".error").html("用户名不能为空");
                    $("input[name='username']").addClass("errorTip");
                } else if (cipher == "") {
                    $(".error").html("密码不能为空");
                    $("input[name='cipher']").addClass("errorTip");
                } else if (kaptcha == "") {
                    $(".error").html("验证码不能为空");
                    $("input[name='kaptcha']").addClass("errorTip");
                }else {
                    $(".login-form input").removeClass("errorTip");
                    Login.login();
                }
            } else {
                //没开启验证码时
                var username = $("input[name='username']").val().trim();
                var cipher = $("input[name='cipher']").val().trim();
                if (username == "") {
                    $(".error").html("用户名不能为空");
                    $("input[name='username']").addClass("errorTip");
                } else if (cipher == "") {
                    $(".error").html("密码不能为空");
                    $("input[name='cipher']").addClass("errorTip");
                }else {
                    $(".login-form input").removeClass("errorTip");
                    Login.login();
                }
            }
        });

        $(".login-form input").blur(function() {
            var loginVal = $(this).val().trim();

            if (loginVal != "") {
                $(this).removeClass("errorTip");
            } else {
                $(this).addClass("errorTip");
            }
        });
    };

    Login.login = function() {
        //使用loading，防止多次提交
        var index = layer.load(2);
        var cipher =encodeURIComponent($("input[name='cipher']").val());
        var params = Security.encode(cipher);//调用加密方法进行加密
        $("input[name='cipher']").val("");
        var data = $.param({'encrypted':params})+'&'+$("#tokenForm").serialize();
        var ajax = new $ax(Hussar.ctxPath + "/login", function(data) {
            if (data.code == 200) {
                if (window.location.origin == undefined) {
                    var location = window.location.protocol + "//" + window.location.hostname + (window.location.port ? ':' + window.location.port : '');
                    window.location.href = location + home_path;
                }else{
                    window.location.href = window.location.origin + home_path;
                }
            }
            layer.close(index);	//关闭loading
        }, function(data) {
            $(".error").html(data.responseJSON.result);
            $("#kaptcha").attr("src",Hussar.ctxPath +"/kaptcha");
            layer.close(index);	//关闭loading
        });
        ajax.setData(data);
        ajax.start();

    };

    $(function() {
        Login.initButtonEvent(); // 初始化按钮事件
        // Enter触发登录按钮事件
        $(document).keyup(function(event) {
            if (event.keyCode == 13) {
                $("#login").click();
            }
        });
        Security.initSecurityKey();// 初始化加密密钥
    });

});
