/**
 * 字典管理初始化
 */
var Dict = {
    id: "DictTable",	//表格id
    seItem: null,		//选中的条目 array
    tableType: null,    //当前table的种类['root'所有类别的表格（包括系统和业务）, 'type'类别所属字段的表格]
    currentNode: null,  //当前左方树选中的node的值(非original)（仅限root node或者type node）
    treeRefreshing: false, //防止树刷新或者搜索时节点展开触发事件
    layerIndex: -1,
    permissions:{
        'add': false,
        'edit': false,
        'del': false,
        'sort': false
    }
};
var TYPE_RANGE_MAP = {'sys':'系统字典', 'biz':'业务字典'};
layui.use(['layer', 'table', 'HussarAjax', 'Hussar', 'jstree'], function() {

    var layer = layui.layer
        , table = layui.table
        , $ = layui.jquery
        , $ax = layui.HussarAjax
        , Hussar = layui.Hussar;

    /**
     * 初始化字典树
     */
    Dict.iniTypeTree = function(){
        var $tree = $("#dicTree");
        $tree.jstree({
            core: {
                check_callback: true,
                data: function (obj, callback) {
                    var data;
                    var ajax = new $ax(Hussar.ctxPath+"/sys/dic/dicTypeTree",
                        function(result) {
                            data = result
                        },
                        function(data) {
                            Hussar.error("加载字典树失败！");
                        });
                    ajax.start();
                    callback.call(this, (function(arr){
                        var rootNode = [
                            {parent: '#', id:'root', text : '数据字典', type: 'root', state:{opened: true, selected: true}},
                            {parent: 'root', id:'sys', text : '系统字典', type: 'sys'},
                            {parent: 'root', id:'biz', text : '业务字典', type: 'biz'}
                        ];
                        return Array.isArray(arr) ? rootNode.concat(arr) : rootNode;
                    })(data));
                }
            },
            contextmenu:{
                select_node:false,
                show_at_node:true,
                items : function(node, cb){
                    var actions = {};
                    if(!node) return {};
                    var type = node.original.type;
                    var rangeType = node.original.rangeType;
                    if(type == 'type' && rangeType!='sys'){
                        //TODO:支持多级字典时开启注释
                        //actions.addType = {
                        //    label: '新增子类',
                        //    icon : Hussar.ctxPath+"/static/assets/img/treeContext/59.png",
                        //    action: function () {
                        //        Dict.openAddType(node.id);
                        //    }
                        //};
                        if (Dict.permissions.edit) {
                            actions.editType = {
                                label: '类别修改',
                                icon: Hussar.ctxPath + "/static/assets/img/treeContext/53.png",
                                action: function () {
                                    Dict.openTypeEdit(node.id,"haveType")
                                }
                            };
                        }
                        if (Dict.permissions.del) {
                            actions.delType = {
                                label: '类别删除',
                                icon: Hussar.ctxPath + "/static/assets/img/treeContext/57.png",
                                action: function () {
                                    Dict.typeDelete([node.id+","+node.children_d], [node.original.text]);
                                }
                            };
                        }
                        if (Dict.permissions.sort) {
                            actions.sort = {
                                label: '下级排序',
                                icon: Hussar.ctxPath + "/static/assets/img/treeContext/5111.png",
                                action: function () {
                                    Dict.openSortTree(node.id);
                                }
                            };
                        }
                        if (Dict.permissions.add) {
                            actions.addKey = {
                                label: '字段添加',
                                icon: Hussar.ctxPath + "/static/assets/img/treeContext/5011.png",
                                action: function () {
                                    Dict.openAddSingle(node,0);
                                }
                            };
                        }
                    }else if(type == 'dic' && rangeType!='sys'){
                        if(node && node.original && node.original.id) {
                            var id = node.original.id;
                            var n = $("#"+id);
                            if (Dict.permissions.edit) {
                                actions.editType = {
                                    label: '字段修改',
                                    icon: Hussar.ctxPath + "/static/assets/img/treeContext/53.png",
                                    action: function () {
                                        Dict.openTypeEdit(node.id,"justSingle")
                                    }
                                };
                            }
                            if (Dict.permissions.del) {
                                actions.delSingle = {
                                    label: '字段删除',
                                    icon: Hussar.ctxPath + "/static/assets/img/treeContext/57.png",
                                    action: function () {
                                        Dict.singleDelete([node.id+","+node.children_d],"");
                                    }
                                };
                            }
                            if (Dict.permissions.sort) {
                                if (n.index() > 0) {//非第一个
                                    actions.upMove = {
                                        label: '字段上移',
                                        icon: Hussar.ctxPath + "/static/assets/img/treeContext/511101.png",
                                        action: function () {
                                            Dict.singleMove(id, 'up');
                                        }
                                    }
                                }
                                if (n.next().length > 0) {//非最后一个
                                    actions.downMove = {
                                        label: '字段下移',
                                        icon: Hussar.ctxPath + "/static/assets/img/treeContext/511102.png",
                                        action: function () {
                                            Dict.singleMove(id, 'down');
                                        }
                                    }
                                }
                            }
                            if (Dict.permissions.add) {
                                actions.addKey = {
                                    label: '字段添加',
                                    icon: Hussar.ctxPath + "/static/assets/img/treeContext/5011.png",
                                    action: function () {
                                        Dict.openAddSingle(node,1);
                                    }
                                };
                            }
                        }
                    }else if(type == 'biz'){
                        if (Dict.permissions.add) {
                            actions.addType = {
                                label: '类别新增',
                                icon: Hussar.ctxPath + "/static/assets/img/treeContext/5011.png",
                                action: function () {
                                    Dict.openAddType('biz');
                                }
                            };
                        }
                    }
                    cb(actions);
                }
            },
            types:{
                'biz':{icon: Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/dicRoots.png"},
                'sys':{icon: Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/dicRoots.png"},
                'type':{icon: Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/dicTypes.png"},
                'dic':{icon: Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/dicSingle.png"},
                'child':{icon: Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/dicSingle.png"}
            },
            plugins: ['types', 'contextmenu', 'search']
        });
        $tree.on('open_node.jstree', function(e, data){//展开时（非刷新、非搜索导致的展开）也选中
            if(!Dict.treeRefreshing) {
                var node = data.node;
                var inst = data.instance;
                if (node && inst && (!node.state.selected)) {
                    //inst.select_node(node.id);
                    // inst.select_node不明原因不起作用，只能调用$.click触发
                    $('#dicTree').find('#' + node.id + '_anchor').click();
                }
            }
        }).on('refresh.jstree', function(){
            //刷新结束
            Dict.treeRefreshing = false;
        }).on('search.jstree', function(){
            //搜索结束
            Dict.treeRefreshing = false;
        });

        $tree.bind("activate_node.jstree", function (obj, e) {
            var currentNode = e.node || {};
            var dat = currentNode.original || {};
            if (['root', 'sys', 'biz'].indexOf(dat.type) >= 0){
                $("#condition").prop('placeholder', '类型名称').val('');
                Dict.currentNode = currentNode;
                Dict.renderAllTypeTable(dat.type);
            }else if (dat.type == 'type') {
                var cond = $("#condition");
                cond.prop('placeholder', '字段名称').val('');
                Dict.currentNode = currentNode;
                Dict.renderSingleTable(dat);
            }else if (dat.type == 'dic') {
                //单条修改放到右键菜单中了
                //Dict.openSingleDict(dat.id);
                Dict.renderSingleTable(dat)

            }
        });

        //树查询绑定事件
        var to = false;
        $("#dictTreeSearch").keyup(function () {
            if (to) { clearTimeout(to); }
            to = setTimeout(function () {
                var v = $("#dictTreeSearch").val();
                var temp = $tree.is(":hidden");
                if (temp == true) {
                    $tree.show();
                }
                Dict.treeRefreshing = true;
                $tree.jstree(true).search(v);
                //添加索引
                if(v!=''){
                    var n = $(".jstree-search").length,con_html;
                    if(n>0){
                        con_html = "<em>"+ n +"</em>个匹配项";
                    }else{
                        con_html = "无匹配项";
                    }
                    $(".search-results").html(con_html);
                    //定位到符合查询结果的树节点上
                    var searchResult = $tree.jstree('search', v);
                    $(searchResult).find('.jstree-search').focus();
                }else {
                    $(".search-results").html("");
                }
            }, 250);
        });
    };

    /**
     * 初始化排序树
     */
    Dict.iniSortTree = function(){
        var $orderTree = $('#dicOrderTree');	//排序树
        $orderTree.data('jstree', false).empty();
        $orderTree.jstree({
            core: {
                check_callback: function (operation, node, node_parent) {
                    //拖动排序时只允许同级拖动
                    if(operation=='move_node'){
                        return !(node.parent == node_parent.parent || node_parent.parent == null);
                    }else{
                        return true;
                    }
                },
                data: null
            },
            types:{
                'biz':{icon: Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/dicRoots.png"},
                'sys':{icon: Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/dicRoots.png"},
                'type':{icon: Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/dicTypes.png"},
                'dic':{icon: Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/dicSingle.png"}
            },
            plugins: ['types', "dnd"]
        });
    };

    /**
     * 打开字典条目排序layer
     * @param nodeId 字典类型id
     */
    Dict.openSortTree = function(nodeId){
        layer.open({
            type: 1,
            btn: ['取消', '保存'],
            skin: 'confirm-class',
            area: ['350px','500px'],
            shadeClose: false,
            zIndex: 9999,
            title: "下级排序",
            content: $('#dicOrder'),
            success:function(){
                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
                $.ajax({
                    type: "POST",
                    data:{
                        typeId:nodeId
                    },
                    url: Hussar.ctxPath+"/sys/dic/dicOrderTree",
                    dataType:"json",
                    async: false,
                    success:function(result) {
                        if(Array.isArray(result) && result.length > 0){
                            result[0].state = {opened: true};
                            var tree = $.jstree.reference('#dicOrderTree');
                            tree.settings.core.data = result;
                            tree.refresh();
                        }
                    }
                });
            },
            btn2: function(index){
                var saveTree =function(){
                    var tree = $('#dicOrderTree');
                    var param = [];
                    tree.find('.jstree-leaf').each(function(i, v){
                        //只拿2级节点的数据，防止拿到根节点
                        if($(v).attr('aria-level') > 1){
                            param.push(v.id);
                        }
                    });
                    $.ajax({
                        url:Hussar.ctxPath+"/sys/dic/saveDicOrder",
                        async:false,
                        data:{
                            orderInfo: JSON.stringify(param)
                        },
                        type:"POST",
                        success:function(data){
                            data = data || {};
                            if(data.code == 200){
                                Hussar.success("保存成功！");
                                Dict.refreshTreeAndTable();
                            }else{
                                Hussar.error("保存失败！（" + (data.message || '未知错误') + "）");
                            }
                        },
                        error:function(data){
                            Hussar.error("保存失败！（" + data.responseJSON.message + "）");
                        }
                    });
                    layer.close(index);
                };
                Hussar.confirm("确定要保存排序吗？", saveTree);
                return false;
            }
        });
    };

    /**
     * 上移下移方法
     * @param id 字典id
     * @param direction 方向 'up' | 'down'
     */
    Dict.singleMove = function(id, direction){
        var layerIndex = layer.open({type: 3});
        $.ajax({
            url:Hussar.ctxPath+"/sys/dic/singleMove",
            //async:false,
            data:{
                dictId: id,
                isUp: direction == 'up'
            },
            type:"POST",
            success:function(data){
                data = data || {};
                if(data.code == 200){
                    Hussar.success("操作成功！");
                    Dict.refreshTreeAndTable();
                }else{
                    Hussar.error("操作失败！（" + (data.message || '未知错误') + "）");
                }
                layer.close(layerIndex);
            },
            error:function(){
                layer.close(layerIndex);
                Hussar.error("操作失败！");
            }
        });
    };
    Dict.buttonMove = function(direction){
        console.log(table);
        if (Dict.check()) {
            if (Dict.seItem.length != 1) {
                Hussar.info("请选择一条记录！");
            } else {
                if (Dict.tableType == 'root') {
                    //类别暂时没做移动
                }else if(Dict.tableType == 'type') {
                    console.log(Dict.seItem[0]);
                    Dict.singleMove(Dict.seItem[0].id, direction);
                }
            }
        }
    };

    /**
     * 检查表格中是否选中
     */
    Dict.check = function () {
        var flag = false;
        var selected = table.checkStatus('DictTable').data;
        if (selected && selected.length > 0) {
            Dict.seItem = selected;
            flag = true;
        } else {
            // layer.confirm("请先选中表格中的某一记录！ ", { btn: ['确认'],title:'信息'});
            Hussar.info("请至少选择一条记录！");
        }
        return flag;
    };

    /**
     * 点击表格上方添加字典按钮
     */
    //Dict.openAddDict = function () {
    //    if (Dict.tableType == 'root') {
    //        Dict.openAddType;
    //    } else if (Dict.tableType == 'type') {
    //        Dict.openAddSingle(Dict.currentNode);
    //    }
    //};

    /**
     * 点击表格上方添加字典按钮(表格为'type'类型)
     * AND 右键菜单中的添加字典条目
     * @param node 当前树上选中的类别节点
     */
    Dict.openAddSingle = function(node,flag){
        if(node && node.id){
            Dict.layerIndex = layer.open({
                type: 2,
                title: '字段新增',
                area: ['350px', '200px'], //宽高
                fix: false, //不固定
                maxmin: false,
                content: Hussar.ctxPath+'/sys/dic/dict_add_single/' + node.id + "/" + flag
            });
        }else{
            Hussar.error("树节点信息异常！");
        }
    };

    /**
     * 打开添加字典类型layer
     * @param parentId 父节点id(可能是'biz'或其他字典类型id)
     */
    Dict.openAddType = function(parentId){
        Dict.layerIndex = layer.open({
            type: 2,
            title: '字典类别新增',
            area: ['805px', '420px'], //宽高
            fix: false, //不固定
            maxmin: false,
            content: Hussar.ctxPath+'/sys/dic/dict_add/'+parentId
        });
    };

    /**
     * 打开查看字典详情（表格上方按钮）
     */
    //Dict.openDictDetail = function () {
    //    if (Dict.check()) {
    //        if (Dict.seItem.length != 1) {
    //            Hussar.info("每次只能修改一条！");
    //        } else {
    //            if (Dict.tableType == 'root') {
    //
    //                $('#dicTree').find('#type-' + Dict.seItem[0].type + '_anchor').click();
    //            }else if(Dict.tableType == 'type') {
    //                Dict.openSingleDict(Dict.seItem[0].id);
    //            }
    //        }
    //    }
    //
    //};

    /**
     * 打开修改字典类型
     * @param dictTypeId 字典类型id
     */
    Dict.openTypeEdit = function(dictTypeId,str) {
        Dict.layerIndex = layer.open({
            type: 2,
            title: '字典类别修改',
            area: ['805px', '420px'], //宽高
            fix: false, //不固定
            maxmin: false,
            content:Hussar.ctxPath+ '/sys/dic/dict_edit/' + dictTypeId + "/" + str
        });
    };

    /**
     * 打开修改字典条目layer
     * @param id 字典条目id
     */
    Dict.openSingleDict = function(id){
        if(id){
            Dict.layerIndex = layer.open({
                type: 2,
                title: '字段修改',
                area: ['350px', '200px'], //宽高
                fix: false, //不固定
                maxmin: false,
                content: Hussar.ctxPath+'/sys/dic/dict_edit_single/' + id
            });
        }else{
            Hussar.error("获取字典id失败！");
        }
    };

    /**
     * 删除字典(表格上方按钮，批量删除)
     */
    //Dict.delete = function () {
    //    if (Dict.check()) {
    //        if (Dict.tableType == 'root') {//批量删类别
    //            var nameArr = [];
    //            var idArr = [];
    //            Dict.seItem.forEach(function (v) {
    //                idArr.push(v.type);
    //                nameArr.push(v.description);
    //            });
    //            Dict.typeDelete(idArr, nameArr);
    //        } else if (Dict.tableType == 'type') {//批量删字段
    //            var idsArr = [];
    //            Dict.seItem.forEach(function (v) {
    //                idsArr.push(v.id);
    //            });
    //            Dict.singleDelete(idsArr);
    //        }
    //    }
    //};

    /**
     * 删除字典条目单条
     */
    Dict.singleDelete = function(ids) {
        var operation = function () {
            var ajax = new $ax(Hussar.ctxPath+"/sys/dic/delete_single", function (data) {
                data = data || {};
                if(data.code == 200) {
                    Hussar.success("删除成功！");
                    Dict.refreshTreeAndTable();
                }
                else{
                    Hussar.error("删除失败！（" + (data.message || '未知错误') + "）");
                }

            }, function (data) {
                Hussar.error("删除失败！（" + (data.responseJSON.message || '未知错误') + "）");
            });
            ajax.set("dictId", ids.toString());
            ajax.start();
        };

        Hussar.confirm("确定要删除吗？", operation);
    };
    /**
     * 删除字典类别
     */
    Dict.typeDelete = function(idArr, nameArr){
        var operation = function () {
            var ajax = new $ax(Hussar.ctxPath+"/sys/dic/delete", function (data) {
                if (data.code == 200){
                    Hussar.success("删除成功！");
                    Dict.refreshTreeAndTable();
                }
            }, function (data) {
                Hussar.error("删除失败！（" + (data.responseJSON.message || '未知错误') + "）");
            });
            ajax.set("dictId", idArr.toString());
            ajax.start();
        };

        Hussar.confirm("确定要删除吗？", operation);
    };

    /**
     * 查询字典列表
     */
    Dict.search = function () {
        var queryData = {};
        queryData['condition'] = $("#condition").val();
        table.reload('DictTable', {where: queryData});
    };

    /**
     * 刷新字典类别表格
     * @param rangeType 字典业务类别('sys'或者'biz'，或者'root'为全部)
     */
    Dict.renderAllTypeTable = function(rangeType) {
        Dict.tableType = 'root';
        $("#buttonsAboveTable").hide();

        table.render({
            elem: '#DictTable'
            , url: Hussar.ctxPath+'/sys/dic/list/'+(rangeType||'') //数据接口
            , limit: 20
            , page: true //开启分页
            , cols: [[ //表头
                //{type: 'checkbox', width: '5%'},
                {title: '序号', type: 'numbers', width: 50},
                {title: '字典类型', field: 'typeName'},
                {title: '类别', field: 'rangeType', templet: function(d){return TYPE_RANGE_MAP[d.rangeType];}},
                {title: '类型描述', field: 'typeDescription'},
                {title: '详情', field: 'detail', width:'55%'}
            ]]
            , even: true
            , height: $("body").height() - $(".layui-form").outerHeight(true) - 26
        });
    };

    /**
     * 刷新字典条目表格
     * @param typeData 树节点数据 {id,parent,text,type,rangeType,typeName}
     */
    Dict.renderSingleTable = function(typeData) {
        typeData = typeData||{};
        Dict.tableType = 'type';
        if(typeData.rangeType == 'sys'){
            $("#buttonsAboveTable").hide();
        }else{
            $("#buttonsAboveTable").show();
        }
        table.render({
            elem: '#DictTable'
            , url:Hussar.ctxPath+ '/sys/dic/list_single/' + (typeData.id||'') //数据接口
            , limit: 20
            , page: true //开启分页
            , cols: [[ //表头
                {type: 'checkbox', width: 40},
                {title: '序号', type: 'numbers', width: 50},
                {title: '字典类型', field: 'type', templet: function(){ return typeData.typeName||'' }},
                {title: '类型描述', field: 'description', templet: function(){ return typeData.text||'' }},
                {title: '字段名称', field: 'label', width: '30%'},
                {title: '字段值', field: 'value', width: '30%'}
            ]]
            , even: true
            , height: $("body").height() - $(".layui-form").outerHeight(true) - 26
        });
    };

    /**
     * 刷新左侧树和右侧表格数据，可以供子页面调用
     */
    Dict.refreshTreeAndTable = function(){
        Dict.treeRefreshing = true;
        $.jstree.reference('#dicTree').refresh();
        table.reload('DictTable');
    };

    $(function () {
        //检查权限情况，用于控制jstree右键菜单的显示
        for(var perm in Dict.permissions){
            Dict.permissions[perm] = $("#"+perm+"DictPermission").val() == '1';
        }

        var bodyH = $("body").height();
        $(".tree-box").css("height", bodyH -60  + "px");
        Dict.iniTypeTree();
        Dict.iniSortTree();
        Dict.renderAllTypeTable('root');
    });
});
