/**
* @Description:    工作日历脚本文件
* @Author:         LiangDong
* @CreateDate:     2018/5/15 15:33
* @UpdateUser:     LiangDong
* @UpdateDate:     2018/5/15 15:33
* @UpdateRemark:   修改内容
* @Version:        1.0
*/
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','form','laydate'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer = layui.layer;
	var $ax = layui.HussarAjax;
	var form = layui.form;
	var laydate = layui.laydate;
	
	var Calendar = {
        layerIndex: -1
	}

    /**
	 * 初始化工作日历
     */
    Calendar.initWorkCalendar = function () {
        $('#calendar').fullCalendar({
            customButtons: {
                addButton: {
                    text: '新增',
                    click: function() {
                        Calendar.openAddWin();      //打开新增对话框
                    }
                },
                delButton: {
                    text: '删除',
                    click: function () {
                        Calendar.openDelWin();      //打开删除对话框
                    }
                }
            },
            header: {
                left: 'prevYear,prev,next,nextYear, today ',
                center: 'title',
                right: 'addButton,delButton',
            },
            editable: true,
            eventLimit: true, // allow "more" link when too many events
            locale: 'zh-cn',
            weekends: true, //是否显示周末
            selectable: true,
            weekMode: 'liquid',
            eventStartEditable: false,  //事件不可拖拉
            events: function (start, end, timezone, callback) {
                var events = [];
                var ajax = new $ax(Hussar.ctxPath + "/calendar/list",
                    function(data) {
                        events = data;
                        callback(events);
                    },
                    function(data) {
                        Hussar.error("获取事件失败!");
                    });
                ajax.set("startTime", start.format('YYYY-MM-DD') );
                ajax.set("endTime", end.format('YYYY-MM-DD') );
                ajax.start();
            },
            dayClick: function(date, allDay, jsEvent, view) {
                var events = $('#calendar').fullCalendar('clientEvents', function(event) {
                    var eventStart = event.start.format('YYYY-MM-DD');
                    var eventEnd = event.end ? event.end.format('YYYY-MM-DD') : null;
                    var theDate = date.format('YYYY-MM-DD');
                    // Make sure the event starts on or before date and ends afterward
                    // Events that have no end date specified (null) end that day, so check if start = date
                    return (eventStart <= theDate && (eventEnd >= theDate) && !(eventStart < theDate && (eventEnd == theDate))) || (eventStart == theDate && (eventEnd === null));
                });
                if (events.length == 0) {
                    //如果当天没有事件，就弹出新增当天事件的对话框
                    Calendar.openAddOneWin(date);
                }

            },
            eventClick: function (event, jsEvent, view) {
                Calendar.openEditWin(event);     // 打开修改对话框
            },
            eventMouseover: function (event, jsEvent, view) {
                $(this).attr('title', event.title);
            }
        });
    }


    /**
     * 初始化下拉框
     */
    Calendar.initSelectOption = function () {
        var ajax = new $ax(Hussar.ctxPath + "/calendar/calendarEventTypeOption",
            function(data) {
                $("select[name='title']").html("<option value=''>请选择</option>");
                for (var i = 0; i < data.length; i++) {
                    $("select[name='title']").append(
                        "<option value='" + data[i].value + "'>"
                        + data[i].label + "</option>");
                }
            }, function(data) {
                Hussar.error("获取日历事件类型失败!");
            });
        ajax.start();
        form.render();
    }

    /**
     *  打开新增对话框
     */
    Calendar.openAddWin = function () {
        Calendar.layerIndex = layer.open({
            type: 1,
            title: '新增事件',
            area: ['450px', '300px'], //宽高
            fix: false, //不固定
            maxmin: false,
            shadeClose: false,
            content: $('#addEvent'),
            success: function(){
                //重置form
                $('#addForm')[0].reset();
            }
        });
    }

    /**
     *  打开新增单日事件对话框
     */
    Calendar.openAddOneWin = function (date) {
        var theDate = date.format('YYYY-MM-DD');
        Calendar.layerIndex = layer.open({
            type: 1,
            title: '新增事件',
            area: ['450px', '300px'], //宽高
            fix: false, //不固定
            maxmin: false,
            shadeClose: false,
            content: $('#addOneEvent'),
            success: function(){
                //重置form
                $('#addOneForm')[0].reset();
                $('#addOneStart').val(theDate);
            }
        });
    }

    /**
     *  打开修改对话框
     */
    Calendar.openEditWin = function (event) {
        Calendar.layerIndex = layer.open({
            type: 1,
            title: '修改事件',
            area: ['450px', '300px'], //宽高
            fix: false, //不固定
            maxmin: false,
            shadeClose: false,
            content: $('#editEvent'),
            success: function(){
                //重置form
                $('#editForm')[0].reset();
                $('#id').val(event.id);
                $('#editClassName').val(event.className);
                $('#title').val(event.title);
            }
        });
    }

    /**
     *  打开删除对话框
     */
    Calendar.openDelWin = function () {
        Calendar.layerIndex = layer.open({
            type: 1,
            title: '删除时间',
            area: ['450px', '300px'], //宽高
            fix: false, //不固定
            maxmin: false,
            shadeClose: false,
            content: $('#delEvent'),
            success: function(){
                //重置form
                $('#delForm')[0].reset();
            }
        });
    }

    /**
     * 初始化时间控件
     */
    Calendar.initLaydate = function () {
        var ts = laydate.render({
            elem: '#start',
            type : 'date',
            done: function (value,date) {
                if (value !== '') {
                    te.config.min.year = date.year;
                    te.config.min.month = date.month - 1;
                    te.config.min.date = date.date;
                } else {
                    te.config.min.year = '';
                    te.config.min.month = '';
                    te.config.min.date = '';
                }
            }
        });
        var te = laydate.render({
            elem: '#end',
            type : 'date',
            done: function (value,date) {
                if (value !== '') {
                    ts.config.max.year = date.year;
                    ts.config.max.month = date.month - 1;
                    ts.config.max.date = date.date;
                } else {
                    ts.config.max.year = '2099';
                    ts.config.max.month = '11';
                    ts.config.max.date = '31';
                }
            }
        });

        var delts = laydate.render({
            elem: '#delstart',
            type : 'date',
            done: function (value,date) {
                if (value !== '') {
                    delte.config.min.year = date.year;
                    delte.config.min.month = date.month - 1;
                    delte.config.min.date = date.date;
                } else {
                    delte.config.min.year = '';
                    delte.config.min.month = '';
                    delte.config.min.date = '';
                }
            }
        });
        var delte = laydate.render({
            elem: '#delend',
            type : 'date',
            done: function (value,date) {
                if (value !== '') {
                    delts.config.max.year = date.year;
                    delts.config.max.month = date.month - 1;
                    delts.config.max.date = date.date;
                } else {
                    delts.config.max.year = '2099';
                    delts.config.max.month = '11';
                    delts.config.max.date = '31';
                }
            }
        });
    }

    /**
     *  关闭弹窗
     */
    Calendar.closeWin = function () {
        layer.close(Calendar.layerIndex);
    }

    /**
     *  新增保存
     */
    Calendar.save = function () {
        var data = $("#addForm").serialize();
        var ajax = new $ax(Hussar.ctxPath + "/calendar/addEvent", function(data) {
            if (data.code == '200') {
                Hussar.success("保存成功！");
                Calendar.closeWin();
                $('#calendar').fullCalendar('refetchEvents');
            } else if (data.code == '409') {
                Hussar.error(data.message);
            } else {
                Hussar.error("保存失败！");
            }
        }, function(data) {
            Hussar.error("保存失败！");
        });
        ajax.setData(data);
        ajax.start();
    }

    /**
     *  新增单日事件保存
     */
    Calendar.saveOne = function () {
        var data = $("#addOneForm").serialize();
        var ajax = new $ax(Hussar.ctxPath + "/calendar/addOneEvent", function(data) {
            if (data.code == '200') {
                Hussar.success("保存成功！");
                Calendar.closeWin();
                $('#calendar').fullCalendar('refetchEvents');
            } else if (data.code == '409') {
                Hussar.error(data.message);
            }else {
                Hussar.error("保存失败！");
            }
        }, function(data) {
            Hussar.error("保存失败！");
        });
        ajax.setData(data);
        ajax.start();
    }

    /**
     *  事件修改保存
     */
    Calendar.edit = function () {
        var data = $("#editForm").serialize();
        var ajax = new $ax(Hussar.ctxPath + "/calendar/editEvent", function(data) {
            if (data.code == '200') {
                Hussar.success("修改成功！");
                Calendar.closeWin();
                $('#calendar').fullCalendar('refetchEvents');
            } else {
                Hussar.error("修改失败！");
            }
        }, function(data) {
            Hussar.error("修改失败！");
        });
        ajax.setData(data);
        ajax.start();
    }

    /**
     *  删除单个事件
     */
    Calendar.delOne = function () {
        var id = $('#id').val();
        var ajax = new $ax(Hussar.ctxPath + "/calendar/delOneEvent", function(data) {
            if (data.code == '200') {
                Hussar.success("删除成功！");
                Calendar.closeWin();
                $('#calendar').fullCalendar('refetchEvents');
            } else {
                Hussar.error("删除失败！");
            }
        }, function(data) {
            Hussar.error("删除失败！");
        });
        ajax.set("id",id);
        ajax.start();
    }

    /**
     *  删除事件
     */
    Calendar.del = function () {
        var data = $("#delForm").serialize();
        var ajax = new $ax(Hussar.ctxPath + "/calendar/delEvent", function(data) {
            if (data.code == '200') {
                Hussar.success("删除成功！");
                Calendar.closeWin();
                $('#calendar').fullCalendar('refetchEvents');
            } else {
                Hussar.error("删除失败！");
            }
        }, function(data) {
            Hussar.error("删除失败！");
        });
        ajax.setData(data);
        ajax.start();
    }

    /**
     * 初始化按钮事件
     */
    Calendar.initButtonEvent = function () {
        //新增保存按钮
        $("#btnSave").click(function(){
            form.on('submit(add)', function(data){
                Calendar.save();
            });
        });
        //新增单日事件保存按钮
        $("#btnSaveOne").click(function(){
            form.on('submit(addOne)', function(data){
                Calendar.saveOne();
            });
        });
        //修改按钮
        $("#btnEdit").click(function(){
            form.on('submit(edit)', function(data){
                Calendar.edit();
            });
        });
        //删除单个事件按钮
        $("#btnDeleteOne").click(function(){
            var operation = function () {
                Calendar.delOne();
            };
            Hussar.confirm("确定要删除该事件吗?", operation);
        });
        //确定删除按钮
        $("#btnDelete").click(function () {
            form.on('submit(del)', function(data){
                Calendar.del();
            });
        });
        //取消按钮
        $("button[name='btnClose']").click(function(){
            Calendar.closeWin();
        });

        //新增事件类型下拉框选择监听
        form.on('select(addtitle)', function(data){
            if (data.value == '班') {
                $('#className').val('work');
            } else if (data.value == '休') {
                $('#className').val('holiday');
            }
        })

        //新增单日事件类型下拉框选择监听
        form.on('select(addOneTitle)', function(data){
            if (data.value == '班') {
                $('#addOneClassName').val('work');
            } else if (data.value == '休') {
                $('#addOneClassName').val('holiday');
            }
        })

        //修改事件类型下拉框选择监听
        form.on('select(edittitle)', function(data){
            if (data.value == '班') {
                $('#editClassName').val('work');
            } else if (data.value == '休') {
                $('#editClassName').val('holiday');
            }
        })
    }

	$(function () { 
		Calendar.initWorkCalendar();	//初始化工作日历
        Calendar.initLaydate();     //初始化时间控件
        Calendar.initButtonEvent();     //初始化按钮事件
        Calendar.initSelectOption();    //初始化下拉框
	});
	
});




